/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.filter;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.catalina.connector.OutputBuffer;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.filter.BufferedResponseWrapper;
import org.springframework.util.ReflectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ExportDelegate {
    private static Log log = LogFactory.getLog(ExportDelegate.class);

    private ExportDelegate() {
    }

    protected static void writeExport(HttpServletResponse response, ServletRequest request, BufferedResponseWrapper wrapper) throws IOException {
        if (wrapper.isOutRequested()) {
            log.debug((Object)"Filter operating in unbuffered mode. Everything done, exiting");
            return;
        }
        log.debug((Object)"Filter operating in buffered mode. ");
        Map bean = (Map)request.getAttribute("org.displaytag.filter.ResponseOverrideFilter.CONTENT_OVERRIDE_BODY");
        if (log.isDebugEnabled()) {
            log.debug((Object)bean);
        }
        Object pageContent = bean.get("body");
        OutputBuffer outputBuffer = ExportDelegate.getOutputBuffer((HttpServletResponse)response);
        outputBuffer.reset();
        outputBuffer.setSuspended(false);
        if (pageContent == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Filter is enabled but exported content has not been found. Maybe an error occurred?");
            }
            response.setContentType(wrapper.getContentType());
            PrintWriter out = response.getWriter();
            out.write(wrapper.getContentAsString());
            out.flush();
            return;
        }
        if (!response.isCommitted()) {
            response.reset();
        }
        String filename = (String)bean.get("filename");
        Object contentType = (String)bean.get("contenttype");
        if (StringUtils.isNotBlank((String)filename)) {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        }
        String characterEncoding = wrapper.getCharacterEncoding();
        String wrappedContentType = wrapper.getContentType();
        if (wrappedContentType != null && wrappedContentType.indexOf("charset") > -1) {
            characterEncoding = StringUtils.substringAfter((String)wrappedContentType, (String)"charset=");
        }
        if (characterEncoding != null && ((String)contentType).indexOf("charset") == -1) {
            contentType = (String)contentType + "; charset=" + characterEncoding;
        }
        response.setContentType((String)contentType);
        if (pageContent instanceof String) {
            if (characterEncoding != null) {
                response.setContentLength(((String)pageContent).getBytes(characterEncoding).length);
            } else {
                response.setContentLength(((String)pageContent).getBytes().length);
            }
            PrintWriter out = response.getWriter();
            out.write((String)pageContent);
            out.flush();
        } else {
            byte[] content = (byte[])pageContent;
            response.setContentLength(content.length);
            ServletOutputStream out = response.getOutputStream();
            out.write(content);
            out.flush();
        }
    }

    private static OutputBuffer getOutputBuffer(HttpServletResponse response) {
        try {
            Field responseField = ReflectionUtils.findField(ResponseFacade.class, (String)"response");
            ReflectionUtils.makeAccessible((Field)responseField);
            Object catalinaConnectorResponse = responseField.get(response);
            Field outputBuffer = ReflectionUtils.findField(catalinaConnectorResponse.getClass(), (String)"outputBuffer");
            ReflectionUtils.makeAccessible((Field)outputBuffer);
            return (OutputBuffer)outputBuffer.get(catalinaConnectorResponse);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("getCoyoteResponse(...) - Failed to access response fields : message=" + e.getMessage()));
            throw new IllegalStateException("Failed to access internal response fields", e);
        }
    }
}

