<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2026 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Stuck Documents Report</title>
    <style type="text/css">
        td, th
        {
            padding:0 15px 0 15px;
        }
    </style>
</head>
<body>
<h1>Currently Stuck Documents</h1>
<c:choose>
    <c:when test="${fn:length(stuckDocuments) == 0}">
        <p>There are currently no stuck documents</p>
    </c:when>
    <c:otherwise>
    <table>
        <thead>
        <tr>
            <th>Document ID</th>
            <th>Document Type</th>
            <th>Last Modified Date</th>
            <th>Create Date</th>
        </tr>
        </thead>
        <tbody>
        <c:forEach var="stuckDocument" items="${stuckDocuments}">
          <tr>
              <td><c:out value="${stuckDocument.documentId}"/></td>
              <td><c:out value="${stuckDocument.documentTypeLabel}"/></td>
              <td><c:out value="${stuckDocument.formattedLastModifiedDate}"/></td>
              <td><c:out value="${stuckDocument.formattedCreateDate}"/></td>
          </tr>
        </c:forEach>
    </c:otherwise>
</c:choose>
</body>
</html>
