(globalThis["webpackChunkfinancials_web"] = globalThis["webpackChunkfinancials_web"] || []).push([["commons"],{

/***/ "./app/batch-upload/batch-upload.tsx":
/*!*******************************************!*\
  !*** ./app/batch-upload/batch-upload.tsx ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _utils_utils_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/utils/utils.tsx */ "./app/utils/utils.tsx");
/* harmony import */ var _components_document_notes_and_attachments_attachment_input_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/document/notes-and-attachments/attachment-input.tsx */ "./app/components/document/notes-and-attachments/attachment-input.tsx");
/* harmony import */ var _components_breadcrumbs_index_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/components/breadcrumbs/index.tsx */ "./app/components/breadcrumbs/index.tsx");
/* harmony import */ var _components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ~/components/buttons/index.tsx */ "./app/components/buttons/index.tsx");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _components_collapsible_section_index_tsx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ~/components/collapsible-section/index.tsx */ "./app/components/collapsible-section/index.tsx");
/* harmony import */ var _lookup_error_tsx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ~/lookup/error.tsx */ "./app/lookup/error.tsx");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/material */ "./node_modules/@mui/material/esm/Grid/Grid.js");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var _components_page_header_index_tsx__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ~/components/page-header/index.tsx */ "./app/components/page-header/index.tsx");
/* harmony import */ var _components_page_spinner_index_tsx__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ~/components/page-spinner/index.tsx */ "./app/components/page-spinner/index.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./style.css */ "./app/batch-upload/style.css");
/* harmony import */ var _mui_material_TextField__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @mui/material/TextField */ "./node_modules/@mui/material/esm/TextField/TextField.js");
/* harmony import */ var _batch_upload_use_fetch_upload_template_ts__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ~/batch-upload/use-fetch-upload-template.ts */ "./app/batch-upload/use-fetch-upload-template.ts");
/* harmony import */ var _utils_use_previous_ts__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ~/utils/use-previous.ts */ "./app/utils/use-previous.ts");
/* harmony import */ var _lookup_use_router_params_ts__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ~/lookup/use-router-params.ts */ "./app/lookup/use-router-params.ts");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ~/style.css */ "./app/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_18__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


















const REQUIRE_DESCRIPTION = ['AssetBarcodeInventoryInputFileType'];
const BatchUpload = ({ isSet = false }) => {
    const params = (0,_lookup_use_router_params_ts__WEBPACK_IMPORTED_MODULE_16__.useRouterParams)();
    const previousBusinessObjectName = (0,_utils_use_previous_ts__WEBPACK_IMPORTED_MODULE_15__["default"])(params.routeParams.businessObjectName);
    const requiresDescription = REQUIRE_DESCRIPTION.includes(params.routeParams.businessObjectName);
    const pageHeader = (0,react__WEBPACK_IMPORTED_MODULE_18__.useRef)(null);
    const [attachmentFiles, setAttachmentFiles] = (0,react__WEBPACK_IMPORTED_MODULE_18__.useState)([
        null,
        null
    ]);
    const [fileIdentifier, setFileIdentifier] = (0,react__WEBPACK_IMPORTED_MODULE_18__.useState)('');
    const [description, setDescription] = (0,react__WEBPACK_IMPORTED_MODULE_18__.useState)('');
    const [errorMessages, setErrorMessages] = (0,react__WEBPACK_IMPORTED_MODULE_18__.useState)(null);
    const [successMessages, setSuccessMessages] = (0,react__WEBPACK_IMPORTED_MODULE_18__.useState)(null);
    const [warningMessages, setWarningMessages] = (0,react__WEBPACK_IMPORTED_MODULE_18__.useState)(null);
    const { isTemplateLoading, template, hasError: hasTemplateError, errorMessage: templateErrorMessage } = (0,_batch_upload_use_fetch_upload_template_ts__WEBPACK_IMPORTED_MODULE_14__.useFetchUploadTemplate)(params.routeParams.businessObjectName, isSet);
    const [isSaving, setSaving] = (0,react__WEBPACK_IMPORTED_MODULE_18__.useState)(false);
    (0,react__WEBPACK_IMPORTED_MODULE_18__.useEffect)(() => {
        if (previousBusinessObjectName !== params.routeParams.businessObjectName) {
            setAttachmentFiles([]);
            setFileIdentifier('');
            setDescription('');
            setErrorMessages(null);
            setSuccessMessages(null);
            setWarningMessages(null);
        }
    }, [params.routeParams.businessObjectName, previousBusinessObjectName]);
    const setAttachmentFileAt = (0,react__WEBPACK_IMPORTED_MODULE_18__.useCallback)((file, index) => {
        const newAttachmentFiles = [...attachmentFiles];
        newAttachmentFiles[index] = file;
        setAttachmentFiles(newAttachmentFiles);
    }, [attachmentFiles]);
    const handleButtonClick = async () => {
        await handleFileUpload();
    };
    const formatResponseString = (responseStrings) => {
        let message = '';
        for (const line of responseStrings) {
            message = message.concat(line + '\n');
        }
        return message;
    };
    const handleFileUpload = async () => {
        setErrorMessages(null);
        setSuccessMessages(null);
        const errorMessageList = [];
        if (isSet) {
            Object.keys(template.fieldDefinitions).forEach((fieldName, index) => {
                if (!attachmentFiles[index]) {
                    errorMessageList.push(`Please select a file for ${template.fieldDefinitions[fieldName]}`);
                }
            });
            if (requiresDescription) {
                if (description.length === 0) {
                    errorMessageList.push('Please enter a file upload description.');
                }
            }
        }
        else {
            if (attachmentFiles[0] === null) {
                errorMessageList.push('Please select a file to upload.');
            }
        }
        if (errorMessageList.length > 0) {
            setErrorMessages(errorMessageList.join('\n'));
            return;
        }
        setSaving(true);
        const formData = new FormData();
        formData.append('fileName', fileIdentifier);
        if (isSet) {
            attachmentFiles.forEach((file) => {
                formData.append('files', file);
            });
            if (requiresDescription) {
                formData.append('description', description);
            }
        }
        else {
            formData.append('file', attachmentFiles[0]);
        }
        const options = {
            method: 'POST',
            headers: {
                'content-type': 'multipart/form-data'
            },
            data: formData
        };
        try {
            const response = await (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_1__.apiCall)(`api/batchFileAttachmentUpload/${isSet ? 'set/' : ''}${params.routeParams.businessObjectName}`, options);
            const responseData = response.data;
            setSuccessMessages(formatResponseString(responseData.infoMessages));
            setErrorMessages(formatResponseString(responseData.errorMessages));
            setWarningMessages(formatResponseString(responseData.warningMessages));
            setAttachmentFiles([null, null]);
            setFileIdentifier('');
            setDescription('');
            setSaving(false);
            return response;
        }
        catch (error) {
            setSaving(false);
            if (!(0,axios__WEBPACK_IMPORTED_MODULE_9__.isAxiosError)(error)) {
                throw error;
            }
            setErrorMessages(`There was a problem uploading the file: ${error.message}`);
            return error;
        }
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_17__["default"]['page-padding'], children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_page_header_index_tsx__WEBPACK_IMPORTED_MODULE_10__["default"], { ref: pageHeader, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_breadcrumbs_index_tsx__WEBPACK_IMPORTED_MODULE_3__.Breadcrumbs, {}), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h2", { className: _style_css__WEBPACK_IMPORTED_MODULE_12__["default"].header, children: template.title })] }), isTemplateLoading && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_page_spinner_index_tsx__WEBPACK_IMPORTED_MODULE_11__["default"], {}), hasTemplateError && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_lookup_error_tsx__WEBPACK_IMPORTED_MODULE_7__["default"], { message: templateErrorMessage }), !isTemplateLoading && !hasTemplateError && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_17__["default"]['webapp-stretch'], children: [successMessages && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_5___default()(_style_css__WEBPACK_IMPORTED_MODULE_12__["default"]['padded-children'], _style_css__WEBPACK_IMPORTED_MODULE_12__["default"]['success-message']), children: successMessages })), warningMessages && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_5___default()(_style_css__WEBPACK_IMPORTED_MODULE_12__["default"]['padded-children'], _style_css__WEBPACK_IMPORTED_MODULE_12__["default"]['warning-message']), children: warningMessages })), errorMessages && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_5___default()(_style_css__WEBPACK_IMPORTED_MODULE_12__["default"]['padded-children'], _style_css__WEBPACK_IMPORTED_MODULE_12__["default"]['error-message']), children: errorMessages })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_5___default()(_style_css__WEBPACK_IMPORTED_MODULE_17__["default"].card), children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_collapsible_section_index_tsx__WEBPACK_IMPORTED_MODULE_6__["default"], { title: 'MANAGE BATCH FILES', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_12__["default"].container, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_5___default()(_style_css__WEBPACK_IMPORTED_MODULE_12__["default"]['padded-children'], _style_css__WEBPACK_IMPORTED_MODULE_12__["default"]['attachment-input']), children: isSet && template.fieldDefinitions
                                            ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_8__["default"], { spacing: 1, container: true, columns: 2, children: [Object.keys(template.fieldDefinitions).map((key, index) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react__WEBPACK_IMPORTED_MODULE_18__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_8__["default"], { display: 'flex', justifyContent: 'end', alignItems: 'center', size: 1, children: ["* ", template.fieldDefinitions[key], ":"] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material__WEBPACK_IMPORTED_MODULE_8__["default"], { display: 'flex', justifyContent: 'start', alignItems: 'center', size: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_document_notes_and_attachments_attachment_input_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { attachmentFile: attachmentFiles[index], handleFileChange: (file) => setAttachmentFileAt(file, index) }) })] }, key))), requiresDescription && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material__WEBPACK_IMPORTED_MODULE_8__["default"], { display: 'flex', justifyContent: 'end', alignItems: 'center', size: 1, children: "* File Upload Description:" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material__WEBPACK_IMPORTED_MODULE_8__["default"], { display: 'flex', justifyContent: 'start', alignItems: 'center', size: 1, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_TextField__WEBPACK_IMPORTED_MODULE_13__["default"], { id: 'description', name: 'description', slotProps: {
                                                                        inputLabel: { shrink: true },
                                                                        htmlInput: { maxLength: 40 }
                                                                    }, fullWidth: true, onChange: (e) => {
                                                                        setDescription(e.target.value);
                                                                    }, value: description }, 'description') })] }))] }))
                                            : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_document_notes_and_attachments_attachment_input_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { attachmentFile: attachmentFiles[0], handleFileChange: (file) => setAttachmentFileAt(file, 0) })) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_12__["default"]['padded-children'], children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_TextField__WEBPACK_IMPORTED_MODULE_13__["default"], { id: 'file-identifier', label: 'File Identifier*', size: 'small', onChange: (e) => {
                                                setFileIdentifier(e.target.value);
                                            }, value: fileIdentifier }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_12__["default"]['padded-children'], children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_4__["default"], { variant: 'contained', 
                                            /* eslint-disable-next-line @typescript-eslint/no-misused-promises */
                                            onClick: handleButtonClick, customStyle: { minWidth: '100px' }, loading: isSaving, children: "Add" }) })] }) }) })] }))] }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BatchUpload);


/***/ }),

/***/ "./app/batch-upload/style.css":
/*!************************************!*\
  !*** ./app/batch-upload/style.css ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/batch-upload/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/batch-upload/use-fetch-upload-template.ts":
/*!*******************************************************!*\
  !*** ./app/batch-upload/use-fetch-upload-template.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useFetchUploadTemplate: () => (/* binding */ useFetchUploadTemplate)
/* harmony export */ });
/* harmony import */ var _models_batch_upload_model_ts__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ~/models/batch-upload-model.ts */ "./app/models/batch-upload-model.ts");
/* harmony import */ var _models_business_object_ts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/models/business-object.ts */ "./app/models/business-object.ts");
/* harmony import */ var _utils_utils_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/utils/utils.tsx */ "./app/utils/utils.tsx");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */





const useFetchUploadTemplate = (fileInputTypeName, isSet = false) => {
    const [isTemplateLoading, setIsTemplateLoading] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(false);
    const [hasError, setHasError] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(false);
    const [errorMessage, setErrorMessage] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)();
    const [template, setTemplate] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)({
        title: `${(0,lodash__WEBPACK_IMPORTED_MODULE_3__.startCase)(fileInputTypeName)} Upload`,
        fieldDefinitions: null
    });
    (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
        setIsTemplateLoading(true);
        const fetchData = async () => {
            const data = await (0,_models_batch_upload_model_ts__WEBPACK_IMPORTED_MODULE_0__.getBatchUploadTemplate)(fileInputTypeName, isSet);
            if ((0,_models_business_object_ts__WEBPACK_IMPORTED_MODULE_1__.isErrorResponse)(data)) {
                let message = data.message;
                if (data.status === 403) {
                    (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_2__.showErrorPage)('unauthorized', `${(0,lodash__WEBPACK_IMPORTED_MODULE_3__.startCase)(fileInputTypeName)} Upload`);
                    return;
                }
                if (data.status === 404) {
                    message = `There was an issue finding batch upload file type for ${(0,lodash__WEBPACK_IMPORTED_MODULE_3__.startCase)(fileInputTypeName)}.`;
                }
                setIsTemplateLoading(false);
                setHasError(true);
                setErrorMessage(message ?? data.data);
                setTemplate({
                    title: `${(0,lodash__WEBPACK_IMPORTED_MODULE_3__.startCase)(fileInputTypeName)} Upload`,
                    fieldDefinitions: null
                });
                return;
            }
            setTemplate(data);
            setIsTemplateLoading(false);
            setErrorMessage(undefined);
            setHasError(false);
        };
        // eslint-disable-next-line no-void
        void fetchData();
    }, [fileInputTypeName, isSet]);
    return { isTemplateLoading, template, hasError, errorMessage };
};


/***/ }),

/***/ "./app/components/adapters/document-adapter.tsx":
/*!******************************************************!*\
  !*** ./app/components/adapters/document-adapter.tsx ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var flexboxgrid_dist_flexboxgrid_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! flexboxgrid/dist/flexboxgrid.css */ "./node_modules/flexboxgrid/dist/flexboxgrid.css");
/* harmony import */ var _documents_payment_application_adjustment_index_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/documents/payment-application-adjustment/index.tsx */ "./app/documents/payment-application-adjustment/index.tsx");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */




const DocumentAdapter = ({ docType }) => {
    (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
        const selectorsToHide = ['#headerarea-small', '.msg-excol', '.left-errmsg'];
        selectorsToHide.forEach((selector) => {
            const element = window.document.querySelectorAll(selector);
            element.forEach((element) => {
                if (element) {
                    element.style.display = 'none';
                }
            });
        });
        const idsToRemove = ['view_div', 'page-content'];
        idsToRemove.forEach((id) => {
            const element = window.document.getElementById(id);
            if (element) {
                element.removeAttribute('id');
            }
        });
    }, []);
    if (docType === 'APPA') {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_documents_payment_application_adjustment_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { documentData: window.documentData }));
    }
    else {
        console.error(`Could not find mapping for documentType ${docType}`);
        return null;
    }
};
DocumentAdapter.displayName = 'DocumentAdapter';
DocumentAdapter.propTypes = {
    docType: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_4__.memo)(DocumentAdapter));


/***/ }),

/***/ "./app/components/adapters/webapp-modal-inner.tsx":
/*!********************************************************!*\
  !*** ./app/components/adapters/webapp-modal-inner.tsx ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   WebappModalInner: () => (/* binding */ WebappModalInner),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _details_details_view_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/details/details-view.tsx */ "./app/details/details-view.tsx");
/* harmony import */ var _components_inquiry_index_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/components/inquiry/index.tsx */ "./app/components/inquiry/index.tsx");
/* harmony import */ var _utils_utils_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ~/utils/utils.tsx */ "./app/utils/utils.tsx");
/* harmony import */ var _components_modal_index_tsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/components/modal/index.tsx */ "./app/components/modal/index.tsx");
/* harmony import */ var qs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! qs */ "./node_modules/qs/lib/index.js");
/* harmony import */ var qs__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(qs__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _webapp_modal_css__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./webapp-modal.css */ "./app/components/adapters/webapp-modal.css");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ~/style.css */ "./app/style.css");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _webapp_modal_tsx__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./webapp-modal.tsx */ "./app/components/adapters/webapp-modal.tsx");
/* harmony import */ var _lookup_utils_tsx__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ~/lookup/utils.tsx */ "./app/lookup/utils.tsx");
/* harmony import */ var _lookup_modal_lookup_page_tsx__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ~/lookup/modal/lookup-page.tsx */ "./app/lookup/modal/lookup-page.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_13__);














const isLookupView = (candidate) => candidate?.type === _webapp_modal_tsx__WEBPACK_IMPORTED_MODULE_10__.WebappModalViewType.LOOKUP;
const isInquiryView = (candidate) => candidate?.type === _webapp_modal_tsx__WEBPACK_IMPORTED_MODULE_10__.WebappModalViewType.INQUIRY;
const isDetailsView = (candidate) => candidate?.type === _webapp_modal_tsx__WEBPACK_IMPORTED_MODULE_10__.WebappModalViewType.DETAILS;
function WebappModalInner({ isOpen, onRequestClose, initialView, onLookupValueSelected }) {
    const [views, setViews] = (0,react__WEBPACK_IMPORTED_MODULE_13__.useState)([]); // The 'pages' within the modal
    const currentView = (0,lodash__WEBPACK_IMPORTED_MODULE_9__.last)(views);
    //
    // INQUIRIES
    //
    const renderInquiryView = (view) => {
        const { url, title } = view.props;
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_inquiry_index_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], { inquiryUrl: url, inquiryTitle: title, onHandleInquiryPushed: addInquiryView }));
    };
    const addInquiryView = (inquiryTitle, inquiryUrl, clearOthers = false) => {
        // Add the new inquiry to the views
        setViews((prevViews) => [
            ...(clearOthers ? [] : prevViews),
            {
                type: _webapp_modal_tsx__WEBPACK_IMPORTED_MODULE_10__.WebappModalViewType.INQUIRY,
                title: inquiryTitle,
                props: {
                    url: inquiryUrl,
                    title: inquiryTitle
                }
            }
        ]);
    };
    //
    // LOOKUPS
    //
    const renderLookupView = (view) => {
        const { businessObjectName, formData } = view.props;
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _webapp_modal_css__WEBPACK_IMPORTED_MODULE_7__["default"]['lookup-view'], children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_lookup_modal_lookup_page_tsx__WEBPACK_IMPORTED_MODULE_12__["default"], { onLookup: openNestedLookup, businessObjectName: businessObjectName, parentFormData: formData, onCancelLookup: onCancelLookup, onReturnToParent: onReturnLookupValueToParent }) }));
    };
    const openNestedLookup = (businessObjectName, lookupRelationshipMappings) => {
        addLookupView(businessObjectName, {}, lookupRelationshipMappings);
    };
    // Adds new lookup view and initializes form
    const addLookupView = (0,react__WEBPACK_IMPORTED_MODULE_13__.useCallback)((businessObjectName, viewProps, lookupRelationshipMappings = {}, clearOthers = false) => {
        setViews((prevViews) => {
            const lastView = (0,lodash__WEBPACK_IMPORTED_MODULE_9__.last)(prevViews);
            let parentFormData = {};
            if (lastView?.type === _webapp_modal_tsx__WEBPACK_IMPORTED_MODULE_10__.WebappModalViewType.LOOKUP) {
                parentFormData = lastView?.props?.formData ?? {};
            }
            const formDataFromParent = (0,_lookup_utils_tsx__WEBPACK_IMPORTED_MODULE_11__.getFormDataToPopulateChild)(parentFormData, lookupRelationshipMappings);
            const fetchedProps = {
                businessObjectName,
                formData: formDataFromParent,
                lookupRelationshipMappings
            };
            return [
                ...(clearOthers ? [] : prevViews),
                {
                    type: _webapp_modal_tsx__WEBPACK_IMPORTED_MODULE_10__.WebappModalViewType.LOOKUP,
                    props: (0,lodash__WEBPACK_IMPORTED_MODULE_9__.merge)(fetchedProps, viewProps)
                }
            ];
        });
    }, []);
    const sanitizeRow = (row) => {
        return (0,lodash__WEBPACK_IMPORTED_MODULE_9__.reduce)(row, (result, value, key) => {
            // dereference inquiry object using their value prop
            if ((0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_4__.isLink)(value) && value.type === 'inquiry') {
                value = value.value;
            }
            result[key] = value;
            return result;
        }, {});
    };
    const handleReturnLookupValue = (value) => {
        onLookupValueSelected(sanitizeRow(value));
        handleClose();
    };
    const onLookupFormDataChange = (viewIndex, key, val) => {
        setViews((prevViews) => {
            const newViews = (0,lodash__WEBPACK_IMPORTED_MODULE_9__.cloneDeep)(prevViews);
            if (isLookupView(newViews[viewIndex])) {
                newViews[viewIndex].props.formData[key] = val;
                return newViews;
            }
            return prevViews;
        });
    };
    // Returns a value to the parent lookup
    // If there is no parent lookup, returns the value to the outer context
    const onReturnLookupValueToParent = (result) => {
        if (currentView && isLookupView(currentView)) {
            if (views.length === 1) {
                handleReturnLookupValue(result);
            }
            else {
                const childLookup = (0,lodash__WEBPACK_IMPORTED_MODULE_9__.last)(views);
                const parentLookupIndex = views.length - 2;
                const formDataToReturn = (0,_lookup_utils_tsx__WEBPACK_IMPORTED_MODULE_11__.getFormDataForReturnToParent)(result, childLookup.props.lookupRelationshipMappings);
                for (const key in formDataToReturn) {
                    const value = formDataToReturn[key];
                    onLookupFormDataChange(parentLookupIndex, key, value);
                }
                popView();
            }
        }
    };
    const onCancelLookup = () => {
        if (views.length <= 1) {
            handleClose();
        }
        else {
            popView();
        }
    };
    const onOpenInquiry = (businessObjectLabel, inquiryUrl, clickEvent) => {
        if (clickEvent) {
            clickEvent.preventDefault();
        }
        const queryString = qs__WEBPACK_IMPORTED_MODULE_6___default().parse((0,lodash__WEBPACK_IMPORTED_MODULE_9__.get)(inquiryUrl.split('?'), '1'));
        const boName = (0,lodash__WEBPACK_IMPORTED_MODULE_9__.get)(queryString, 'title');
        const title = boName ?? businessObjectLabel;
        addInquiryView(title, inquiryUrl);
    };
    //
    // DETAILS
    //
    const addDetailsView = (businessObjectName, businessObjectId, clearOthers = false) => {
        setViews((prevViews) => [
            ...(clearOthers ? [] : prevViews),
            {
                type: _webapp_modal_tsx__WEBPACK_IMPORTED_MODULE_10__.WebappModalViewType.DETAILS,
                title: `${(0,lodash__WEBPACK_IMPORTED_MODULE_9__.capitalize)(businessObjectName)} Details`,
                props: {
                    businessObjectName,
                    businessObjectId
                }
            }
        ]);
    };
    const renderDetailsView = (view) => {
        const { businessObjectName, businessObjectId } = view.props;
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_details_details_view_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { businessObjectName: businessObjectName, businessObjectId: businessObjectId, handleInquiry: (0,lodash__WEBPACK_IMPORTED_MODULE_9__.partial)(onOpenInquiry, (0,lodash__WEBPACK_IMPORTED_MODULE_9__.startCase)(businessObjectName)), handleOpenDetails: onOpenDetails }));
    };
    const onOpenDetails = (url, clickEvent) => {
        if (clickEvent) {
            clickEvent.preventDefault();
        }
        // Parse out the bo name and id from the url
        const parsedUrl = /\/details\/(.+)\/(.+)/.exec(url);
        if (parsedUrl && parsedUrl.length > 2) {
            const businessObjectName = parsedUrl[1];
            const businessObjectId = parsedUrl[2];
            addDetailsView(businessObjectName, businessObjectId);
        }
    };
    //
    // GENERAL
    //
    // Initialize the views with the starting view
    (0,react__WEBPACK_IMPORTED_MODULE_13__.useEffect)(() => {
        if (isOpen && !(0,lodash__WEBPACK_IMPORTED_MODULE_9__.isEmpty)(initialView)) {
            if (initialView.type === _webapp_modal_tsx__WEBPACK_IMPORTED_MODULE_10__.WebappModalViewType.LOOKUP) {
                const { businessObjectName } = initialView.props;
                if (businessObjectName) {
                    addLookupView(businessObjectName, initialView.props, {}, true);
                }
            }
            else if (initialView.type === _webapp_modal_tsx__WEBPACK_IMPORTED_MODULE_10__.WebappModalViewType.INQUIRY) {
                const { title, url } = initialView.props;
                addInquiryView(title, url, true);
            }
            else if (initialView.type === _webapp_modal_tsx__WEBPACK_IMPORTED_MODULE_10__.WebappModalViewType.DETAILS) {
                const { businessObjectName, businessObjectId } = initialView.props;
                addDetailsView(businessObjectName, businessObjectId, true);
            }
        }
    }, [isOpen, initialView, addLookupView]);
    const handleClose = () => {
        setViews([]);
        onRequestClose();
    };
    const popView = () => {
        setViews((prevViews) => prevViews.slice(0, prevViews.length - 1));
    };
    const renderView = (view) => {
        if (isLookupView(view)) {
            return renderLookupView(view);
        }
        if (isInquiryView(view)) {
            return renderInquiryView(view);
        }
        if (isDetailsView(view)) {
            return renderDetailsView(view);
        }
        return null;
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_13__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_modal_index_tsx__WEBPACK_IMPORTED_MODULE_5__["default"], { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_webapp_modal_css__WEBPACK_IMPORTED_MODULE_7__["default"]['webapp-modal'], _style_css__WEBPACK_IMPORTED_MODULE_8__["default"]['modal-container']), isOpen: isOpen, onRequestClose: handleClose, showClose: true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_webapp_modal_css__WEBPACK_IMPORTED_MODULE_7__["default"]['webapp-modal-content'], _style_css__WEBPACK_IMPORTED_MODULE_8__["default"]['modal-content']), children: renderView(currentView) }) }) }) }));
}
WebappModalInner.displayName = 'WebappModalInner';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_13__.memo)(WebappModalInner));


/***/ }),

/***/ "./app/components/adapters/webapp-modal.css":
/*!**************************************************!*\
  !*** ./app/components/adapters/webapp-modal.css ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_webapp_modal_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./webapp-modal.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/adapters/webapp-modal.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_webapp_modal_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_webapp_modal_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_webapp_modal_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_webapp_modal_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/adapters/webapp-modal.tsx":
/*!**************************************************!*\
  !*** ./app/components/adapters/webapp-modal.tsx ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   WebappModalViewType: () => (/* binding */ WebappModalViewType),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _webapp_modal_inner_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./webapp-modal-inner.tsx */ "./app/components/adapters/webapp-modal-inner.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);



var WebappModalViewType;
(function (WebappModalViewType) {
    WebappModalViewType["LOOKUP"] = "lookup";
    WebappModalViewType["DETAILS"] = "details";
    WebappModalViewType["INQUIRY"] = "inquiry";
})(WebappModalViewType || (WebappModalViewType = {}));
const WebappModal = ({ isOpen, onRequestClose, initialView, onLookupValueSelected }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_2__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_webapp_modal_inner_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { isOpen: isOpen, onRequestClose: onRequestClose, initialView: initialView, onLookupValueSelected: onLookupValueSelected }) }));
};
WebappModal.displayName = 'WebappModal';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_2__.memo)(WebappModal));


/***/ }),

/***/ "./app/components/attachment-link/index.tsx":
/*!**************************************************!*\
  !*** ./app/components/attachment-link/index.tsx ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AttachmentLink: () => (/* binding */ AttachmentLink)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const AttachmentLink = ({ attachmentInfo }) => {
    const { value, url } = attachmentInfo;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_1__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { href: url, target: '_blank', rel: 'noreferrer', children: value ?? 'Download Attachment' }) }));
};


/***/ }),

/***/ "./app/components/autocomplete/autocomplete-related.tsx":
/*!**************************************************************!*\
  !*** ./app/components/autocomplete/autocomplete-related.tsx ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_material_IconButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/material/IconButton */ "./node_modules/@mui/material/esm/IconButton/IconButton.js");
/* harmony import */ var _mui_material_Autocomplete__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/material/Autocomplete */ "./node_modules/@mui/material/esm/Autocomplete/Autocomplete.js");
/* harmony import */ var _mui_material_Popper__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mui/material/Popper */ "./node_modules/@mui/material/esm/Popper/Popper.js");
/* harmony import */ var _mui_icons_material_Search__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/icons-material/Search */ "./node_modules/@mui/icons-material/esm/Search.js");
/* harmony import */ var _search_result_item_tsx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./search-result-item.tsx */ "./app/components/autocomplete/search-result-item.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./style.css */ "./app/components/autocomplete/style.css");
/* harmony import */ var _mui_material_TextField__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @mui/material/TextField */ "./node_modules/@mui/material/esm/TextField/TextField.js");
/* harmony import */ var _models_business_object_ts__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ~/models/business-object.ts */ "./app/models/business-object.ts");
/* harmony import */ var _utils_utils_tsx__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ~/utils/utils.tsx */ "./app/utils/utils.tsx");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _adapters_webapp_modal_tsx__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../adapters/webapp-modal.tsx */ "./app/components/adapters/webapp-modal.tsx");















const MAX_RESULT_COUNT = 5;
const AutocompleteRelated = ({ id, value, onChange, className, placeholder, businessObjectLabel, businessObjectName, searchPropName, searchDescriptionPropName, primaryDisplayPropName, secondaryDisplayPropName, submitValuePropName, errorMessage, keyFields, associatedFields, rowData, defaultFilters }) => {
    const [options, setOptions] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
    const [inputValue, setInputValue] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)('');
    const [showLookup, setShowLookup] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const [subText, setSubText] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const fetchData = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => (0,lodash__WEBPACK_IMPORTED_MODULE_12__.throttle)(async (request, callback) => {
        const options = {
            searchParams: request.searchParams
        };
        const response = await (0,_models_business_object_ts__WEBPACK_IMPORTED_MODULE_10__.search)(request.businessObjectName, options);
        if ((0,_models_business_object_ts__WEBPACK_IMPORTED_MODULE_10__.isErrorResponse)(response)) {
            callback([]);
            return;
        }
        const results = response.results ?? [];
        callback(results);
    }, 200), []);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        let active = true;
        const asyncEffect = async () => {
            if (inputValue === '') {
                setOptions([]);
                return undefined;
            }
            let searchParams = {
                skip: 0,
                limit: MAX_RESULT_COUNT,
                [searchPropName]: `*${inputValue}*`
            };
            if (associatedFields && associatedFields.length > 0) {
                associatedFields.forEach((field) => {
                    if (rowData &&
                        Object.prototype.hasOwnProperty.call(rowData, field.searchPropName) &&
                        !(0,lodash__WEBPACK_IMPORTED_MODULE_12__.isNil)(rowData[field.searchPropName]) &&
                        !(0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(rowData[field.searchPropName])) {
                        searchParams[field.searchPropName] = `${rowData[field.searchPropName]}`;
                    }
                });
            }
            if (defaultFilters) {
                const clonedFilters = { ...defaultFilters };
                const fySearch = Object.keys(clonedFilters).filter((key) => clonedFilters[key] === '{FISCAL_YEAR}');
                if (fySearch.length > 0) {
                    const fy = await (0,_models_business_object_ts__WEBPACK_IMPORTED_MODULE_10__.getCurrentFiscalYear)();
                    fySearch.forEach((key) => {
                        clonedFilters[key] = fy;
                    });
                }
                searchParams = { ...searchParams, ...clonedFilters };
            }
            // eslint-disable-next-line no-void
            void fetchData({ searchParams, businessObjectName }, (results) => {
                if (active) {
                    let newOptions = [];
                    if (results) {
                        newOptions = [...results];
                    }
                    setOptions(newOptions);
                }
            });
        };
        // eslint-disable-next-line no-void
        void asyncEffect();
        return () => {
            active = false;
        };
    }, [
        associatedFields,
        businessObjectName,
        defaultFilters,
        fetchData,
        inputValue,
        rowData,
        searchPropName
    ]);
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((_event, value) => {
        const businessObject = options.find((fullOption) => fullOption[submitValuePropName] === value);
        if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isNil)(value) || (0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(value) || (0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(businessObject)) {
            setSubText(null);
            onChange('');
            return;
        }
        setSubText(businessObject && secondaryDisplayPropName
            ? businessObject[secondaryDisplayPropName]
            : null);
        onChange(businessObject !== null
            ? businessObject[submitValuePropName]
            : null);
    }, [onChange, options, secondaryDisplayPropName, submitValuePropName]);
    const getPrimaryDisplay = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((value) => {
        return (value[primaryDisplayPropName] ?? '');
    }, [primaryDisplayPropName]);
    const getSecondaryDisplay = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((value) => {
        if (secondaryDisplayPropName) {
            const secondaryDisplay = (value[secondaryDisplayPropName] ??
                null);
            if (secondaryDisplay !== null && !(0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(secondaryDisplay)) {
                return (0,lodash__WEBPACK_IMPORTED_MODULE_12__.startCase)(secondaryDisplay.toLowerCase());
            }
        }
        return null;
    }, [secondaryDisplayPropName]);
    const handleGetOptionLabel = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((option) => {
        if ((0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_11__.isBusinessObject)(option)) {
            return option[submitValuePropName];
        }
        return option;
    }, [submitValuePropName]);
    const handleFilterOptions = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((objectValues) => objectValues, []);
    const handleInputChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((_event, newInputValue) => {
        setInputValue(newInputValue);
    }, []);
    const isOptionEqualToValue = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((option, value) => {
        if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isNil)(value) || (0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(value)) {
            return true;
        }
        return option === value;
    }, []);
    const handleBlur = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => {
        if (options.length > 0) {
            const found = options.find((option) => option[submitValuePropName] === event.target.value);
            if (found) {
                if (secondaryDisplayPropName) {
                    setSubText(found[secondaryDisplayPropName]);
                }
                onChange(found[submitValuePropName]);
            }
            else {
                setSubText(`No ${businessObjectName} for ${event.target.value} found`);
                onChange(event.target.value);
            }
        }
        else if (!(0,lodash__WEBPACK_IMPORTED_MODULE_12__.isNil)(event.target.value) &&
            !(0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(event.target.value) &&
            event.target.value !== value) {
            setSubText(`No ${businessObjectName} for ${event.target.value} found`);
            onChange(event.target.value);
        }
        else if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isNil)(event.target.value) || (0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(event.target.value)) {
            setSubText(null);
            onChange('');
        }
        setInputValue('');
    }, [
        businessObjectName,
        onChange,
        options,
        secondaryDisplayPropName,
        submitValuePropName,
        value
    ]);
    const handleRenderOptions = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((props, option) => {
        let key = option;
        const businessObject = options.find((fullOption) => fullOption[submitValuePropName] === option);
        if (businessObject && keyFields && keyFields.length > 0) {
            keyFields.forEach((str) => {
                key += `${businessObject[str]}-`;
            });
        }
        return ((0,react__WEBPACK_IMPORTED_MODULE_1__.createElement)("li", { ...props, key: key },
            (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_search_result_item_tsx__WEBPACK_IMPORTED_MODULE_7__["default"], { primary: businessObject ? getPrimaryDisplay(businessObject) : option, secondary: businessObject ? getSecondaryDisplay(businessObject) : null })));
    }, [
        getPrimaryDisplay,
        getSecondaryDisplay,
        keyFields,
        options,
        submitValuePropName
    ]);
    const handleRenderInput = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((props) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_TextField__WEBPACK_IMPORTED_MODULE_9__["default"], { ...props, placeholder: placeholder, fullWidth: true, onBlur: handleBlur, error: !!errorMessage, helperText: errorMessage ?? subText ?? ' ' })), [errorMessage, handleBlur, subText, placeholder]);
    const handleRenderPopper = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((props) => {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_Popper__WEBPACK_IMPORTED_MODULE_5__["default"], { ...props, style: { width: 'fit-content' }, placement: 'bottom-start' }));
    }, []);
    const handleLookupValueSubmit = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((lookupValue) => {
        let subText = null;
        if (searchDescriptionPropName) {
            subText = lookupValue[searchDescriptionPropName];
        }
        else if (secondaryDisplayPropName) {
            subText = lookupValue[secondaryDisplayPropName];
        }
        setSubText(subText);
        let newValue = lookupValue[searchPropName];
        if ((0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_11__.isLink)(newValue)) {
            newValue = newValue.value;
        }
        onChange(newValue);
        setInputValue('');
        setOptions([]);
    }, [
        onChange,
        searchDescriptionPropName,
        searchPropName,
        secondaryDisplayPropName
    ]);
    const lookupView = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
        const lookup = {
            type: _adapters_webapp_modal_tsx__WEBPACK_IMPORTED_MODULE_13__.WebappModalViewType.LOOKUP,
            props: {
                businessObjectName,
                formData: {
                    [searchPropName]: value
                },
                lookupRelationshipMappings: {}
            }
        };
        if (associatedFields && associatedFields.length > 0) {
            associatedFields.forEach((field) => {
                if (rowData &&
                    Object.prototype.hasOwnProperty.call(rowData, field.searchPropName) &&
                    !(0,lodash__WEBPACK_IMPORTED_MODULE_12__.isNil)(rowData[field.searchPropName]) &&
                    !(0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(rowData[field.searchPropName])) {
                    lookup.props.formData[field.searchPropName] = `${rowData[field.searchPropName]}`;
                }
            });
        }
        return lookup;
    }, [businessObjectName, searchPropName, value, associatedFields, rowData]);
    const mappedOptions = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => options.map((option) => option[submitValuePropName]), [options, submitValuePropName]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_1__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_2___default()(_style_css__WEBPACK_IMPORTED_MODULE_8__["default"]['input-wrapper'], className), children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_8__["default"]['autocomplete-wrapper'], children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_Autocomplete__WEBPACK_IMPORTED_MODULE_4__["default"], { id: id, className: _style_css__WEBPACK_IMPORTED_MODULE_8__["default"].input, getOptionLabel: handleGetOptionLabel, fullWidth: true, size: 'small', forcePopupIcon: false, clearOnBlur: false, filterOptions: handleFilterOptions, value: value, onChange: handleChange, onInputChange: handleInputChange, isOptionEqualToValue: isOptionEqualToValue, options: mappedOptions, "data-testid": 'business-object-input', renderInput: handleRenderInput, renderOption: handleRenderOptions, PopperComponent: handleRenderPopper }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_3__["default"], { "data-testid": 'lookup-button', "aria-label": `Look up ${businessObjectLabel}`, onClick: () => setShowLookup(true), children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_Search__WEBPACK_IMPORTED_MODULE_6__["default"], {}) })] }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_adapters_webapp_modal_tsx__WEBPACK_IMPORTED_MODULE_13__["default"], { isOpen: showLookup, onRequestClose: () => setShowLookup(false), initialView: lookupView, onLookupValueSelected: handleLookupValueSubmit })] }) }));
};
AutocompleteRelated.displayName = 'AutocompleteRelated';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(AutocompleteRelated));


/***/ }),

/***/ "./app/components/autocomplete/autocomplete-standalone.tsx":
/*!*****************************************************************!*\
  !*** ./app/components/autocomplete/autocomplete-standalone.tsx ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/buttons/index.tsx */ "./app/components/buttons/index.tsx");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _mui_material_IconButton__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/material/IconButton */ "./node_modules/@mui/material/esm/IconButton/IconButton.js");
/* harmony import */ var _mui_material_Autocomplete__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mui/material/Autocomplete */ "./node_modules/@mui/material/esm/Autocomplete/Autocomplete.js");
/* harmony import */ var _mui_material_Popper__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/material/Popper */ "./node_modules/@mui/material/esm/Popper/Popper.js");
/* harmony import */ var _mui_icons_material_Search__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/icons-material/Search */ "./node_modules/@mui/icons-material/esm/Search.js");
/* harmony import */ var _search_result_item_tsx__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./search-result-item.tsx */ "./app/components/autocomplete/search-result-item.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./style.css */ "./app/components/autocomplete/style.css");
/* harmony import */ var _mui_material_TextField__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @mui/material/TextField */ "./node_modules/@mui/material/esm/TextField/TextField.js");
/* harmony import */ var use_immer__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! use-immer */ "./node_modules/use-immer/dist/use-immer.module.mjs");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var _models_business_object_ts__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ~/models/business-object.ts */ "./app/models/business-object.ts");
/* harmony import */ var _adapters_webapp_modal_tsx__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../adapters/webapp-modal.tsx */ "./app/components/adapters/webapp-modal.tsx");
















const MAX_RESULT_COUNT = 5;
var ACTION_TYPES;
(function (ACTION_TYPES) {
    ACTION_TYPES["NEW_RESULTS"] = "NEW_RESULTS";
    ACTION_TYPES["HANDLE_CHANGE"] = "HANDLE_CHANGE";
    ACTION_TYPES["HANDLE_INPUT_CHANGE"] = "HANDLE_INPUT_CHANGE";
    ACTION_TYPES["HANDLE_BLUR"] = "HANDLE_BLUR";
    ACTION_TYPES["HANDLE_SUBMIT"] = "HANDLE_SUBMIT";
    ACTION_TYPES["TOGGLE_LOOKUP"] = "TOGGLE_LOOKUP";
})(ACTION_TYPES || (ACTION_TYPES = {}));
const getSecondaryText = (value, secondaryDisplayPropName) => {
    if (!secondaryDisplayPropName) {
        return null;
    }
    if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isFunction)(secondaryDisplayPropName)) {
        return secondaryDisplayPropName(value);
    }
    return (0,lodash__WEBPACK_IMPORTED_MODULE_12__.get)(value, secondaryDisplayPropName, null);
};
const reducer = (draft, action) => {
    switch (action.type) {
        case ACTION_TYPES.NEW_RESULTS:
            draft.options = action.payload.options ?? [];
            break;
        case ACTION_TYPES.HANDLE_CHANGE:
            if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isNil)(action.payload.value) || (0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(action.payload.value)) {
                draft.subText = null;
            }
            else {
                draft.subText = getSecondaryText(action.payload.value, action.payload?.secondaryDisplayPropName);
            }
            break;
        case ACTION_TYPES.HANDLE_INPUT_CHANGE:
            if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isNil)(action.payload.inputValue) ||
                (0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(action.payload.inputValue)) {
                draft.options = [];
            }
            draft.inputValue = action.payload.inputValue;
            break;
        case ACTION_TYPES.HANDLE_BLUR:
            if (action.payload.found) {
                draft.subText = getSecondaryText(action.payload.value, action.payload.secondaryDisplayPropName);
                draft.errorMessage = null;
            }
            else {
                draft.subText = null;
                if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isNil)(action.payload.value) || (0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(action.payload.value)) {
                    draft.errorMessage = null;
                }
                else {
                    draft.errorMessage = `No ${action.payload.businessObjectName} for ${action.payload.value} found`;
                }
            }
            break;
        case ACTION_TYPES.HANDLE_SUBMIT:
            draft.options = [];
            draft.inputValue = '';
            draft.subText = null;
            draft.errorMessage = null;
            break;
        case ACTION_TYPES.TOGGLE_LOOKUP:
            draft.showLookup = !draft.showLookup;
            break;
        default:
            break;
    }
};
const defaultState = {
    options: [],
    inputValue: '',
    showLookup: false,
    subText: null,
    errorMessage: null
};
const AutocompleteStandalone = ({ id, value, onChange, className, placeholder, businessObjectLabel, businessObjectName, searchPropName, primaryDisplayPropName, secondaryDisplayPropName, submitValuePropName, keyFields, defaultFilters, onSubmit, submitButtonLabel, label, shapeSubmitValue, wide = false }) => {
    const [state, dispatch] = (0,use_immer__WEBPACK_IMPORTED_MODULE_11__.useImmerReducer)(reducer, defaultState);
    const fetchData = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => (0,lodash__WEBPACK_IMPORTED_MODULE_12__.throttle)(async (request, callback) => {
        const options = {
            searchParams: request.searchParams
        };
        const response = await (0,_models_business_object_ts__WEBPACK_IMPORTED_MODULE_13__.search)(request.businessObjectName, options);
        if ((0,_models_business_object_ts__WEBPACK_IMPORTED_MODULE_13__.isErrorResponse)(response)) {
            callback([]);
            return;
        }
        const results = response.results ?? [];
        callback(results);
    }, 200), []);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        let active = true;
        const asyncEffect = async () => {
            if (state.inputValue === '') {
                return undefined;
            }
            let searchParams = {
                skip: 0,
                limit: MAX_RESULT_COUNT,
                [searchPropName]: `*${state.inputValue}*`
            };
            if (defaultFilters) {
                const clonedFilters = { ...defaultFilters };
                const fySearch = Object.keys(clonedFilters).filter((key) => clonedFilters[key] === '{FISCAL_YEAR}');
                if (fySearch.length > 0) {
                    const fy = await (0,_models_business_object_ts__WEBPACK_IMPORTED_MODULE_13__.getCurrentFiscalYear)();
                    if ((0,_models_business_object_ts__WEBPACK_IMPORTED_MODULE_13__.isErrorResponse)(fy)) {
                        console.error(fy);
                        return;
                    }
                    fySearch.forEach((key) => {
                        clonedFilters[key] = fy;
                    });
                }
                searchParams = { ...searchParams, ...clonedFilters };
            }
            await fetchData({ searchParams, businessObjectName }, (results) => {
                if (active) {
                    let newOptions = [];
                    if (results) {
                        newOptions = [...results];
                    }
                    dispatch({
                        type: ACTION_TYPES.NEW_RESULTS,
                        payload: { options: newOptions }
                    });
                }
            });
        };
        // eslint-disable-next-line no-void
        void asyncEffect();
        return () => {
            active = false;
        };
    }, [
        businessObjectName,
        defaultFilters,
        fetchData,
        state.inputValue,
        searchPropName,
        dispatch
    ]);
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((_event, value) => {
        dispatch({
            type: ACTION_TYPES.HANDLE_CHANGE,
            payload: { value, secondaryDisplayPropName }
        });
        if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isNil)(value)) {
            onChange(null);
            return;
        }
        if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isString)(value)) {
            onChange(value);
            return;
        }
        onChange(value[submitValuePropName] ?? null);
    }, [dispatch, onChange, secondaryDisplayPropName, submitValuePropName]);
    const getPrimaryDisplay = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((value) => {
        if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isString)(value)) {
            return value;
        }
        return (0,lodash__WEBPACK_IMPORTED_MODULE_12__.get)(value, primaryDisplayPropName, '');
    }, [primaryDisplayPropName]);
    const getSecondaryDisplay = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((value) => {
        if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isNil)(value)) {
            return null;
        }
        if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isString)(value)) {
            return value;
        }
        let secondaryDisplay;
        if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isFunction)(secondaryDisplayPropName)) {
            secondaryDisplay = secondaryDisplayPropName(value);
        }
        else {
            secondaryDisplay = (0,lodash__WEBPACK_IMPORTED_MODULE_12__.get)(value, secondaryDisplayPropName ?? 'dummy', null);
        }
        if (!(0,lodash__WEBPACK_IMPORTED_MODULE_12__.isNil)(secondaryDisplay) && !(0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(secondaryDisplay)) {
            return (0,lodash__WEBPACK_IMPORTED_MODULE_12__.startCase)(secondaryDisplay.toLowerCase());
        }
        return null;
    }, [secondaryDisplayPropName]);
    const handleGetOptionLabel = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((option) => {
        if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isString)(option)) {
            return option;
        }
        return option[submitValuePropName];
    }, [submitValuePropName]);
    const handleFilterOptions = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((x) => x, []);
    const handleInputChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((_event, newInputValue) => {
        dispatch({
            type: ACTION_TYPES.HANDLE_INPUT_CHANGE,
            payload: { inputValue: newInputValue }
        });
    }, [dispatch]);
    const isOptionEqualToValue = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((option, value) => {
        if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isNil)(value) || (0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(value)) {
            return true;
        }
        else if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isPlainObject)(value)) {
            const optionValue = (0,lodash__WEBPACK_IMPORTED_MODULE_12__.get)(option, submitValuePropName);
            const valueValue = (0,lodash__WEBPACK_IMPORTED_MODULE_12__.get)(value, submitValuePropName);
            return optionValue === valueValue;
        }
        else {
            return (0,lodash__WEBPACK_IMPORTED_MODULE_12__.get)(option, submitValuePropName) === value;
        }
    }, [submitValuePropName]);
    const handleBlur = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => {
        let onChangeValue = null;
        const action = {
            type: ACTION_TYPES.HANDLE_BLUR,
            payload: {
                secondaryDisplayPropName,
                businessObjectName,
                value: event.target.value,
                found: false
            }
        };
        if (state.options.length > 0) {
            const found = state.options.find((option) => option[submitValuePropName] === event.target.value);
            if (found) {
                action.payload.value = found;
                action.payload.found = true;
            }
        }
        else if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isNil)(event.target.value) || (0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(event.target.value)) {
            onChangeValue = '';
        }
        dispatch(action);
        onChange(onChangeValue ?? action.payload.value);
    }, [
        secondaryDisplayPropName,
        businessObjectName,
        state.options,
        dispatch,
        onChange,
        submitValuePropName
    ]);
    const handleRenderOptions = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((props, option) => {
        let key = (0,lodash__WEBPACK_IMPORTED_MODULE_12__.get)(option, submitValuePropName);
        if (keyFields && keyFields.length > 0) {
            keyFields.forEach((str) => {
                key += `${(0,lodash__WEBPACK_IMPORTED_MODULE_12__.get)(option, str)}-`;
            });
        }
        return ((0,react__WEBPACK_IMPORTED_MODULE_1__.createElement)("li", { ...props, key: key },
            (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_search_result_item_tsx__WEBPACK_IMPORTED_MODULE_8__["default"], { primary: getPrimaryDisplay(option), secondary: getSecondaryDisplay(option) })));
    }, [getPrimaryDisplay, getSecondaryDisplay, keyFields, submitValuePropName]);
    const handleRenderInput = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((params) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_TextField__WEBPACK_IMPORTED_MODULE_10__["default"], { ...params, placeholder: placeholder, label: label, slotProps: {
            inputLabel: {
                shrink: true
            }
        }, fullWidth: true, onBlur: handleBlur, error: !!state.errorMessage, helperText: state.errorMessage ?? state.subText ?? ' ' })), [placeholder, label, handleBlur, state.errorMessage, state.subText]);
    const handleRenderPopper = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((params) => {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_Popper__WEBPACK_IMPORTED_MODULE_6__["default"], { ...params, style: { width: 'fit-content' }, placement: 'bottom-start' }));
    }, []);
    const handleLookupValueSubmit = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(async (lookupValue) => {
        dispatch({
            type: ACTION_TYPES.HANDLE_SUBMIT
        });
        let submitValue = lookupValue;
        if (shapeSubmitValue) {
            submitValue = await shapeSubmitValue(lookupValue);
        }
        if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isNil)(submitValue) || (0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(submitValue)) {
            return;
        }
        await onSubmit(submitValue);
    }, [dispatch, onSubmit, shapeSubmitValue]);
    const handleSubmit = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(async () => {
        dispatch({
            type: ACTION_TYPES.HANDLE_SUBMIT
        });
        let submitValue = value;
        if (shapeSubmitValue) {
            submitValue = await shapeSubmitValue(value);
        }
        await onSubmit(submitValue);
    }, [dispatch, onSubmit, shapeSubmitValue, value]);
    const lookupView = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
        let searchValue;
        if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isNil)(value) || (0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(value)) {
            searchValue = '';
        }
        else if ((0,lodash__WEBPACK_IMPORTED_MODULE_12__.isPlainObject)(value)) {
            searchValue = (0,lodash__WEBPACK_IMPORTED_MODULE_12__.get)(value, primaryDisplayPropName, '');
        }
        else {
            searchValue = value;
        }
        return {
            type: _adapters_webapp_modal_tsx__WEBPACK_IMPORTED_MODULE_14__.WebappModalViewType.LOOKUP,
            props: {
                businessObjectName,
                formData: {
                    [searchPropName]: searchValue
                },
                lookupRelationshipMappings: {}
            }
        };
    }, [businessObjectName, searchPropName, value, primaryDisplayPropName]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react__WEBPACK_IMPORTED_MODULE_1__.StrictMode, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_3___default()(_style_css__WEBPACK_IMPORTED_MODULE_9__["default"]['input-wrapper'], wide ? _style_css__WEBPACK_IMPORTED_MODULE_9__["default"]['input-wrapper-wide'] : undefined, className), children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_9__["default"]['autocomplete-wrapper'], children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_Autocomplete__WEBPACK_IMPORTED_MODULE_5__["default"], { id: id, className: _style_css__WEBPACK_IMPORTED_MODULE_9__["default"].input, getOptionLabel: handleGetOptionLabel, fullWidth: true, size: 'small', forcePopupIcon: false, clearOnBlur: false, filterOptions: handleFilterOptions, value: value, onChange: handleChange, onInputChange: handleInputChange, isOptionEqualToValue: isOptionEqualToValue, options: state.options, "data-testid": 'business-object-input', renderInput: handleRenderInput, renderOption: handleRenderOptions, PopperComponent: handleRenderPopper }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_4__["default"], { "data-testid": 'lookup-button', "aria-label": `Look up ${businessObjectLabel}`, onClick: () => dispatch({ type: ACTION_TYPES.TOGGLE_LOOKUP }), children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_Search__WEBPACK_IMPORTED_MODULE_7__["default"], {}) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { testId: 'add-button', variant: 'outlined', disabled: (0,lodash__WEBPACK_IMPORTED_MODULE_12__.isNil)(value) ||
                                (0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(value) ||
                                !(0,lodash__WEBPACK_IMPORTED_MODULE_12__.isNil)(state.errorMessage) ||
                                !(0,lodash__WEBPACK_IMPORTED_MODULE_12__.isEmpty)(state.errorMessage), 
                            /* eslint-disable-next-line @typescript-eslint/no-misused-promises */
                            onClick: handleSubmit, children: submitButtonLabel })] }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_adapters_webapp_modal_tsx__WEBPACK_IMPORTED_MODULE_14__["default"], { isOpen: state.showLookup, onRequestClose: () => dispatch({ type: ACTION_TYPES.TOGGLE_LOOKUP }), initialView: lookupView, 
                /* eslint-disable-next-line @typescript-eslint/no-misused-promises */
                onLookupValueSelected: handleLookupValueSubmit })] }));
};
AutocompleteStandalone.displayName = 'AutocompleteStandalone';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(AutocompleteStandalone));


/***/ }),

/***/ "./app/components/autocomplete/search-result-item.tsx":
/*!************************************************************!*\
  !*** ./app/components/autocomplete/search-result-item.tsx ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./style.css */ "./app/components/autocomplete/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */




const SearchResultItem = ({ primary, secondary }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_4__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { children: [primary, !(0,lodash__WEBPACK_IMPORTED_MODULE_2__.isEmpty)(secondary) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('caption', _style_css__WEBPACK_IMPORTED_MODULE_3__["default"]['secondary-property']), children: secondary }))] }) }));
};
SearchResultItem.displayName = 'SearchResultItem';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_4__.memo)(SearchResultItem));


/***/ }),

/***/ "./app/components/autocomplete/style.css":
/*!***********************************************!*\
  !*** ./app/components/autocomplete/style.css ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/autocomplete/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/breadcrumbs/index.tsx":
/*!**********************************************!*\
  !*** ./app/components/breadcrumbs/index.tsx ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Breadcrumbs: () => (/* binding */ Breadcrumbs)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _mui_icons_material_ArrowBack__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/icons-material/ArrowBack */ "./node_modules/@mui/icons-material/esm/ArrowBack.js");
/* harmony import */ var _utils_utils_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/utils/utils.tsx */ "./app/utils/utils.tsx");
/* harmony import */ var _mui_material_IconButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/material/IconButton */ "./node_modules/@mui/material/esm/IconButton/IconButton.js");
/* harmony import */ var react_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-router */ "./node_modules/react-router/dist/development/chunk-PVWAREVJ.mjs");
/* harmony import */ var _mui_material_Breadcrumbs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mui/material/Breadcrumbs */ "./node_modules/@mui/material/esm/Breadcrumbs/Breadcrumbs.js");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./style.css */ "./app/components/breadcrumbs/style.css");
/* harmony import */ var _models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ~/models/page-history-slice.ts */ "./app/models/page-history-slice.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/dist/react-redux.mjs");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */









const MAX_NUM_CRUMBS = 4;
const generateLinks = (pageHistory, dispatch, resetLookup) => {
    const backButton = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_3__["default"], { size: 'small', onClick: () => {
            if (resetLookup) {
                resetLookup();
            }
            dispatch((0,_models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_7__.popHistory)());
        }, "data-testid": 'breadcrumb-arrow-button', "aria-label": 'breadcrumb-back-button', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_ArrowBack__WEBPACK_IMPORTED_MODULE_1__["default"], { name: 'back' }) }));
    return pageHistory.map((history, index) => {
        if (history.legacy) {
            const breadcrumb = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"].breadcrumb, onClick: () => {
                    if (resetLookup) {
                        resetLookup();
                    }
                    dispatch((0,_models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_7__.goToHistory)(history.id));
                }, style: { cursor: 'pointer' }, "data-testid": 'breadcrumb-link', children: history.title }, history.id));
            if (index === 0) {
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [backButton, breadcrumb] }, 'first-breadcrumb-with-back-button'));
            }
            return breadcrumb;
        }
        else {
            const searchParams = (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_2__.getStringifiedParams)((history?.pageConfiguration?.formData ?? {}));
            const breadcrumb = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_router__WEBPACK_IMPORTED_MODULE_4__.Link, { replace: true, to: `${history.pathname}${searchParams}`, onClick: () => {
                    if (resetLookup) {
                        resetLookup();
                    }
                    dispatch((0,_models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_7__.goToHistory)(history.id));
                }, "data-testid": 'breadcrumb-link', children: history.title }, history.id));
            if (index === 0) {
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [backButton, breadcrumb] }, 'first-breadcrumb-with-back-button'));
            }
            return breadcrumb;
        }
    });
};
const Breadcrumbs = (0,react__WEBPACK_IMPORTED_MODULE_8__.memo)(({ resetLookup }) => {
    const history = (0,react_redux__WEBPACK_IMPORTED_MODULE_9__.useSelector)(_models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_7__.getHistory);
    const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_9__.useDispatch)();
    const listener = (0,react__WEBPACK_IMPORTED_MODULE_8__.useCallback)(() => {
        if (resetLookup) {
            resetLookup();
        }
        dispatch((0,_models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_7__.popHistory)());
    }, [dispatch, resetLookup]);
    (0,react__WEBPACK_IMPORTED_MODULE_8__.useEffect)(() => {
        window.addEventListener('popstate', listener);
        return () => {
            setTimeout(() => {
                window.removeEventListener('popstate', listener);
            }, 0);
        };
    }, [dispatch, listener]);
    if (history.length === 0) {
        return null;
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_8__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_Breadcrumbs__WEBPACK_IMPORTED_MODULE_5__["default"], { sx: {
                fontSize: 'inherit',
                backgroundColor: 'inherit',
                paddingTop: '12px',
                marginBottom: '-10px'
            }, maxItems: MAX_NUM_CRUMBS, "aria-label": 'breadcrumb', itemsBeforeCollapse: 1, itemsAfterCollapse: 3, children: generateLinks(history, dispatch, resetLookup) }) }));
});


/***/ }),

/***/ "./app/components/breadcrumbs/style.css":
/*!**********************************************!*\
  !*** ./app/components/breadcrumbs/style.css ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/breadcrumbs/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/buttons/button-bar.tsx":
/*!***********************************************!*\
  !*** ./app/components/buttons/button-bar.tsx ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/components/buttons/index.tsx */ "./app/components/buttons/index.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


const ButtonBar = ({ buttonInfo, onButtonClick, className, loading = false }) => {
    const handleButtonClick = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)(async (action) => {
        if (onButtonClick) {
            await onButtonClick(action);
        }
    }, [onButtonClick]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_2__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: className, children: buttonInfo.map(({ label, action, variant, props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { testId: `${label}-button`, 
                /* eslint-disable-next-line @typescript-eslint/no-misused-promises */
                onClick: async () => {
                    await handleButtonClick(action);
                }, variant: variant ?? 'contained', customStyle: { marginLeft: '8px' }, loading: loading, ...props, children: label }, label))) }) }));
};
ButtonBar.displayName = 'ButtonBar';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_2__.memo)(ButtonBar));


/***/ }),

/***/ "./app/components/buttons/close-button.tsx":
/*!*************************************************!*\
  !*** ./app/components/buttons/close-button.tsx ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _mui_icons_material_Close__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/icons-material/Close */ "./node_modules/@mui/icons-material/esm/Close.js");
/* harmony import */ var _mui_material_IconButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material/IconButton */ "./node_modules/@mui/material/esm/IconButton/IconButton.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);




const CloseButton = ({ onClick, testId, ariaLabel, className }) => {
    const dataTestId = testId ? `close-${testId}` : undefined;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_3__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_2__["default"], { "data-testid": dataTestId, "aria-label": ariaLabel ?? 'Close', onClick: onClick, className: className, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_Close__WEBPACK_IMPORTED_MODULE_1__["default"], { "data-testid": 'close-icon' }) }) }));
};
CloseButton.displayName = 'CloseButton';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_3__.memo)(CloseButton));


/***/ }),

/***/ "./app/components/buttons/index.tsx":
/*!******************************************!*\
  !*** ./app/components/buttons/index.tsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material_Button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material/Button */ "./node_modules/@mui/material/esm/Button/Button.js");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


const defaultStyle = {
    textTransform: 'none',
    fontSize: '14px',
    height: '32px',
    color: 'var(--kuali-blue-default)'
};
const Button = ({ children, onClick, id, ariaLabel, testId, variant = 'text', href, customStyle = {}, disabled = false, loading, type = 'button', customClassName, ref }) => {
    const style = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
        if (variant === 'outlined') {
            return {
                ...defaultStyle,
                borderColor: 'var(--kuali-light-gray-500)',
                backgroundColor: 'var(--kuali-white-default)',
                ...customStyle
            };
        }
        else if (variant === 'contained') {
            return {
                ...defaultStyle,
                backgroundColor: 'var(--kuali-blue-default)',
                color: 'var(--kuali-white-default)',
                ...customStyle
            };
        }
        return { ...defaultStyle, ...customStyle };
    }, [customStyle, variant]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_1__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_Button__WEBPACK_IMPORTED_MODULE_2__["default"], { href: href, onClick: onClick, id: id, "aria-label": ariaLabel, "data-testid": testId, sx: style, variant: variant, disabled: disabled, type: type, ref: ref, className: customClassName, loading: loading, children: children }) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Button);


/***/ }),

/***/ "./app/components/buttons/menu-button.tsx":
/*!************************************************!*\
  !*** ./app/components/buttons/menu-button.tsx ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _mui_material_IconButton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material/IconButton */ "./node_modules/@mui/material/esm/IconButton/IconButton.js");
/* harmony import */ var _mui_material_Menu__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material/Menu */ "./node_modules/@mui/material/esm/Menu/Menu.js");
/* harmony import */ var _mui_material_MenuItem__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/material/MenuItem */ "./node_modules/@mui/material/esm/MenuItem/MenuItem.js");
/* harmony import */ var _components_tooltip_index_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ~/components/tooltip/index.tsx */ "./app/components/tooltip/index.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */





const MenuButton = ({ items = [], tooltipLabel, icon, ariaLabel, id }) => {
    const [anchorEl, setAnchorEl] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(null);
    const open = Boolean(anchorEl);
    const handleClick = (event) => {
        setAnchorEl(event.currentTarget);
    };
    const handleClose = () => {
        setAnchorEl(null);
    };
    const button = (0,react__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => {
        const innerButton = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_1__["default"], { onClick: handleClick, "aria-label": ariaLabel, "aria-controls": open ? `${id}-menu` : undefined, "aria-haspopup": true, "aria-expanded": open ? true : undefined, id: `${id}-button`, children: icon }));
        if (tooltipLabel) {
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_tooltip_index_tsx__WEBPACK_IMPORTED_MODULE_4__["default"], { title: tooltipLabel, placement: 'top', children: innerButton }));
        }
        return innerButton;
    }, [ariaLabel, icon, id, open, tooltipLabel]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_5__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [button, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_Menu__WEBPACK_IMPORTED_MODULE_2__["default"], { id: `${id}-menu`, "aria-labelledby": `${id}-button`, anchorEl: anchorEl, open: open, onClose: handleClose, anchorOrigin: {
                        vertical: 'top',
                        horizontal: 'right'
                    }, transformOrigin: {
                        vertical: 'top',
                        horizontal: 'left'
                    }, children: items.map((item) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_MenuItem__WEBPACK_IMPORTED_MODULE_3__["default"], { onClick: () => {
                            item.handleClick();
                            handleClose();
                        }, children: item.label }, item.key))) })] }) }));
};
MenuButton.displayName = 'MenuButton';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_5__.memo)(MenuButton));


/***/ }),

/***/ "./app/components/collapsible-section/index.tsx":
/*!******************************************************!*\
  !*** ./app/components/collapsible-section/index.tsx ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material_IconButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material/IconButton */ "./node_modules/@mui/material/esm/IconButton/IconButton.js");
/* harmony import */ var _mui_icons_material_KeyboardArrowUp__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material/KeyboardArrowUp */ "./node_modules/@mui/icons-material/esm/KeyboardArrowUp.js");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/collapsible-section/style.css");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../style.css */ "./app/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */






const CollapsibleSection = ({ className, id, title, children, contentClassName, isCollapsible = true, startOpen = true, padded = true, actions = null }) => {
    const [isOpen, setIsOpen] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(isCollapsible ? startOpen : true);
    const toggleArrowButton = (0,react__WEBPACK_IMPORTED_MODULE_6__.useMemo)(() => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_2__["default"], { onClick: () => {
            setIsOpen(!isOpen);
        }, "aria-label": isOpen ? 'collapse' : 'expand', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_KeyboardArrowUp__WEBPACK_IMPORTED_MODULE_3__["default"], { sx: {
                transform: isOpen ? 'rotate(180deg)' : 'rotate(0deg)',
                transition: 'transform 0.3s',
                color: 'var(--kuali-medium-gray-default)'
            } }) })), [isOpen]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { id: id, className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(className, _style_css__WEBPACK_IMPORTED_MODULE_4__["default"].container, _style_css__WEBPACK_IMPORTED_MODULE_5__["default"].card, {
            [_style_css__WEBPACK_IMPORTED_MODULE_4__["default"].collapsed]: !isOpen
        }), children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['card-title'], _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['title-bar']), children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['title-section'], children: title }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"].actions, children: [isOpen && actions, isCollapsible && toggleArrowButton] })] }), isOpen && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { "data-test-id": 'section-children', className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(contentClassName, {
                    [_style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['padded-children']]: padded
                }), children: children }))] }));
};
CollapsibleSection.displayName = 'CollapsibleSection';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_6__.memo)(CollapsibleSection));


/***/ }),

/***/ "./app/components/collapsible-section/style.css":
/*!******************************************************!*\
  !*** ./app/components/collapsible-section/style.css ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/collapsible-section/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/collapsible-table/index.tsx":
/*!****************************************************!*\
  !*** ./app/components/collapsible-table/index.tsx ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _components_collapsible_section_index_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/components/collapsible-section/index.tsx */ "./app/components/collapsible-section/index.tsx");
/* harmony import */ var _components_full_screen_index_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/full-screen/index.tsx */ "./app/components/full-screen/index.tsx");
/* harmony import */ var _components_table_actions_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/components/table/actions.tsx */ "./app/components/table/actions.tsx");
/* harmony import */ var _utils_transformers_ts__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ~/utils/transformers.ts */ "./app/utils/transformers.ts");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _table_index_tsx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../table/index.tsx */ "./app/components/table/index.tsx");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */







const CollapsibleTable = ({ id, title, footer, className, emptyMessage = 'No rows', onChange, getSchema, showCsvExport, rows, headerData }) => {
    const [showFullScreen, setShowFullScreen] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    const [open, setOpen] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    const [hiddenColumns, setHiddenColumns] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)([]);
    const headerSchema = getSchema(_table_index_tsx__WEBPACK_IMPORTED_MODULE_7__.RowTypes.HEADER);
    const [transformers, setTransformers] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)();
    (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
        setTransformers((0,_utils_transformers_ts__WEBPACK_IMPORTED_MODULE_4__.buildTransformers)(headerSchema));
    }, [headerSchema]);
    const actions = !(0,lodash__WEBPACK_IMPORTED_MODULE_5__.isEmpty)(rows)
        ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_table_actions_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], { id: `${id}-actions`, showFullScreen: showFullScreen, setShowFullScreen: setShowFullScreen, schema: headerSchema, hiddenColumns: hiddenColumns, setHiddenColumns: setHiddenColumns, rows: rows, transformers: transformers, showCsvExport: showCsvExport, columnMenuOpen: open, setColumnMenuOpen: setOpen }))
        : null;
    const section = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_collapsible_section_index_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { title: title, padded: false, actions: actions, className: className, isCollapsible: !showFullScreen, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_table_index_tsx__WEBPACK_IMPORTED_MODULE_7__["default"]
            // TODO: Table should be made generic, which will resolve this issue
            , { 
                // TODO: Table should be made generic, which will resolve this issue
                rows: rows, headerData: headerData, 
                /* Need to cast as for some reason it's not picking up the generic. The internet has not been helpful on
                 this. */
                getSchema: getSchema, hiddenColumns: hiddenColumns, onChange: onChange, transformers: transformers, emptyMessage: emptyMessage, setColumnMenuOpen: setOpen }), footer] }));
    return showFullScreen
        ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_full_screen_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { handleClose: (0,lodash__WEBPACK_IMPORTED_MODULE_5__.partial)(setShowFullScreen, false), children: section }) }))
        : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: section }));
};
const genericMemo = react__WEBPACK_IMPORTED_MODULE_6__.memo;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (genericMemo(CollapsibleTable));


/***/ }),

/***/ "./app/components/currency-inquiry/index.tsx":
/*!***************************************************!*\
  !*** ./app/components/currency-inquiry/index.tsx ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _utils_utils_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/utils/utils.tsx */ "./app/utils/utils.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var url__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! url */ "./node_modules/url/url.js");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



const urlRoot = (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_1__.getUrlPathPrefix)();
const baseUrl = `${window.location.protocol}//${window.location.host}${urlRoot}`;
const CurrencyInquiry = ({ value, inquiryUrl }) => {
    if (!value || !inquiryUrl) {
        return null;
    }
    const parsedUrl = new URL(inquiryUrl, baseUrl);
    parsedUrl.searchParams.append('mode', 'standalone');
    const standaloneUrl = url__WEBPACK_IMPORTED_MODULE_3__.format(parsedUrl).replace(baseUrl, urlRoot);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_2__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { target: '_blank', href: standaloneUrl, rel: 'noreferrer', children: value }) }) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CurrencyInquiry);


/***/ }),

/***/ "./app/components/currency-link/index.tsx":
/*!************************************************!*\
  !*** ./app/components/currency-link/index.tsx ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CurrencyLink: () => (/* binding */ CurrencyLink)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var react_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-router */ "./node_modules/react-router/dist/development/chunk-PVWAREVJ.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


const CurrencyLink = ({ value, url }) => {
    if (!value || !url) {
        return null;
    }
    const splitUrl = url.split('?');
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_2__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_router__WEBPACK_IMPORTED_MODULE_1__.Link, { to: {
                pathname: splitUrl[0],
                search: splitUrl.length > 1 ? splitUrl[1] : ''
            }, target: '_blank', children: value }) }));
};


/***/ }),

/***/ "./app/components/date-picker/index.tsx":
/*!**********************************************!*\
  !*** ./app/components/date-picker/index.tsx ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DatePicker: () => (/* binding */ DatePicker)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _mui_x_date_pickers_pro_AdapterDateFns__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/x-date-pickers-pro/AdapterDateFns */ "./node_modules/@mui/x-date-pickers/esm/AdapterDateFns/AdapterDateFns.js");
/* harmony import */ var _mui_x_date_pickers_pro__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/x-date-pickers-pro */ "./node_modules/@mui/x-date-pickers/esm/DesktopDatePicker/DesktopDatePicker.js");
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/isEmpty */ "./node_modules/lodash/isEmpty.js");
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_isNil__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/isNil */ "./node_modules/lodash/isNil.js");
/* harmony import */ var lodash_isNil__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_isNil__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _mui_x_date_pickers_pro_LocalizationProvider__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mui/x-date-pickers-pro/LocalizationProvider */ "./node_modules/@mui/x-date-pickers/esm/LocalizationProvider/LocalizationProvider.js");
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/material/styles */ "./node_modules/@mui/material/esm/styles/styled.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/endOfDay.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/format.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/parseISO.js");
/* harmony import */ var date_fns__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! date-fns */ "./node_modules/date-fns/startOfDay.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! react-hook-form */ "./node_modules/react-hook-form/dist/index.esm.mjs");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */









const LOOKUP_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
const StyledDatePicker = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_6__["default"])(_mui_x_date_pickers_pro__WEBPACK_IMPORTED_MODULE_2__.DesktopDatePicker)(() => ({
    '& .MuiPickersInputBase-sectionsContainer': {
        padding: 0
    }
}));
const normalizeDate = (input) => {
    if (input instanceof Date) {
        return input;
    }
    return (0,date_fns__WEBPACK_IMPORTED_MODULE_9__.parseISO)(input);
};
const stringifyDateRange = (lower, upper) => {
    if (!lodash_isNil__WEBPACK_IMPORTED_MODULE_4___default()(lower) && !lodash_isNil__WEBPACK_IMPORTED_MODULE_4___default()(upper)) {
        return `${(0,date_fns__WEBPACK_IMPORTED_MODULE_8__.format)((0,date_fns__WEBPACK_IMPORTED_MODULE_10__.startOfDay)(lower), LOOKUP_DATE_FORMAT)}..${(0,date_fns__WEBPACK_IMPORTED_MODULE_8__.format)((0,date_fns__WEBPACK_IMPORTED_MODULE_7__.endOfDay)(upper), LOOKUP_DATE_FORMAT)}`;
    }
    else if (!lodash_isNil__WEBPACK_IMPORTED_MODULE_4___default()(lower)) {
        return `>=${(0,date_fns__WEBPACK_IMPORTED_MODULE_8__.format)((0,date_fns__WEBPACK_IMPORTED_MODULE_10__.startOfDay)(lower), LOOKUP_DATE_FORMAT)}`;
    }
    else if (!lodash_isNil__WEBPACK_IMPORTED_MODULE_4___default()(upper)) {
        return `<=${(0,date_fns__WEBPACK_IMPORTED_MODULE_8__.format)((0,date_fns__WEBPACK_IMPORTED_MODULE_7__.endOfDay)(upper), LOOKUP_DATE_FORMAT)}`;
    }
    return '';
};
const parseDateRange = (dateRangeString) => {
    let lower, upper;
    if (dateRangeString.startsWith('>=')) {
        lower = dateRangeString.replace('>=', '');
    }
    else if (dateRangeString.startsWith('<=')) {
        upper = dateRangeString.replace('<=', '');
    }
    else if (dateRangeString.includes('..')) {
        const parts = dateRangeString.split('..');
        lower = parts[0];
        upper = parts[1];
    }
    return {
        lower: lower !== undefined ? normalizeDate(lower) : undefined,
        upper: upper !== undefined ? normalizeDate(upper) : undefined
    };
};
const isUpper = (name) => name.endsWith('-upper');
const isLower = (name) => name.endsWith('-lower');
const validateDateRange = (name, value) => {
    if (lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3___default()(value)) {
        return true;
    }
    const parsedValue = parseDateRange(value);
    if (isLower(name) &&
        !lodash_isNil__WEBPACK_IMPORTED_MODULE_4___default()(parsedValue.upper) &&
        !lodash_isNil__WEBPACK_IMPORTED_MODULE_4___default()(parsedValue.lower) &&
        parsedValue.lower > parsedValue.upper) {
        return false;
    }
    return !(isUpper(name) &&
        !lodash_isNil__WEBPACK_IMPORTED_MODULE_4___default()(parsedValue.lower) &&
        !lodash_isNil__WEBPACK_IMPORTED_MODULE_4___default()(parsedValue.upper) &&
        parsedValue.upper < parsedValue.lower);
};
const getParentName = (name) => name.replace(/-lower|-upper/, '');
const DatePicker = ({ name, label, autoFocus }) => {
    const parentName = (0,react__WEBPACK_IMPORTED_MODULE_11__.useMemo)(() => getParentName(name), [name]);
    const parentValue = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_12__.useWatch)({ name: parentName });
    const isCurrentUpper = (0,react__WEBPACK_IMPORTED_MODULE_11__.useMemo)(() => isUpper(name), [name]);
    const isCurrentLower = (0,react__WEBPACK_IMPORTED_MODULE_11__.useMemo)(() => isLower(name), [name]);
    const rules = (0,react__WEBPACK_IMPORTED_MODULE_11__.useMemo)(() => {
        if (isCurrentLower || isCurrentUpper) {
            return {
                validate: () => {
                    const message = `${isCurrentLower ? 'From' : 'To'} date must be ` +
                        `${isCurrentLower ? 'less' : 'greater'} than or equal to ` +
                        `${isCurrentLower ? 'to' : 'from'} date.`;
                    return validateDateRange(name, parentValue) || message;
                }
            };
        }
        return {};
    }, [isCurrentLower, isCurrentUpper, name, parentValue]);
    const { getValues, setValue } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_12__.useFormContext)();
    const { field: { onChange, value, ref }, fieldState: { error } } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_12__.useController)({
        name,
        defaultValue: null,
        rules
    });
    (0,react__WEBPACK_IMPORTED_MODULE_11__.useEffect)(() => {
        if (!isCurrentLower && !isCurrentUpper)
            return;
        if (lodash_isNil__WEBPACK_IMPORTED_MODULE_4___default()(parentValue) || lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3___default()(parentValue))
            return;
        const currentValue = getValues(name);
        const parsedValue = parseDateRange(parentValue);
        let newValue = null;
        if (isCurrentLower && !lodash_isNil__WEBPACK_IMPORTED_MODULE_4___default()(parsedValue.lower)) {
            newValue = parsedValue.lower;
        }
        else if (isCurrentUpper && !lodash_isNil__WEBPACK_IMPORTED_MODULE_4___default()(parsedValue.upper)) {
            newValue = parsedValue.upper;
        }
        if (lodash_isNil__WEBPACK_IMPORTED_MODULE_4___default()(currentValue) && lodash_isNil__WEBPACK_IMPORTED_MODULE_4___default()(newValue))
            return;
        if ((lodash_isNil__WEBPACK_IMPORTED_MODULE_4___default()(currentValue) && !lodash_isNil__WEBPACK_IMPORTED_MODULE_4___default()(newValue)) ||
            (!lodash_isNil__WEBPACK_IMPORTED_MODULE_4___default()(currentValue) && lodash_isNil__WEBPACK_IMPORTED_MODULE_4___default()(newValue)) ||
            currentValue?.getTime() !== newValue?.getTime()) {
            setValue(name, newValue, { shouldValidate: true });
        }
    }, [getValues, isCurrentLower, isCurrentUpper, name, parentValue, setValue]);
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_11__.useCallback)((date) => {
        onChange(date);
        if (!isCurrentUpper && !isCurrentLower)
            return;
        const lowerDate = isCurrentLower
            ? date
            : getValues(`${parentName}-lower`);
        const upperDate = isCurrentUpper
            ? date
            : getValues(`${parentName}-upper`);
        const stringValue = stringifyDateRange(lowerDate, upperDate);
        setValue(parentName, stringValue, { shouldValidate: true });
    }, [getValues, isCurrentLower, isCurrentUpper, onChange, parentName, setValue]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_x_date_pickers_pro_LocalizationProvider__WEBPACK_IMPORTED_MODULE_5__.LocalizationProvider, { dateAdapter: _mui_x_date_pickers_pro_AdapterDateFns__WEBPACK_IMPORTED_MODULE_1__.AdapterDateFns, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(StyledDatePicker, { ref: ref, value: value, onChange: handleChange, slotProps: {
                field: { clearable: true },
                openPickerButton: { 'aria-label': `Open datepicker for ${label}` },
                textField: {
                    label,
                    fullWidth: true,
                    InputLabelProps: { shrink: true, sx: { zIndex: 0 } },
                    error: !!error,
                    helperText: error?.message
                }
            }, autoFocus: autoFocus }) }));
};


/***/ }),

/***/ "./app/components/details-link/index.tsx":
/*!***********************************************!*\
  !*** ./app/components/details-link/index.tsx ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);



const DetailsLink = ({ detailsInfo, handleOpenDetails }) => {
    const { value, url } = detailsInfo;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_2__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { href: url, onClick: (0,lodash__WEBPACK_IMPORTED_MODULE_1__.partial)(handleOpenDetails, url), children: value }) }));
};
DetailsLink.displayName = 'DetailsLink';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_2__.memo)(DetailsLink));


/***/ }),

/***/ "./app/components/document-link/index.tsx":
/*!************************************************!*\
  !*** ./app/components/document-link/index.tsx ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const DocumentLink = ({ documentInfo }) => {
    const { value, url } = documentInfo;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_1__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { href: url, children: value }) }));
};
DocumentLink.displayName = 'DocumentLink';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(DocumentLink));


/***/ }),

/***/ "./app/components/document/accounting-lines/accounting-line.tsx":
/*!**********************************************************************!*\
  !*** ./app/components/document/accounting-lines/accounting-line.tsx ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _utils_transformers_ts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/utils/transformers.ts */ "./app/utils/transformers.ts");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_buttons_close_button_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/components/buttons/close-button.tsx */ "./app/components/buttons/close-button.tsx");
/* harmony import */ var _documents_document_page_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ~/documents/document-page.css */ "./app/documents/document-page.css");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./style.css */ "./app/components/document/accounting-lines/style.css");
/* harmony import */ var _components_flex_grid_index_tsx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ~/components/flex-grid/index.tsx */ "./app/components/flex-grid/index.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);








const AccountingLine = ({ index, line, schema, readOnly, onChange, onRequestRemove, errors }) => {
    const [row1Schema, row2Schema] = schema;
    const row1Transformers = (0,_utils_transformers_ts__WEBPACK_IMPORTED_MODULE_1__.buildTransformers)(row1Schema);
    const row2Transformers = (0,_utils_transformers_ts__WEBPACK_IMPORTED_MODULE_1__.buildTransformers)(row2Schema);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_7__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['accounting-line'], children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_2___default()('row', _documents_document_page_css__WEBPACK_IMPORTED_MODULE_4__["default"]['section-header']), children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs-11', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { className: 'subtitle2', children: ["Item ", index + 1] }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs-1', style: { textAlign: 'right', whiteSpace: 'nowrap' }, children: !readOnly && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_close_button_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], { onClick: onRequestRemove, ariaLabel: `Remove Line ${index + 1}` })) })] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_flex_grid_index_tsx__WEBPACK_IMPORTED_MODULE_6__.GridHeader, { schema: row1Schema }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_flex_grid_index_tsx__WEBPACK_IMPORTED_MODULE_6__.GridRow, { schema: row1Schema, transformers: row1Transformers, rowData: line, readOnly: readOnly, onChange: onChange, errors: errors }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_flex_grid_index_tsx__WEBPACK_IMPORTED_MODULE_6__.GridHeader, { schema: row2Schema }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_flex_grid_index_tsx__WEBPACK_IMPORTED_MODULE_6__.GridRow, { schema: row2Schema, transformers: row2Transformers, rowData: line, readOnly: readOnly, onChange: onChange, errors: errors })] })] }) }));
};
AccountingLine.displayName = 'AccountingLine';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_7__.memo)(AccountingLine));


/***/ }),

/***/ "./app/components/document/accounting-lines/index.tsx":
/*!************************************************************!*\
  !*** ./app/components/document/accounting-lines/index.tsx ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _accounting_line_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./accounting-line.tsx */ "./app/components/document/accounting-lines/accounting-line.tsx");
/* harmony import */ var _mui_icons_material_Add__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material/Add */ "./node_modules/@mui/icons-material/esm/Add.js");
/* harmony import */ var _components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/components/buttons/index.tsx */ "./app/components/buttons/index.tsx");
/* harmony import */ var _documents_document_page_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ~/documents/document-page.css */ "./app/documents/document-page.css");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./style.css */ "./app/components/document/accounting-lines/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_7__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */







const AccountingLines = ({ schema, lines, readOnly, onChange, onLineAdd, onLineRemove, errors, addButtonLabel }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _documents_document_page_css__WEBPACK_IMPORTED_MODULE_4__["default"]['section-content'], children: [lines.map((line, index) => {
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react__WEBPACK_IMPORTED_MODULE_6__.Fragment, { children: [index !== 0 && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("hr", { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"].divider, "aria-hidden": true }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_accounting_line_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { index: index, line: line, schema: schema, readOnly: readOnly, onChange: (0,lodash__WEBPACK_IMPORTED_MODULE_7__.partial)(onChange, line), onRequestRemove: (0,lodash__WEBPACK_IMPORTED_MODULE_7__.partial)(onLineRemove, line), errors: (0,lodash__WEBPACK_IMPORTED_MODULE_7__.get)(errors, index, {}) }, index)] }, index));
                }), !readOnly && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [lines.length > 0 && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("hr", { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"].divider, "aria-hidden": true }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], { onClick: onLineAdd, testId: 'add-non-ar-item-button', variant: 'outlined', customStyle: { marginTop: '16px' }, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { style: { display: 'flex', alignItems: 'normal' }, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_Add__WEBPACK_IMPORTED_MODULE_2__["default"], {}), addButtonLabel ?? 'Add Accounting Line'] }) })] }))] }) }));
};
AccountingLines.displayName = 'AccountingLines';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_6__.memo)(AccountingLines));


/***/ }),

/***/ "./app/components/document/accounting-lines/schema.ts":
/*!************************************************************!*\
  !*** ./app/components/document/accounting-lines/schema.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EMPTY_ACCOUNTING_LINE: () => (/* binding */ EMPTY_ACCOUNTING_LINE),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_document_table_utils_tsx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ~/utils/document/table-utils.tsx */ "./app/utils/document/table-utils.tsx");
/* harmony import */ var _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/utils/constants.ts */ "./app/utils/constants.ts");
/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


const EMPTY_ACCOUNTING_LINE = {
    chartOfAccountsCode: '',
    accountNumber: '',
    subAccountNumber: '',
    financialObjectCode: '',
    financialSubObjectCode: '',
    projectCode: '',
    organizationReferenceId: '',
    description: '',
    amount: 0
};
const getSchema = (readOnly) => {
    return [
        [
            // Row 1
            {
                label: 'Chart',
                defaultValue: '--',
                type: readOnly ? _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormFieldTypes.LINK : _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormFieldTypes.TEXT,
                name: readOnly ? 'chartOfAccountsCodeLink' : 'chartOfAccountsCode',
                control: !readOnly
                    ? {
                        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormControlTypes.AUTOCOMPLETE_RELATED,
                        required: true,
                        props: {
                            businessObjectLabel: 'Chart',
                            businessObjectName: 'Chart',
                            searchPropName: 'chartOfAccountsCode',
                            searchDescriptionPropName: 'finChartOfAccountDescription',
                            primaryDisplayPropName: 'code',
                            secondaryDisplayPropName: 'name',
                            submitValuePropName: 'code',
                            defaultFilters: {
                                active: 'Y'
                            },
                            keyFields: ['chartOfAccountsCode']
                        }
                    }
                    : null
            },
            {
                label: 'Account',
                defaultValue: '--',
                type: readOnly ? _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormFieldTypes.LINK : _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormFieldTypes.TEXT,
                name: readOnly ? 'accountNumberLink' : 'accountNumber',
                control: !readOnly
                    ? {
                        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormControlTypes.AUTOCOMPLETE_RELATED,
                        required: true,
                        props: {
                            businessObjectLabel: 'Account',
                            businessObjectName: 'Account',
                            searchPropName: 'accountNumber',
                            primaryDisplayPropName: 'accountNumber',
                            secondaryDisplayPropName: 'accountName',
                            submitValuePropName: 'accountNumber',
                            keyFields: ['chartOfAccountsCode', 'accountNumber'],
                            associatedFields: [
                                {
                                    searchPropName: 'chartOfAccountsCode'
                                }
                            ],
                            defaultFilters: {
                                active: 'Y'
                            }
                        }
                    }
                    : null
            },
            {
                label: 'Sub-Account',
                defaultValue: '--',
                type: readOnly ? _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormFieldTypes.LINK : _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormFieldTypes.TEXT,
                name: readOnly ? 'subAccountNumberLink' : 'subAccountNumber',
                control: !readOnly
                    ? {
                        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormControlTypes.AUTOCOMPLETE_RELATED,
                        props: {
                            businessObjectLabel: 'Sub-Account',
                            businessObjectName: 'SubAccount',
                            searchPropName: 'subAccountNumber',
                            primaryDisplayPropName: 'subAccountNumber',
                            secondaryDisplayPropName: 'subAccountName',
                            submitValuePropName: 'subAccountNumber',
                            keyFields: [
                                'chartOfAccountsCode',
                                'accountNumber',
                                'subAccountNumber'
                            ],
                            associatedFields: [
                                {
                                    searchPropName: 'chartOfAccountsCode'
                                },
                                {
                                    searchPropName: 'accountNumber'
                                }
                            ],
                            defaultFilters: {
                                active: 'Y'
                            }
                        }
                    }
                    : null
            },
            {
                label: 'Object',
                defaultValue: '--',
                type: readOnly ? _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormFieldTypes.LINK : _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormFieldTypes.TEXT,
                name: readOnly ? 'financialObjectCodeLink' : 'financialObjectCode',
                control: !readOnly
                    ? {
                        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormControlTypes.AUTOCOMPLETE_RELATED,
                        required: true,
                        props: {
                            businessObjectLabel: 'Object',
                            businessObjectName: 'ObjectCode',
                            searchPropName: 'financialObjectCode',
                            primaryDisplayPropName: 'financialObjectCode',
                            secondaryDisplayPropName: 'financialObjectCodeName',
                            submitValuePropName: 'financialObjectCode',
                            keyFields: ['chartOfAccountsCode', 'financialObjectCode'],
                            associatedFields: [
                                {
                                    searchPropName: 'chartOfAccountsCode'
                                }
                            ],
                            defaultFilters: {
                                active: 'Y',
                                universityFiscalYear: '{FISCAL_YEAR}'
                            }
                        }
                    }
                    : null
            },
            {
                label: 'Sub-Object',
                defaultValue: '--',
                type: readOnly ? _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormFieldTypes.LINK : _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormFieldTypes.TEXT,
                name: readOnly
                    ? 'financialSubObjectCodeLink'
                    : 'financialSubObjectCode',
                control: !readOnly
                    ? {
                        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormControlTypes.AUTOCOMPLETE_RELATED,
                        props: {
                            businessObjectLabel: 'Sub-Object',
                            businessObjectName: 'SubObjectCode',
                            searchPropName: 'financialSubObjectCode',
                            primaryDisplayPropName: 'financialSubObjectCode',
                            secondaryDisplayPropName: 'financialSubObjectCodeName',
                            submitValuePropName: 'financialSubObjectCode',
                            keyFields: [
                                'chartOfAccountsCode',
                                'financialObjectCode',
                                'accountNumber',
                                'financialSubObjectCode'
                            ],
                            associatedFields: [
                                {
                                    searchPropName: 'chartOfAccountsCode'
                                },
                                {
                                    searchPropName: 'financialObjectCode'
                                },
                                {
                                    searchPropName: 'accountNumber'
                                }
                            ],
                            defaultFilters: {
                                active: 'Y',
                                universityFiscalYear: '{FISCAL_YEAR}'
                            }
                        }
                    }
                    : null
            },
            { ..._utils_document_table_utils_tsx__WEBPACK_IMPORTED_MODULE_0__.SPACER_COLUMN, name: _utils_document_table_utils_tsx__WEBPACK_IMPORTED_MODULE_0__.SPACER_COLUMN.name + '1' },
            { ..._utils_document_table_utils_tsx__WEBPACK_IMPORTED_MODULE_0__.SPACER_COLUMN, name: _utils_document_table_utils_tsx__WEBPACK_IMPORTED_MODULE_0__.SPACER_COLUMN.name + '2' }
        ],
        [
            // Row 2
            {
                label: 'Project',
                defaultValue: '--',
                type: readOnly ? _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormFieldTypes.LINK : _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormFieldTypes.TEXT,
                name: readOnly ? 'projectCodeLink' : 'projectCode',
                control: !readOnly
                    ? {
                        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormControlTypes.AUTOCOMPLETE_RELATED,
                        props: {
                            businessObjectLabel: 'Project',
                            businessObjectName: 'ProjectCode',
                            searchPropName: 'code',
                            primaryDisplayPropName: 'code',
                            secondaryDisplayPropName: 'name',
                            submitValuePropName: 'code',
                            keyFields: ['chartOfAccountsCode', 'projectCode'],
                            associatedFields: [
                                {
                                    searchPropName: 'chartOfAccountsCode'
                                }
                            ],
                            defaultFilters: {
                                active: 'Y'
                            }
                        }
                    }
                    : null
            },
            {
                label: 'Org Ref ID',
                defaultValue: '--',
                type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormFieldTypes.TEXT,
                name: 'organizationReferenceId',
                control: !readOnly
                    ? {
                        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormControlTypes.TEXT
                    }
                    : null
            },
            {
                label: 'Line Description',
                defaultValue: '--',
                type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormFieldTypes.TEXT,
                name: 'description',
                control: !readOnly
                    ? {
                        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormControlTypes.TEXT
                    }
                    : null,
                style: { flexBasis: '30%' }
            },
            { ..._utils_document_table_utils_tsx__WEBPACK_IMPORTED_MODULE_0__.SPACER_COLUMN, name: _utils_document_table_utils_tsx__WEBPACK_IMPORTED_MODULE_0__.SPACER_COLUMN.name + '1' },
            {
                label: 'Non-AR Amount',
                defaultValue: '--',
                name: 'amount',
                type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormFieldTypes.CURRENCY,
                control: !readOnly
                    ? {
                        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormControlTypes.TEXT
                    }
                    : null
            }
        ]
    ];
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (getSchema);


/***/ }),

/***/ "./app/components/document/accounting-lines/style.css":
/*!************************************************************!*\
  !*** ./app/components/document/accounting-lines/style.css ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/document/accounting-lines/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/document/accounting-lines/use-accounting-lines.ts":
/*!**************************************************************************!*\
  !*** ./app/components/document/accounting-lines/use-accounting-lines.ts ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACCOUNTING_LINES_KEY: () => (/* binding */ ACCOUNTING_LINES_KEY),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var nanoid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! nanoid */ "./node_modules/nanoid/index.browser.js");
/* harmony import */ var _utils_use_managed_list_ts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/utils/use-managed-list.ts */ "./app/utils/use-managed-list.ts");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _schema_ts__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./schema.ts */ "./app/components/document/accounting-lines/schema.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */





const ACCOUNTING_LINES_KEY = 'accountingLines';
const MISSING_FIELD_MESSAGE = 'Field is required.';
const numberAlphabet = (0,nanoid__WEBPACK_IMPORTED_MODULE_0__.customAlphabet)('0123456789', 7);
// Fill null/undefined values with empty strings for inputs
const normalizeLines = (lines) => {
    const fillNils = (val) => ((0,lodash__WEBPACK_IMPORTED_MODULE_2__.isNil)(val) ? '' : val);
    return lines
        ? lines.map((line) => (0,lodash__WEBPACK_IMPORTED_MODULE_2__.mapValues)(line, fillNils))
        : [];
};
const useAccountingLines = (accountingLines, readOnly = false) => {
    const { list: lines, addItem, removeItem: handleRemoveLine, updateItem, findItemIndex } = (0,_utils_use_managed_list_ts__WEBPACK_IMPORTED_MODULE_1__["default"])('sequenceNumber', normalizeLines(accountingLines));
    const [errors, setErrors] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)({});
    const schema = (0,react__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => (0,_schema_ts__WEBPACK_IMPORTED_MODULE_3__["default"])(readOnly), [readOnly]);
    const requiredLineFields = (0,react__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => (0,lodash__WEBPACK_IMPORTED_MODULE_2__.flatten)(schema)
        .filter((field) => (0,lodash__WEBPACK_IMPORTED_MODULE_2__.get)(field, ['control', 'required']))
        .map((field) => field.name), [schema]);
    const handleAddLine = () => {
        addItem({
            ..._schema_ts__WEBPACK_IMPORTED_MODULE_3__.EMPTY_ACCOUNTING_LINE,
            isNew: true,
            sequenceNumber: parseInt(numberAlphabet()) // Temporary for frontend until backend assigns it
        });
    };
    const handleUpdateLine = (line, ...rest) => {
        // Clear any field error when updating data
        const index = findItemIndex(line, lines);
        setErrors((prevErrors) => {
            const newErrors = (0,lodash__WEBPACK_IMPORTED_MODULE_2__.cloneDeep)(prevErrors);
            (0,lodash__WEBPACK_IMPORTED_MODULE_2__.unset)(newErrors, [index, ...(0,lodash__WEBPACK_IMPORTED_MODULE_2__.initial)(rest)]);
            return newErrors;
        });
        updateItem(line, ...rest);
    };
    const getFieldErrors = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)((fieldName, value) => {
        const fieldErrors = [];
        const isRequired = requiredLineFields.includes(fieldName);
        if (isRequired && (0,lodash__WEBPACK_IMPORTED_MODULE_2__.isEmpty)(value)) {
            fieldErrors.push(MISSING_FIELD_MESSAGE);
        }
        return fieldErrors;
    }, [requiredLineFields]);
    const getLineErrors = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)((line, index) => {
        const lineErrs = {};
        for (const [fieldName, value] of Object.entries(line)) {
            const fieldErrors = getFieldErrors(fieldName, value);
            if (!(0,lodash__WEBPACK_IMPORTED_MODULE_2__.isEmpty)(fieldErrors)) {
                (0,lodash__WEBPACK_IMPORTED_MODULE_2__.set)(lineErrs, [index, fieldName], fieldErrors);
            }
        }
        return lineErrs;
    }, [getFieldErrors]);
    // Performs validation & sets error messages in state
    // Returns true if valid, false if invalid
    const validate = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(() => {
        const validationErrors = lines.reduce((errors, line, index) => ({
            ...errors,
            ...getLineErrors(line, index)
        }), {});
        setErrors(validationErrors);
        return (0,lodash__WEBPACK_IMPORTED_MODULE_2__.isEmpty)(validationErrors);
    }, [lines, getLineErrors]);
    // Sets additional error messages in state (i.e. server errors)
    const addErrors = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)((serverErrors) => {
        setErrors((prevErrors) => {
            const newErrors = (0,lodash__WEBPACK_IMPORTED_MODULE_2__.cloneDeep)(prevErrors);
            return (0,lodash__WEBPACK_IMPORTED_MODULE_2__.merge)(newErrors, serverErrors);
        });
    }, []);
    const totalAmount = (0,lodash__WEBPACK_IMPORTED_MODULE_2__.sumBy)(lines, 'amount');
    const getLinesToSave = () => {
        // Don't include temporary sequence numbers in the server request
        return lines.map((line) => line.isNew ? (0,lodash__WEBPACK_IMPORTED_MODULE_2__.omit)(line, 'sequenceNumber') : line);
    };
    return {
        schema,
        lines,
        getLinesToSave,
        handleUpdateLine,
        handleAddLine,
        handleRemoveLine,
        validate,
        addErrors,
        errors,
        totalAmount
    };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useAccountingLines);


/***/ }),

/***/ "./app/components/document/ad-hoc-routing/ad-hoc-routing-recipient-footer.tsx":
/*!************************************************************************************!*\
  !*** ./app/components/document/ad-hoc-routing/ad-hoc-routing-recipient-footer.tsx ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _mui_icons_material_Add__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/icons-material/Add */ "./node_modules/@mui/icons-material/esm/Add.js");
/* harmony import */ var _components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/buttons/index.tsx */ "./app/components/buttons/index.tsx");
/* harmony import */ var _components_popper_index_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/components/popper/index.tsx */ "./app/components/popper/index.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/document/ad-hoc-routing/style.css");
/* harmony import */ var _autocomplete_autocomplete_standalone_tsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../autocomplete/autocomplete-standalone.tsx */ "./app/components/autocomplete/autocomplete-standalone.tsx");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _models_business_object_ts__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ~/models/business-object.ts */ "./app/models/business-object.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_8__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */








const shapePersonSubmitValue = async (value) => {
    const shapeValue = value;
    if (!(0,lodash__WEBPACK_IMPORTED_MODULE_6__.isPlainObject)(shapeValue.primaryPrincipal)) {
        return value;
    }
    const options = {
        searchParams: { objectId: shapeValue.objectId }
    };
    const response = await (0,_models_business_object_ts__WEBPACK_IMPORTED_MODULE_7__.search)('Person', options);
    if ((0,_models_business_object_ts__WEBPACK_IMPORTED_MODULE_7__.isErrorResponse)(response)) {
        console.error('Error searching Person objects', response);
        return;
    }
    return response.results[0];
};
const shapeGroupSubmitValue = async (value) => {
    const shapeValue = value;
    if (!(0,lodash__WEBPACK_IMPORTED_MODULE_6__.isPlainObject)(shapeValue.name)) {
        return shapeValue;
    }
    const options = {
        searchParams: { objectId: shapeValue.objectId }
    };
    const response = await (0,_models_business_object_ts__WEBPACK_IMPORTED_MODULE_7__.search)('Group', options);
    if ((0,_models_business_object_ts__WEBPACK_IMPORTED_MODULE_7__.isErrorResponse)(response)) {
        console.error('Error searching Group objects', response);
        return;
    }
    return response.results[0];
};
const AdHocRoutingRecipientFooter = ({ onPersonAdd, onGroupAdd }) => {
    const personAnchorRef = (0,react__WEBPACK_IMPORTED_MODULE_8__.useRef)(null);
    const groupAnchorRef = (0,react__WEBPACK_IMPORTED_MODULE_8__.useRef)(null);
    const [personOpen, setPersonOpen] = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
    const [groupOpen, setGroupOpen] = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
    const handlePersonToggle = () => {
        setPersonOpen((prevOpen) => !prevOpen);
    };
    const handleGroupToggle = () => {
        setGroupOpen((prevOpen) => !prevOpen);
    };
    const [addingPerson, setAddingPerson] = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
    const [addingGroup, setAddingGroup] = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
    const [personSearchTerm, setPersonSearchTerm] = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)('');
    const [groupSearchTerm, setGroupSearchTerm] = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)('');
    const personSearchChange = (searchTerm) => {
        if (!searchTerm) {
            setPersonSearchTerm('');
            return;
        }
        setPersonSearchTerm(searchTerm);
    };
    const groupSearchChange = (searchTerm) => {
        if (!searchTerm) {
            setGroupSearchTerm('');
            return;
        }
        setGroupSearchTerm(searchTerm);
    };
    const handlePersonAdd = async (person) => {
        // We use an entity to find the principal Id because using the Person interface is far too slow for
        // a quality user experience. In order to keep the ad hoc recipient interface consistent,
        // we map the principal name prop
        setAddingPerson(true);
        await onPersonAdd({
            principalName: (0,lodash__WEBPACK_IMPORTED_MODULE_6__.get)(person, 'principalName')
        });
        setPersonSearchTerm('');
        setAddingPerson(false);
        setPersonOpen(false);
    };
    const handleGroupAdd = async (group) => {
        setAddingGroup(true);
        await onGroupAdd(group);
        setGroupSearchTerm('');
        setAddingGroup(false);
        setGroupOpen(false);
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_8__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"].footer, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { id: 'person-add-button', onClick: handlePersonToggle, loading: addingPerson, ref: personAnchorRef, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { style: { display: 'flex', alignItems: 'end' }, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_Add__WEBPACK_IMPORTED_MODULE_1__["default"], {}), "Add a Person"] }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_popper_index_tsx__WEBPACK_IMPORTED_MODULE_3__.Popper, { open: personOpen, anchorElement: personAnchorRef.current, placement: 'top-end', transformOrigin: 'top left', handleHide: setPersonOpen, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_autocomplete_autocomplete_standalone_tsx__WEBPACK_IMPORTED_MODULE_5__["default"], { value: personSearchTerm, onChange: personSearchChange, id: 'person-ad-hoc-input', label: 'Principal Name', businessObjectLabel: 'Person', businessObjectName: 'Person', searchPropName: 'principalName', primaryDisplayPropName: 'principalName', secondaryDisplayPropName: 'name', onSubmit: handlePersonAdd, submitButtonLabel: 'Add', submitValuePropName: 'principalName', shapeSubmitValue: shapePersonSubmitValue, keyFields: ['principalName'], wide: true, placeholder: 'Principal Name' }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { id: 'group-add-button', onClick: handleGroupToggle, loading: addingGroup, ref: groupAnchorRef, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { style: { display: 'flex', alignItems: 'end' }, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_Add__WEBPACK_IMPORTED_MODULE_1__["default"], {}), "Add a Group"] }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_popper_index_tsx__WEBPACK_IMPORTED_MODULE_3__.Popper, { open: groupOpen, anchorElement: groupAnchorRef.current, placement: 'bottom-end', transformOrigin: 'top left', handleHide: setGroupOpen, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_autocomplete_autocomplete_standalone_tsx__WEBPACK_IMPORTED_MODULE_5__["default"], { value: groupSearchTerm, onChange: groupSearchChange, id: 'group-ad-hoc-input', label: 'Group Name', businessObjectLabel: 'Group', businessObjectName: 'Group', searchPropName: 'name', primaryDisplayPropName: 'name', onSubmit: handleGroupAdd, submitButtonLabel: 'Add', submitValuePropName: 'name', shapeSubmitValue: shapeGroupSubmitValue, keyFields: ['name'], wide: true, placeholder: 'Group Name' }) })] }) }));
};
AdHocRoutingRecipientFooter.displayName = 'AdHocRoutingRecipientFooter';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_8__.memo)(AdHocRoutingRecipientFooter));


/***/ }),

/***/ "./app/components/document/ad-hoc-routing/ad-hoc-routing-recipient.tsx":
/*!*****************************************************************************!*\
  !*** ./app/components/document/ad-hoc-routing/ad-hoc-routing-recipient.tsx ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_buttons_close_button_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/buttons/close-button.tsx */ "./app/components/buttons/close-button.tsx");
/* harmony import */ var _components_errors_error_message_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/components/errors/error-message.tsx */ "./app/components/errors/error-message.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/document/ad-hoc-routing/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _components_flex_grid_index_tsx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ~/components/flex-grid/index.tsx */ "./app/components/flex-grid/index.tsx");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */






const AdHocRoutingRecipient = ({ className, errors, schema, recipient, onChange, onRequestRemove }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_5__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_4__["default"].recipient, className), role: 'grid', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_close_button_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { onClick: onRequestRemove, testId: `${recipient.name}`, ariaLabel: `Remove ${recipient.name}`, className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['close-button'] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_flex_grid_index_tsx__WEBPACK_IMPORTED_MODULE_6__.GridHeader, { schema: schema, className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['recipient-header'] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_flex_grid_index_tsx__WEBPACK_IMPORTED_MODULE_6__.GridRow, { schema: schema, rowData: recipient, onChange: onChange, className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['recipient-data'] }), errors?.map((message, index) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_errors_error_message_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], { message: message }, index)))] }) }));
};
AdHocRoutingRecipient.displayName = 'AdHocRoutingRecipient';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_5__.memo)(AdHocRoutingRecipient));


/***/ }),

/***/ "./app/components/document/ad-hoc-routing/ad-hoc-routing.tsx":
/*!*******************************************************************!*\
  !*** ./app/components/document/ad-hoc-routing/ad-hoc-routing.tsx ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _ad_hoc_routing_recipient_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ad-hoc-routing-recipient.tsx */ "./app/components/document/ad-hoc-routing/ad-hoc-routing-recipient.tsx");
/* harmony import */ var _ad_hoc_routing_recipient_footer_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ad-hoc-routing-recipient-footer.tsx */ "./app/components/document/ad-hoc-routing/ad-hoc-routing-recipient-footer.tsx");
/* harmony import */ var _documents_document_page_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/documents/document-page.css */ "./app/documents/document-page.css");
/* harmony import */ var nanoid__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! nanoid */ "./node_modules/nanoid/index.browser.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */






const AdHocRouting = ({ errors, schema, groups, onGroupAdd, onGroupUpdate, onGroupRemove, persons, onPersonAdd, onPersonUpdate, onPersonRemove }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _documents_document_page_css__WEBPACK_IMPORTED_MODULE_3__["default"]['section-content'], children: [persons.map((person) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_ad_hoc_routing_recipient_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { schema: schema.person, recipient: person, errors: errors?.persons?.[person.principalName] ??
                        errors?.persons?.[person.id], className: _documents_document_page_css__WEBPACK_IMPORTED_MODULE_3__["default"]['section-row'], onChange: (0,lodash__WEBPACK_IMPORTED_MODULE_5__.partial)(onPersonUpdate, person), onRequestRemove: (0,lodash__WEBPACK_IMPORTED_MODULE_5__.partial)(onPersonRemove, person) }, person.id ?? (0,nanoid__WEBPACK_IMPORTED_MODULE_4__.nanoid)()))), groups.map((group) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_ad_hoc_routing_recipient_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { schema: schema.group, recipient: group, errors: errors?.groups?.[group.name]?.[group.namespaceCode], className: _documents_document_page_css__WEBPACK_IMPORTED_MODULE_3__["default"]['section-row'], onChange: (0,lodash__WEBPACK_IMPORTED_MODULE_5__.partial)(onGroupUpdate, group), onRequestRemove: (0,lodash__WEBPACK_IMPORTED_MODULE_5__.partial)(onGroupRemove, group) }, group.id ?? (0,nanoid__WEBPACK_IMPORTED_MODULE_4__.nanoid)()))), (!(0,lodash__WEBPACK_IMPORTED_MODULE_5__.isEmpty)(persons) || !(0,lodash__WEBPACK_IMPORTED_MODULE_5__.isEmpty)(groups)) && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("hr", { "aria-hidden": true }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_ad_hoc_routing_recipient_footer_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { onPersonAdd: onPersonAdd, onGroupAdd: onGroupAdd })] }) }));
};
AdHocRouting.displayName = 'AdHocRouting';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_6__.memo)(AdHocRouting));


/***/ }),

/***/ "./app/components/document/ad-hoc-routing/schema.ts":
/*!**********************************************************!*\
  !*** ./app/components/document/ad-hoc-routing/schema.ts ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ~/utils/constants.ts */ "./app/utils/constants.ts");
/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

const ACTION_FIELD = {
    name: 'action',
    label: 'Action Requested',
    type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.TEXT,
    control: {
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormControlTypes.SELECT
    }
};
const schema = {
    group: [
        {
            name: 'nameLink',
            type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
            label: 'Group Name'
        },
        {
            name: 'namespaceCode',
            type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.TEXT,
            label: 'Namespace Code'
        },
        ACTION_FIELD
    ],
    person: [
        {
            name: 'personLink',
            type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
            label: 'Person Name'
        },
        ACTION_FIELD
    ]
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (schema);


/***/ }),

/***/ "./app/components/document/ad-hoc-routing/style.css":
/*!**********************************************************!*\
  !*** ./app/components/document/ad-hoc-routing/style.css ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/document/ad-hoc-routing/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/document/ad-hoc-routing/use-ad-hoc-routing.ts":
/*!**********************************************************************!*\
  !*** ./app/components/document/ad-hoc-routing/use-ad-hoc-routing.ts ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _models_documents_document_response_error_ts__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ~/models/documents/document-response-error.ts */ "./app/models/documents/document-response-error.ts");
/* harmony import */ var _utils_use_managed_list_ts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/utils/use-managed-list.ts */ "./app/utils/use-managed-list.ts");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _schema_ts__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./schema.ts */ "./app/components/document/ad-hoc-routing/schema.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */





const ACTION_KEY = 'action';
const ERROR_KEY_PREFIX = 'adHocRouting';
const useAdHocRouting = (adHocRouting, documentRequest) => {
    const { list: groups, addItem: addGroup, removeItem: removeGroup, updateItem: updateGroup } = (0,_utils_use_managed_list_ts__WEBPACK_IMPORTED_MODULE_1__["default"])('id', adHocRouting.groups ?? []);
    const { list: persons, addItem: addPerson, removeItem: removePerson, updateItem: updatePerson } = (0,_utils_use_managed_list_ts__WEBPACK_IMPORTED_MODULE_1__["default"])('id', adHocRouting.persons ?? []);
    // map the list of options to value / key pair and sort by key to ensure consistent display
    const [actionRequestCodes, setActionRequestCodes] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)([]);
    (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
        const codes = (0,lodash__WEBPACK_IMPORTED_MODULE_2__.get)(adHocRouting, 'actionRequestCodes', {});
        const codesAsOptions = (0,lodash__WEBPACK_IMPORTED_MODULE_2__.map)(codes, (value, key) => ({
            value: key,
            label: value
        }));
        setActionRequestCodes((0,lodash__WEBPACK_IMPORTED_MODULE_2__.sortBy)(codesAsOptions, 'value'));
    }, [adHocRouting]);
    // This takes the schema on the front end and splices in the server stored options for the
    // actionRequestCodes requested select field
    const [adHocRoutingSchema, setAdHocRoutingSchema] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(_schema_ts__WEBPACK_IMPORTED_MODULE_3__["default"]);
    (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
        const schemaNames = ['group', 'person'];
        schemaNames.forEach((schemaName) => {
            const subSchema = _schema_ts__WEBPACK_IMPORTED_MODULE_3__["default"][schemaName] ?? [];
            const actionIndex = (0,lodash__WEBPACK_IMPORTED_MODULE_2__.findIndex)(subSchema, (item) => item.name === ACTION_KEY);
            if (actionIndex > -1) {
                (0,lodash__WEBPACK_IMPORTED_MODULE_2__.set)(subSchema, [actionIndex, 'control', 'config', 'options'], actionRequestCodes);
            }
            else {
                console.error(`Could not find action entry inside ad hoc ${schemaName} schema`);
            }
        });
        setAdHocRoutingSchema({ ..._schema_ts__WEBPACK_IMPORTED_MODULE_3__["default"] });
    }, [actionRequestCodes]);
    const [errors, setErrors] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)({});
    const parseErrors = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)((error) => {
        setErrors(error.getErrorsForPrefix(ERROR_KEY_PREFIX));
    }, []);
    const addAdHocRoutingRecipient = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(async (recipientKey, methodName, recipientAddMethod, recipient) => {
        // Typed as an intersection as the recipientAddMethod could be either, and a union type does not satisfy
        // the type check for the data object.
        const response = await documentRequest(methodName, {
            data: {
                [recipientKey]: {
                    ...recipient,
                    action: (0,lodash__WEBPACK_IMPORTED_MODULE_2__.get)(actionRequestCodes, [0, 'value'], '')
                }
            }
        });
        if ((0,_models_documents_document_response_error_ts__WEBPACK_IMPORTED_MODULE_0__.isDocumentResponseError)(response)) {
            console.error('Error adding ad hoc routing recipient', response);
            return;
        }
        recipientAddMethod(response.data);
    }, [documentRequest, actionRequestCodes]);
    const handleAdHocRoutingGroupAdd = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(async (group) => {
        return addAdHocRoutingRecipient('group', 'addAdHocRouteWorkgroup', addGroup, group);
    }, [addAdHocRoutingRecipient, addGroup]);
    const handleAdHocRoutingPersonAdd = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(async (person) => {
        return addAdHocRoutingRecipient('person', 'addAdHocRoutePerson', addPerson, person);
    }, [addAdHocRoutingRecipient, addPerson]);
    return {
        errors,
        parseErrors,
        adHocRoutingSchema,
        adHocRoutingGroups: groups,
        handleAdHocRoutingGroupAdd,
        handleAdHocRoutingGroupRemove: removeGroup,
        handleAdhocRoutingGroupUpdate: updateGroup,
        adHocRoutingPersons: persons,
        handleAdHocRoutingPersonAdd,
        handleAdHocRoutingPersonRemove: removePerson,
        handleAdHocRoutingPersonUpdate: updatePerson
    };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useAdHocRouting);


/***/ }),

/***/ "./app/components/document/doc-footer.css":
/*!************************************************!*\
  !*** ./app/components/document/doc-footer.css ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_doc_footer_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./doc-footer.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/document/doc-footer.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_doc_footer_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_doc_footer_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_doc_footer_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_doc_footer_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/document/doc-footer.tsx":
/*!************************************************!*\
  !*** ./app/components/document/doc-footer.tsx ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _doc_footer_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./doc-footer.css */ "./app/components/document/doc-footer.css");
/* harmony import */ var _buttons_button_bar_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../buttons/button-bar.tsx */ "./app/components/buttons/button-bar.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);





const DocumentFooter = ({ buttons, loadingAction, onButtonClick }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_4__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_buttons_button_bar_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], { className: _doc_footer_css__WEBPACK_IMPORTED_MODULE_2__["default"]['button-bar'], onButtonClick: onButtonClick, buttonInfo: buttons.map((button) => ({
                label: button.label,
                action: button.action,
                props: {
                    disabled: !(0,lodash__WEBPACK_IMPORTED_MODULE_1__.isNil)(loadingAction),
                    loading: button.action === loadingAction,
                    testId: `${button.label}-button`
                }
            })) }) }));
};
DocumentFooter.displayName = 'DocumentFooter';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_4__.memo)(DocumentFooter));


/***/ }),

/***/ "./app/components/document/doc-header.css":
/*!************************************************!*\
  !*** ./app/components/document/doc-header.css ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_doc_header_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./doc-header.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/document/doc-header.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_doc_header_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_doc_header_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_doc_header_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_doc_header_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/document/doc-header.tsx":
/*!************************************************!*\
  !*** ./app/components/document/doc-header.tsx ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _doc_header_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./doc-header.css */ "./app/components/document/doc-header.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



const FIELD_COLUMN_COUNT = 2;
const HeaderField = (0,react__WEBPACK_IMPORTED_MODULE_3__.memo)(({ field }) => {
    const fieldValue = () => {
        if (field.url) {
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { href: field.url, children: field.value });
        }
        return field.value;
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [field.label, ": ", fieldValue()] }));
});
HeaderField.displayName = 'HeaderField';
const DocumentHeader = ({ headerFields, title }) => {
    const headerFieldGroups = (0,lodash__WEBPACK_IMPORTED_MODULE_1__.chunk)(headerFields, FIELD_COLUMN_COUNT);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_3__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _doc_header_css__WEBPACK_IMPORTED_MODULE_2__["default"].header, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h2", { className: _doc_header_css__WEBPACK_IMPORTED_MODULE_2__["default"].title, children: title }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _doc_header_css__WEBPACK_IMPORTED_MODULE_2__["default"].details, children: headerFieldGroups.map((fieldGroup, groupIndex) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _doc_header_css__WEBPACK_IMPORTED_MODULE_2__["default"]['field-group'], children: fieldGroup.map((field) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(HeaderField, { field: field }, field.label))) }, groupIndex))) })] }) }));
};
DocumentHeader.displayName = 'DocumentHeader';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_3__.memo)(DocumentHeader));


/***/ }),

/***/ "./app/components/document/general-ledger-pending-entries/index.tsx":
/*!**************************************************************************!*\
  !*** ./app/components/document/general-ledger-pending-entries/index.tsx ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _components_collapsible_table_index_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/components/collapsible-table/index.tsx */ "./app/components/collapsible-table/index.tsx");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _documents_document_page_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/documents/document-page.css */ "./app/documents/document-page.css");
/* harmony import */ var _schema_ts__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./schema.ts */ "./app/components/document/general-ledger-pending-entries/schema.ts");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./style.css */ "./app/components/document/general-ledger-pending-entries/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);







const GeneralLedgerPendingEntries = ({ entries }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_collapsible_table_index_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { id: 'glpes', rows: entries, getSchema: (0,lodash__WEBPACK_IMPORTED_MODULE_2__.constant)(_schema_ts__WEBPACK_IMPORTED_MODULE_4__["default"]), className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"].section, title: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h3", { children: "General Ledger Pending Entries" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("h4", { className: _documents_document_page_css__WEBPACK_IMPORTED_MODULE_3__["default"]['section-subtitle'], children: ["(", entries ? entries.length : 0, ")"] })] }), emptyMessage: 'There are no pending entries.', showCsvExport: true }) }));
};
GeneralLedgerPendingEntries.displayName = 'GeneralLedgerPendingEntries';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_6__.memo)(GeneralLedgerPendingEntries));


/***/ }),

/***/ "./app/components/document/general-ledger-pending-entries/schema.ts":
/*!**************************************************************************!*\
  !*** ./app/components/document/general-ledger-pending-entries/schema.ts ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ~/utils/constants.ts */ "./app/utils/constants.ts");
/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

const schema = [
    {
        name: 'universityFiscalYearLink',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
        label: 'Fiscal Year',
        defaultValue: '--'
    },
    {
        name: 'chartCodeLink',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
        label: 'Chart',
        defaultValue: '--'
    },
    {
        name: 'accountNumberLink',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
        label: 'Account',
        defaultValue: '--'
    },
    {
        name: 'subAccountNumberLink',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
        label: 'Sub-Account',
        defaultValue: '--'
    },
    {
        name: 'objectLink',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
        label: 'Object',
        defaultValue: '--'
    },
    {
        name: 'subObjectLink',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
        label: 'Sub-Object',
        defaultValue: '--'
    },
    {
        name: 'projectCodeLink',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
        label: 'Project',
        defaultValue: '--'
    },
    {
        name: 'documentTypeLink',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
        label: 'Doc Type',
        defaultValue: '--'
    },
    {
        name: 'balanceTypeLink',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
        label: 'Balance Type',
        defaultValue: '--'
    },
    {
        name: 'objectTypeLink',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
        label: 'Obj. Type',
        defaultValue: '--'
    },
    {
        name: 'amount',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.CURRENCY,
        label: 'Amount',
        defaultValue: '--'
    },
    {
        name: 'debitCreditCode',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.TEXT,
        label: 'D/C',
        defaultValue: '--'
    },
    {
        name: 'fiscalPeriodCodeLink',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
        label: 'Fiscal Period',
        defaultValue: '--'
    },
    {
        name: 'originCodeLink',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
        label: 'Origin Code',
        defaultValue: '--'
    },
    {
        name: 'documentNumberLink',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
        label: 'Document Number',
        defaultValue: '--'
    },
    {
        name: 'ledgerEntryDescription',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.TEXT,
        label: 'Transaction Ledger Entry Description',
        defaultValue: '--'
    },
    {
        name: 'transactionDate',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.DATE_TIME,
        label: 'Transaction Date',
        defaultValue: '--'
    },
    {
        name: 'organizationDocNumber',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.TEXT,
        label: 'Organization Doc Number',
        defaultValue: '--'
    },
    {
        name: 'organizationReferenceId',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.TEXT,
        label: 'Organization Reference ID',
        defaultValue: '--'
    },
    {
        name: 'referenceDocTypeCode',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.TEXT,
        label: 'Reference Doc Type Code',
        defaultValue: '--'
    },
    {
        name: 'referenceOriginCode',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.TEXT,
        label: 'Reference Origin Code',
        defaultValue: '--'
    },
    {
        name: 'referenceDocNumber',
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.TEXT,
        label: 'Reference Doc Number',
        defaultValue: '--'
    }
];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (schema);


/***/ }),

/***/ "./app/components/document/general-ledger-pending-entries/style.css":
/*!**************************************************************************!*\
  !*** ./app/components/document/general-ledger-pending-entries/style.css ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/document/general-ledger-pending-entries/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/document/general-ledger-pending-entries/use-general-ledger-pending-entries.ts":
/*!******************************************************************************************************!*\
  !*** ./app/components/document/general-ledger-pending-entries/use-general-ledger-pending-entries.ts ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _models_documents_document_response_error_ts__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ~/models/documents/document-response-error.ts */ "./app/models/documents/document-response-error.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


const useGeneralLedgerPendingEntries = (startingEntries, documentRequest) => {
    const [entries, setEntries] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(startingEntries);
    const reload = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(async () => {
        const response = await documentRequest('getGeneralLedgerPendingEntries');
        if ((0,_models_documents_document_response_error_ts__WEBPACK_IMPORTED_MODULE_0__.isDocumentResponseError)(response)) {
            console.error('Error adding general ledger pending entries', response);
            return;
        }
        setEntries(response.data);
    }, [documentRequest]);
    return {
        entries,
        reload
    };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useGeneralLedgerPendingEntries);


/***/ }),

/***/ "./app/components/document/notes-and-attachments/actions.css":
/*!*******************************************************************!*\
  !*** ./app/components/document/notes-and-attachments/actions.css ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_actions_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./actions.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/document/notes-and-attachments/actions.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_actions_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_actions_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_actions_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_actions_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/document/notes-and-attachments/attachment-input.tsx":
/*!****************************************************************************!*\
  !*** ./app/components/document/notes-and-attachments/attachment-input.tsx ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FILENAME_TRUNCATE_LENGTH: () => (/* binding */ FILENAME_TRUNCATE_LENGTH),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _mui_material_Alert__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material/Alert */ "./node_modules/@mui/material/esm/Alert/Alert.js");
/* harmony import */ var _mui_icons_material_AttachFile__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material/AttachFile */ "./node_modules/@mui/icons-material/esm/AttachFile.js");
/* harmony import */ var _components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/components/buttons/index.tsx */ "./app/components/buttons/index.tsx");
/* harmony import */ var _mui_icons_material_Close__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/icons-material/Close */ "./node_modules/@mui/icons-material/esm/Close.js");
/* harmony import */ var filesize__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! filesize */ "./node_modules/filesize/dist/filesize.js");
/* harmony import */ var _mui_material_IconButton__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/material/IconButton */ "./node_modules/@mui/material/esm/IconButton/IconButton.js");
/* harmony import */ var _components_snackbar_padded_snackbar_ts__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ~/components/snackbar/padded-snackbar.ts */ "./app/components/snackbar/padded-snackbar.ts");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./style.css */ "./app/components/document/notes-and-attachments/style.css");
/* harmony import */ var _mui_icons_material_Warning__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @mui/icons-material/Warning */ "./node_modules/@mui/icons-material/esm/Warning.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_10__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */










const FILENAME_TRUNCATE_LENGTH = 15;
const AttachmentInput = (0,react__WEBPACK_IMPORTED_MODULE_10__.memo)(({ attachmentFile, handleFileChange, maxFileSize }) => {
    const [showAttachmentAlert, setShowAttachmentAlert] = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)(false);
    const [attachmentAlertMessage, setAttachmentAlertMessage] = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)(null);
    const handleAttachmentUploadChange = (0,react__WEBPACK_IMPORTED_MODULE_10__.useCallback)((e) => {
        const file = e.target.files?.[0];
        if (file && maxFileSize && file.size > maxFileSize) {
            e.target.value = '';
            setShowAttachmentAlert(true);
            setAttachmentAlertMessage(`Attachment failed. Your file exceeds the ${(0,filesize__WEBPACK_IMPORTED_MODULE_5__.filesize)(maxFileSize)} size limit.`);
        }
        else if (file) {
            handleFileChange(file);
        }
    }, [handleFileChange, maxFileSize]);
    const clearAlert = (0,react__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => {
        setShowAttachmentAlert(false);
        setAttachmentAlertMessage(null);
    }, []);
    const removeAttachmentFile = (0,react__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => {
        handleFileChange(null);
    }, [handleFileChange]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [attachmentFile
                ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(FileDisplay, { file: attachmentFile, onRemove: removeAttachmentFile }))
                : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(FileInput, { onChange: handleAttachmentUploadChange })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_snackbar_padded_snackbar_ts__WEBPACK_IMPORTED_MODULE_7__.PaddedSnackbar, { open: showAttachmentAlert, anchorOrigin: { vertical: 'top', horizontal: 'center' }, sx: { boxShadow: 5 }, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_Alert__WEBPACK_IMPORTED_MODULE_1__["default"], { sx: { fontSize: '16px' }, severity: 'error', icon: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_Warning__WEBPACK_IMPORTED_MODULE_9__["default"], {}), action: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], { variant: 'outlined', onClick: () => clearAlert(), children: "Understood" }), children: attachmentAlertMessage ?? 'Attachment is too large' }) })] }));
});
AttachmentInput.displayName = 'AttachmentInput';
const FileInput = (0,react__WEBPACK_IMPORTED_MODULE_10__.memo)(({ onChange }) => {
    const inputElement = (0,react__WEBPACK_IMPORTED_MODULE_10__.useRef)(null);
    const handleButtonClick = (0,react__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => {
        inputElement.current?.click();
    }, []);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_10__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], { onClick: handleButtonClick, variant: 'outlined', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { style: { display: 'flex', alignItems: 'normal' }, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_AttachFile__WEBPACK_IMPORTED_MODULE_2__["default"], {}), "Attach File"] }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { ref: inputElement, className: _style_css__WEBPACK_IMPORTED_MODULE_8__["default"]['attachment-input'], type: 'file', id: 'uploadAttachment', onChange: onChange, style: { display: 'none' } })] }) }));
});
FileInput.displayName = 'FileInput';
const FileDisplay = (0,react__WEBPACK_IMPORTED_MODULE_10__.memo)(({ file, onRemove }) => {
    function getFileString() {
        let name = file.name;
        if (name.length > FILENAME_TRUNCATE_LENGTH) {
            name = name.substring(0, FILENAME_TRUNCATE_LENGTH) + '…';
        }
        return `${name} (${(0,filesize__WEBPACK_IMPORTED_MODULE_5__.filesize)(file.size)})`;
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_10__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_8__["default"]['attachment-file-name'], "data-testid": 'attachment-file-name', children: [getFileString(), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_6__["default"], { size: 'small', onClick: onRemove, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_Close__WEBPACK_IMPORTED_MODULE_4__["default"], {}) })] }) }) }));
});
FileDisplay.displayName = 'DisplayName';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AttachmentInput);


/***/ }),

/***/ "./app/components/document/notes-and-attachments/index.tsx":
/*!*****************************************************************!*\
  !*** ./app/components/document/notes-and-attachments/index.tsx ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _mui_icons_material_Add__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/icons-material/Add */ "./node_modules/@mui/icons-material/esm/Add.js");
/* harmony import */ var _components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/buttons/index.tsx */ "./app/components/buttons/index.tsx");
/* harmony import */ var _new_note_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./new-note.tsx */ "./app/components/document/notes-and-attachments/new-note.tsx");
/* harmony import */ var _note_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./note.tsx */ "./app/components/document/notes-and-attachments/note.tsx");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */






const NotesAndAttachments = (0,react__WEBPACK_IMPORTED_MODULE_6__.memo)(({ notes, addNote, removeNote, notifyPerson, maxFileSize }) => {
    const noteInput = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(null);
    const [showNewNote, setShowNewNote] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
        if (showNewNote && noteInput.current) {
            noteInput.current.focus();
        }
    }, [showNewNote]);
    const handleAddItemClick = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
        setShowNewNote(true);
    }, []);
    const handleCancelAddNote = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
        setShowNewNote(false);
    }, []);
    const handleSubmitAddNote = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)(async (noteText, attachmentFile) => {
        await addNote(noteText, attachmentFile);
        setShowNewNote(false);
    }, [addNote]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [notes?.map((note, index) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_note_tsx__WEBPACK_IMPORTED_MODULE_4__["default"], { index: index, note: note, onRequestRemove: (0,lodash__WEBPACK_IMPORTED_MODULE_5__.partial)(removeNote, note), onRequestNotify: (0,lodash__WEBPACK_IMPORTED_MODULE_5__.partial)(notifyPerson, note.objectId) }, note.objectId))), showNewNote
                    ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_new_note_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], { noteInputRef: noteInput, index: (0,lodash__WEBPACK_IMPORTED_MODULE_5__.get)(notes, ['length'], 0), handleCancel: handleCancelAddNote, handleSubmit: handleSubmitAddNote, maxFileSize: maxFileSize }))
                    : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { onClick: handleAddItemClick, testId: 'add-note-button', variant: 'outlined', customStyle: { marginTop: '16px' }, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { style: { display: 'flex', alignItems: 'normal' }, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_Add__WEBPACK_IMPORTED_MODULE_1__["default"], {}), "Add an Item"] }) }))] }) }));
});
NotesAndAttachments.displayName = 'NotesAndAttachments';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotesAndAttachments);


/***/ }),

/***/ "./app/components/document/notes-and-attachments/new-note-actions.tsx":
/*!****************************************************************************!*\
  !*** ./app/components/document/notes-and-attachments/new-note-actions.tsx ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/components/buttons/index.tsx */ "./app/components/buttons/index.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


const NewNoteActions = ({ disableSubmit, handleCancel, handleSubmit }) => {
    const [loading, setLoading] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
    const handleAddButtonClick = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)(async () => {
        setLoading(true);
        await handleSubmit();
    }, [handleSubmit]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_2__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { onClick: handleCancel, disabled: loading, testId: 'cancel-new-note-button', children: "Cancel" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { variant: 'outlined', onClick: handleAddButtonClick, testId: 'submit-new-note-button', disabled: disableSubmit, loading: loading, children: "Add" })] }) }));
};
NewNoteActions.displayName = 'NewNoteActions';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_2__.memo)(NewNoteActions));


/***/ }),

/***/ "./app/components/document/notes-and-attachments/new-note.tsx":
/*!********************************************************************!*\
  !*** ./app/components/document/notes-and-attachments/new-note.tsx ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _attachment_input_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./attachment-input.tsx */ "./app/components/document/notes-and-attachments/attachment-input.tsx");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _new_note_actions_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./new-note-actions.tsx */ "./app/components/document/notes-and-attachments/new-note-actions.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./style.css */ "./app/components/document/notes-and-attachments/style.css");
/* harmony import */ var _components_input_textarea_tsx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ~/components/input/textarea.tsx */ "./app/components/input/textarea.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */







const NewNote = ({ index, handleCancel, handleSubmit, noteInputRef, maxFileSize }) => {
    const [noteText, setNoteText] = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)('');
    const [attachmentFile, setAttachmentFile] = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(null);
    const disableSubmit = (0,lodash__WEBPACK_IMPORTED_MODULE_3__.isEmpty)(noteText) && !attachmentFile;
    const handleNoteTextAreaChange = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)((e) => {
        setNoteText(e.target.value);
    }, []);
    const onSubmit = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)(async () => {
        let text = noteText;
        if ((0,lodash__WEBPACK_IMPORTED_MODULE_3__.isEmpty)(noteText)) {
            // The backend doesn't support empty note text, but for usability we allow submit
            text = '--';
        }
        await handleSubmit(text, attachmentFile);
    }, [attachmentFile, handleSubmit, noteText]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_7__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_2___default()('row', 'caption', _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['header-row']), children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs-1', children: "Item" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs', children: "Note" })] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_2___default()('row', 'body1', _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['body-row']), children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs-1', children: index + 1 }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_input_textarea_tsx__WEBPACK_IMPORTED_MODULE_6__["default"], { ref: noteInputRef, id: 'newNoteText', placeholder: 'Type your message...', value: noteText, onChange: handleNoteTextAreaChange }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_attachment_input_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { attachmentFile: attachmentFile, handleFileChange: setAttachmentFile, maxFileSize: maxFileSize }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_2___default()('col-xs', _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['actions-column']), children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_new_note_actions_tsx__WEBPACK_IMPORTED_MODULE_4__["default"], { disableSubmit: disableSubmit, handleCancel: handleCancel, handleSubmit: onSubmit }) })] })] }) }));
};
NewNote.displayName = 'NewNote';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_7__.memo)(NewNote));


/***/ }),

/***/ "./app/components/document/notes-and-attachments/note-actions.tsx":
/*!************************************************************************!*\
  !*** ./app/components/document/notes-and-attachments/note-actions.tsx ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _mui_icons_material_Delete__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/icons-material/Delete */ "./node_modules/@mui/icons-material/esm/Delete.js");
/* harmony import */ var _components_icon_index_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/icon/index.tsx */ "./app/components/icon/index.tsx");
/* harmony import */ var _mui_material_IconButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/material/IconButton */ "./node_modules/@mui/material/esm/IconButton/IconButton.js");
/* harmony import */ var _components_popper_index_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ~/components/popper/index.tsx */ "./app/components/popper/index.tsx");
/* harmony import */ var _models_business_object_ts__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/models/business-object.ts */ "./app/models/business-object.ts");
/* harmony import */ var _actions_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./actions.css */ "./app/components/document/notes-and-attachments/actions.css");
/* harmony import */ var _components_tooltip_index_tsx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ~/components/tooltip/index.tsx */ "./app/components/tooltip/index.tsx");
/* harmony import */ var _autocomplete_autocomplete_standalone_tsx__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../autocomplete/autocomplete-standalone.tsx */ "./app/components/autocomplete/autocomplete-standalone.tsx");
/* harmony import */ var _utils_toast_ts__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ~/utils/toast.ts */ "./app/utils/toast.ts");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_11__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// We don't have an analog for the current Notify Someone icon in material-ui, so we need to use the old icon
// TODO: Replace this with a material-ui icon?










const shapeSubmitValue = async (value) => {
    if (!(0,lodash__WEBPACK_IMPORTED_MODULE_10__.isPlainObject)(value.primaryPrincipal)) {
        return value;
    }
    const options = {
        searchParams: { objectId: value.objectId }
    };
    const response = await (0,_models_business_object_ts__WEBPACK_IMPORTED_MODULE_5__.search)('Person', options);
    // eslint-disable-next-line @typescript-eslint/no-unsafe-return
    return (0,lodash__WEBPACK_IMPORTED_MODULE_10__.get)(response, ['results', 0]);
};
const NoteActions = ({ onRequestRemove, onRequestNotify, noteId }) => {
    const personInput = (0,react__WEBPACK_IMPORTED_MODULE_11__.useRef)(null);
    const [open, setOpen] = (0,react__WEBPACK_IMPORTED_MODULE_11__.useState)(false);
    const anchorRef = (0,react__WEBPACK_IMPORTED_MODULE_11__.useRef)(null);
    const handleToggle = () => {
        setOpen((prevOpen) => !prevOpen);
    };
    const [removeProcessing, setRemoveProcessing] = (0,react__WEBPACK_IMPORTED_MODULE_11__.useState)(false);
    const [notifyProcessing, setNotifyProcessing] = (0,react__WEBPACK_IMPORTED_MODULE_11__.useState)(false);
    const [recipientSearchTerm, setRecipientSearchTerm] = (0,react__WEBPACK_IMPORTED_MODULE_11__.useState)('');
    const handleRemoveButtonClick = (0,react__WEBPACK_IMPORTED_MODULE_11__.useCallback)(async () => {
        setRemoveProcessing(true);
        const removed = await onRequestRemove();
        if (!removed) {
            setRemoveProcessing(false);
            (0,_utils_toast_ts__WEBPACK_IMPORTED_MODULE_9__.error)('Unable to delete note');
        }
    }, [onRequestRemove]);
    const handleSendButtonClick = (0,react__WEBPACK_IMPORTED_MODULE_11__.useCallback)(async (person) => {
        setNotifyProcessing(true);
        const principalName = (0,lodash__WEBPACK_IMPORTED_MODULE_10__.get)(person, 'principalName');
        const notified = await onRequestNotify(principalName);
        setNotifyProcessing(false);
        if (notified) {
            (0,_utils_toast_ts__WEBPACK_IMPORTED_MODULE_9__.success)('Read request sent');
            setRecipientSearchTerm('');
            setOpen(false);
        }
        else {
            (0,_utils_toast_ts__WEBPACK_IMPORTED_MODULE_9__.error)('Unable to send notification. Please make sure the person has permission & the document is saved.');
        }
    }, [onRequestNotify]);
    const notifySomeone = (0,react__WEBPACK_IMPORTED_MODULE_11__.useMemo)(() => {
        const WrappedButton = (props) => {
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_3__["default"], { onClick: handleToggle, disabled: notifyProcessing, "data-testid": 'notify-someone-button', "aria-label": 'Notify Someone', size: 'small', ref: anchorRef, sx: {
                        width: '31px',
                        height: '31px',
                        color: 'var(--kuali-blue-default)'
                    }, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_icon_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { name: 'single-neutral-actions-address' }) }) }));
        };
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_tooltip_index_tsx__WEBPACK_IMPORTED_MODULE_7__["default"], { title: 'Notify Someone', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(WrappedButton, {}) }));
    }, [notifyProcessing]);
    const deleteNote = (0,react__WEBPACK_IMPORTED_MODULE_11__.useMemo)(() => {
        const WrappedButton = (props) => {
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ...props, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_3__["default"], { size: 'small', onClick: handleRemoveButtonClick, disabled: removeProcessing, "data-testid": `delete-note-button-${noteId}`, "aria-label": 'Delete Note', sx: { color: 'var(--kuali-blue-default)' }, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_Delete__WEBPACK_IMPORTED_MODULE_1__["default"], {}) }) }));
        };
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_tooltip_index_tsx__WEBPACK_IMPORTED_MODULE_7__["default"], { title: 'Delete Note', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(WrappedButton, {}) }));
    }, [handleRemoveButtonClick, noteId, removeProcessing]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_11__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _actions_css__WEBPACK_IMPORTED_MODULE_6__["default"]['actions-wrapper'], "data-testid": 'note-actions', children: [notifySomeone, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_popper_index_tsx__WEBPACK_IMPORTED_MODULE_4__.Popper, { open: open, handleHide: setOpen, anchorElement: anchorRef.current, placement: 'bottom-end', transformOrigin: 'right top', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h4", { style: { textAlign: 'start' }, children: "Send a read request" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_autocomplete_autocomplete_standalone_tsx__WEBPACK_IMPORTED_MODULE_8__["default"], { id: `note-${noteId}-notify`, value: recipientSearchTerm, onChange: setRecipientSearchTerm, inputRef: personInput, label: 'Principal Name', businessObjectLabel: 'Person', businessObjectName: 'Person', searchPropName: 'principalName', primaryDisplayPropName: 'principalName', submitButtonLabel: 'Send', onSubmit: handleSendButtonClick, keyFields: ['principalName'], submitValuePropName: 'principalName', shapeSubmitValue: shapeSubmitValue })] }) }), deleteNote] }) }));
};
NoteActions.displayName = 'NoteActions';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_11__.memo)(NoteActions));


/***/ }),

/***/ "./app/components/document/notes-and-attachments/note-author.tsx":
/*!***********************************************************************!*\
  !*** ./app/components/document/notes-and-attachments/note-author.tsx ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/utils/constants.ts */ "./app/utils/constants.ts");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils_date_ts__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/utils/date.ts */ "./app/utils/date.ts");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/document/notes-and-attachments/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */





const NoteAuthor = ({ note }) => {
    const authorLink = (0,lodash__WEBPACK_IMPORTED_MODULE_2__.get)(note, ['authorLink'], {});
    const timestamp = (0,lodash__WEBPACK_IMPORTED_MODULE_2__.get)(note, ['notePostedTimestamp']);
    const timeString = timestamp
        ? (0,_utils_date_ts__WEBPACK_IMPORTED_MODULE_3__.getDateStringByType)(timestamp, _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.FormFieldTypes.DATE_TIME)
        : null;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react__WEBPACK_IMPORTED_MODULE_5__.StrictMode, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { "data-testid": 'note-author', href: authorLink?.url, target: '_blank', className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['author-link'], rel: 'noreferrer', children: (0,lodash__WEBPACK_IMPORTED_MODULE_2__.get)(authorLink, ['value'], '').toLowerCase() }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("br", {}), timeString] }));
};
NoteAuthor.displayName = 'NoteAuthor';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_5__.memo)(NoteAuthor));


/***/ }),

/***/ "./app/components/document/notes-and-attachments/note.tsx":
/*!****************************************************************!*\
  !*** ./app/components/document/notes-and-attachments/note.tsx ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _note_actions_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./note-actions.tsx */ "./app/components/document/notes-and-attachments/note-actions.tsx");
/* harmony import */ var _note_author_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./note-author.tsx */ "./app/components/document/notes-and-attachments/note-author.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/document/notes-and-attachments/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */





const Note = ({ note, index, onRequestRemove, onRequestNotify }) => {
    const emptyMessage = (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("em", { children: "None" });
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_5__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { role: 'grid', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('row', 'caption', _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['header-row']), role: 'row', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs-1', role: 'columnheader', children: "Item" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs', role: 'columnheader', children: "Added By" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs', role: 'columnheader', children: "Note" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs', role: 'columnheader', children: "Attachment" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('col-xs-1', _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['actions-column']), role: 'columnheader', children: "Actions" })] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('row', 'body1', _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['body-row']), role: 'row', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs-1', role: 'gridcell', children: index + 1 }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs', role: 'gridcell', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_note_author_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], { note: note }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs', role: 'gridcell', children: note.noteText || emptyMessage }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('col-xs', _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['attachment-column']), role: 'gridcell', children: note.attachmentFileLink
                                ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("a", { "data-ignore-modal": true, href: note.attachmentFileLink.url.replace('&mode=modal', ''), target: '_blank', download: note.attachmentFileLink.value, rel: 'noreferrer', children: [note.attachmentFileLink.value, " (", note.attachmentSize, ")"] }))
                                : (emptyMessage) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('col-xs-1', _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['actions-column']), role: 'gridcell', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_note_actions_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { noteId: note.objectId, onRequestRemove: onRequestRemove, onRequestNotify: onRequestNotify }) })] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("hr", {})] }) }));
};
Note.displayName = 'Note';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_5__.memo)(Note));


/***/ }),

/***/ "./app/components/document/notes-and-attachments/style.css":
/*!*****************************************************************!*\
  !*** ./app/components/document/notes-and-attachments/style.css ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/document/notes-and-attachments/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/document/notes-and-attachments/use-notes-and-attachments.tsx":
/*!*************************************************************************************!*\
  !*** ./app/components/document/notes-and-attachments/use-notes-and-attachments.tsx ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _models_documents_document_response_error_ts__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ~/models/documents/document-response-error.ts */ "./app/models/documents/document-response-error.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_use_managed_list_ts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/utils/use-managed-list.ts */ "./app/utils/use-managed-list.ts");
/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



const useNotesAndAttachments = (notesAndAttachments, maxFileSize, documentRequest, documentFormRequest) => {
    const { list: notes, addItem: addNoteToList, removeItem: removeNoteFromList } = (0,_utils_use_managed_list_ts__WEBPACK_IMPORTED_MODULE_2__["default"])('objectId', notesAndAttachments);
    const addNote = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(async (noteText, attachmentFile) => {
        const data = {
            'newNote.noteText': noteText
        };
        if (attachmentFile) {
            data.attachmentFile = attachmentFile;
        }
        const response = await documentFormRequest('insertBONote', {
            data
        });
        if (!(0,_models_documents_document_response_error_ts__WEBPACK_IMPORTED_MODULE_0__.isDocumentResponseError)(response)) {
            const newNote = response.data;
            if (newNote?.objectId) {
                addNoteToList(newNote);
            }
        }
    }, [addNoteToList, documentFormRequest]);
    const removeNote = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(async (note) => {
        const response = await documentRequest('deleteBONote', {
            data: { noteId: note.objectId }
        });
        if ((0,_models_documents_document_response_error_ts__WEBPACK_IMPORTED_MODULE_0__.isDocumentResponseError)(response)) {
            return false;
        }
        removeNoteFromList(note);
        return true;
    }, [documentRequest, removeNoteFromList]);
    const notifyPerson = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(async (noteId, principalName) => {
        const response = await documentRequest('sendNoteWorkflowNotification', {
            data: {
                noteId,
                principalName
            }
        });
        return !(0,_models_documents_document_response_error_ts__WEBPACK_IMPORTED_MODULE_0__.isDocumentResponseError)(response);
    }, [documentRequest]);
    return {
        notes,
        maxFileSize,
        addNote,
        removeNote,
        notifyPerson
    };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useNotesAndAttachments);


/***/ }),

/***/ "./app/components/document/overview.css":
/*!**********************************************!*\
  !*** ./app/components/document/overview.css ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_overview_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./overview.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/document/overview.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_overview_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_overview_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_overview_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_overview_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/document/overview.tsx":
/*!**********************************************!*\
  !*** ./app/components/document/overview.tsx ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_input_index_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/input/index.tsx */ "./app/components/input/index.tsx");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _overview_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./overview.css */ "./app/components/document/overview.css");
/* harmony import */ var _components_input_textarea_tsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/components/input/textarea.tsx */ "./app/components/input/textarea.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _models_documents_use_document_ts__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ~/models/documents/use-document.ts */ "./app/models/documents/use-document.ts");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */







const Overview = ({ onValueChange, document, readOnly }) => {
    const [descriptionError, setDescriptionError] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)();
    const [orgDocNumberError, setOrgDocNumberError] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)();
    const [explanationError, setExplanationError] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)();
    const handleChange = (propName, value) => {
        if (value.length > _models_documents_use_document_ts__WEBPACK_IMPORTED_MODULE_7__.MAX_LENGTH_MAP[propName]) {
            const error = `${propName.charAt(0).toUpperCase() + propName.slice(1)} must be less than or equal to ${_models_documents_use_document_ts__WEBPACK_IMPORTED_MODULE_7__.MAX_LENGTH_MAP[propName]} characters`;
            if (propName === _models_documents_use_document_ts__WEBPACK_IMPORTED_MODULE_7__.DESCRIPTION_KEY) {
                setDescriptionError(error);
            }
            else if (propName === _models_documents_use_document_ts__WEBPACK_IMPORTED_MODULE_7__.ORG_DOC_NUMBER_KEY) {
                setOrgDocNumberError(error);
            }
            else {
                setExplanationError(error);
            }
        }
        else {
            if (propName === _models_documents_use_document_ts__WEBPACK_IMPORTED_MODULE_7__.DESCRIPTION_KEY) {
                setDescriptionError(undefined);
            }
            else if (propName === _models_documents_use_document_ts__WEBPACK_IMPORTED_MODULE_7__.ORG_DOC_NUMBER_KEY) {
                setOrgDocNumberError(undefined);
            }
            else {
                setExplanationError(undefined);
            }
        }
        onValueChange(propName, value);
    };
    const handleInputChange = (propName, e) => {
        handleChange(propName, e.target.value);
    };
    const handleTextAreaChange = (propName, e) => {
        handleChange(propName, e.target.value);
    };
    const description = document.getValueForKey(_models_documents_use_document_ts__WEBPACK_IMPORTED_MODULE_7__.DESCRIPTION_KEY);
    const explanation = document.getValueForKey(_models_documents_use_document_ts__WEBPACK_IMPORTED_MODULE_7__.EXPLANATION_KEY);
    const orgDocNumber = document.getValueForKey(_models_documents_use_document_ts__WEBPACK_IMPORTED_MODULE_7__.ORG_DOC_NUMBER_KEY);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(['row', _overview_css__WEBPACK_IMPORTED_MODULE_4__["default"].overview]), children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(['col-xs-5', 'col-xs-offset-1']), children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _overview_css__WEBPACK_IMPORTED_MODULE_4__["default"]['left-column'], children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_input_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { id: _models_documents_use_document_ts__WEBPACK_IMPORTED_MODULE_7__.DESCRIPTION_KEY, label: 'Description', value: description, className: _overview_css__WEBPACK_IMPORTED_MODULE_4__["default"]['input-wrapper'], readOnly: readOnly, onChange: (0,lodash__WEBPACK_IMPORTED_MODULE_3__.partial)(handleInputChange, _models_documents_use_document_ts__WEBPACK_IMPORTED_MODULE_7__.DESCRIPTION_KEY), hasError: descriptionError !== undefined, errorMessage: descriptionError }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_input_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { id: _models_documents_use_document_ts__WEBPACK_IMPORTED_MODULE_7__.ORG_DOC_NUMBER_KEY, label: 'Organization Document Number', value: orgDocNumber, readOnly: readOnly, onChange: (0,lodash__WEBPACK_IMPORTED_MODULE_3__.partial)(handleInputChange, _models_documents_use_document_ts__WEBPACK_IMPORTED_MODULE_7__.ORG_DOC_NUMBER_KEY), hasError: orgDocNumberError !== undefined, errorMessage: orgDocNumberError })] }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(['col-xs-5', _overview_css__WEBPACK_IMPORTED_MODULE_4__["default"].stretched]), children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_input_textarea_tsx__WEBPACK_IMPORTED_MODULE_5__["default"], { id: _models_documents_use_document_ts__WEBPACK_IMPORTED_MODULE_7__.EXPLANATION_KEY, className: classnames__WEBPACK_IMPORTED_MODULE_1___default()([
                            _overview_css__WEBPACK_IMPORTED_MODULE_4__["default"]['full-height'],
                            _overview_css__WEBPACK_IMPORTED_MODULE_4__["default"]['explanation-wrapper']
                        ]), inputClassName: _overview_css__WEBPACK_IMPORTED_MODULE_4__["default"]['explanation-input'], label: 'Explanation', value: explanation, readOnly: readOnly, onChange: (0,lodash__WEBPACK_IMPORTED_MODULE_3__.partial)(handleTextAreaChange, _models_documents_use_document_ts__WEBPACK_IMPORTED_MODULE_7__.EXPLANATION_KEY), hasError: explanationError !== undefined, errorMessage: explanationError }) })] }) }));
};
Overview.displayName = 'Overview';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_6__.memo)(Overview));


/***/ }),

/***/ "./app/components/document/route-log/index.tsx":
/*!*****************************************************!*\
  !*** ./app/components/document/route-log/index.tsx ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_collapsible_section_index_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/collapsible-section/index.tsx */ "./app/components/collapsible-section/index.tsx");
/* harmony import */ var _components_collapsible_table_index_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/components/collapsible-table/index.tsx */ "./app/components/collapsible-table/index.tsx");
/* harmony import */ var _utils_constants_ts__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ~/utils/constants.ts */ "./app/utils/constants.ts");
/* harmony import */ var _utils_date_ts__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/utils/date.ts */ "./app/utils/date.ts");
/* harmony import */ var _pending_action_requests_tsx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./pending-action-requests.tsx */ "./app/components/document/route-log/pending-action-requests.tsx");
/* harmony import */ var _schema_ts__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./schema.ts */ "./app/components/document/route-log/schema.ts");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./style.css */ "./app/components/document/route-log/style.css");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ~/style.css */ "./app/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_10__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */










const leftFieldClassList = classnames__WEBPACK_IMPORTED_MODULE_1___default()([
    'col-md-offset-1',
    'col-md-5',
    'col-sm-6'
]);
const rightFieldClassList = classnames__WEBPACK_IMPORTED_MODULE_1___default()(['col-md-5', 'col-sm-6']);
const getDateString = (date) => {
    return date ? (0,_utils_date_ts__WEBPACK_IMPORTED_MODULE_5__.getDateStringByType)(date, _utils_constants_ts__WEBPACK_IMPORTED_MODULE_4__.FormFieldTypes.DATE_TIME) : '--';
};
const RouteLog = ({ summary, footer, canProcessActions, onRequestProcessActions }) => {
    const generateSummaryRows = (0,react__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => {
        const summaryRows = [
            [
                {
                    label: 'Type',
                    value: ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { href: summary.documentType?.url, children: summary.documentType?.value }))
                },
                { label: 'Created', value: getDateString(summary.createdOn) }
            ],
            [
                {
                    label: 'Initiator',
                    value: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { href: summary.initiator?.url, children: summary.initiator?.value })
                },
                {
                    label: 'Last Modified',
                    value: getDateString(summary.lastModifiedOn)
                }
            ],
            [
                { label: 'Route Status', value: summary.status },
                {
                    label: 'Last Approved',
                    value: getDateString(summary.lastApprovedOn)
                }
            ],
            [
                { label: 'Node(s)', value: (summary.nodes ?? []).join(', ') },
                { label: 'Finalized', value: getDateString(summary.finalizedOn) }
            ]
        ];
        return summaryRows.map(([left, right], index) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'row', role: 'row', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: leftFieldClassList, role: 'gridcell', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { "data-testid": `${left.label.toLowerCase()}-field`, className: _style_css__WEBPACK_IMPORTED_MODULE_9__["default"].field, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("label", { children: left.label }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { children: left.value ?? null })] }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: rightFieldClassList, role: 'gridcell', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { "data-testid": `${right.label.toLowerCase()}-field`, className: _style_css__WEBPACK_IMPORTED_MODULE_9__["default"].field, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("label", { children: right.label }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { children: right.value })] }) })] }, `row-${index}`)));
    }, [
        summary.createdOn,
        summary.documentType?.url,
        summary.documentType?.value,
        summary.finalizedOn,
        summary.initiator?.url,
        summary.initiator?.value,
        summary.lastApprovedOn,
        summary.lastModifiedOn,
        summary.nodes,
        summary.status
    ]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_10__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_collapsible_section_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { className: _style_css__WEBPACK_IMPORTED_MODULE_8__["default"].section, title: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h3", { children: "Route Log" }), children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_8__["default"]['doc-number'], children: ["ID: ", summary.documentNumber] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_8__["default"].summary, children: generateSummaryRows() }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_collapsible_table_index_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], { id: 'actions-taken', rows: summary.takenActions, getSchema: () => _schema_ts__WEBPACK_IMPORTED_MODULE_7__["default"].takenActions, title: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'subtitle2', children: "Actions Taken" }), emptyMessage: 'No actions', className: _style_css__WEBPACK_IMPORTED_MODULE_8__["default"]['actions-table'] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_pending_action_requests_tsx__WEBPACK_IMPORTED_MODULE_6__["default"], { rows: summary.pendingActions ?? [], className: _style_css__WEBPACK_IMPORTED_MODULE_8__["default"]['actions-table'], canProcessActions: canProcessActions, onRequestProcessActions: onRequestProcessActions }), footer && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("hr", {}), footer] }))] }) }));
};
RouteLog.displayName = 'RouteLog';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_10__.memo)(RouteLog));


/***/ }),

/***/ "./app/components/document/route-log/pending-action-requests.tsx":
/*!***********************************************************************!*\
  !*** ./app/components/document/route-log/pending-action-requests.tsx ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   INITIAL_HEADER_DATA: () => (/* binding */ INITIAL_HEADER_DATA),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _components_document_super_user_annotation_modal_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/components/document/super-user/annotation-modal.tsx */ "./app/components/document/super-user/annotation-modal.tsx");
/* harmony import */ var _components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/buttons/index.tsx */ "./app/components/buttons/index.tsx");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_collapsible_table_index_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ~/components/collapsible-table/index.tsx */ "./app/components/collapsible-table/index.tsx");
/* harmony import */ var _utils_constants_ts__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/utils/constants.ts */ "./app/utils/constants.ts");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _table_index_tsx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../table/index.tsx */ "./app/components/table/index.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./style.css */ "./app/components/document/route-log/style.css");
/* harmony import */ var _components_table_use_selectable_rows_ts__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ~/components/table/use-selectable-rows.ts */ "./app/components/table/use-selectable-rows.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _schema_ts__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./schema.ts */ "./app/components/document/route-log/schema.ts");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */











const BASE_SCHEMA = [
    { name: 'selected', label: '', type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_5__.FormFieldTypes.SPACER },
    ..._schema_ts__WEBPACK_IMPORTED_MODULE_11__["default"].pendingActions
];
const EDIT_SCHEMA = [_schema_ts__WEBPACK_IMPORTED_MODULE_11__.checkBoxColumn, ..._schema_ts__WEBPACK_IMPORTED_MODULE_11__["default"].pendingActions];
const INITIAL_HEADER_DATA = {
    id: 'header',
    selected: {
        checked: false,
        indeterminate: false
    }
};
const rowIsSelectable = (row) => (0,lodash__WEBPACK_IMPORTED_MODULE_6__.get)(row, 'active', false);
const PendingActionRequestsTable = ({ rows, className, onRequestProcessActions, canProcessActions }) => {
    const [showAnnotationModal, setShowAnnotationModal] = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)(false);
    const [actionsBeingProcessed, setActionsBeingProcessed] = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)(false);
    const { rows: rowData, header: headerData, selectedRowCount, handleRowOnChange } = (0,_components_table_use_selectable_rows_ts__WEBPACK_IMPORTED_MODULE_9__["default"])(rows, INITIAL_HEADER_DATA, rowIsSelectable);
    const handleTakeSelectedActionsClicked = (0,react__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => {
        setShowAnnotationModal(true);
    }, []);
    const handleRequestSave = (0,react__WEBPACK_IMPORTED_MODULE_10__.useCallback)(async (annotation) => {
        setShowAnnotationModal(false);
        const actionsToProcess = rowData.filter(({ selected }) => selected);
        setActionsBeingProcessed(true);
        await onRequestProcessActions(actionsToProcess, annotation);
        setActionsBeingProcessed(false);
    }, [onRequestProcessActions, rowData]);
    const getSchema = (0,react__WEBPACK_IMPORTED_MODULE_10__.useCallback)((type, row) => {
        const isActiveRow = type === _table_index_tsx__WEBPACK_IMPORTED_MODULE_7__.RowTypes.ROW && rowIsSelectable(row);
        const isHeader = type === _table_index_tsx__WEBPACK_IMPORTED_MODULE_7__.RowTypes.HEADER;
        if (canProcessActions && (isActiveRow || isHeader)) {
            return EDIT_SCHEMA;
        }
        return BASE_SCHEMA;
    }, [canProcessActions]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react__WEBPACK_IMPORTED_MODULE_10__.StrictMode, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_collapsible_table_index_tsx__WEBPACK_IMPORTED_MODULE_4__["default"], { id: 'pending-actions-table', rows: rowData, headerData: headerData, getSchema: getSchema, onChange: handleRowOnChange, className: classnames__WEBPACK_IMPORTED_MODULE_3___default()(className, {
                    [_style_css__WEBPACK_IMPORTED_MODULE_8__["default"]['editable-pending-actions-table']]: canProcessActions
                }), emptyMessage: 'No pending actions', title: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'subtitle2', children: "Actions Pending" }), footer: canProcessActions && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { variant: 'contained', disabled: selectedRowCount === 0, loading: actionsBeingProcessed, testId: 'take-selected-actions-button', onClick: handleTakeSelectedActionsClicked, children: "Take Selected Actions" })) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_document_super_user_annotation_modal_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { isOpen: showAnnotationModal, onRequestClose: () => setShowAnnotationModal(false), onRequestSave: handleRequestSave })] }));
};
PendingActionRequestsTable.displayName = 'PendingActionRequestsTable';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_10__.memo)(PendingActionRequestsTable));


/***/ }),

/***/ "./app/components/document/route-log/schema.ts":
/*!*****************************************************!*\
  !*** ./app/components/document/route-log/schema.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   checkBoxColumn: () => (/* binding */ checkBoxColumn),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ~/utils/constants.ts */ "./app/utils/constants.ts");
/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

const checkBoxColumn = {
    name: 'selected',
    type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.BOOLEAN,
    label: '',
    control: {
        type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormControlTypes.CHECKBOX,
        displayInHeader: true
    }
};
const schema = {
    takenActions: [
        {
            name: 'action',
            type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.TEXT,
            label: 'Action'
        },
        {
            name: 'target',
            type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
            label: 'Taken By'
        },
        {
            name: 'delegator',
            type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
            label: 'For Delegator',
            defaultValue: '--'
        },
        {
            name: 'actionTakenOn',
            type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.DATE_TIME,
            label: 'Date & Time'
        },
        {
            name: 'annotation',
            type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.TEXT,
            label: 'Annotation'
        }
    ],
    pendingActions: [
        {
            name: 'action',
            type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.TEXT,
            label: 'Action'
        },
        {
            name: 'target',
            type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
            label: 'Requested of'
        },
        {
            name: 'delegator',
            type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.LINK,
            label: 'For Delegator(s)',
            defaultValue: '--'
        },
        {
            name: 'actionCreatedOn',
            type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.DATE_TIME,
            label: 'Date & Time'
        },
        {
            name: 'annotation',
            type: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_0__.FormFieldTypes.TEXT,
            label: 'Annotation'
        }
    ]
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (schema);


/***/ }),

/***/ "./app/components/document/route-log/style.css":
/*!*****************************************************!*\
  !*** ./app/components/document/route-log/style.css ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/document/route-log/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/document/route-log/use-route-log.ts":
/*!************************************************************!*\
  !*** ./app/components/document/route-log/use-route-log.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _models_documents_document_response_error_ts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/models/documents/document-response-error.ts */ "./app/models/documents/document-response-error.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



const useRouteLog = (initialRouteLog, documentRequest) => {
    const [routeLog, setRouteLog] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(initialRouteLog);
    const [summary, setSummary] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)({});
    (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
        const newSummary = {
            initiator: routeLog.initiatorLink,
            documentNumber: routeLog.documentNumber,
            documentType: routeLog.documentTypeLink,
            status: routeLog.routeStatus,
            nodes: routeLog.nodeNames ?? [],
            takenActions: routeLog.takenActions ?? [],
            pendingActions: routeLog.pendingActions ?? [],
            createdOn: routeLog.createdOn,
            lastModifiedOn: routeLog.lastModifiedOn,
            lastApprovedOn: routeLog.lastApprovedOn,
            finalizedOn: routeLog.finalizedOn
        };
        const dateFields = [
            'createdOn',
            'lastModifiedOn',
            'lastApprovedOn',
            'finalizedOn'
        ];
        dateFields.forEach((dateField) => {
            const timestamp = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.get)(routeLog, dateField);
            if (timestamp) {
                newSummary[dateField] = timestamp;
            }
        });
        setSummary(newSummary);
    }, [routeLog]);
    const reload = (0,react__WEBPACK_IMPORTED_MODULE_2__.useCallback)(async () => {
        const response = await documentRequest('getRouteLog');
        if ((0,_models_documents_document_response_error_ts__WEBPACK_IMPORTED_MODULE_1__.isDocumentResponseError)(response)) {
            console.error('Error adding ad hoc routing recipient', response);
            return;
        }
        setRouteLog(response.data);
    }, [documentRequest]);
    return {
        summary,
        reload
    };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useRouteLog);


/***/ }),

/***/ "./app/components/document/super-user/annotation-modal.tsx":
/*!*****************************************************************!*\
  !*** ./app/components/document/super-user/annotation-modal.tsx ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/components/buttons/index.tsx */ "./app/components/buttons/index.tsx");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_modal_index_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/components/modal/index.tsx */ "./app/components/modal/index.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/document/super-user/style.css");
/* harmony import */ var _components_input_textarea_tsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/components/input/textarea.tsx */ "./app/components/input/textarea.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */






const AnnotationModal = ({ onRequestClose, onRequestSave, isOpen }) => {
    const [annotation, setAnnotation] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)('');
    const [saveDisabled, setSaveDisabled] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(true);
    const [saveLoading, setSaveLoading] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
    (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
        setSaveDisabled((0,lodash__WEBPACK_IMPORTED_MODULE_2__.isEmpty)(annotation));
    }, [annotation]);
    const handleAnnotationChange = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((e) => {
        setAnnotation(e.target.value);
    }, []);
    const handleRequestSave = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
        const asyncCall = async () => {
            setSaveLoading(true);
            await onRequestSave(annotation);
            setSaveLoading(false);
            setAnnotation('');
        };
        // eslint-disable-next-line no-void
        void asyncCall();
    }, [annotation, onRequestSave]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_modal_index_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], { isOpen: isOpen, onRequestClose: onRequestClose, className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['annotation-modal'], showClose: false, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h3", { children: "Annotation Required" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'caption', children: "Add details*" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_input_textarea_tsx__WEBPACK_IMPORTED_MODULE_5__["default"], { id: 'annotation-input', value: annotation, className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['annotation-input-wrapper'], inputClassName: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['annotation-input'], onChange: handleAnnotationChange }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['annotation-button-wrapper'], children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { onClick: onRequestClose, testId: 'annotation-close-button', children: "Cancel" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { variant: 'contained', onClick: handleRequestSave, disabled: saveDisabled, loading: saveLoading, testId: 'annotation-save-button', children: "Save" })] })] }) }));
};
AnnotationModal.displayName = 'AnnotationModal';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_6__.memo)(AnnotationModal));


/***/ }),

/***/ "./app/components/document/super-user/footer.tsx":
/*!*******************************************************!*\
  !*** ./app/components/document/super-user/footer.tsx ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _annotation_modal_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./annotation-modal.tsx */ "./app/components/document/super-user/annotation-modal.tsx");
/* harmony import */ var _components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/buttons/index.tsx */ "./app/components/buttons/index.tsx");
/* harmony import */ var _utils_constants_ts__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/utils/constants.ts */ "./app/utils/constants.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */




const SuperUserFooter = ({ canApproveDocument, canDisapproveDocument, onRequestApprove, onRequestDisapprove }) => {
    const [showAnnotationModal, setShowAnnotationModal] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(false);
    const [currentAction, setCurrentAction] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)();
    const [loadingButton, setLoadingButton] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)();
    const handleSuperUserApprove = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(() => {
        setShowAnnotationModal(true);
        setCurrentAction(_utils_constants_ts__WEBPACK_IMPORTED_MODULE_3__.DOCUMENT.ACTIONS.SUPER_USER_APPROVE);
    }, []);
    const handleSuperUserDisapprove = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(() => {
        setShowAnnotationModal(true);
        setCurrentAction(_utils_constants_ts__WEBPACK_IMPORTED_MODULE_3__.DOCUMENT.ACTIONS.SUPER_USER_DISAPPROVE);
    }, []);
    const handleRequestSave = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(async (annotation) => {
        setShowAnnotationModal(false);
        setLoadingButton(currentAction);
        if (currentAction === _utils_constants_ts__WEBPACK_IMPORTED_MODULE_3__.DOCUMENT.ACTIONS.SUPER_USER_APPROVE) {
            await onRequestApprove(annotation);
        }
        else if (currentAction === _utils_constants_ts__WEBPACK_IMPORTED_MODULE_3__.DOCUMENT.ACTIONS.SUPER_USER_DISAPPROVE) {
            await onRequestDisapprove(annotation);
        }
        setLoadingButton(null);
        setCurrentAction(null);
    }, [currentAction, onRequestApprove, onRequestDisapprove]);
    const handleRequestClose = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(() => {
        setShowAnnotationModal(false);
        setCurrentAction(null);
    }, []);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react__WEBPACK_IMPORTED_MODULE_4__.StrictMode, { children: [canApproveDocument && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { variant: 'outlined', onClick: handleSuperUserApprove, loading: loadingButton === _utils_constants_ts__WEBPACK_IMPORTED_MODULE_3__.DOCUMENT.ACTIONS.SUPER_USER_APPROVE, testId: 'superuser-approve-button', customStyle: { marginRight: '8px' }, children: "Approve Document" })), canDisapproveDocument && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { variant: 'outlined', onClick: handleSuperUserDisapprove, loading: loadingButton === _utils_constants_ts__WEBPACK_IMPORTED_MODULE_3__.DOCUMENT.ACTIONS.SUPER_USER_DISAPPROVE, testId: 'superuser-disapprove-button', children: "Disapprove Document" })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_annotation_modal_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { isOpen: showAnnotationModal, onRequestClose: handleRequestClose, onRequestSave: handleRequestSave })] }));
};
SuperUserFooter.displayName = 'SuperUserFooter';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_4__.memo)(SuperUserFooter));


/***/ }),

/***/ "./app/components/document/super-user/style.css":
/*!******************************************************!*\
  !*** ./app/components/document/super-user/style.css ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/document/super-user/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/document/super-user/use-super-user.ts":
/*!**************************************************************!*\
  !*** ./app/components/document/super-user/use-super-user.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


var SUPER_USER_ACTIONS;
(function (SUPER_USER_ACTIONS) {
    SUPER_USER_ACTIONS["APPROVE"] = "approve";
    SUPER_USER_ACTIONS["DISAPPROVE"] = "disapprove";
})(SUPER_USER_ACTIONS || (SUPER_USER_ACTIONS = {}));
const useSuperUser = (superUser, documentRequest) => {
    const isSuperUser = superUser.isSuperUser ?? false;
    const canApproveDocument = superUser.canApproveDocument ?? false;
    const canDisapproveDocument = superUser.canDisapproveDocument ?? false;
    const canApproveSingleActionRequest = superUser.canApproveSingleActionRequest ?? false;
    const actionsAvailable = superUser.actionsAvailable ?? false;
    const hasSuperUserActions = isSuperUser && (canApproveDocument || canDisapproveDocument);
    const canApproveActionRequests = canApproveSingleActionRequest && actionsAvailable;
    const superUserAction = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(async (annotation, action) => {
        return documentRequest('superUserAction', {
            data: { annotation, action }
        });
    }, [documentRequest]);
    const superUserApprove = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(async (annotation) => {
        return superUserAction(annotation, SUPER_USER_ACTIONS.APPROVE);
    }, [superUserAction]);
    const superUserDisapprove = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(async (annotation) => {
        return superUserAction(annotation, SUPER_USER_ACTIONS.DISAPPROVE);
    }, [superUserAction]);
    const processPendingActions = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(async (actions, annotation) => {
        const actionIds = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.map)(actions, 'id');
        return documentRequest('processSuperUserActions', {
            data: { actionIds, annotation }
        });
    }, [documentRequest]);
    return {
        isSuperUser,
        hasSuperUserActions,
        canApproveDocument,
        canDisapproveDocument,
        canApproveActionRequests,
        superUserApprove,
        superUserDisapprove,
        processPendingActions
    };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useSuperUser);


/***/ }),

/***/ "./app/components/errors/error-message.tsx":
/*!*************************************************!*\
  !*** ./app/components/errors/error-message.tsx ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./style.css */ "./app/components/errors/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


const ErrorMessage = ({ message }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_2__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_1__["default"].error, children: message }) }));
};
ErrorMessage.displayName = 'ErrorMessage';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_2__.memo)(ErrorMessage));


/***/ }),

/***/ "./app/components/errors/style.css":
/*!*****************************************!*\
  !*** ./app/components/errors/style.css ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/errors/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/field-renderers/currency-renderer.tsx":
/*!**************************************************************!*\
  !*** ./app/components/field-renderers/currency-renderer.tsx ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var accounting__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! accounting */ "./node_modules/accounting/accounting.js");
/* harmony import */ var accounting__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(accounting__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _currency_inquiry_index_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../currency-inquiry/index.tsx */ "./app/components/currency-inquiry/index.tsx");
/* harmony import */ var _currency_link_index_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../currency-link/index.tsx */ "./app/components/currency-link/index.tsx");
/* harmony import */ var _utils_utils_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ~/utils/utils.tsx */ "./app/utils/utils.tsx");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash/isObject */ "./node_modules/lodash/isObject.js");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash_isObject__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */






const INQUIRY = 'inquiry';
const LINK = 'link';
const currencyFormatters = {
    2: new Intl.NumberFormat(navigator.language, {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
    })
};
const currencyRenderer = (value, precision) => {
    const plainValue = lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default()(value) ? value.value : value;
    const unformattedValue = accounting__WEBPACK_IMPORTED_MODULE_1___default().unformat(plainValue);
    let formattedValue;
    if (currencyFormatters[precision]) {
        formattedValue = currencyFormatters[precision].format(unformattedValue);
    }
    else {
        const formatter = new Intl.NumberFormat(navigator.language, {
            minimumFractionDigits: precision,
            maximumFractionDigits: precision
        });
        currencyFormatters[precision] = formatter;
        formattedValue = formatter.format(unformattedValue);
    }
    if (formattedValue.startsWith('-')) {
        formattedValue = `(${formattedValue.substring(1)})`;
    }
    if (!(0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_4__.isLink)(value)) {
        return formattedValue;
    }
    switch (value.type) {
        case INQUIRY:
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_currency_inquiry_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { inquiryUrl: value.url, value: formattedValue }) }));
        case LINK:
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_currency_link_index_tsx__WEBPACK_IMPORTED_MODULE_3__.CurrencyLink, { url: value.url, value: formattedValue }) }));
        default:
            return formattedValue;
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (currencyRenderer);


/***/ }),

/***/ "./app/components/flex-grid/grid.css":
/*!*******************************************!*\
  !*** ./app/components/flex-grid/grid.css ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_grid_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./grid.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/flex-grid/grid.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_grid_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_grid_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_grid_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_grid_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/flex-grid/index.tsx":
/*!********************************************!*\
  !*** ./app/components/flex-grid/index.tsx ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   GridHeader: () => (/* binding */ GridHeader),
/* harmony export */   GridRow: () => (/* binding */ GridRow)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var nanoid__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! nanoid */ "./node_modules/nanoid/index.browser.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _grid_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./grid.css */ "./app/components/flex-grid/grid.css");
/* harmony import */ var _utils_document_table_utils_tsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/utils/document/table-utils.tsx */ "./app/utils/document/table-utils.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);







const InnerGridRow = (0,react__WEBPACK_IMPORTED_MODULE_6__.memo)(({ className, readOnly = false, rowData, schema, getValue, cellRole = 'gridcell' }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('row', className), role: 'row', children: schema.map((item) => {
                const isRequired = item.control?.required ?? false;
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('col-xs', _grid_css__WEBPACK_IMPORTED_MODULE_4__["default"].column, (0,_utils_document_table_utils_tsx__WEBPACK_IMPORTED_MODULE_5__.classesForType)(item.type)), style: item.style, role: cellRole, "data-testid": 'grid-cell', children: getValue(rowData, item, readOnly, isRequired, false) }, item.name || (0,nanoid__WEBPACK_IMPORTED_MODULE_2__.nanoid)()));
            }) }) }));
});
InnerGridRow.displayName = 'InnerGridRow';
const GridRow = (0,react__WEBPACK_IMPORTED_MODULE_6__.memo)(({ className, readOnly, errors, rowData, schema, transformers, onChange = lodash__WEBPACK_IMPORTED_MODULE_3__.noop }) => {
    const getValue = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((data, schema, readOnly) => {
        return (0,_utils_document_table_utils_tsx__WEBPACK_IMPORTED_MODULE_5__.getCellValue)(data, schema, readOnly, transformers, errors, onChange);
    }, [errors, onChange, transformers]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(InnerGridRow, { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('body1', _grid_css__WEBPACK_IMPORTED_MODULE_4__["default"].row, className), rowData: rowData, readOnly: readOnly, schema: schema, getValue: getValue }) }));
});
GridRow.displayName = 'GridRow';
const GridHeader = (0,react__WEBPACK_IMPORTED_MODULE_6__.memo)(({ className, schema }) => {
    const getLabel = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((item, required) => {
        const itemLabel = item.label;
        const requiredIndicator = required ? '*' : '';
        return itemLabel + requiredIndicator;
    }, []);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(InnerGridRow, { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('caption', _grid_css__WEBPACK_IMPORTED_MODULE_4__["default"].header, className), schema: schema, getValue: (_, item, _readOnly, isRequired) => getLabel(item, isRequired), cellRole: 'columnheader' }) }));
});
GridHeader.displayName = 'GridHeader';



/***/ }),

/***/ "./app/components/full-screen/index.tsx":
/*!**********************************************!*\
  !*** ./app/components/full-screen/index.tsx ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _mui_icons_material_ArrowBack__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/icons-material/ArrowBack */ "./node_modules/@mui/icons-material/esm/ArrowBack.js");
/* harmony import */ var _mui_material_IconButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material/IconButton */ "./node_modules/@mui/material/esm/IconButton/IconButton.js");
/* harmony import */ var react_modal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-modal */ "./node_modules/react-modal/lib/index.js");
/* harmony import */ var react_modal__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_modal__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/full-screen/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */





const FullScreen = ({ children, handleClose }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_5__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)((react_modal__WEBPACK_IMPORTED_MODULE_3___default()), { isOpen: true, className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"].modal, overlayClassName: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['modal-overlay'], ariaHideApp: false, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_2__["default"], { "aria-label": 'Back', onClick: handleClose, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_ArrowBack__WEBPACK_IMPORTED_MODULE_1__["default"], {}) }), children] }) }));
};
FullScreen.displayName = 'FullScreen';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_5__.memo)(FullScreen));


/***/ }),

/***/ "./app/components/full-screen/style.css":
/*!**********************************************!*\
  !*** ./app/components/full-screen/style.css ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/full-screen/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/header/IdleTimerWrapper.tsx":
/*!****************************************************!*\
  !*** ./app/components/header/IdleTimerWrapper.tsx ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_utils_tsx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ~/utils/utils.tsx */ "./app/utils/utils.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_idle_timer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-idle-timer */ "./node_modules/react-idle-timer/dist/index.esm.js");
/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



const IdleTimerWrapper = ({ sessionTimeout }) => {
    (0,react_idle_timer__WEBPACK_IMPORTED_MODULE_2__.useIdleTimer)({
        timeout: 1000 * (sessionTimeout ?? 60 * 60),
        onIdle: () => (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_0__.goToExpiredSession)()
    });
    return null;
};
IdleTimerWrapper.displayName = 'IdleTimerWrapper';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(IdleTimerWrapper));


/***/ }),

/***/ "./app/components/header/about-modal.tsx":
/*!***********************************************!*\
  !*** ./app/components/header/about-modal.tsx ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _components_modal_index_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/components/modal/index.tsx */ "./app/components/modal/index.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.css */ "./app/components/header/style.css");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/style.css */ "./app/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */




const AboutModal = ({ isOpen, onRequestClose, versions }) => {
    const closeModalButton = (0,react__WEBPACK_IMPORTED_MODULE_4__.useRef)(null);
    const handleFocusOnCloseButton = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(() => {
        closeModalButton.current?.focus();
    }, []);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_4__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_modal_index_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { className: _style_css__WEBPACK_IMPORTED_MODULE_2__["default"]['about-modal'], isOpen: isOpen, onRequestClose: onRequestClose, onAfterOpen: handleFocusOnCloseButton, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'content about', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_3__["default"]['modal-header'], children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h2", { children: "ABOUT" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("button", { type: 'button', onClick: onRequestClose, ref: closeModalButton, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { "aria-hidden": 'true', children: "\u00D7" }) })] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("ul", { children: versions &&
                            Object.keys(versions)
                                .sort()
                                .map((heading) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("li", { children: [heading, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("ul", { children: Object.entries(versions[heading])
                                            .sort()
                                            .map(([label, version]) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("li", { children: [label, ": ", version] }, label))) })] }, heading))) })] }) }) }));
};
AboutModal.displayName = 'AboutModal';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_4__.memo)(AboutModal));


/***/ }),

/***/ "./app/components/header/header.tsx":
/*!******************************************!*\
  !*** ./app/components/header/header.tsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _models_user_preferences_ts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/models/user-preferences.ts */ "./app/models/user-preferences.ts");
/* harmony import */ var _IdleTimerWrapper_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./IdleTimerWrapper.tsx */ "./app/components/header/IdleTimerWrapper.tsx");
/* harmony import */ var _models_business_object_ts__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/models/business-object.ts */ "./app/models/business-object.ts");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/header/style.css");
/* harmony import */ var _test_header_tsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./test-header.tsx */ "./app/components/header/test-header.tsx");
/* harmony import */ var react_toastify__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-toastify */ "./node_modules/react-toastify/dist/index.mjs");
/* harmony import */ var _models_slices_application_environment_ts__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ~/models/slices/application-environment.ts */ "./app/models/slices/application-environment.ts");
/* harmony import */ var _utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ~/utils/dom_utils.tsx */ "./app/utils/dom_utils.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */









const Header = () => {
    const [backdoorId, setBackdoorId] = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)();
    const { data: environment, isLoading: isEnvironmentLoading } = (0,_models_slices_application_environment_ts__WEBPACK_IMPORTED_MODULE_7__.useGetApplicationEnvironmentQuery)();
    // TODO: Refactor to use RTKQuery hooks
    (0,react__WEBPACK_IMPORTED_MODULE_9__.useLayoutEffect)(() => {
        const mount = async () => {
            const userPrefs = await (0,_models_user_preferences_ts__WEBPACK_IMPORTED_MODULE_1__.getBackdoorId)();
            if ((0,_models_business_object_ts__WEBPACK_IMPORTED_MODULE_3__.isErrorResponse)(userPrefs)) {
                console.log(userPrefs);
                return;
            }
            setBackdoorId(userPrefs);
        };
        // eslint-disable-next-line no-void
        void mount();
    }, []);
    (0,react__WEBPACK_IMPORTED_MODULE_9__.useLayoutEffect)(() => {
        if (environment === undefined) {
            return;
        }
        if (!environment.prodMode) {
            const body = (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_8__.getFirstElementBySelector)('.body');
            (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_8__.addClassToElement)(body, 'test-env');
            (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_8__.setStyleRule)(document.getElementById('test-header'), 'display', 'block');
        }
    }, [environment, environment?.prodMode]);
    const renderTestHeader = (0,react__WEBPACK_IMPORTED_MODULE_9__.useCallback)(() => {
        if (environment === undefined) {
            return;
        }
        const prodMode = environment?.prodMode;
        return !prodMode && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_test_header_tsx__WEBPACK_IMPORTED_MODULE_5__["default"], { backdoorId: backdoorId });
    }, [backdoorId, environment]);
    const renderHeader = (0,react__WEBPACK_IMPORTED_MODULE_9__.useCallback)(() => {
        let mainLink = null;
        if (document.getElementById('lookup') !== null ||
            document.getElementById('workarea') !== null) {
            mainLink = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { href: '#view_div', className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"].skippy, children: "Skip to main" }));
        }
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { id: 'skipmenu', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { href: '#sidebarHome', className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"].skippy, children: "Skip to menu" }), mainLink] }));
    }, []);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_9__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_toastify__WEBPACK_IMPORTED_MODULE_6__.ToastContainer, { closeButton: false, hideProgressBar: true, theme: 'colored', style: {
                        width: 'auto'
                    } }), renderHeader(), renderTestHeader(), !(window.location.pathname.endsWith('.do') || isEnvironmentLoading) && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_IdleTimerWrapper_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { sessionTimeout: environment?.sessionTimeout })] }) }));
};
Header.displayName = 'Header';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_9__.memo)(Header));


/***/ }),

/***/ "./app/components/header/style.css":
/*!*****************************************!*\
  !*** ./app/components/header/style.css ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/header/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/header/test-header.tsx":
/*!***********************************************!*\
  !*** ./app/components/header/test-header.tsx ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TEST_HEADER_HEIGHT: () => (/* binding */ TEST_HEADER_HEIGHT),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/components/buttons/index.tsx */ "./app/components/buttons/index.tsx");
/* harmony import */ var _models_user_preferences_slice_ts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/models/user-preferences-slice.ts */ "./app/models/user-preferences-slice.ts");
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
/* harmony import */ var _utils_local_storage_ts__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ~/utils/local-storage.ts */ "./app/utils/local-storage.ts");
/* harmony import */ var _utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/utils/dom_utils.tsx */ "./app/utils/dom_utils.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./style.css */ "./app/components/header/style.css");
/* harmony import */ var _utils_constants_ts__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ~/utils/constants.ts */ "./app/utils/constants.ts");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/dist/react-redux.mjs");
/* harmony import */ var react_hotkeys_hook__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-hotkeys-hook */ "./node_modules/react-hotkeys-hook/packages/react-hotkeys-hook/dist/index.js");
/* harmony import */ var _mui_icons_material_Warning__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @mui/icons-material/Warning */ "./node_modules/@mui/icons-material/esm/Warning.js");
/* harmony import */ var _utils_utils_tsx__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ~/utils/utils.tsx */ "./app/utils/utils.tsx");
/* harmony import */ var _utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ~/utils/keyboard.ts */ "./app/utils/keyboard.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_13__);














const TEST_HEADER_HEIGHT = 40;
const TestHeader = ({ backdoorId }) => {
    const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_8__.useDispatch)();
    const backdoorIdInput = (0,react__WEBPACK_IMPORTED_MODULE_13__.useRef)(null);
    (0,react_hotkeys_hook__WEBPACK_IMPORTED_MODULE_9__.useHotkeys)('ctrl+b', () => backdoorIdInput.current?.focus(), {
        enableOnFormTags: ['input', 'textarea', 'select']
    }, []);
    const dispatchFetchUserPreferences = (0,react__WEBPACK_IMPORTED_MODULE_13__.useCallback)(async () => {
        await dispatch((0,_models_user_preferences_slice_ts__WEBPACK_IMPORTED_MODULE_2__.fetchUserPreferences)({ forceRefresh: true }));
    }, [dispatch]);
    const handleBackdoorLogin = (0,react__WEBPACK_IMPORTED_MODULE_13__.useCallback)(async () => {
        const backdoorId = backdoorIdInput.current?.value ?? '';
        if (backdoorId === '') {
            return;
        }
        try {
            await (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_11__.apiCall)(_utils_constants_ts__WEBPACK_IMPORTED_MODULE_7__.URLS.API.SYS.BACKDOOR_LOGIN, {
                method: 'POST',
                data: { backdoorId }
            });
            backdoorIdInput.current.value = '';
            (0,_utils_local_storage_ts__WEBPACK_IMPORTED_MODULE_4__.localStorageRemove)('userPreferences');
            await dispatchFetchUserPreferences();
            (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_5__.replaceWindowLocation)((0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_11__.getUrlPathPrefix)());
        }
        catch (error) {
            if ((0,axios__WEBPACK_IMPORTED_MODULE_3__.isAxiosError)(error)) {
                console.error(error.response?.status, error.message);
            }
        }
    }, [dispatchFetchUserPreferences]);
    const handleBackDoorEnter = (0,react__WEBPACK_IMPORTED_MODULE_13__.useCallback)(async (evt) => {
        if ((0,_utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_12__.isKeyPressed)(evt, _utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_12__.KeyCodesByText.ENTER)) {
            await handleBackdoorLogin();
        }
    }, [handleBackdoorLogin]);
    const handleBackdoorLogout = (0,react__WEBPACK_IMPORTED_MODULE_13__.useCallback)(async () => {
        try {
            await (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_11__.apiCall)(_utils_constants_ts__WEBPACK_IMPORTED_MODULE_7__.URLS.API.SYS.BACKDOOR_LOGOUT, {});
            (0,_utils_local_storage_ts__WEBPACK_IMPORTED_MODULE_4__.localStorageRemove)('userPreferences');
            await dispatchFetchUserPreferences();
            (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_5__.replaceWindowLocation)((0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_11__.getUrlPathPrefix)());
        }
        catch (error) {
            if ((0,axios__WEBPACK_IMPORTED_MODULE_3__.isAxiosError)(error)) {
                console.error(error.response?.status, error.message);
            }
        }
    }, [dispatchFetchUserPreferences]);
    const renderImpersonatingText = (0,react__WEBPACK_IMPORTED_MODULE_13__.useCallback)(() => {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { children: ["Impersonating ", (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("strong", { children: backdoorId })] }));
    }, [backdoorId]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_13__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { id: 'test-header', className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['test-header'], style: { height: `${TEST_HEADER_HEIGHT}px` }, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['test-info'], style: { height: `${TEST_HEADER_HEIGHT}px` }, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['test-header-column'], style: { display: 'flex', alignItems: 'normal' }, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_Warning__WEBPACK_IMPORTED_MODULE_10__["default"], {}), "This is a test environment"] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { "data-testid": 'impersonation-label', className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['test-header-column'], children: [backdoorId ? renderImpersonatingText() : '', "\u00A0"] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['test-header-column'], children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { "data-testid": 'backdoor-id-input', type: 'text', placeholder: 'Back Door ID', 
                                // eslint-disable-next-line @typescript-eslint/no-misused-promises
                                onKeyDown: handleBackDoorEnter, ref: backdoorIdInput }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__["default"]
                            // eslint-disable-next-line @typescript-eslint/no-misused-promises
                            , { 
                                // eslint-disable-next-line @typescript-eslint/no-misused-promises
                                onClick: handleBackdoorLogin, testId: 'backdoor-login', variant: 'outlined', children: "Login" }), backdoorId && backdoorId !== '' && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__["default"]
                            // eslint-disable-next-line @typescript-eslint/no-misused-promises
                            , { 
                                // eslint-disable-next-line @typescript-eslint/no-misused-promises
                                onClick: handleBackdoorLogout, testId: 'backdoor-logout', variant: 'outlined', customClassName: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"].backdoorHover, children: "Logout" }))] })] }) }) }));
};
TestHeader.displayName = 'TestHeader';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_13__.memo)(TestHeader));


/***/ }),

/***/ "./app/components/header/wrapped-header.tsx":
/*!**************************************************!*\
  !*** ./app/components/header/wrapped-header.tsx ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _header_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./header.tsx */ "./app/components/header/header.tsx");
/* harmony import */ var redux_persist_integration_react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! redux-persist/integration/react */ "./node_modules/redux-persist/es/integration/react.js");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/dist/react-redux.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _models_store_ts__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/models/store.ts */ "./app/models/store.ts");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */





const WrappedHeader = () => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_4__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_redux__WEBPACK_IMPORTED_MODULE_3__.Provider, { store: _models_store_ts__WEBPACK_IMPORTED_MODULE_5__.store, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(redux_persist_integration_react__WEBPACK_IMPORTED_MODULE_2__.PersistGate, { persistor: _models_store_ts__WEBPACK_IMPORTED_MODULE_5__.persistor, loading: null, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_header_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], {}) }) }) }));
};
WrappedHeader.displayName = 'WrappedHeader';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_4__.memo)(WrappedHeader));


/***/ }),

/***/ "./app/components/icon-picker/icon-paginator.tsx":
/*!*******************************************************!*\
  !*** ./app/components/icon-picker/icon-paginator.tsx ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _mui_icons_material_ChevronLeft__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/icons-material/ChevronLeft */ "./node_modules/@mui/icons-material/esm/ChevronLeft.js");
/* harmony import */ var _mui_icons_material_ChevronRight__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material/ChevronRight */ "./node_modules/@mui/icons-material/esm/ChevronRight.js");
/* harmony import */ var _mui_material_IconButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/material/IconButton */ "./node_modules/@mui/material/esm/IconButton/IconButton.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./style.css */ "./app/components/icon-picker/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */






const IconPaginator = ({ currentPage, numPages, goToPage }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"].paginator, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_3__["default"], { onClick: (0,lodash__WEBPACK_IMPORTED_MODULE_4__.partial)(goToPage, currentPage - 1), disabled: currentPage === 0, "aria-label": 'Go to previous page', sx: { color: 'var(--kuali-dark-cool-default)' }, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_ChevronLeft__WEBPACK_IMPORTED_MODULE_1__["default"], {}) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [currentPage + 1, " of ", numPages] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_3__["default"], { onClick: (0,lodash__WEBPACK_IMPORTED_MODULE_4__.partial)(goToPage, currentPage + 1), disabled: currentPage + 1 === numPages, "aria-label": 'Go to next page', sx: { color: 'var(--kuali-dark-cool-default)' }, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_ChevronRight__WEBPACK_IMPORTED_MODULE_2__["default"], {}) })] }) }));
};
IconPaginator.displayName = 'IconPaginator';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_6__.memo)(IconPaginator));


/***/ }),

/***/ "./app/components/icon-picker/icons.ts":
/*!*********************************************!*\
  !*** ./app/components/icon-picker/icons.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
const SELECTABLE_ICONS = [
    'accounting-abacus',
    'accounting-bill-stack-1',
    'accounting-bill-stack',
    'accounting-bill',
    'accounting-bills-1',
    'accounting-calculator-1',
    'accounting-calculator-2',
    'accounting-calculator',
    'accounting-coins-bill',
    'accounting-coins-stack',
    'accounting-coins-stack-1',
    'accounting-coins',
    'accounting-document',
    'accounting-invoice-hand',
    'accounting-invoice-mail',
    'accounting-invoice',
    'accounting-withdraw',
    'analytics-board-bars',
    'analytics-pie-2',
    'app-window',
    'archive',
    'award-medal-1',
    'book-close-2',
    'bookmarks-1',
    'building-1',
    'calculator-app',
    'calendar-3',
    'camera-1',
    'cash-payment-coin',
    'cash-payment-sign-2',
    'check-badge',
    'cloud',
    'common-file-stack',
    'flag-plain-3',
    'flash-1',
    'folder',
    'gauge-dashboard-1-alternate',
    'graph-stats-circle',
    'help-wheel',
    'hierarchy-6',
    'hourglass',
    'hyperlink-2',
    'image-file-light-alternate',
    'laptop',
    'legal-billing',
    'legal-certificate',
    'lock-1',
    'login-key',
    'maps',
    'messages-bubble-double',
    'messages-bubble',
    'mobile-phone-2',
    'module',
    'money-atm',
    'money-bag-dollar',
    'money-bags',
    'multiple-neutral-2',
    'newspaper',
    'pencil-write-alternate',
    'picture-polaroid-landscape',
    'professions-woman-office-1',
    'rating-star-circle',
    'saving-bank-1',
    'single-neutral-id-card-3',
    'target-center-1',
    'task-list-text-1',
    'time-clock-circle-2-alternate',
    'tools-wrench'
];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SELECTABLE_ICONS);


/***/ }),

/***/ "./app/components/icon-picker/index.tsx":
/*!**********************************************!*\
  !*** ./app/components/icon-picker/index.tsx ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/utils/dom_utils.tsx */ "./app/utils/dom_utils.tsx");
/* harmony import */ var _components_icon_index_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/icon/index.tsx */ "./app/components/icon/index.tsx");
/* harmony import */ var _mui_material_IconButton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/material/IconButton */ "./node_modules/@mui/material/esm/IconButton/IconButton.js");
/* harmony import */ var _icon_paginator_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./icon-paginator.tsx */ "./app/components/icon-picker/icon-paginator.tsx");
/* harmony import */ var _icons_ts__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./icons.ts */ "./app/components/icon-picker/icons.ts");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./style.css */ "./app/components/icon-picker/style.css");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ~/utils/keyboard.ts */ "./app/utils/keyboard.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// We need to use the custom Icon component from the Kuali codebase as it uses a custom font collection
// tailored to the financial system. This is not a standard MUI Icon component.
// TODO: Replace with Material Icons?








const ICON_PAGES = (0,lodash__WEBPACK_IMPORTED_MODULE_7__.chunk)(_icons_ts__WEBPACK_IMPORTED_MODULE_5__["default"], 28);
const IconPicker = ({ block, selectedIcon, handleSelectIcon }) => {
    const [isMenuOpen, setIsMenuOpen] = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)(false);
    const [currentPage, setCurrentPage] = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)(0);
    const firstIconElement = (0,react__WEBPACK_IMPORTED_MODULE_9__.useRef)(null);
    const iconsInPage = ICON_PAGES[currentPage];
    const numberOfPages = ICON_PAGES.length;
    const focusFirstIcon = (0,react__WEBPACK_IMPORTED_MODULE_9__.useCallback)(() => {
        if (firstIconElement.current) {
            firstIconElement.current.focus();
        }
    }, []);
    const goToPage = (0,react__WEBPACK_IMPORTED_MODULE_9__.useCallback)((pageNumber) => {
        setCurrentPage(pageNumber);
        focusFirstIcon();
    }, [focusFirstIcon]);
    const closeMenu = (0,react__WEBPACK_IMPORTED_MODULE_9__.useCallback)(() => {
        setIsMenuOpen(false);
        goToPage(0);
    }, [goToPage]);
    // Close the menu when clicked outside
    (0,react__WEBPACK_IMPORTED_MODULE_9__.useEffect)(function () {
        function handleClick(e) {
            if (isMenuOpen &&
                !(0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_1__.closest)(e.target, `.${_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].menu}`)) {
                closeMenu();
            }
        }
        window.addEventListener('click', handleClick);
        return function cleanup() {
            window.removeEventListener('click', handleClick);
        };
    }, [closeMenu, isMenuOpen]);
    // Focus on the first icon when the menu opens
    (0,react__WEBPACK_IMPORTED_MODULE_9__.useEffect)(function () {
        if (isMenuOpen) {
            focusFirstIcon();
        }
    }, [focusFirstIcon, isMenuOpen]);
    // Keyboard controls in the menu
    (0,react__WEBPACK_IMPORTED_MODULE_9__.useEffect)(function () {
        function handleKeyDown(e) {
            const kEvent = e;
            if (isMenuOpen) {
                if ((0,_utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_8__.isKeyPressed)(kEvent, _utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_8__.KeyCodesByNumber.ESCAPE)) {
                    closeMenu();
                }
                else if ((0,_utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_8__.isKeyPressed)(kEvent, _utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_8__.KeyCodesByNumber.LEFT) &&
                    currentPage > 0) {
                    goToPage(currentPage - 1);
                }
                else if ((0,_utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_8__.isKeyPressed)(kEvent, _utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_8__.KeyCodesByNumber.RIGHT) &&
                    currentPage < numberOfPages - 1) {
                    goToPage(currentPage + 1);
                }
            }
        }
        window.addEventListener('keydown', handleKeyDown);
        return function cleanup() {
            window.removeEventListener('keydown', handleKeyDown);
        };
    }, [closeMenu, currentPage, goToPage, isMenuOpen, numberOfPages]);
    const toggleMenu = (0,react__WEBPACK_IMPORTED_MODULE_9__.useCallback)((event) => {
        event.stopPropagation();
        setIsMenuOpen((isMenuOpen) => !isMenuOpen);
    }, []);
    const selectIcon = (0,react__WEBPACK_IMPORTED_MODULE_9__.useCallback)((iconName) => {
        handleSelectIcon(iconName);
        closeMenu();
    }, [closeMenu, handleSelectIcon]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_9__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"].wrapper, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['outer-span-100-width'], children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['inner-span-100-width'], children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("button", { "aria-haspopup": 'true', "aria-expanded": isMenuOpen, style: block
                                ? {
                                    width: '100%'
                                }
                                : undefined, className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['menu-button'], onClick: toggleMenu, "data-testid": 'icon-picker-menu-button', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['button-content'], children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['selected-icon'], children: selectedIcon ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_icon_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { "data-testid": 'icon-picker-selected-icon', name: selectedIcon })) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"].placeholder, children: "Choose an icon..." })) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"].caret })] }) }) }) }), isMenuOpen && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"].menu, tabIndex: 0, "aria-label": 'Choose an icon.', "data-testid": 'icon-picker-menu', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { role: 'menu', className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['icon-container'], children: iconsInPage.map((iconName, index) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_IconButton__WEBPACK_IMPORTED_MODULE_3__["default"], { onClick: (0,lodash__WEBPACK_IMPORTED_MODULE_7__.partial)(selectIcon, iconName), ref: index === 0 ? firstIconElement : undefined, "aria-label": iconName, "data-testid": 'icon-picker-item-button', role: 'menuitem', sx: {
                                    color: 'var(--kuali-dark-cool-default)',
                                    width: '32px',
                                    height: '32px'
                                }, size: 'small', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_icon_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { name: iconName }) }, iconName))) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_icon_paginator_tsx__WEBPACK_IMPORTED_MODULE_4__["default"], { currentPage: currentPage, numPages: numberOfPages, goToPage: goToPage })] }))] }) }));
};
IconPicker.displayName = 'IconPicker';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_9__.memo)(IconPicker));


/***/ }),

/***/ "./app/components/icon-picker/style.css":
/*!**********************************************!*\
  !*** ./app/components/icon-picker/style.css ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/icon-picker/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/icon/fonts/kuali-financials-icons.ttf":
/*!**************************************************************!*\
  !*** ./app/components/icon/fonts/kuali-financials-icons.ttf ***!
  \**************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "data:font/ttf;base64,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";

/***/ }),

/***/ "./app/components/icon/fonts/kuali-financials-icons.woff":
/*!***************************************************************!*\
  !*** ./app/components/icon/fonts/kuali-financials-icons.woff ***!
  \***************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "data:font/woff;base64,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";

/***/ }),

/***/ "./app/components/icon/index.tsx":
/*!***************************************!*\
  !*** ./app/components/icon/index.tsx ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.css */ "./app/components/icon/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_4__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */




const Icon = ({ name, className, size, ref, ...otherProps }) => {
    const dataAriaProps = (0,lodash__WEBPACK_IMPORTED_MODULE_4__.omitBy)(otherProps, (value, key) => !(0,lodash__WEBPACK_IMPORTED_MODULE_4__.startsWith)(key, 'aria-') && !(0,lodash__WEBPACK_IMPORTED_MODULE_4__.startsWith)(key, 'data-'));
    const style = size
        ? {
            fontSize: `${size}px`
        }
        : {};
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { ref: ref, style: style, className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_2__["default"].icon, _style_css__WEBPACK_IMPORTED_MODULE_2__["default"][name], className), ...dataAriaProps }));
};
Icon.displayName = 'Icon';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_3__.memo)(Icon));


/***/ }),

/***/ "./app/components/icon/style.css":
/*!***************************************!*\
  !*** ./app/components/icon/style.css ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/icon/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/input/currency.tsx":
/*!*******************************************!*\
  !*** ./app/components/input/currency.tsx ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var accounting__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! accounting */ "./node_modules/accounting/accounting.js");
/* harmony import */ var accounting__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(accounting__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_transformers_ts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/utils/transformers.ts */ "./app/utils/transformers.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _index_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./index.tsx */ "./app/components/input/index.tsx");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */




const CurrencyInput = ({ value, onChange, ...rest }) => {
    const [isEditing, setIsEditing] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
    const [innerValue, setInnerValue] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)((0,_utils_transformers_ts__WEBPACK_IMPORTED_MODULE_2__.currencyTransformer)(value ?? ''));
    (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
        // only format the value coming in if we are not currently editing
        if (!isEditing) {
            setInnerValue((0,_utils_transformers_ts__WEBPACK_IMPORTED_MODULE_2__.currencyTransformer)(value ?? ''));
        }
    }, [value, isEditing]);
    const innerOnChange = (0,react__WEBPACK_IMPORTED_MODULE_3__.useCallback)((e) => {
        const rawValue = e.target.value;
        setInnerValue(rawValue);
        onChange(accounting__WEBPACK_IMPORTED_MODULE_1___default().unformat(accounting__WEBPACK_IMPORTED_MODULE_1___default().toFixed(accounting__WEBPACK_IMPORTED_MODULE_1___default().unformat(rawValue), 2)));
    }, [onChange]);
    const onBlur = (0,react__WEBPACK_IMPORTED_MODULE_3__.useCallback)((e) => {
        setInnerValue((0,_utils_transformers_ts__WEBPACK_IMPORTED_MODULE_2__.currencyTransformer)(e.target.value));
        setIsEditing(false);
    }, []);
    const onFocus = (0,react__WEBPACK_IMPORTED_MODULE_3__.useCallback)(() => {
        setIsEditing(true);
    }, []);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_index_tsx__WEBPACK_IMPORTED_MODULE_4__["default"], { value: innerValue, onChange: innerOnChange, onBlur: onBlur, onFocus: onFocus, ...rest }));
};
CurrencyInput.displayName = 'CurrencyInput';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_3__.memo)(CurrencyInput));


/***/ }),

/***/ "./app/components/input/index.tsx":
/*!****************************************!*\
  !*** ./app/components/input/index.tsx ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_errors_error_message_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/errors/error-message.tsx */ "./app/components/errors/error-message.tsx");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/input/style.css");
/* harmony import */ var _components_tooltip_index_tsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/components/tooltip/index.tsx */ "./app/components/tooltip/index.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */






const Input = ({ className, inputClassName, labelClassName, hasError, errorMessage, id, label, tooltipLabel, ref, ...props }) => {
    const inputProps = (0,lodash__WEBPACK_IMPORTED_MODULE_3__.omit)({
        id,
        className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_4__["default"].input, inputClassName),
        type: 'text',
        ...props
    }, ['rowData']);
    if (props.readOnly) {
        inputProps.tabIndex = -1;
    }
    let inputComponent = (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { ...inputProps, ref: ref });
    if (tooltipLabel) {
        inputComponent = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_tooltip_index_tsx__WEBPACK_IMPORTED_MODULE_5__["default"], { title: tooltipLabel, placement: 'top-start', children: inputComponent }));
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(className, {
            [_style_css__WEBPACK_IMPORTED_MODULE_4__["default"].error]: hasError
        }), children: [label && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("label", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_4__["default"].label, labelClassName), htmlFor: id, children: label })), inputComponent, hasError && errorMessage && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_errors_error_message_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { message: errorMessage })] }));
};
Input.displayName = 'Input';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_6__.memo)(Input));


/***/ }),

/***/ "./app/components/input/style.css":
/*!****************************************!*\
  !*** ./app/components/input/style.css ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/input/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/input/textarea.tsx":
/*!*******************************************!*\
  !*** ./app/components/input/textarea.tsx ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_errors_error_message_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/errors/error-message.tsx */ "./app/components/errors/error-message.tsx");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_input_style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ~/components/input/style.css */ "./app/components/input/style.css");
/* harmony import */ var _components_tooltip_index_tsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/components/tooltip/index.tsx */ "./app/components/tooltip/index.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */






const TextArea = ({ className, inputClassName, labelClassName, hasError, errorMessage, id, label, tooltipLabel, ref, ...props }) => {
    const inputProps = (0,lodash__WEBPACK_IMPORTED_MODULE_3__.omit)({
        id,
        className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_components_input_style_css__WEBPACK_IMPORTED_MODULE_4__["default"].input, inputClassName),
        type: 'text',
        ...props
    }, ['rowData']);
    if (props.readOnly) {
        inputProps.tabIndex = -1;
    }
    inputProps.className = classnames__WEBPACK_IMPORTED_MODULE_1___default()(inputProps.className, _components_input_style_css__WEBPACK_IMPORTED_MODULE_4__["default"].textarea);
    let inputComponent = (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("textarea", { ...inputProps, ref: ref });
    if (tooltipLabel) {
        inputComponent = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_tooltip_index_tsx__WEBPACK_IMPORTED_MODULE_5__["default"], { title: tooltipLabel, placement: 'top-start', children: inputComponent }));
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(className, {
            [_components_input_style_css__WEBPACK_IMPORTED_MODULE_4__["default"].error]: hasError
        }), children: [label && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("label", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_components_input_style_css__WEBPACK_IMPORTED_MODULE_4__["default"].label, labelClassName), htmlFor: id, children: label })), inputComponent, hasError && errorMessage && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_errors_error_message_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { message: errorMessage })] }));
};
TextArea.displayName = 'TextArea';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_6__.memo)(TextArea));


/***/ }),

/***/ "./app/components/inquiry-link/index.tsx":
/*!***********************************************!*\
  !*** ./app/components/inquiry-link/index.tsx ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InquiryLink: () => (/* binding */ InquiryLink),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _utils_utils_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/utils/utils.tsx */ "./app/utils/utils.tsx");
/* harmony import */ var _mui_icons_material_OpenInNew__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material/OpenInNew */ "./node_modules/@mui/icons-material/esm/OpenInNew.js");
/* harmony import */ var lodash_partial__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/partial */ "./node_modules/lodash/partial.js");
/* harmony import */ var lodash_partial__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_partial__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/inquiry-link/style.css");
/* harmony import */ var url__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! url */ "./node_modules/url/url.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */






const InquiryLink = ({ inquiryInfo, handleInquiry }) => {
    const standaloneRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(null);
    const urlRoot = (0,react__WEBPACK_IMPORTED_MODULE_6__.useMemo)(() => (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_1__.getUrlPathPrefix)(), []);
    const baseUrl = (0,react__WEBPACK_IMPORTED_MODULE_6__.useMemo)(() => `${window.location.protocol}//${window.location.host}${urlRoot}`, [urlRoot]);
    const [showPopup, setShowPopup] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(true);
    (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
        if (standaloneRef.current?.closest('.ReactModalPortal')) {
            setShowPopup(false);
        }
    }, []);
    const { value, url: inquiryUrl } = inquiryInfo;
    if (inquiryUrl && inquiryUrl.length > 0) {
        const parsedUrl = new URL(inquiryUrl, baseUrl);
        parsedUrl.searchParams.append('mode', 'modal');
        const modalUrl = url__WEBPACK_IMPORTED_MODULE_5__.format(parsedUrl).replace(baseUrl, '');
        parsedUrl.searchParams.set('mode', 'standalone');
        const standaloneUrl = url__WEBPACK_IMPORTED_MODULE_5__.format(parsedUrl).replace(baseUrl, urlRoot);
        // Use the standalone mode as the href to ensure link works on its own.
        // The onClick handler can be used to show the modal mode.
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"].inquiry, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { onClick: lodash_partial__WEBPACK_IMPORTED_MODULE_3___default()(handleInquiry, modalUrl), href: standaloneUrl, children: value }), showPopup && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { target: '_blank', className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['new-window-link'], href: standaloneUrl, rel: 'noreferrer', ref: standaloneRef, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_OpenInNew__WEBPACK_IMPORTED_MODULE_2__["default"], { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['new-window-icon'] }) }))] }) }));
    }
    else {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"].inquiry, children: value }) }));
    }
};
InquiryLink.displayName = 'InquiryView';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_6__.memo)(InquiryLink));


/***/ }),

/***/ "./app/components/inquiry-link/style.css":
/*!***********************************************!*\
  !*** ./app/components/inquiry-link/style.css ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/inquiry-link/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/inquiry/index.tsx":
/*!******************************************!*\
  !*** ./app/components/inquiry/index.tsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./style.css */ "./app/components/inquiry/style.css");
/* harmony import */ var _utils_use_previous_ts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/utils/use-previous.ts */ "./app/utils/use-previous.ts");
/* harmony import */ var _utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/utils/dom_utils.tsx */ "./app/utils/dom_utils.tsx");
/* harmony import */ var _utils_utils_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ~/utils/utils.tsx */ "./app/utils/utils.tsx");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_html_parser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-html-parser */ "./node_modules/react-html-parser/lib/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);






// TODO: Replace with html-react-parser


const TAB_ID_REGEX = /^tab-([\w]*)-imageToggle$/;
const ERROR_MESSAGE_REGEX = /Error Message:<\/strong>\n(.*)/;
// This is like this to match the way it was being used in javascript, where they weren't doing it right
// to begin with, so here we are.
const castConvertNodeToElement = react_html_parser__WEBPACK_IMPORTED_MODULE_6__.convertNodeToElement;
const Inquiry = ({ breadcrumbs, inquiryUrl, inquiryTitle, onHandleInquiryPushed, noHeader, replaceBreadcrumbs }) => {
    const prevInquiryUrl = (0,_utils_use_previous_ts__WEBPACK_IMPORTED_MODULE_2__["default"])(inquiryUrl);
    const tabNames = (0,react__WEBPACK_IMPORTED_MODULE_7__.useRef)([]);
    const [error, setError] = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(null);
    const [content, setContent] = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)('');
    const updateInquiry = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)(async () => {
        if (!(0,lodash__WEBPACK_IMPORTED_MODULE_5__.isEmpty)(inquiryUrl)) {
            tabNames.current.length = 0;
            let error = null;
            let content = '';
            try {
                const { data = '' } = await (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_4__.apiCall)(inquiryUrl);
                const errorMatch = ERROR_MESSAGE_REGEX.exec(data);
                if (errorMatch && errorMatch.length > 1) {
                    error = errorMatch[1];
                }
                else {
                    content = data;
                }
            }
            catch (_e) {
                // no op, will default to the message below
                // Add during testing to see if the api call failed due to not finding a matching mock
                // console.log(e);
            }
            if (!content && !error) {
                error = 'Unable to fetch inquiry at this time';
            }
            setContent(content);
            setError(error);
        }
    }, [inquiryUrl]);
    (0,react__WEBPACK_IMPORTED_MODULE_7__.useLayoutEffect)(() => {
        const internalUpdateInquiry = async () => {
            if (prevInquiryUrl !== inquiryUrl) {
                await updateInquiry();
            }
        };
        // eslint-disable-next-line no-void
        void internalUpdateInquiry();
    }, [inquiryUrl, prevInquiryUrl, updateInquiry]);
    const handleInquiryLinkClick = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)((title, inquiryUrl, e) => {
        e.preventDefault();
        onHandleInquiryPushed(title, inquiryUrl);
    }, [onHandleInquiryPushed]);
    const showOrHideTab = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)((tabName, show) => {
        const node = document.getElementById(`tab-${tabName}-div`);
        if (!node) {
            return;
        }
        node.style.display = show ? 'block' : 'none';
        const header = document.getElementById(`tab-${tabName}-imageToggle`);
        if (!header) {
            return;
        }
        const icon = (0,lodash__WEBPACK_IMPORTED_MODULE_5__.get)(header.getElementsByClassName('glyphicon'), 0);
        if (icon) {
            const showClass = 'glyphicon-menu-up';
            const hideClass = 'glyphicon-menu-down';
            const classToAdd = show ? showClass : hideClass;
            const classToRemove = show ? hideClass : showClass;
            (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_3__.addClassToElement)(icon, classToAdd);
            (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_3__.removeClassFromElement)(icon, classToRemove);
        }
    }, []);
    const handleTabToggle = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)((tabName) => {
        const node = document.getElementById(`tab-${tabName}-div`);
        if (!node) {
            return;
        }
        const display = node.style.display;
        const shouldShow = display === 'none';
        showOrHideTab(tabName, shouldShow);
    }, [showOrHideTab]);
    // UI Helpers
    // Can't be pulled out as it relies on the tabNames ref
    const showOrHideAllTabs = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)((show) => {
        tabNames.current.forEach((tabName) => showOrHideTab(tabName, show));
    }, [showOrHideTab]);
    // Can't be pulled out as it relies on the tabNames ref
    const transformToggleBar = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)((node) => {
        if (!node.attribs) {
            return;
        }
        const { attribs } = node;
        const matches = TAB_ID_REGEX.exec(attribs.id);
        const match = (0,lodash__WEBPACK_IMPORTED_MODULE_5__.get)(matches, 1, '');
        delete node.attribs.onclick;
        if (!tabNames.current.includes(match)) {
            tabNames.current.push(match);
        }
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { onClick: (0,lodash__WEBPACK_IMPORTED_MODULE_5__.partial)(handleTabToggle, match), children: castConvertNodeToElement(node) }));
    }, [handleTabToggle]);
    const transformInquiryLink = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)((node) => {
        if (!node.attribs) {
            return;
        }
        const { attribs } = node;
        let relativeUrl = attribs.href;
        if (relativeUrl.startsWith('http')) {
            const urlInfo = new URL(attribs.href);
            relativeUrl = `${urlInfo.pathname}${urlInfo.search}`.replace((0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_4__.getUrlPathPrefix)(), '');
        }
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { href: attribs.href, title: attribs.title, onClick: (0,lodash__WEBPACK_IMPORTED_MODULE_5__.partial)(handleInquiryLinkClick, attribs['data-label'], relativeUrl), children: (0,lodash__WEBPACK_IMPORTED_MODULE_5__.get)(node, ['children', 0, 'data']) }, attribs['data-label']));
    }, [handleInquiryLinkClick]);
    const transformGlobalButton = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)((node) => {
        if (!node.attribs) {
            return;
        }
        const { attribs } = node;
        const show = attribs.id === 'expandAll';
        delete node.attribs.onclick;
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { style: { marginRight: '7px' }, onClick: (0,lodash__WEBPACK_IMPORTED_MODULE_5__.partial)(showOrHideAllTabs, show), children: castConvertNodeToElement(node) }));
    }, [showOrHideAllTabs]);
    const transformNode = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)((node) => {
        if (!node.attribs) {
            return undefined;
        }
        const { name, attribs = {} } = node;
        if (attribs.id === 'breadcrumbs') {
            return replaceBreadcrumbs ? breadcrumbs : null;
        }
        else if (name === 'button' &&
            (0,lodash__WEBPACK_IMPORTED_MODULE_5__.has)(attribs, 'class') &&
            attribs.class.startsWith('close')) {
            return null;
        }
        else if (name === 'a' && attribs['data-remodal-target']) {
            return transformInquiryLink(node);
        }
        else if (attribs.id) {
            const { id } = attribs;
            if (TAB_ID_REGEX.test(id)) {
                return transformToggleBar(node);
            }
            else if (id === 'collapseAll' || id === 'expandAll') {
                return transformGlobalButton(node);
            }
        }
        return undefined;
    }, [
        breadcrumbs,
        replaceBreadcrumbs,
        transformGlobalButton,
        transformInquiryLink,
        transformToggleBar
    ]);
    let inquiryContent;
    if (!error) {
        inquiryContent = (0,react_html_parser__WEBPACK_IMPORTED_MODULE_6__["default"])(content, {
            transform: transformNode
        });
    }
    else {
        inquiryContent = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'fullwidth inquirymodal body', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("main", { className: 'content', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { id: 'view_div', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'inquiry', style: { marginLeft: 0 }, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'main-panel', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'headerarea-small', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h2", { children: "Error" }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { style: { padding: '30px 0' }, children: error })] }) }) }) }) }));
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_7__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_1__["default"].inquiry, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_1__["default"].title, children: [!replaceBreadcrumbs && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_1__["default"].breadcrumbs, children: breadcrumbs })), !noHeader && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { "data-testid": 'inquiry-header', children: inquiryTitle })] }), inquiryContent] }) }));
};
Inquiry.displayName = 'Inquiry';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_7__.memo)(Inquiry));


/***/ }),

/***/ "./app/components/inquiry/modal.tsx":
/*!******************************************!*\
  !*** ./app/components/inquiry/modal.tsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _index_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./index.tsx */ "./app/components/inquiry/index.tsx");
/* harmony import */ var _components_modal_index_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/modal/index.tsx */ "./app/components/modal/index.tsx");
/* harmony import */ var qs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! qs */ "./node_modules/qs/lib/index.js");
/* harmony import */ var qs__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(qs__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/inquiry/style.css");
/* harmony import */ var _utils_use_previous_ts__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/use-previous.ts */ "./app/utils/use-previous.ts");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */







const InquiryModal = ({ isOpen, initialInquiryUrl, initialTitle, onClose }) => {
    const initialBreadcrumbs = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)(() => {
        let title;
        if (initialInquiryUrl) {
            const queryString = qs__WEBPACK_IMPORTED_MODULE_3___default().parse((0,lodash__WEBPACK_IMPORTED_MODULE_6__.get)(initialInquiryUrl.split('?'), '1'));
            const boName = (0,lodash__WEBPACK_IMPORTED_MODULE_6__.get)(queryString, 'title');
            title = boName ?? initialTitle;
        }
        return [{ title, href: initialInquiryUrl }];
    }, [initialInquiryUrl, initialTitle]);
    const [inquiryUrl, setInquiryUrl] = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(initialInquiryUrl);
    const [breadcrumbs, setBreadcrumbs] = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(initialBreadcrumbs());
    const prevIsOpen = (0,_utils_use_previous_ts__WEBPACK_IMPORTED_MODULE_5__["default"])(isOpen);
    const prevInitialInquiryUrl = (0,_utils_use_previous_ts__WEBPACK_IMPORTED_MODULE_5__["default"])(initialInquiryUrl);
    const resetBreadcrumbs = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)(() => {
        setBreadcrumbs(initialBreadcrumbs());
    }, [initialBreadcrumbs]);
    const resetInquiryUrl = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)(() => {
        setInquiryUrl(initialInquiryUrl);
    }, [initialInquiryUrl]);
    (0,react__WEBPACK_IMPORTED_MODULE_7__.useEffect)(() => {
        if (isOpen && !prevIsOpen) {
            resetBreadcrumbs();
        }
        if (initialInquiryUrl !== prevInitialInquiryUrl) {
            resetInquiryUrl();
        }
    }, [
        initialInquiryUrl,
        isOpen,
        prevInitialInquiryUrl,
        prevIsOpen,
        resetBreadcrumbs,
        resetInquiryUrl
    ]);
    const handleInquiryPushed = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)((title, inquiryUrl) => {
        const newBreadcrumbs = [...breadcrumbs, { title, href: inquiryUrl }];
        setBreadcrumbs(newBreadcrumbs);
        setInquiryUrl(inquiryUrl);
    }, [breadcrumbs]);
    const handleBreadcrumbClicked = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)((index, e) => {
        e.preventDefault();
        const newInquiryUrl = breadcrumbs[index].href;
        const newBreadcrumbs = breadcrumbs.slice(0, index + 1);
        setBreadcrumbs(newBreadcrumbs);
        setInquiryUrl(newInquiryUrl);
    }, [breadcrumbs]);
    const handleClose = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)(() => {
        if (onClose) {
            onClose();
        }
    }, [onClose]);
    const buildBreadcrumbs = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)(() => {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { id: 'breadcrumbs', children: [breadcrumbs
                    .slice(0, breadcrumbs.length - 1)
                    .map(({ href = '', title = '' }, i) => {
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { "data-testid": 'inquiry-breadcrumb-link', onClick: (0,lodash__WEBPACK_IMPORTED_MODULE_6__.partial)(handleBreadcrumbClicked, i), title: title, href: href, children: title }), i < breadcrumbs.length - 1 && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'glyphicon glyphicon-chevron-right' }))] }, title + href));
                }), (0,lodash__WEBPACK_IMPORTED_MODULE_6__.last)(breadcrumbs)?.title] }));
    }, [breadcrumbs, handleBreadcrumbClicked]);
    const renderedBreadcrumbs = (0,react__WEBPACK_IMPORTED_MODULE_7__.useMemo)(() => buildBreadcrumbs(), [buildBreadcrumbs]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_7__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_modal_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['inquiry-modal'], isOpen: isOpen, onRequestClose: handleClose, showClose: true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_index_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { breadcrumbs: renderedBreadcrumbs, replaceBreadcrumbs: true, noHeader: true, inquiryUrl: inquiryUrl, onHandleInquiryPushed: handleInquiryPushed, inquiryTitle: initialTitle }) }) }));
};
InquiryModal.displayName = 'InquiryModal';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_7__.memo)(InquiryModal));


/***/ }),

/***/ "./app/components/inquiry/style.css":
/*!******************************************!*\
  !*** ./app/components/inquiry/style.css ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/inquiry/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/inquiry/useLegacyInquiry.tsx":
/*!*****************************************************!*\
  !*** ./app/components/inquiry/useLegacyInquiry.tsx ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _utils_utils_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/utils/utils.tsx */ "./app/utils/utils.tsx");
/* harmony import */ var _components_inquiry_modal_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/inquiry/modal.tsx */ "./app/components/inquiry/modal.tsx");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */




const useLegacyInquiry = (dataToWatch = null) => {
    // Legacy Inquiry support. By default, the link generation on the backend does not have an opinion
    // whether you open an inquiry in a new window or modal. Since documents are still expensive to load
    // we don't want to open an inquiry and lose our place on the document page. Therefore, when the page loads
    // we find all the inquiry links and divert their clicks to an inquiry modal here so that we remain on this page.
    // The dataToWatch parameter is watched for changes. Anytime that data changes, the page will be searched
    // for links to make sure each one has the proper handler attached.
    const [inquiryUrl, setInquiryUrl] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)();
    const handleInquiryClick = (e) => {
        e.preventDefault();
        e.stopPropagation();
        const urlInfo = new URL(e.target.href);
        const relativeUrl = `${urlInfo.pathname}${urlInfo.search}`.replace((0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_1__.getUrlPathPrefix)(), '');
        setInquiryUrl(`${relativeUrl}&mode=modal`);
    };
    (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
        const anchors = window.document.getElementsByTagName('a');
        const inquiryMatch = 'inquiry.do';
        for (const anchor of anchors) {
            if (anchor.href.includes(inquiryMatch) &&
                !anchor.hasAttribute('data-ignore-modal')) {
                anchor.addEventListener('click', handleInquiryClick);
            }
        }
        return () => {
            for (const anchor of anchors) {
                anchor.removeEventListener('click', handleInquiryClick);
            }
        };
    }, [dataToWatch]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_inquiry_modal_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { isOpen: inquiryUrl !== undefined, initialInquiryUrl: inquiryUrl, onClose: (0,lodash__WEBPACK_IMPORTED_MODULE_3__.partial)(setInquiryUrl, undefined), initialTitle: 'Inquiry' }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useLegacyInquiry);


/***/ }),

/***/ "./app/components/leaving-page-modal/index.tsx":
/*!*****************************************************!*\
  !*** ./app/components/leaving-page-modal/index.tsx ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../buttons/index.tsx */ "./app/components/buttons/index.tsx");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_modal_index_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/components/modal/index.tsx */ "./app/components/modal/index.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/leaving-page-modal/style.css");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/style.css */ "./app/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */






// A confirmation modal for leaving a page and discarding changes
const LeavingPageModal = ({ isOpen, onRequestClose, onContinue }) => {
    const continueButton = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(null);
    const placeFocus = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
        if (continueButton.current) {
            continueButton.current.focus();
        }
    }, []);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_modal_index_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], { isOpen: isOpen, className: classnames__WEBPACK_IMPORTED_MODULE_2___default()(_style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['modal-container'], _style_css__WEBPACK_IMPORTED_MODULE_5__["default"].small), onRequestClose: onRequestClose, onAfterOpen: placeFocus, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_2___default()(_style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['modal-content'], _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['leaving-page-modal']), children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h3", { children: "Discard Changes?" }), "If you choose to continue, any unsaved changes to this document will be lost.", (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['modal-buttons'], children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { testId: 'cancel-button', onClick: onRequestClose, children: "Cancel" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { testId: 'continue-button', variant: 'contained', onClick: onContinue, ref: continueButton, children: "Continue" })] })] }) }) }));
};
LeavingPageModal.displayName = 'LeavingPageModal';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_6__.memo)(LeavingPageModal));


/***/ }),

/***/ "./app/components/leaving-page-modal/style.css":
/*!*****************************************************!*\
  !*** ./app/components/leaving-page-modal/style.css ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/leaving-page-modal/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/loading-modal/index.tsx":
/*!************************************************!*\
  !*** ./app/components/loading-modal/index.tsx ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _mui_material_CircularProgress__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material/CircularProgress */ "./node_modules/@mui/material/esm/CircularProgress/CircularProgress.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _components_modal_index_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/components/modal/index.tsx */ "./app/components/modal/index.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/loading-modal/style.css");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/style.css */ "./app/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */






const LoadingModal = () => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_modal_index_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], { className: classnames__WEBPACK_IMPORTED_MODULE_2___default()(_style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['modal-container'], _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['modal-container']), isOpen: true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_2___default()(_style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['modal-content'], _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['modal-content']), children: ["Loading Your Request", (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_CircularProgress__WEBPACK_IMPORTED_MODULE_1__["default"], {})] }) }) }));
LoadingModal.displayName = 'LoadingModal';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_6__.memo)(LoadingModal));


/***/ }),

/***/ "./app/components/loading-modal/style.css":
/*!************************************************!*\
  !*** ./app/components/loading-modal/style.css ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/loading-modal/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/message-block/index.tsx":
/*!************************************************!*\
  !*** ./app/components/message-block/index.tsx ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./style.css */ "./app/components/message-block/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


const MessageBlock = ({ message, id }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_2__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_1__["default"]['message-block-container'], children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { "data-testid": id, className: _style_css__WEBPACK_IMPORTED_MODULE_1__["default"]['message-block'], children: message }) }) }));
};
MessageBlock.displayName = 'MessageBlock';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_2__.memo)(MessageBlock));


/***/ }),

/***/ "./app/components/message-block/style.css":
/*!************************************************!*\
  !*** ./app/components/message-block/style.css ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/message-block/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/modal/index.tsx":
/*!****************************************!*\
  !*** ./app/components/modal/index.tsx ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_buttons_close_button_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/buttons/close-button.tsx */ "./app/components/buttons/close-button.tsx");
/* harmony import */ var _utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/utils/dom_utils.tsx */ "./app/utils/dom_utils.tsx");
/* harmony import */ var react_modal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-modal */ "./node_modules/react-modal/lib/index.js");
/* harmony import */ var react_modal__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_modal__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./style.css */ "./app/components/modal/style.css");
/* harmony import */ var _utils_use_constructor_ts__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ~/utils/use-constructor.ts */ "./app/utils/use-constructor.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */







// TODO: Need to try and find a replacement for ReactModal
// It's got some issues that are filling up the console with warnings
const Modal = ({ children, className, isOpen, onRequestClose, onAfterOpen, showClose }) => {
    (0,_utils_use_constructor_ts__WEBPACK_IMPORTED_MODULE_6__.useConstructor)(() => {
        const appBodyElement = (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_3__.getFirstElementBySelector)('.body');
        react_modal__WEBPACK_IMPORTED_MODULE_4___default().setAppElement(appBodyElement ? '.body' : 'body');
    });
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_7__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)((react_modal__WEBPACK_IMPORTED_MODULE_4___default()), { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('kModal', _style_css__WEBPACK_IMPORTED_MODULE_5__["default"].modal, className), overlayClassName: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"].overlay, isOpen: isOpen, onRequestClose: onRequestClose, onAfterOpen: onAfterOpen, children: [showClose && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_close_button_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['close-button'], onClick: onRequestClose })), children] }) }));
};
Modal.displayName = 'Modal';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_7__.memo)(Modal));


/***/ }),

/***/ "./app/components/modal/style.css":
/*!****************************************!*\
  !*** ./app/components/modal/style.css ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/modal/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/page-header/index.tsx":
/*!**********************************************!*\
  !*** ./app/components/page-header/index.tsx ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_sticky_index_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/sticky/index.tsx */ "./app/components/sticky/index.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./style.css */ "./app/components/page-header/style.css");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ~/style.css */ "./app/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */





const PageHeader = (0,react__WEBPACK_IMPORTED_MODULE_5__.memo)(({ children, className, stickyClassName, childrenWrapperClassName, topOffset, scrollElement = 'main', stickyHeaderDisable, ref }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_5__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_sticky_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { scrollElement: scrollElement, className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(className, _style_css__WEBPACK_IMPORTED_MODULE_3__["default"].header), stickyClassName: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_3__["default"].fixed, stickyClassName), topOffset: topOffset, isNotSticky: stickyHeaderDisable, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ref: ref, className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(childrenWrapperClassName, _style_css__WEBPACK_IMPORTED_MODULE_3__["default"]['header-content'], _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['webapp-container']), children: children }) }) }));
});
PageHeader.displayName = 'PageHeader';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PageHeader);


/***/ }),

/***/ "./app/components/page-header/style.css":
/*!**********************************************!*\
  !*** ./app/components/page-header/style.css ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/page-header/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/page-spinner/index.tsx":
/*!***********************************************!*\
  !*** ./app/components/page-spinner/index.tsx ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _mui_material_CircularProgress__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material/CircularProgress */ "./node_modules/@mui/material/esm/CircularProgress/CircularProgress.js");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.css */ "./app/components/page-spinner/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



const PageSpinner = () => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_3__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_2__["default"]['spinner-container'], "data-testid": 'page-spinner', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_CircularProgress__WEBPACK_IMPORTED_MODULE_1__["default"], {}) }) }));
};
PageSpinner.displayName = 'PageSpinner';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_3__.memo)(PageSpinner));


/***/ }),

/***/ "./app/components/page-spinner/style.css":
/*!***********************************************!*\
  !*** ./app/components/page-spinner/style.css ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/page-spinner/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/popper/index.tsx":
/*!*****************************************!*\
  !*** ./app/components/popper/index.tsx ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Popper: () => (/* binding */ Popper)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _mui_material_ClickAwayListener__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material/ClickAwayListener */ "./node_modules/@mui/material/esm/ClickAwayListener/ClickAwayListener.js");
/* harmony import */ var _mui_material_Grow__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material/Grow */ "./node_modules/@mui/material/esm/Grow/Grow.js");
/* harmony import */ var _mui_material_Paper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/material/Paper */ "./node_modules/@mui/material/esm/Paper/Paper.js");
/* harmony import */ var _mui_material_Popper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/material/Popper */ "./node_modules/@mui/material/esm/Popper/Popper.js");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */




// This is a simple wrapper around the MUI Popper component that allows us a bit of styling control. Using Popper vs
// Popover prevents the popped frame from disabling scrolling, which causes some jiggling when the popper is opened.
const Popper = ({ anchorElement, children, open, placement, handleHide, transformOrigin, removePadding, id }) => {
    const handleClose = (event) => {
        if (anchorElement?.contains(event.target)) {
            return;
        }
        handleHide(false);
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_Popper__WEBPACK_IMPORTED_MODULE_4__["default"], { open: open, anchorEl: anchorElement, placement: placement, transition: true, disablePortal: true, sx: { zIndex: 2000 }, id: id, children: ({ TransitionProps }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_Grow__WEBPACK_IMPORTED_MODULE_2__["default"], { ...TransitionProps, style: { transformOrigin }, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_Paper__WEBPACK_IMPORTED_MODULE_3__["default"], { sx: { boxShadow: 3, padding: removePadding ? undefined : '16px' }, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_ClickAwayListener__WEBPACK_IMPORTED_MODULE_1__.ClickAwayListener, { onClickAway: handleClose, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { role: 'presentation', children: children }) }) }) })) }));
};


/***/ }),

/***/ "./app/components/redirect-wrapper/index.tsx":
/*!***************************************************!*\
  !*** ./app/components/redirect-wrapper/index.tsx ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react-router */ "./node_modules/react-router/dist/development/chunk-PVWAREVJ.mjs");
/* harmony import */ var _models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/models/page-history-slice.ts */ "./app/models/page-history-slice.ts");
/* harmony import */ var _utils_utils_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/utils/utils.tsx */ "./app/utils/utils.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/dist/react-redux.mjs");
/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */





const isNavigateState = (candidate) => {
    return !!(candidate &&
        typeof candidate === 'object' &&
        'queryParams' in candidate);
};
const RedirectWrapper = ({ children }) => {
    const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useDispatch)();
    const reduxNavigate = (0,react_redux__WEBPACK_IMPORTED_MODULE_4__.useSelector)(_models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_1__.getNavigate);
    const routerNavigate = (0,react_router__WEBPACK_IMPORTED_MODULE_0__.useNavigate)();
    const [localNavigate, setLocalNavigate] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(undefined);
    (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
        if (reduxNavigate) {
            dispatch((0,_models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_1__.clearNavigate)());
            setLocalNavigate({ ...reduxNavigate });
        }
    }, [dispatch, reduxNavigate]);
    (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
        const asyncEffect = async () => {
            if (localNavigate) {
                const search = isNavigateState(localNavigate)
                    ? (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_2__.getStringifiedParams)(localNavigate.queryParams)
                    : '';
                if (localNavigate.legacy) {
                    window.location.assign(`${localNavigate.pathname}${search}`);
                }
                else {
                    setLocalNavigate(undefined);
                    let navigatePath = localNavigate.pathname;
                    const pathPrefix = (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_2__.getUrlPathPrefix)();
                    if (navigatePath.startsWith(pathPrefix)) {
                        navigatePath = navigatePath.replace(pathPrefix, '');
                    }
                    if (navigatePath.startsWith('webapp/')) {
                        navigatePath = navigatePath.replace('webapp', '');
                    }
                    await routerNavigate({
                        pathname: navigatePath,
                        search
                    }, { state: { fromNavigation: true } });
                }
            }
        };
        // eslint-disable-next-line no-void
        void asyncEffect();
    }, [localNavigate, routerNavigate]);
    return children;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RedirectWrapper);


/***/ }),

/***/ "./app/components/section-header/help.tsx":
/*!************************************************!*\
  !*** ./app/components/section-header/help.tsx ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./style.css */ "./app/components/section-header/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);



const Help = ({ className, title, sections }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_2__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: className, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h3", { className: _style_css__WEBPACK_IMPORTED_MODULE_1__["default"]['help-title'], children: title }), sections.map((section) => {
                    const { title, items } = section;
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h4", { className: _style_css__WEBPACK_IMPORTED_MODULE_1__["default"]['help-section-title'], children: title }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("ul", { children: items.map((item, idx) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { children: item }, `${title}-${idx}`))) })] }, title));
                })] }) }));
};
Help.displayName = 'Help';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_2__.memo)(Help));


/***/ }),

/***/ "./app/components/section-header/index.tsx":
/*!*************************************************!*\
  !*** ./app/components/section-header/index.tsx ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/style.css */ "./app/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



const SectionHeader = ({ icon, title, children, className, ...rest }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_3__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(className, _style_css__WEBPACK_IMPORTED_MODULE_2__["default"]['card-title']), ...rest, children: [icon, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h3", { className: 'heading3', children: title }), children] }) }));
};
SectionHeader.displayName = 'SectionHeader';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_3__.memo)(SectionHeader));


/***/ }),

/***/ "./app/components/section-header/style.css":
/*!*************************************************!*\
  !*** ./app/components/section-header/style.css ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/section-header/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/section-menu/index.tsx":
/*!***********************************************!*\
  !*** ./app/components/section-menu/index.tsx ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/utils/dom_utils.tsx */ "./app/utils/dom_utils.tsx");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material */ "./node_modules/@mui/material/esm/MenuItem/MenuItem.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/material */ "./node_modules/@mui/material/esm/FormControl/FormControl.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/material */ "./node_modules/@mui/material/esm/InputLabel/InputLabel.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _mui_material_Select__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/material/Select */ "./node_modules/@mui/material/esm/Select/Select.js");





// A dropdown menu to navigate sections on a page.
// `sections`: an array with items containing `label` and `elementId` (IDs that correspond to the
// section elements on the page.)
// `pageHeaderElement`: the DOM element of the page header, used to calculate offsets when scrolling
// to a section and determining which section is currently scrolled into view.
const SectionMenu = ({ sections, pageHeaderElement }) => {
    const [currentSectionId, setCurrentSectionId] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(sections?.[0]?.title ?? 'Details');
    const [minWidth, setMinWidth] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(null);
    // On mount, set the width of the dropdown to the width of the longest item.
    const menuCallbackRef = (0,react__WEBPACK_IMPORTED_MODULE_5__.useCallback)((menuDiv) => {
        if (menuDiv !== null) {
            if (minWidth === null || minWidth !== menuDiv.clientWidth) {
                setMinWidth(menuDiv.clientWidth);
            }
        }
    }, [minWidth]);
    const determineCurrentSectionId = (0,react__WEBPACK_IMPORTED_MODULE_5__.useCallback)(() => {
        const sectionIds = sections.map((section, index) => {
            const indexString = index === 0 ? '' : ` ${index + 1}`;
            return section.title ?? `Details${indexString}`;
        });
        let currentId = sectionIds[0];
        // Find the first section whose top is scrolled into view
        for (const sectionId of sectionIds) {
            const sectionElement = document.getElementById(sectionId);
            if (sectionElement) {
                const sectionTop = sectionElement.getBoundingClientRect().top;
                const headerOffset = pageHeaderElement
                    ? pageHeaderElement.getBoundingClientRect().bottom
                    : 0;
                if (sectionTop >= headerOffset) {
                    currentId = sectionId;
                    break;
                }
            }
        }
        setCurrentSectionId(currentId);
    }, [sections, pageHeaderElement]);
    (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
        determineCurrentSectionId();
        const container = (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_1__.getFirstElementBySelector)('.content');
        if (container) {
            container.addEventListener('scroll', determineCurrentSectionId);
        }
        return () => {
            if (container) {
                container.removeEventListener('scroll', determineCurrentSectionId);
            }
        };
    }, [determineCurrentSectionId]);
    const scrollToSection = (0,react__WEBPACK_IMPORTED_MODULE_5__.useCallback)((event) => {
        const sectionId = event.target.value;
        const sectionElement = document.getElementById(sectionId);
        if (sectionElement) {
            const container = (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_1__.getFirstElementBySelector)('.content');
            if (!container) {
                return;
            }
            const containerTop = container.getBoundingClientRect().top;
            const containerScroll = container.scrollTop;
            const sectionPosition = sectionElement.getBoundingClientRect().top;
            const scrollPadding = 8;
            const pageHeaderHeight = pageHeaderElement?.parentElement?.offsetHeight ?? 0;
            (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_1__.animateScrollTo)(sectionPosition +
                containerScroll -
                containerTop -
                pageHeaderHeight -
                scrollPadding, container, 250);
        }
        setCurrentSectionId(sectionId);
    }, [pageHeaderElement, setCurrentSectionId]);
    const items = (0,react__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => {
        return sections.map((section, index) => {
            const indexString = index === 0 ? '' : ` ${index + 1}`;
            const headerTitle = section.title ?? `Details${indexString}`;
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material__WEBPACK_IMPORTED_MODULE_2__["default"], { value: headerTitle, children: headerTitle }, index));
        });
    }, [sections]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_3__["default"], { variant: 'standard', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material__WEBPACK_IMPORTED_MODULE_4__["default"], { id: 'section-navigation-label', children: "Go to section" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_Select__WEBPACK_IMPORTED_MODULE_6__["default"], { id: 'section-navigation', labelId: 'section-navigation-label', value: currentSectionId, onChange: scrollToSection, sx: {
                        backgroundColor: 'white',
                        ...(minWidth === null ? {} : { minWidth: minWidth + 14 })
                    }, MenuProps: {
                        keepMounted: true,
                        slotProps: { paper: { ref: menuCallbackRef } }
                    }, variant: 'standard', children: items })] }) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_5__.memo)(SectionMenu));


/***/ }),

/***/ "./app/components/sidebar/favorites/favorites-link-config.tsx":
/*!********************************************************************!*\
  !*** ./app/components/sidebar/favorites/favorites-link-config.tsx ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FavoritesLinkConfig: () => (/* binding */ FavoritesLinkConfig)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_icons_material_Close__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material/Close */ "./node_modules/@mui/icons-material/esm/Close.js");
/* harmony import */ var _selectable_link_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./selectable-link.tsx */ "./app/components/sidebar/favorites/selectable-link.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../style.css */ "./app/components/sidebar/style.css");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./style.css */ "./app/components/sidebar/favorites/style.css");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ~/style.css */ "./app/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _utils_links_tsx__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ~/utils/links.tsx */ "./app/utils/links.tsx");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */








const noResults = (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { id: 'no-search-results', children: "No results found" });
const FavoritesLinkConfig = ({ addFavorite, removeFavorite, links, favorites, id, className }) => {
    const [searchResults, setSearchResults] = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(null);
    const inputRef = (0,react__WEBPACK_IMPORTED_MODULE_7__.useRef)(null);
    const mappedCleanLinks = (0,react__WEBPACK_IMPORTED_MODULE_7__.useMemo)(() => links.map((link) => (0,_utils_links_tsx__WEBPACK_IMPORTED_MODULE_8__.toLinkObjectSearchResult)(link)), [links]);
    const handleToggleFavorite = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)((link) => {
        const isFavorite = !!favorites[link.id];
        const favoriteMethod = isFavorite ? removeFavorite : addFavorite;
        favoriteMethod(link.id);
    }, [addFavorite, favorites, removeFavorite]);
    const handleSearch = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)((event) => {
        const searchTerm = event.target.value;
        setSearchResults(searchTerm.length > 2 ? (0,_utils_links_tsx__WEBPACK_IMPORTED_MODULE_8__.searchAllLinks)(searchTerm, links) : null);
    }, [links]);
    const handleClearSearch = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)(() => {
        if (inputRef.current) {
            inputRef.current.value = '';
        }
        setSearchResults(null);
    }, []);
    const searchBar = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_4__["default"].search, _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['favorites-search']), children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { "aria-label": 'favorites menu search', "aria-controls": 'favorites-search-results', "aria-describedby": 'favorites-search-input-description', id: 'search-input', type: 'search', placeholder: 'Find Links', className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['favorites-search-input'], onChange: handleSearch, onFocus: handleSearch, ref: inputRef }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['screen-reader-only'], id: 'favorites-search-input-description', "aria-hidden": 'true', children: "You will be notified of results." }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_Close__WEBPACK_IMPORTED_MODULE_2__["default"], { name: 'close', style: { marginLeft: '4px', cursor: 'pointer' }, "aria-hidden": true, "data-testid": 'clear-search-button', onClick: handleClearSearch })] }));
    const renderSelectableLink = (link) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_selectable_link_tsx__WEBPACK_IMPORTED_MODULE_3__.SelectableLink, { onToggleFavorite: handleToggleFavorite, link: link, isFavorite: !!favorites[link.id] }, link.id));
    const content = searchResults
        ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { id: 'favorites-search-results', children: searchResults.length === 0
                ? noResults
                : searchResults
                    .filter((link) => link.label && link.label !== '')
                    .map(renderSelectableLink) }))
        : (mappedCleanLinks
            .filter((link) => link.label && link.label !== '')
            .map(renderSelectableLink));
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_7__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { id: id, className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['favorites-menu'], className), children: [searchBar, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['favorites-body'], children: content })] }) }));
};


/***/ }),

/***/ "./app/components/sidebar/favorites/selectable-link.tsx":
/*!**************************************************************!*\
  !*** ./app/components/sidebar/favorites/selectable-link.tsx ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectableLink: () => (/* binding */ SelectableLink),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.css */ "./app/components/sidebar/favorites/style.css");



const SelectableLink = ({ link, isFavorite = false, onToggleFavorite }) => {
    const { label, textLabel } = link;
    const metaLabel = textLabel;
    const inputId = `selectable-link-${metaLabel.replace(/\s/g, '')}`;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_1__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_2__["default"]['favorites-selectable-link'], children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { type: 'checkbox', name: 'favoriteLinks', id: inputId, checked: isFavorite, onKeyDown: (e) => {
                        const key = e.key;
                        if (key === 'Enter') {
                            onToggleFavorite(link);
                        }
                    }, onChange: () => onToggleFavorite(link), "aria-label": metaLabel }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("label", { htmlFor: inputId, "aria-hidden": true, children: label })] }) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SelectableLink);


/***/ }),

/***/ "./app/components/sidebar/favorites/style.css":
/*!****************************************************!*\
  !*** ./app/components/sidebar/favorites/style.css ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/sidebar/favorites/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/sidebar/jump-to/index.tsx":
/*!**************************************************!*\
  !*** ./app/components/sidebar/jump-to/index.tsx ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/utils/dom_utils.tsx */ "./app/utils/dom_utils.tsx");
/* harmony import */ var _components_icon_index_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/components/icon/index.tsx */ "./app/components/icon/index.tsx");
/* harmony import */ var _modal_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./modal.tsx */ "./app/components/sidebar/jump-to/modal.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../style.css */ "./app/components/sidebar/style.css");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./style.css */ "./app/components/sidebar/jump-to/style.css");
/* harmony import */ var _components_tooltip_index_tsx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ~/components/tooltip/index.tsx */ "./app/components/tooltip/index.tsx");
/* harmony import */ var react_hotkeys_hook__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react-hotkeys-hook */ "./node_modules/react-hotkeys-hook/packages/react-hotkeys-hook/dist/index.js");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ~/style.css */ "./app/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_10__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */










const getKeyboardShortcut = () => {
    let modifierKeyLabel = (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_2__.getModifierKeyLabel)();
    if (modifierKeyLabel === 'ctrl') {
        modifierKeyLabel = 'Ctrl+';
    }
    return modifierKeyLabel + 'K';
};
const keyboardShortcut = getKeyboardShortcut();
const JumpTo = ({ buttonRef, extraLinks, links, sidebarOut }) => {
    const [modalOpen, setModalOpen] = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)(false);
    const modalContainer = (0,react__WEBPACK_IMPORTED_MODULE_10__.useRef)(null);
    (0,react_hotkeys_hook__WEBPACK_IMPORTED_MODULE_8__.useHotkeys)('mod+k', (e) => {
        e.preventDefault();
        setModalOpen(true);
    });
    const closeModal = (0,react__WEBPACK_IMPORTED_MODULE_10__.useCallback)(() => {
        setModalOpen(false);
    }, []);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_10__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['jump-to-container'], children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_tooltip_index_tsx__WEBPACK_IMPORTED_MODULE_7__["default"], { title: 'Jump To', placement: 'right', disabled: sidebarOut, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("button", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['jump-to-button'], onClick: () => setModalOpen(true), onKeyDown: () => setModalOpen(true), "aria-label": 'Jump To', ref: buttonRef, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['jump-to-label'], children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_icon_index_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], { name: 'rabbit-running' }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['jump-to-label-text'], _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['list-item-text']), children: ["Jump to...", (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { children: keyboardShortcut })] })] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: _style_css__WEBPACK_IMPORTED_MODULE_9__["default"]['screen-reader-only'], id: 'sidebar-search-input-description', "aria-hidden": 'true', children: "You will be notified of results." })] }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_modal_tsx__WEBPACK_IMPORTED_MODULE_4__["default"], { keyboardShortcut: keyboardShortcut, isOpen: modalOpen, handleClose: closeModal, links: links, extraLinks: extraLinks, modalRef: modalContainer })] }) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JumpTo);


/***/ }),

/***/ "./app/components/sidebar/jump-to/modal.tsx":
/*!**************************************************!*\
  !*** ./app/components/sidebar/jump-to/modal.tsx ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _components_sidebar_jump_to_results_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/components/sidebar/jump-to/results.tsx */ "./app/components/sidebar/jump-to/results.tsx");
/* harmony import */ var _components_modal_index_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/modal/index.tsx */ "./app/components/modal/index.tsx");
/* harmony import */ var nanoid__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! nanoid */ "./node_modules/nanoid/index.browser.js");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/sidebar/jump-to/style.css");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/style.css */ "./app/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ~/utils/dom_utils.tsx */ "./app/utils/dom_utils.tsx");
/* harmony import */ var _utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ~/utils/keyboard.ts */ "./app/utils/keyboard.ts");
/* harmony import */ var _utils_links_tsx__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ~/utils/links.tsx */ "./app/utils/links.tsx");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */









const emphasizeMatch = (match, index) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"].underlined, children: match }, index));
const JumpToModal = ({ extraLinks, links, isOpen, keyboardShortcut, handleClose, modalRef }) => {
    const [searchResults, setSearchResults] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)([]);
    const [activeResultId, setActiveResultId] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(null);
    const inputElementRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(null);
    const linksToSearch = (0,react__WEBPACK_IMPORTED_MODULE_6__.useMemo)(() => [...(links ?? []), ...(extraLinks ?? [])], [extraLinks, links]);
    const handleSearchTermChange = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((e) => {
        if (e.target.value.length === 0) {
            setSearchResults([]);
            return;
        }
        const results = (0,_utils_links_tsx__WEBPACK_IMPORTED_MODULE_9__.searchAllLinks)(e.target.value, linksToSearch, emphasizeMatch);
        setSearchResults(results);
    }, [linksToSearch]);
    const handleFocusOnInput = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
        if (inputElementRef.current) {
            inputElementRef.current.focus();
        }
    }, []);
    const handleInputKeyDown = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)((e) => {
        // Hacky fix to get this working on short timeline
        if (activeResultId) {
            const domLink = document.getElementById(activeResultId);
            if ((0,_utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_8__.isKeyPressed)(e, _utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_8__.KeyCodesByText.ARROW_DOWN)) {
                // Focus down to the results menu
                e.preventDefault();
                const nextResult = (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_7__.getNextSiblingOfType)(domLink, 'a');
                if (nextResult) {
                    nextResult.focus();
                }
            }
            else if ((0,_utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_8__.isKeyPressed)(e, _utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_8__.KeyCodesByText.ENTER) && domLink) {
                // Trigger the active result in the menu
                e.preventDefault();
                const openInNewTab = e.ctrlKey || e.metaKey;
                (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_7__.clickLink)(domLink, openInNewTab);
            }
        }
    }, [activeResultId]);
    const inputAriaLabel = 'Jump to a page. Begin typing to search. Use up and down arrows to navigate results, return to select a result, and escape to close the dialog. You can open this dialog from anywhere by typing ' +
        keyboardShortcut;
    // Randomly generate an ID to discourage browser autocomplete
    const inputId = (0,nanoid__WEBPACK_IMPORTED_MODULE_3__.nanoid)();
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_modal_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['modal-container'], isOpen: isOpen, onRequestClose: handleClose, onAfterOpen: handleFocusOnInput, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { ref: modalRef, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['modal-content'], children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['modal-input'], placeholder: 'Jump to...', onChange: handleSearchTermChange, onKeyDown: handleInputKeyDown, "aria-label": inputAriaLabel, "aria-controls": 'sidebar-search-results', "aria-describedby": 'sidebar-search-input-description', "data-testid": 'jump-to-input', type: 'search', ref: inputElementRef, autoComplete: 'off', id: inputId, name: inputId }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['screen-reader-only'], id: 'sidebar-search-input-description', "aria-hidden": 'true', children: "You will be notified of results." }), inputElementRef.current &&
                                inputElementRef.current.value.length > 0 && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_sidebar_jump_to_results_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { setSelectedLink: setActiveResultId, onFocusOnInput: handleFocusOnInput, results: searchResults, searchTerm: inputElementRef.current.value, handleCloseModal: handleClose }))] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['modal-hint-container'], children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { "aria-hidden": true, className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['modal-hint'], children: ["Open this from anywhere by typing ", keyboardShortcut] }) })] }) }) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JumpToModal);


/***/ }),

/***/ "./app/components/sidebar/jump-to/results-controls-bar.tsx":
/*!*****************************************************************!*\
  !*** ./app/components/sidebar/jump-to/results-controls-bar.tsx ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/utils/dom_utils.tsx */ "./app/utils/dom_utils.tsx");
/* harmony import */ var _utils_utils_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/utils/utils.tsx */ "./app/utils/utils.tsx");
/* harmony import */ var react_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react-svg */ "./node_modules/react-svg/dist/react-svg.esm.js");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./style.css */ "./app/components/sidebar/jump-to/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */






const ResultsControlsBar = () => {
    const basePath = (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_3__.getUrlPathPrefix)();
    const upKey = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['results-control-key'], _style_css__WEBPACK_IMPORTED_MODULE_5__["default"].arrow), children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_svg__WEBPACK_IMPORTED_MODULE_4__.ReactSVG, { src: `${basePath}static/images/keyboard-arrow-up.svg` }) }));
    const downKey = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['results-control-key'], _style_css__WEBPACK_IMPORTED_MODULE_5__["default"].arrow), children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_svg__WEBPACK_IMPORTED_MODULE_4__.ReactSVG, { src: `${basePath}static/images/keyboard-arrow-down.svg` }) }));
    const enterKey = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['results-control-key'], _style_css__WEBPACK_IMPORTED_MODULE_5__["default"].enter), children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_svg__WEBPACK_IMPORTED_MODULE_4__.ReactSVG, { src: `${basePath}static/images/keyboard-arrow-return.svg` }) }));
    const escKey = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['results-control-key'], _style_css__WEBPACK_IMPORTED_MODULE_5__["default"].esc), children: "esc" }));
    let modKeyStyle;
    let modKeyLabel = (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_2__.getModifierKeyLabel)();
    if (modKeyLabel === 'ctrl') {
        modKeyStyle = _style_css__WEBPACK_IMPORTED_MODULE_5__["default"].control;
    }
    else {
        modKeyStyle = _style_css__WEBPACK_IMPORTED_MODULE_5__["default"].command;
        modKeyLabel = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_svg__WEBPACK_IMPORTED_MODULE_4__.ReactSVG, { src: `${basePath}static/images/keyboard-mac-command.svg` }));
    }
    const modKey = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['results-control-key'], modKeyStyle), children: modKeyLabel }));
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_6__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { "aria-hidden": true, className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['results-controls-bar'], children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['results-control'], children: [upKey, downKey, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['results-control-caption'], children: "to navigate" })] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['results-control'], children: [enterKey, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['results-control-caption'], children: "to select" })] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['results-control'], children: [modKey, enterKey, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['results-control-caption'], children: "to open in a new tab" })] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['results-control'], children: [escKey, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['results-control-caption'], children: "to dismiss" })] })] }) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ResultsControlsBar);


/***/ }),

/***/ "./app/components/sidebar/jump-to/results.tsx":
/*!****************************************************!*\
  !*** ./app/components/sidebar/jump-to/results.tsx ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/models/page-history-slice.ts */ "./app/models/page-history-slice.ts");
/* harmony import */ var _results_controls_bar_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./results-controls-bar.tsx */ "./app/components/sidebar/jump-to/results-controls-bar.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/sidebar/jump-to/style.css");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/dist/react-redux.mjs");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ~/style.css */ "./app/style.css");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ~/utils/dom_utils.tsx */ "./app/utils/dom_utils.tsx");
/* harmony import */ var _utils_utils_tsx__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ~/utils/utils.tsx */ "./app/utils/utils.tsx");
/* harmony import */ var _utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ~/utils/keyboard.ts */ "./app/utils/keyboard.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_11__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */











const RESULTS_LIMIT = 20;
const JumpToResults = ({ setSelectedLink, onFocusOnInput, results, searchTerm, handleCloseModal }) => {
    const [activeIndex, setActiveIndex] = (0,react__WEBPACK_IMPORTED_MODULE_11__.useState)(0);
    const resultsContainer = (0,react__WEBPACK_IMPORTED_MODULE_11__.useRef)(null);
    const ignoreMouse = (0,react__WEBPACK_IMPORTED_MODULE_11__.useRef)(false);
    const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_5__.useDispatch)();
    const tempIgnoreMouse = (0,react__WEBPACK_IMPORTED_MODULE_11__.useCallback)((duration) => {
        ignoreMouse.current = true;
        setTimeout(() => {
            ignoreMouse.current = false;
        }, duration);
    }, []);
    (0,react__WEBPACK_IMPORTED_MODULE_11__.useEffect)(() => {
        tempIgnoreMouse(200);
    }, [tempIgnoreMouse]);
    const resetActiveIndex = (0,react__WEBPACK_IMPORTED_MODULE_11__.useCallback)(() => {
        setActiveIndex(0);
        if (!(0,lodash__WEBPACK_IMPORTED_MODULE_7__.isEmpty)(results)) {
            setSelectedLink(`${(0,lodash__WEBPACK_IMPORTED_MODULE_7__.camelCase)(results[0].textLabel)}JumpToLink`);
        }
    }, [results, setSelectedLink]);
    (0,react__WEBPACK_IMPORTED_MODULE_11__.useEffect)(() => {
        resetActiveIndex();
        if (resultsContainer.current) {
            resultsContainer.current.scrollTop = 0;
        }
        tempIgnoreMouse(200);
    }, [resetActiveIndex, searchTerm, tempIgnoreMouse]);
    const handleResultFocused = (0,react__WEBPACK_IMPORTED_MODULE_11__.useCallback)((index) => {
        setActiveIndex(index);
        if (!(0,lodash__WEBPACK_IMPORTED_MODULE_7__.isEmpty)(results)) {
            setSelectedLink(`${(0,lodash__WEBPACK_IMPORTED_MODULE_7__.camelCase)(results[index].textLabel)}JumpToLink`);
        }
        tempIgnoreMouse(1000);
    }, [results, setSelectedLink, tempIgnoreMouse]);
    const handleResultBlurred = (0,react__WEBPACK_IMPORTED_MODULE_11__.useCallback)(() => {
        setActiveIndex(0);
        if (!(0,lodash__WEBPACK_IMPORTED_MODULE_7__.isEmpty)(results)) {
            setSelectedLink(`${(0,lodash__WEBPACK_IMPORTED_MODULE_7__.camelCase)(results[0].textLabel)}JumpToLink`);
        }
    }, [results, setSelectedLink]);
    const handleResultHovered = (0,react__WEBPACK_IMPORTED_MODULE_11__.useCallback)((index) => {
        if (!ignoreMouse.current) {
            setActiveIndex(index);
            if (!(0,lodash__WEBPACK_IMPORTED_MODULE_7__.isEmpty)(results)) {
                setSelectedLink(`${(0,lodash__WEBPACK_IMPORTED_MODULE_7__.camelCase)(results[index].textLabel)}JumpToLink`);
            }
        }
    }, [results, setSelectedLink]);
    const handleResultUnhovered = (0,react__WEBPACK_IMPORTED_MODULE_11__.useCallback)(() => {
        if (!ignoreMouse.current) {
            setActiveIndex(0);
            if (!(0,lodash__WEBPACK_IMPORTED_MODULE_7__.isEmpty)(results)) {
                setSelectedLink(`${(0,lodash__WEBPACK_IMPORTED_MODULE_7__.camelCase)(results[0].textLabel)}JumpToLink`);
            }
        }
    }, [results, setSelectedLink]);
    const handleResultClick = (0,react__WEBPACK_IMPORTED_MODULE_11__.useCallback)((e) => {
        dispatch((0,_models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_2__.clearAll)());
        document.dispatchEvent(new Event('JumpTo'));
        (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_9__.handleLinkClick)(handleCloseModal, e);
    }, [dispatch, handleCloseModal]);
    const handleResultKeyDown = (0,react__WEBPACK_IMPORTED_MODULE_11__.useCallback)((e) => {
        const upPressed = (0,_utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_10__.isKeyPressed)(e, _utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_10__.KeyCodesByText.ARROW_UP);
        const downPressed = (0,_utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_10__.isKeyPressed)(e, _utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_10__.KeyCodesByText.ARROW_DOWN);
        if (upPressed || downPressed) {
            e.preventDefault();
            let focusLink = null;
            if (upPressed) {
                focusLink = (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_8__.getPreviousSiblingOfType)(e.currentTarget, 'a');
                const previousLink = (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_8__.getPreviousSiblingOfType)(focusLink, 'a');
                if (!previousLink) {
                    focusLink = null;
                    onFocusOnInput();
                }
            }
            else if (downPressed) {
                focusLink = (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_8__.getNextSiblingOfType)(e.currentTarget, 'a');
            }
            if (focusLink) {
                focusLink.focus();
            }
        }
        else if ((0,_utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_10__.isKeyPressed)(e, _utils_keyboard_ts__WEBPACK_IMPORTED_MODULE_10__.KeyCodesByText.ENTER)) {
            e.preventDefault();
            const openInNewTab = e.ctrlKey || e.metaKey;
            dispatch((0,_models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_2__.clearAll)());
            document.dispatchEvent(new Event('JumpTo'));
            (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_8__.clickLink)(e.currentTarget, openInNewTab);
        }
    }, [dispatch, onFocusOnInput]);
    const renderAriaSearchResultsText = () => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { role: 'alert', id: 'aria-search-results-text', className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['screen-reader-only'], children: `There are ${results.length} search results for ${searchTerm}.` }));
    const renderLink = (0,react__WEBPACK_IMPORTED_MODULE_11__.useCallback)((link, index) => {
        const isActive = index === activeIndex;
        const linkContent = [
            (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"].title, children: link.label }, `${link.textLabel}-title`)
        ];
        const linkProps = {
            key: link.id ?? index,
            className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['results-link'], {
                [_style_css__WEBPACK_IMPORTED_MODULE_4__["default"].active]: isActive
            }),
            'data-testid': `${(0,lodash__WEBPACK_IMPORTED_MODULE_7__.camelCase)(link.textLabel)}JumpToLink`,
            id: `${(0,lodash__WEBPACK_IMPORTED_MODULE_7__.camelCase)(link.textLabel)}JumpToLink`,
            onClick: handleResultClick,
            onKeyDown: handleResultKeyDown,
            onMouseOver: () => handleResultHovered(index),
            onMouseOut: handleResultUnhovered,
            onFocus: () => handleResultFocused(index),
            onBlur: handleResultBlurred,
            'aria-label': link.textLabel
        };
        return (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_9__.renderFinLink)({ ...link, label: link.textLabel }, linkContent, linkProps);
    }, [
        activeIndex,
        handleResultBlurred,
        handleResultClick,
        handleResultFocused,
        handleResultHovered,
        handleResultKeyDown,
        handleResultUnhovered
    ]);
    const buildResultsContent = (0,react__WEBPACK_IMPORTED_MODULE_11__.useCallback)(() => {
        return !(0,lodash__WEBPACK_IMPORTED_MODULE_7__.isEmpty)(results)
            ? results.slice(0, RESULTS_LIMIT).map(renderLink)
            : [];
    }, [renderLink, results]);
    const resultsContent = buildResultsContent();
    const hasResults = !(0,lodash__WEBPACK_IMPORTED_MODULE_7__.isEmpty)(resultsContent);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_11__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [renderAriaSearchResultsText(), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ref: resultsContainer, className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['results-container'], children: hasResults
                        ? (resultsContent)
                        : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['results-link'], children: "No results found" }, 'no-search-results')) }), hasResults && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_results_controls_bar_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], {})] }) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JumpToResults);


/***/ }),

/***/ "./app/components/sidebar/jump-to/style.css":
/*!**************************************************!*\
  !*** ./app/components/sidebar/jump-to/style.css ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/sidebar/jump-to/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/sidebar/kuali.png":
/*!******************************************!*\
  !*** ./app/components/sidebar/kuali.png ***!
  \******************************************/
/***/ ((module) => {

"use strict";
module.exports = "data:image/png;base64,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";

/***/ }),

/***/ "./app/components/sidebar/sidebar-branding.tsx":
/*!*****************************************************!*\
  !*** ./app/components/sidebar/sidebar-branding.tsx ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarBranding: () => (/* binding */ SidebarBranding)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/models/page-history-slice.ts */ "./app/models/page-history-slice.ts");
/* harmony import */ var _kuali_png__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./kuali.png */ "./app/components/sidebar/kuali.png");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./style.css */ "./app/components/sidebar/style.css");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/dist/react-redux.mjs");
/* harmony import */ var _utils_constants_ts__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ~/utils/constants.ts */ "./app/utils/constants.ts");
/* harmony import */ var _utils_utils_tsx__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ~/utils/utils.tsx */ "./app/utils/utils.tsx");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */








const SidebarBranding = ({ logoUrl }) => {
    const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_6__.useDispatch)();
    let logoImg = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['kuali-logo'], src: _kuali_png__WEBPACK_IMPORTED_MODULE_2__, alt: 'kuali', height: '24', "data-testid": 'kuali-logo' }, 'logoImg'));
    // Custom branding
    if (logoUrl) {
        let logoSrc = logoUrl;
        if (!logoUrl.startsWith('data:') && !(0,lodash__WEBPACK_IMPORTED_MODULE_3__.startsWith)(logoUrl, 'http')) {
            logoSrc = (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_8__.getUrlPathPrefix)() + logoUrl;
        }
        logoImg = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", { src: logoSrc, alt: 'financials', height: '56', width: '56' }, 'logoImg'));
    }
    const linkContent = [
        logoImg,
        (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"].title, children: [!logoUrl ? 'Kuali ' : '', "Financials"] }, 'logoText')
    ];
    const linkProps = {
        'data-testid': 'logo-home-link',
        className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['home-link'],
        onClick: () => dispatch((0,_models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_1__.clearAll)())
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_4__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['sidebar-branding'], children: (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_8__.renderLink)((0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_8__.inWebapp)(), _utils_constants_ts__WEBPACK_IMPORTED_MODULE_7__.WEBAPP.ENTRY_POINT + _utils_constants_ts__WEBPACK_IMPORTED_MODULE_7__.WEBAPP.HOMEPAGE, linkContent, linkProps) }) }));
};


/***/ }),

/***/ "./app/components/sidebar/sidebar-error.tsx":
/*!**************************************************!*\
  !*** ./app/components/sidebar/sidebar-error.tsx ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarError: () => (/* binding */ SidebarError)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.css */ "./app/components/sidebar/style.css");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


const SidebarError = () => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_1__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { id: 'sidebar-scroll', className: _style_css__WEBPACK_IMPORTED_MODULE_2__["default"].sidebarScroll, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_2__["default"].error, children: "There was an error loading the menu. Please refresh this page." }) }) }));
};


/***/ }),

/***/ "./app/components/sidebar/sidebar-footer.tsx":
/*!***************************************************!*\
  !*** ./app/components/sidebar/sidebar-footer.tsx ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarFooter: () => (/* binding */ SidebarFooter)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _components_header_about_modal_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/components/header/about-modal.tsx */ "./app/components/header/about-modal.tsx");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _kuali_png__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./kuali.png */ "./app/components/sidebar/kuali.png");
/* harmony import */ var _sidebar_list_item_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./sidebar-list-item.tsx */ "./app/components/sidebar/sidebar-list-item.tsx");
/* harmony import */ var _sidebar_user_menu_tsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./sidebar-user-menu.tsx */ "./app/components/sidebar/sidebar-user-menu.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./style.css */ "./app/components/sidebar/style.css");
/* harmony import */ var _components_tooltip_index_tsx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ~/components/tooltip/index.tsx */ "./app/components/tooltip/index.tsx");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */









const SidebarFooter = ({ onNavigationRefresh, settings, toggleSidebar, sidebarOut, user }) => {
    const [aboutModalOpen, setAboutModalOpen] = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)(false);
    const toggleAboutModal = (0,react__WEBPACK_IMPORTED_MODULE_9__.useCallback)((aboutModalOpen, event) => {
        event.preventDefault();
        setAboutModalOpen(aboutModalOpen);
    }, []);
    const versions = settings.versions;
    const help = settings.help;
    const signoutUrl = settings.signoutUrl;
    const showExpandTooltip = !sidebarOut;
    const expandCollapseButton = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("button", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['sidebar-control-item-label'], "data-testid": 'menu-toggle', onClick: toggleSidebar, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_sidebar_list_item_tsx__WEBPACK_IMPORTED_MODULE_4__.SidebarListItem, { icon: sidebarOut ? 'move-left-1' : 'move-right', label: `${sidebarOut ? 'Collapse' : 'Expand'} Navigation`, sidebarOut: sidebarOut }) }));
    const hasCustomBranding = settings && !!settings.logoUrl;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_9__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_2___default()(_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].nav, _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-group'], _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['sidebar-footer']), children: [user && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_sidebar_user_menu_tsx__WEBPACK_IMPORTED_MODULE_5__.SidebarUserMenu, { handleNavigationRefresh: onNavigationRefresh, signoutUrl: signoutUrl, user: user, sidebarOut: sidebarOut })), help && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { "data-testid": 'preferences-help', className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item'], children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item-link'], href: help, target: '_blank', rel: 'noreferrer', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_sidebar_list_item_tsx__WEBPACK_IMPORTED_MODULE_4__.SidebarListItem, { icon: 'question-help-message', label: 'Help', tooltipLabel: 'Help', sidebarOut: sidebarOut }) }) })), !(0,lodash__WEBPACK_IMPORTED_MODULE_8__.isEmpty)(versions) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item'], children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { "data-testid": 'preferences-about', className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item-link'], href: '', role: 'link', onClick: (0,lodash__WEBPACK_IMPORTED_MODULE_8__.partial)(toggleAboutModal, true), children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_sidebar_list_item_tsx__WEBPACK_IMPORTED_MODULE_4__.SidebarListItem, { icon: 'information-circle', label: 'About', tooltipLabel: 'About', sidebarOut: sidebarOut }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_header_about_modal_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { versions: versions, isOpen: aboutModalOpen, onRequestClose: () => setAboutModalOpen(false) })] })), hasCustomBranding && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item'], children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { "data-testid": 'made-by-kuali', className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item-link'], children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_sidebar_list_item_tsx__WEBPACK_IMPORTED_MODULE_4__.SidebarListItem, { icon: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", { alt: 'Kuali Logo', src: _kuali_png__WEBPACK_IMPORTED_MODULE_3__, height: '16' }), label: 'Made by Kuali', tooltipLabel: 'Made by Kuali', sidebarOut: sidebarOut }) }) })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['sidebar-control-item'], children: showExpandTooltip
                        ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_tooltip_index_tsx__WEBPACK_IMPORTED_MODULE_7__["default"], { placement: 'right', title: `${sidebarOut ? 'Collapse' : 'Expand'} Navigation`, disabled: sidebarOut, children: expandCollapseButton }))
                        : (expandCollapseButton) })] }) }));
};


/***/ }),

/***/ "./app/components/sidebar/sidebar-header.tsx":
/*!***************************************************!*\
  !*** ./app/components/sidebar/sidebar-header.tsx ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarHeader: () => (/* binding */ SidebarHeader)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/models/page-history-slice.ts */ "./app/models/page-history-slice.ts");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _jump_to_index_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./jump-to/index.tsx */ "./app/components/sidebar/jump-to/index.tsx");
/* harmony import */ var _sidebar_list_item_tsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./sidebar-list-item.tsx */ "./app/components/sidebar/sidebar-list-item.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./style.css */ "./app/components/sidebar/style.css");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/dist/react-redux.mjs");
/* harmony import */ var _utils_constants_ts__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ~/utils/constants.ts */ "./app/utils/constants.ts");
/* harmony import */ var _utils_utils_tsx__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ~/utils/utils.tsx */ "./app/utils/utils.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_10__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */










const SidebarHeader = ({ activeDashboardId, preferences, sidebarOut, backdoorId }) => {
    const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_7__.useDispatch)();
    const jumpToButton = (0,react__WEBPACK_IMPORTED_MODULE_10__.useRef)(null);
    const listItemContent = (0,react__WEBPACK_IMPORTED_MODULE_10__.useCallback)((label, icon) => {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_sidebar_list_item_tsx__WEBPACK_IMPORTED_MODULE_5__.SidebarListItem, { icon: icon, label: label, tooltipLabel: label, sidebarOut: sidebarOut }));
    }, [sidebarOut]);
    const homePageLinkItem = (0,react__WEBPACK_IMPORTED_MODULE_10__.useMemo)(() => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item'], {
            [_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].active]: activeDashboardId === 'home'
        }), "aria-label": 'Sidebar Home', children: (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_9__.renderFinLink)({
            value: _utils_constants_ts__WEBPACK_IMPORTED_MODULE_8__.WEBAPP.ENTRY_POINT + _utils_constants_ts__WEBPACK_IMPORTED_MODULE_8__.WEBAPP.HOMEPAGE,
            type: 'kfs',
            label: 'Home',
            id: 'sidebarHome'
        }, listItemContent('Home', 'house-chimney-1'), {
            id: 'sidebarHome',
            className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item-link'],
            'data-testid': 'sidebar-home-link',
            onClick: () => dispatch((0,_models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_2__.clearAll)())
        }) })), [activeDashboardId, dispatch, listItemContent]);
    const actionListListItem = (0,react__WEBPACK_IMPORTED_MODULE_10__.useMemo)(() => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item'], {
            [_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].active]: activeDashboardId === 'ActionList.do'
        }), "aria-label": 'Sidebar Action List', children: (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_9__.renderLink)(false, (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_9__.buildActionUrl)(backdoorId ?? null, preferences.settings.actionListUrl), listItemContent('Action List', 'task-checklist-check'), {
            id: 'sidebarActionList',
            className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item-link'],
            'data-testid': 'sidebar-action-list-link',
            onClick: () => dispatch((0,_models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_2__.clearAll)())
        }) })), [
        activeDashboardId,
        backdoorId,
        dispatch,
        listItemContent,
        preferences.settings.actionListUrl
    ]);
    const docSearchListItem = (0,react__WEBPACK_IMPORTED_MODULE_10__.useMemo)(() => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item'], {
            [_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].active]: activeDashboardId === 'DocumentSearch.do'
        }), "aria-label": 'Sidebar Doc Search', children: (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_9__.renderLink)(false, (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_9__.buildActionUrl)(backdoorId ?? null, preferences.settings.docSearchUrl), listItemContent('Doc Search', 'search-alternate'), {
            id: 'sidebarDocSearch',
            className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item-link'],
            'data-testid': 'sidebar-doc-search-link',
            onClick: () => dispatch((0,_models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_2__.clearAll)())
        }) })), [
        activeDashboardId,
        backdoorId,
        dispatch,
        listItemContent,
        preferences.settings.docSearchUrl
    ]);
    const reportsListItem = (0,react__WEBPACK_IMPORTED_MODULE_10__.useMemo)(() => {
        const reports = preferences.settings.reportsUrl;
        if (!reports) {
            return null;
        }
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item'], {
                [_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].active]: activeDashboardId === 'reports'
            }), "aria-label": 'Sidebar Reports', children: (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_9__.renderFinLink)({
                value: `${_utils_constants_ts__WEBPACK_IMPORTED_MODULE_8__.WEBAPP.ENTRY_POINT}${_utils_constants_ts__WEBPACK_IMPORTED_MODULE_8__.WEBAPP.REPORTS}`,
                type: 'kfs',
                label: 'Reports',
                id: 'reports'
            }, listItemContent('Reports', 'reports'), {
                id: 'reports',
                className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item-link'],
                'data-testid': 'sidebar-reports-link',
                onClick: () => dispatch((0,_models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_2__.clearAll)())
            }) }));
    }, [
        activeDashboardId,
        dispatch,
        listItemContent,
        preferences.settings.reportsUrl
    ]);
    const externalLinks = (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_9__.buildExternalLinks)(backdoorId ?? null, preferences.settings);
    const dashboardLinks = (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_9__.buildDashboardLinks)(preferences ? preferences.dashboards : []);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_10__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("ul", { id: 'filters', className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].nav, _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-group']), children: [homePageLinkItem, actionListListItem, docSearchListItem, reportsListItem, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_jump_to_index_tsx__WEBPACK_IMPORTED_MODULE_4__["default"], { links: preferences ? preferences.links : [], extraLinks: (0,lodash__WEBPACK_IMPORTED_MODULE_3__.concat)(externalLinks, dashboardLinks), sidebarOut: sidebarOut, buttonRef: jumpToButton })] }) }));
};


/***/ }),

/***/ "./app/components/sidebar/sidebar-links.tsx":
/*!**************************************************!*\
  !*** ./app/components/sidebar/sidebar-links.tsx ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LINK_HEIGHT: () => (/* binding */ LINK_HEIGHT),
/* harmony export */   SidebarLinks: () => (/* binding */ SidebarLinks)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_popper_index_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/popper/index.tsx */ "./app/components/popper/index.tsx");
/* harmony import */ var _sidebar_list_item_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sidebar-list-item.tsx */ "./app/components/sidebar/sidebar-list-item.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/sidebar/style.css");
/* harmony import */ var _utils_utils_tsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/utils/utils.tsx */ "./app/utils/utils.tsx");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */







const LINK_HEIGHT = 40;
const shouldShowDashboard = (dashboard) => !dashboard.hidden && (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_5__.isDashboardNonEmpty)(dashboard);
const SidebarLinks = ({ activeDashboardId, dashboards = [], containerHeight, sidebarOut }) => {
    const [anchorEl, setAnchorEl] = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(null);
    const handleOpenPopover = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)((event) => {
        if (anchorEl) {
            setAnchorEl(null);
            return;
        }
        setAnchorEl(event.currentTarget);
    }, [anchorEl]);
    const handleClosePopover = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)(() => {
        setAnchorEl(null);
    }, []);
    const renderSidebarLink = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)((inPopup, dashboard) => {
        const menuId = `dashboard-${dashboard.id}-menu`;
        const listItemProps = inPopup
            ? {
                alwaysShowText: true
            }
            : {
                tooltipLabel: dashboard.label
            };
        const linkContent = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_sidebar_list_item_tsx__WEBPACK_IMPORTED_MODULE_3__.SidebarListItem, { label: dashboard.label, icon: dashboard.iconName || 'rating-star-circle', sidebarOut: sidebarOut, ...listItemProps }));
        const linkProps = {
            className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['list-item-link'],
            'data-testid': `${menuId}-link`,
            onClick: handleClosePopover
        };
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['list-item'], {
                [_style_css__WEBPACK_IMPORTED_MODULE_4__["default"].active]: activeDashboardId === dashboard.id
            }), children: (0,_utils_utils_tsx__WEBPACK_IMPORTED_MODULE_5__.renderFinLink)({
                value: `webapp/dashboard/${dashboard.id}`,
                type: 'kfs',
                label: dashboard.label,
                id: dashboard.id
            }, linkContent, linkProps) }, menuId));
    }, [activeDashboardId, handleClosePopover, sidebarOut]);
    let numberOfVisibleLinks = Math.max(Math.floor(containerHeight / LINK_HEIGHT), 1);
    const nonEmptySortedDashboards = (0,react__WEBPACK_IMPORTED_MODULE_7__.useMemo)(() => (0,lodash__WEBPACK_IMPORTED_MODULE_6__.sortBy)(dashboards.filter(shouldShowDashboard), (dashboard) => dashboard.label.toLowerCase()), [dashboards]);
    let sidebarLinks = nonEmptySortedDashboards;
    let hiddenLinks = [];
    if (!(0,lodash__WEBPACK_IMPORTED_MODULE_6__.isEmpty)(nonEmptySortedDashboards) &&
        nonEmptySortedDashboards.length > numberOfVisibleLinks) {
        // Subtract one for the "hidden" item
        numberOfVisibleLinks--;
        sidebarLinks = nonEmptySortedDashboards.slice(0, numberOfVisibleLinks);
        hiddenLinks = nonEmptySortedDashboards.slice(numberOfVisibleLinks);
    }
    const open = Boolean(anchorEl);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_7__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("ul", { id: 'linkgroups', className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_4__["default"].nav, _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['list-group']), children: [sidebarLinks.map((0,lodash__WEBPACK_IMPORTED_MODULE_6__.partial)(renderSidebarLink, false)), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['list-item'], {
                        [_style_css__WEBPACK_IMPORTED_MODULE_4__["default"].hidden]: (0,lodash__WEBPACK_IMPORTED_MODULE_6__.isEmpty)(hiddenLinks)
                    }), children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("button", { "data-testid": 'more-items-menu-button', onClick: handleOpenPopover, className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['list-item-link'], _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['more-items-button']), children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_sidebar_list_item_tsx__WEBPACK_IMPORTED_MODULE_3__.SidebarListItem, { label: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['more-items-label'], children: ["More Items", (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['caret-right'] })] }), icon: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { "data-testid": 'more-items-icon', className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['fake-icon'], children: ["+", hiddenLinks.length] }), tooltipLabel: open ? undefined : 'More Items' }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_popper_index_tsx__WEBPACK_IMPORTED_MODULE_2__.Popper, { id: 'more-sidebar-items', open: open, handleHide: handleClosePopover, anchorElement: anchorEl, placement: 'right-end', transformOrigin: 'bottom left', removePadding: true, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { style: { backgroundColor: 'var(--kuali-dark-gray-300)' }, children: hiddenLinks.map((0,lodash__WEBPACK_IMPORTED_MODULE_6__.partial)(renderSidebarLink, true)) }) })] })] }) }));
};


/***/ }),

/***/ "./app/components/sidebar/sidebar-list-item.tsx":
/*!******************************************************!*\
  !*** ./app/components/sidebar/sidebar-list-item.tsx ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarListItem: () => (/* binding */ SidebarListItem)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_icon_index_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/components/icon/index.tsx */ "./app/components/icon/index.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./style.css */ "./app/components/sidebar/style.css");
/* harmony import */ var _components_tooltip_index_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ~/components/tooltip/index.tsx */ "./app/components/tooltip/index.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */





const SidebarListItem = ({ className, tooltipLabel, icon, label, alwaysShowText, sidebarOut }) => {
    const iconElement = typeof icon === 'string'
        ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_icon_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { className: _style_css__WEBPACK_IMPORTED_MODULE_3__["default"]['sidebar-icon'], name: icon }))
        : (icon);
    const item = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(className, _style_css__WEBPACK_IMPORTED_MODULE_3__["default"]['list-item-label']), children: [iconElement, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_3__["default"]['list-item-text'], {
                    [_style_css__WEBPACK_IMPORTED_MODULE_3__["default"]['always-show']]: alwaysShowText
                }), children: label })] }));
    let listItem;
    if (tooltipLabel) {
        listItem = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_tooltip_index_tsx__WEBPACK_IMPORTED_MODULE_4__["default"], { title: tooltipLabel, placement: 'right', disabled: sidebarOut, children: item }));
    }
    else {
        listItem = item;
    }
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_5__.StrictMode, { children: listItem });
};


/***/ }),

/***/ "./app/components/sidebar/sidebar-user-menu.tsx":
/*!******************************************************!*\
  !*** ./app/components/sidebar/sidebar-user-menu.tsx ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarUserMenu: () => (/* binding */ SidebarUserMenu)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/utils/constants.ts */ "./app/utils/constants.ts");
/* harmony import */ var _models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/models/page-history-slice.ts */ "./app/models/page-history-slice.ts");
/* harmony import */ var _components_popper_index_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/components/popper/index.tsx */ "./app/components/popper/index.tsx");
/* harmony import */ var _sidebar_list_item_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./sidebar-list-item.tsx */ "./app/components/sidebar/sidebar-list-item.tsx");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./style.css */ "./app/components/sidebar/style.css");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/dist/react-redux.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_8__);









const getUserFullName = (user) => {
    const firstName = user.firstName ?? '';
    const lastName = user.lastName ?? '';
    return (0,lodash__WEBPACK_IMPORTED_MODULE_5__.startCase)(`${firstName} ${lastName}`);
};
const getAvatarColor = (userFullName) => {
    const letters = userFullName.split(' ');
    const charCodeSum = letters.reduce((sum, letter) => {
        return sum + letter.charCodeAt(0);
    }, 0);
    const colorIndex = charCodeSum % _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.AVATAR_COLORS.length;
    return _utils_constants_ts__WEBPACK_IMPORTED_MODULE_1__.AVATAR_COLORS[colorIndex];
};
const getUserAvatar = (user, avatarColor) => {
    const firstInitial = (user.firstName ?? '').charAt(0);
    const lastInitial = (user.lastName ?? '').charAt(0);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { "data-testid": 'user-avatar', className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['user-avatar-icon'], style: {
            backgroundColor: avatarColor
        }, children: `${firstInitial}${lastInitial}` }));
};
const SidebarUserMenu = ({ handleNavigationRefresh, signoutUrl, user, sidebarOut }) => {
    const dispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_7__.useDispatch)();
    const [anchorEl, setAnchorEl] = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)(null);
    const userFullName = getUserFullName(user);
    const avatarColor = getAvatarColor(userFullName);
    const userAvatar = getUserAvatar(user, avatarColor);
    const handleOpenPopover = (event) => {
        setAnchorEl(event.currentTarget);
    };
    const handleClosePopover = () => {
        setAnchorEl(null);
    };
    const open = Boolean(anchorEl);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_8__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { "data-testid": 'sidebar-user', className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item'], children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item-link'], onClick: handleOpenPopover, "data-testid": 'user-menu-link', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_sidebar_list_item_tsx__WEBPACK_IMPORTED_MODULE_4__.SidebarListItem, { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['user-menu'], icon: userAvatar, label: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['user-name-label'], children: [userFullName, (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['caret-right'] })] }), tooltipLabel: userFullName, sidebarOut: sidebarOut }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_popper_index_tsx__WEBPACK_IMPORTED_MODULE_3__.Popper, { open: open, id: 'user-menu-popover', anchorElement: anchorEl, placement: 'right-end', transformOrigin: 'bottom left', handleHide: handleClosePopover, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['user-menu-items'], children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { "data-testid": 'user-menu-refresh-nav', className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item'], children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item-link'], onClick: () => {
                                        handleNavigationRefresh();
                                        handleClosePopover();
                                    }, children: "Refresh Navigation" }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { "data-testid": 'user-menu-signout', className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item'], children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { href: signoutUrl, className: _style_css__WEBPACK_IMPORTED_MODULE_6__["default"]['list-item-link'], onClick: () => {
                                        dispatch((0,_models_page_history_slice_ts__WEBPACK_IMPORTED_MODULE_2__.clearAll)());
                                        handleClosePopover();
                                    }, children: "Sign Out" }) })] }) })] }) }));
};


/***/ }),

/***/ "./app/components/sidebar/sidebar-waiting.tsx":
/*!****************************************************!*\
  !*** ./app/components/sidebar/sidebar-waiting.tsx ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SidebarWaiting: () => (/* binding */ SidebarWaiting)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _mui_material_CircularProgress__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material/CircularProgress */ "./node_modules/@mui/material/esm/CircularProgress/CircularProgress.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/sidebar/style.css");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */




function SidebarWaiting({ sidebarOut }) {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_3__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"].cover }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_2___default()(_style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['sidebar-waiting'], {
                        [_style_css__WEBPACK_IMPORTED_MODULE_4__["default"].expanded]: sidebarOut
                    }), children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_CircularProgress__WEBPACK_IMPORTED_MODULE_1__["default"], {}), sidebarOut && 'Loading'] })] }) }));
}


/***/ }),

/***/ "./app/components/sidebar/sidebar.tsx":
/*!********************************************!*\
  !*** ./app/components/sidebar/sidebar.tsx ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _utils_content_width_ts__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/utils/content-width.ts */ "./app/utils/content-width.ts");
/* harmony import */ var _utils_constants_ts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/utils/constants.ts */ "./app/utils/constants.ts");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _sidebar_branding_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./sidebar-branding.tsx */ "./app/components/sidebar/sidebar-branding.tsx");
/* harmony import */ var _sidebar_error_tsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./sidebar-error.tsx */ "./app/components/sidebar/sidebar-error.tsx");
/* harmony import */ var _sidebar_footer_tsx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./sidebar-footer.tsx */ "./app/components/sidebar/sidebar-footer.tsx");
/* harmony import */ var _sidebar_header_tsx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./sidebar-header.tsx */ "./app/components/sidebar/sidebar-header.tsx");
/* harmony import */ var _sidebar_links_tsx__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./sidebar-links.tsx */ "./app/components/sidebar/sidebar-links.tsx");
/* harmony import */ var _sidebar_waiting_tsx__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./sidebar-waiting.tsx */ "./app/components/sidebar/sidebar-waiting.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./style.css */ "./app/components/sidebar/style.css");
/* harmony import */ var _models_slices_application_environment_ts__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ~/models/slices/application-environment.ts */ "./app/models/slices/application-environment.ts");
/* harmony import */ var use_immer__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! use-immer */ "./node_modules/use-immer/dist/use-immer.module.mjs");
/* harmony import */ var react_router__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react-router */ "./node_modules/react-router/dist/development/chunk-PVWAREVJ.mjs");
/* harmony import */ var _utils_use_previous_ts__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../utils/use-previous.ts */ "./app/utils/use-previous.ts");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @mui/material */ "./node_modules/@mui/material/esm/Drawer/Drawer.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @mui/material */ "./node_modules/@mui/material/esm/styles/styled.js");
/* harmony import */ var _utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ~/utils/dom_utils.tsx */ "./app/utils/dom_utils.tsx");
/* harmony import */ var _models_user_preferences_slice_ts__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ~/models/user-preferences-slice.ts */ "./app/models/user-preferences-slice.ts");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/dist/react-redux.mjs");





















var ActionTypes;
(function (ActionTypes) {
    ActionTypes["SET_SIDEBAR_OUT"] = "SET_SIDEBAR_OUT";
    ActionTypes["SET_SIDEBAR_LINKS_HEIGHT"] = "SET_SIDEBAR_LINKS_HEIGHT";
    ActionTypes["TOGGLE_SIDEBAR_OUT"] = "TOGGLE_SIDEBAR_OUT";
    ActionTypes["MOUNT"] = "MOUNT";
})(ActionTypes || (ActionTypes = {}));
const reducer = (draft, { type, payload }) => {
    switch (type) {
        case ActionTypes.SET_SIDEBAR_OUT:
            draft.sidebarOut = payload;
            break;
        case ActionTypes.SET_SIDEBAR_LINKS_HEIGHT:
            draft.sidebarLinksHeight = payload;
            break;
        case ActionTypes.TOGGLE_SIDEBAR_OUT:
            draft.sidebarOut = !draft.sidebarOut;
            break;
        case ActionTypes.MOUNT:
            draft.sidebarLinksHeight = payload;
            break;
        default:
            break;
    }
};
const StyledDrawer = (0,_mui_material__WEBPACK_IMPORTED_MODULE_16__["default"])(_mui_material__WEBPACK_IMPORTED_MODULE_15__["default"], {
    shouldForwardProp: (prop) => prop !== 'collapsed' && prop !== 'prodMode'
})(({ collapsed, prodMode = false }) => {
    const width = collapsed ? '56px' : '256px';
    let top = '40px';
    let height = 'calc(100% - 40px)';
    if (prodMode) {
        top = '0px';
        height = '100%';
    }
    return {
        '& .MuiDrawer-paper': {
            backgroundColor: 'var(--kuali-dark-cool-400)',
            height,
            overflow: 'visible',
            top,
            width
        }
    };
});
// TODO: Revisit all here with a proper state management system
const Sidebar = ({ startCollapsed }) => {
    let sidebarOut;
    if (startCollapsed !== undefined) {
        sidebarOut = !startCollapsed;
    }
    else {
        sidebarOut = !(0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_17__.elementHasClass)(document.getElementById('sidebar'), 'collapsed');
    }
    const [state, dispatch] = (0,use_immer__WEBPACK_IMPORTED_MODULE_12__.useImmerReducer)(reducer, {
        sidebarOut,
        sidebarLinksHeight: 100
    });
    const sidebarLinksContainer = (0,react__WEBPACK_IMPORTED_MODULE_20__.useRef)(null);
    const reduxDispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_21__.useDispatch)();
    const preferences = (0,react_redux__WEBPACK_IMPORTED_MODULE_21__.useSelector)(_models_user_preferences_slice_ts__WEBPACK_IMPORTED_MODULE_18__.getAllPreferences);
    const prevPreferences = (0,_utils_use_previous_ts__WEBPACK_IMPORTED_MODULE_14__["default"])(preferences);
    const preferencesStatus = (0,react_redux__WEBPACK_IMPORTED_MODULE_21__.useSelector)(_models_user_preferences_slice_ts__WEBPACK_IMPORTED_MODULE_18__.getPreferencesStatus);
    const user = (0,react_redux__WEBPACK_IMPORTED_MODULE_21__.useSelector)(_models_user_preferences_slice_ts__WEBPACK_IMPORTED_MODULE_18__.getUser);
    const prevUser = (0,_utils_use_previous_ts__WEBPACK_IMPORTED_MODULE_14__["default"])(user);
    const backdoorId = (0,react_redux__WEBPACK_IMPORTED_MODULE_21__.useSelector)(_models_user_preferences_slice_ts__WEBPACK_IMPORTED_MODULE_18__.getBackdoorId);
    const { data: environmentData, isLoading: isEnvironmentLoading, isError: isEnvironmentError } = (0,_models_slices_application_environment_ts__WEBPACK_IMPORTED_MODULE_11__.useGetApplicationEnvironmentQuery)();
    let location;
    let activeDashboardId;
    try {
        // Need to be a bit hacky as the context doesn't exist for struts pages,
        // so need to handle error from react-router-dom, and move to window.location
        // eslint-disable-next-line react-hooks/rules-of-hooks
        location = (0,react_router__WEBPACK_IMPORTED_MODULE_13__.useLocation)();
        activeDashboardId = (0,lodash__WEBPACK_IMPORTED_MODULE_19__.get)(location.pathname.split('dashboard/'), [1], null);
    }
    catch {
        location = window.location;
        activeDashboardId = (0,lodash__WEBPACK_IMPORTED_MODULE_19__.get)(location.pathname.split('fin/'), [1], null);
    }
    const handleWindowResized = (0,react__WEBPACK_IMPORTED_MODULE_20__.useCallback)(() => {
        if (!sidebarLinksContainer.current) {
            return;
        }
        const sidebarLinksHeight = sidebarLinksContainer.current.offsetHeight;
        dispatch({
            type: ActionTypes.SET_SIDEBAR_LINKS_HEIGHT,
            payload: sidebarLinksHeight
        });
    }, [dispatch]);
    const handleNavigationRefresh = (0,react__WEBPACK_IMPORTED_MODULE_20__.useCallback)(() => {
        // eslint-disable-next-line no-void
        void reduxDispatch((0,_models_user_preferences_slice_ts__WEBPACK_IMPORTED_MODULE_18__.fetchUserPreferences)({ forceRefresh: true }));
    }, [reduxDispatch]);
    const toggleSidebar = (0,react__WEBPACK_IMPORTED_MODULE_20__.useCallback)(() => {
        (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_17__.toggleClass)(document.getElementById('sidebar'), 'collapsed');
        (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_17__.toggleClass)((0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_17__.getFirstElementBySelector)('main.content'), 'fullwidth');
        (0,_utils_content_width_ts__WEBPACK_IMPORTED_MODULE_1__.dispatchSidebarToggleEvent)();
        dispatch({ type: ActionTypes.TOGGLE_SIDEBAR_OUT });
    }, [dispatch]);
    (0,react__WEBPACK_IMPORTED_MODULE_20__.useEffect)(() => {
        if (preferencesStatus === _utils_constants_ts__WEBPACK_IMPORTED_MODULE_2__.FETCH_STATUSES.IDLE) {
            // eslint-disable-next-line no-void
            void reduxDispatch((0,_models_user_preferences_slice_ts__WEBPACK_IMPORTED_MODULE_18__.fetchUserPreferences)({}));
        }
    }, [preferencesStatus, reduxDispatch]);
    // ComponentDidMount analog
    (0,react__WEBPACK_IMPORTED_MODULE_20__.useLayoutEffect)(() => {
        window.addEventListener('resize', handleWindowResized);
        const sidebarLinksHeight = sidebarLinksContainer.current
            ? sidebarLinksContainer.current.offsetHeight
            : 100;
        dispatch({
            type: ActionTypes.MOUNT,
            payload: sidebarLinksHeight
        });
        return () => {
            window.removeEventListener('resize', handleWindowResized);
        };
    }, [dispatch, handleWindowResized]);
    // ComponentDidUpdate analog
    (0,react__WEBPACK_IMPORTED_MODULE_20__.useLayoutEffect)(() => {
        const dashboardsChanged = !(0,lodash__WEBPACK_IMPORTED_MODULE_19__.isEqual)((0,lodash__WEBPACK_IMPORTED_MODULE_19__.get)(prevPreferences, 'dashboards'), (0,lodash__WEBPACK_IMPORTED_MODULE_19__.get)(preferences, 'dashboards'));
        const userUpdated = !(0,lodash__WEBPACK_IMPORTED_MODULE_19__.isEqual)(prevUser, user);
        if (dashboardsChanged || userUpdated) {
            const sidebarLinksHeight = sidebarLinksContainer.current
                ? sidebarLinksContainer.current.offsetHeight
                : 100;
            dispatch({
                type: ActionTypes.SET_SIDEBAR_LINKS_HEIGHT,
                payload: sidebarLinksHeight
            });
        }
    }, [dispatch, preferences, prevPreferences, prevUser, user]);
    if (state.sidebarOut &&
        (preferencesStatus === _utils_constants_ts__WEBPACK_IMPORTED_MODULE_2__.FETCH_STATUSES.FAILED || isEnvironmentError)) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_20__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_sidebar_error_tsx__WEBPACK_IMPORTED_MODULE_5__.SidebarError, {}) }));
    }
    if ([
        _utils_constants_ts__WEBPACK_IMPORTED_MODULE_2__.FETCH_STATUSES.IDLE.toString(),
        _utils_constants_ts__WEBPACK_IMPORTED_MODULE_2__.FETCH_STATUSES.LOADING.toString()
    ].includes(preferencesStatus) ||
        isEnvironmentLoading) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_20__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_sidebar_waiting_tsx__WEBPACK_IMPORTED_MODULE_9__.SidebarWaiting, { sidebarOut: state.sidebarOut }) }));
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_20__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(StyledDrawer, { prodMode: environmentData === undefined ? true : environmentData.prodMode, collapsed: !state.sidebarOut, variant: 'permanent', anchor: 'left', open: state.sidebarOut, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_sidebar_branding_tsx__WEBPACK_IMPORTED_MODULE_4__.SidebarBranding, { logoUrl: (0,lodash__WEBPACK_IMPORTED_MODULE_19__.get)(preferences, ['settings', 'logoUrl'], null) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_sidebar_header_tsx__WEBPACK_IMPORTED_MODULE_7__.SidebarHeader, { activeDashboardId: activeDashboardId, backdoorId: backdoorId, preferences: preferences, sidebarOut: state.sidebarOut }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ref: sidebarLinksContainer, className: _style_css__WEBPACK_IMPORTED_MODULE_10__["default"]['sidebar-links-container'], children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_sidebar_links_tsx__WEBPACK_IMPORTED_MODULE_8__.SidebarLinks, { containerHeight: state.sidebarLinksHeight, activeDashboardId: activeDashboardId, dashboards: preferences.dashboards, sidebarOut: state.sidebarOut }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_sidebar_footer_tsx__WEBPACK_IMPORTED_MODULE_6__.SidebarFooter, { onNavigationRefresh: handleNavigationRefresh, settings: preferences.settings, toggleSidebar: toggleSidebar, sidebarOut: state.sidebarOut, user: user })] }) }));
};
Sidebar.displayName = 'Sidebar';
Sidebar.propTypes = {
    startCollapsed: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_20__.memo)(Sidebar));


/***/ }),

/***/ "./app/components/sidebar/style.css":
/*!******************************************!*\
  !*** ./app/components/sidebar/style.css ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/sidebar/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/sidebar/wrapped-sidebar.tsx":
/*!****************************************************!*\
  !*** ./app/components/sidebar/wrapped-sidebar.tsx ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var redux_persist_integration_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! redux-persist/integration/react */ "./node_modules/redux-persist/es/integration/react.js");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/dist/react-redux.mjs");
/* harmony import */ var _sidebar_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sidebar.tsx */ "./app/components/sidebar/sidebar.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _models_store_ts__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/models/store.ts */ "./app/models/store.ts");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */





const WrappedSidebar = () => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_4__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react_redux__WEBPACK_IMPORTED_MODULE_2__.Provider, { store: _models_store_ts__WEBPACK_IMPORTED_MODULE_5__.store, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(redux_persist_integration_react__WEBPACK_IMPORTED_MODULE_1__.PersistGate, { persistor: _models_store_ts__WEBPACK_IMPORTED_MODULE_5__.persistor, loading: null, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_sidebar_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], { startCollapsed: undefined }) }) }) }));
};
WrappedSidebar.displayName = 'WrappedSidebar';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_4__.memo)(WrappedSidebar));


/***/ }),

/***/ "./app/components/snackbar/padded-snackbar.ts":
/*!****************************************************!*\
  !*** ./app/components/snackbar/padded-snackbar.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PaddedSnackbar: () => (/* binding */ PaddedSnackbar)
/* harmony export */ });
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mui/material */ "./node_modules/@mui/material/esm/Snackbar/Snackbar.js");
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material/styles */ "./node_modules/@mui/material/esm/styles/styled.js");
/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


const PaddedSnackbar = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_1__["default"])(_mui_material__WEBPACK_IMPORTED_MODULE_0__["default"])(() => ({
    '&.MuiSnackbar-anchorOriginTopCenter': {
        top: '48px'
    }
}));


/***/ }),

/***/ "./app/components/sticky/index.tsx":
/*!*****************************************!*\
  !*** ./app/components/sticky/index.tsx ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var react_sticky_el__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-sticky-el */ "./node_modules/react-sticky-el/lib/index.js");
/* harmony import */ var react_sticky_el__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_sticky_el__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


const StickyWrapper = (0,react__WEBPACK_IMPORTED_MODULE_2__.memo)(({ children, isNotSticky, className, ref, ...props }) => {
    if (isNotSticky) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { ref: ref, className: className, children: children }));
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_2__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)((react_sticky_el__WEBPACK_IMPORTED_MODULE_1___default()), { wrapperClassName: className, ...props, children: children }) }));
});
StickyWrapper.displayName = 'StickyWrapper';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StickyWrapper);


/***/ }),

/***/ "./app/components/table/actions.tsx":
/*!******************************************!*\
  !*** ./app/components/table/actions.tsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/components/buttons/index.tsx */ "./app/components/buttons/index.tsx");
/* harmony import */ var _mui_icons_material_CloseFullscreen__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material/CloseFullscreen */ "./node_modules/@mui/icons-material/esm/CloseFullscreen.js");
/* harmony import */ var _mui_icons_material_Download__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material/Download */ "./node_modules/@mui/icons-material/esm/Download.js");
/* harmony import */ var _utils_csv_export_ts__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ~/utils/csv-export.ts */ "./app/utils/csv-export.ts");
/* harmony import */ var _utils_document_table_utils_tsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/utils/document/table-utils.tsx */ "./app/utils/document/table-utils.tsx");
/* harmony import */ var _hide_columns_menu_tsx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./hide-columns-menu.tsx */ "./app/components/table/hide-columns-menu.tsx");
/* harmony import */ var _mui_icons_material_OpenInFull__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/icons-material/OpenInFull */ "./node_modules/@mui/icons-material/esm/OpenInFull.js");
/* harmony import */ var _mui_icons_material_VisibilityOff__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/icons-material/VisibilityOff */ "./node_modules/@mui/icons-material/esm/VisibilityOff.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);










const TableActions = ({ id, showFullScreen = false, setShowFullScreen, schema, hiddenColumns = [], setHiddenColumns, rows = [], transformers = null, showCsvExport = false, columnMenuOpen = false, setColumnMenuOpen }) => {
    const toggleFullScreenButton = (0,react__WEBPACK_IMPORTED_MODULE_9__.useRef)(null);
    const [hiddenColumnsCount, setHiddenColumnsCount] = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)(0);
    const [hiddenColumnsLabel, setHiddenColumnsLabel] = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)('');
    const hideColumnsAnchorRef = (0,react__WEBPACK_IMPORTED_MODULE_9__.useRef)(null);
    (0,react__WEBPACK_IMPORTED_MODULE_9__.useEffect)(() => {
        setHiddenColumnsCount(hiddenColumns ? hiddenColumns.length : 0);
    }, [hiddenColumns]);
    (0,react__WEBPACK_IMPORTED_MODULE_9__.useEffect)(() => {
        if (hiddenColumnsCount > 0) {
            setHiddenColumnsLabel(`${hiddenColumnsCount} Hidden Column${hiddenColumnsCount === 1 ? '' : 's'}`);
        }
        else {
            setHiddenColumnsLabel('Hide Columns');
        }
    }, [hiddenColumnsCount]);
    (0,react__WEBPACK_IMPORTED_MODULE_9__.useEffect)(() => {
        if (showFullScreen && toggleFullScreenButton.current) {
            toggleFullScreenButton.current.focus();
        }
    }, [showFullScreen]);
    const handleToggleFullScreen = (0,react__WEBPACK_IMPORTED_MODULE_9__.useCallback)(() => {
        setShowFullScreen(!showFullScreen);
    }, [setShowFullScreen, showFullScreen]);
    const handleCsvDownloadClick = (0,react__WEBPACK_IMPORTED_MODULE_9__.useCallback)(() => {
        const csvRows = (0,_utils_document_table_utils_tsx__WEBPACK_IMPORTED_MODULE_5__.getCsvRows)(rows, schema, transformers);
        (0,_utils_csv_export_ts__WEBPACK_IMPORTED_MODULE_4__.exportCsvFile)(csvRows);
    }, [rows, schema, transformers]);
    const handleToggleColumnsMenu = () => {
        if (setColumnMenuOpen) {
            setColumnMenuOpen(!columnMenuOpen);
        }
    };
    const hideColumnsMenu = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_hide_columns_menu_tsx__WEBPACK_IMPORTED_MODULE_6__["default"], { id: `${id}-hide-columns-menu`, shown: columnMenuOpen, setShown: setColumnMenuOpen, anchorElement: hideColumnsAnchorRef.current, schema: schema, hiddenColumns: hiddenColumns, setHiddenColumns: setHiddenColumns }));
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react__WEBPACK_IMPORTED_MODULE_9__.StrictMode, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { testId: 'hide-columns-button', customStyle: hiddenColumnsCount > 0
                    ? { backgroundColor: 'var(--kuali-blue-100);' }
                    : undefined, ref: hideColumnsAnchorRef, onClick: handleToggleColumnsMenu, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_VisibilityOff__WEBPACK_IMPORTED_MODULE_8__["default"], { fontSize: 'small', sx: { marginRight: '4px' } }), hiddenColumnsLabel] }), hideColumnsMenu, showCsvExport && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { testId: 'csv-download-button', onClick: handleCsvDownloadClick, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_Download__WEBPACK_IMPORTED_MODULE_3__["default"], { fontSize: 'small', sx: { marginRight: '4px' } }), "Save as CSV"] })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { testId: 'expand-collapse-button', onClick: handleToggleFullScreen, ref: toggleFullScreenButton, "aria-hidden": true, children: [showFullScreen
                        ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_CloseFullscreen__WEBPACK_IMPORTED_MODULE_2__["default"], { fontSize: 'small', sx: { marginRight: '4px' } }))
                        : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_icons_material_OpenInFull__WEBPACK_IMPORTED_MODULE_7__["default"], { fontSize: 'small', sx: { marginRight: '4px' } })), showFullScreen ? 'View In Page' : 'View Larger'] })] }));
};
TableActions.displayName = 'TableActions';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_9__.memo)(TableActions));


/***/ }),

/***/ "./app/components/table/hide-columns-menu.css":
/*!****************************************************!*\
  !*** ./app/components/table/hide-columns-menu.css ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_hide_columns_menu_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./hide-columns-menu.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/table/hide-columns-menu.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_hide_columns_menu_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_hide_columns_menu_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_hide_columns_menu_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_hide_columns_menu_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/table/hide-columns-menu.tsx":
/*!****************************************************!*\
  !*** ./app/components/table/hide-columns-menu.tsx ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/components/buttons/index.tsx */ "./app/components/buttons/index.tsx");
/* harmony import */ var _mui_material_ButtonGroup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material/ButtonGroup */ "./node_modules/@mui/material/esm/ButtonGroup/ButtonGroup.js");
/* harmony import */ var _mui_material_FormControlLabel__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/material/FormControlLabel */ "./node_modules/@mui/material/esm/FormControlLabel/FormControlLabel.js");
/* harmony import */ var _mui_material_FormGroup__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/material/FormGroup */ "./node_modules/@mui/material/esm/FormGroup/FormGroup.js");
/* harmony import */ var _components_input_index_tsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/components/input/index.tsx */ "./app/components/input/index.tsx");
/* harmony import */ var _components_popper_index_tsx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ~/components/popper/index.tsx */ "./app/components/popper/index.tsx");
/* harmony import */ var _hide_columns_menu_css__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./hide-columns-menu.css */ "./app/components/table/hide-columns-menu.css");
/* harmony import */ var _mui_material_Switch__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/material/Switch */ "./node_modules/@mui/material/esm/Switch/Switch.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_10__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */










const HideColumnsMenu = ({ id, shown, setShown, schema, hiddenColumns, setHiddenColumns, anchorElement }) => {
    const [searchText, setSearchText] = (0,react__WEBPACK_IMPORTED_MODULE_9__.useState)('');
    const menuContentId = `${id}-hideColumnsMenuContent`;
    const handleSearchTextChange = (0,react__WEBPACK_IMPORTED_MODULE_9__.useCallback)((e) => {
        setSearchText(e.target.value);
    }, []);
    const handleColumnToggle = (0,react__WEBPACK_IMPORTED_MODULE_9__.useCallback)((event, checked) => {
        const columnName = event.target.value;
        if (checked) {
            setHiddenColumns((0,lodash__WEBPACK_IMPORTED_MODULE_10__.without)(hiddenColumns, columnName));
        }
        else {
            setHiddenColumns([...hiddenColumns, columnName]);
        }
    }, [hiddenColumns, setHiddenColumns]);
    const filterColumn = (0,react__WEBPACK_IMPORTED_MODULE_9__.useCallback)((column) => {
        return column.label.toLowerCase().includes(searchText.toLowerCase());
    }, [searchText]);
    const handleToggleAll = (0,react__WEBPACK_IMPORTED_MODULE_9__.useCallback)((hidden) => {
        if (hidden) {
            setHiddenColumns(schema.map((column) => column.name));
        }
        else {
            setHiddenColumns([]);
        }
    }, [schema, setHiddenColumns]);
    (0,react__WEBPACK_IMPORTED_MODULE_9__.useEffect)(() => {
        if (!shown) {
            setSearchText('');
        }
    }, [shown]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_9__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_components_popper_index_tsx__WEBPACK_IMPORTED_MODULE_6__.Popper, { id: menuContentId, open: shown, anchorElement: anchorElement, placement: 'bottom-end', transformOrigin: 'top right', handleHide: setShown, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material_ButtonGroup__WEBPACK_IMPORTED_MODULE_2__["default"], { size: 'small', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { variant: 'outlined', onClick: (0,lodash__WEBPACK_IMPORTED_MODULE_10__.partial)(handleToggleAll, true), testId: 'hide-all', children: "Hide All" }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_buttons_index_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { variant: 'outlined', onClick: (0,lodash__WEBPACK_IMPORTED_MODULE_10__.partial)(handleToggleAll, false), testId: 'show-all', children: "Show All" })] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_input_index_tsx__WEBPACK_IMPORTED_MODULE_5__["default"], { className: _hide_columns_menu_css__WEBPACK_IMPORTED_MODULE_7__["default"]['search-input'], placeholder: 'Filter Columns', "aria-label": 'Type to filter columns', value: searchText, id: 'filter-hide-columns-input', onChange: handleSearchTextChange }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_FormGroup__WEBPACK_IMPORTED_MODULE_4__["default"], { children: schema.filter(filterColumn).map((column) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_FormControlLabel__WEBPACK_IMPORTED_MODULE_3__["default"], { control: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_Switch__WEBPACK_IMPORTED_MODULE_8__["default"], { id: `${id}-hide-column-${column.name}`, value: column.name, checked: !(0,lodash__WEBPACK_IMPORTED_MODULE_10__.includes)(hiddenColumns, column.name), onChange: handleColumnToggle }), label: column.label }, column.name))) })] }) }));
};
HideColumnsMenu.displayName = 'HideColumnsMenu';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_9__.memo)(HideColumnsMenu));


/***/ }),

/***/ "./app/components/table/index.tsx":
/*!****************************************!*\
  !*** ./app/components/table/index.tsx ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RowTypes: () => (/* binding */ RowTypes),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.css */ "./app/components/table/style.css");
/* harmony import */ var _table_header_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./table-header.tsx */ "./app/components/table/table-header.tsx");
/* harmony import */ var _table_row_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./table-row.tsx */ "./app/components/table/table-row.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/style.css */ "./app/style.css");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */







var RowTypes;
(function (RowTypes) {
    RowTypes["HEADER"] = "header";
    RowTypes["ROW"] = "row";
})(RowTypes || (RowTypes = {}));
const ROW_HEIGHT = 32;
const TABLE_PADDING_BOTTOM = 16;
const Table = ({ getSchema, hiddenColumns, rows, headerData, transformers, emptyMessage, onChange = lodash__WEBPACK_IMPORTED_MODULE_6__.noop, setColumnMenuOpen }) => {
    const handleShowColumnsClick = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)((e) => {
        e.preventDefault();
        setColumnMenuOpen?.(true);
    }, [setColumnMenuOpen]);
    const filterSchema = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)((schema) => {
        return schema.filter((column) => !(0,lodash__WEBPACK_IMPORTED_MODULE_6__.includes)(hiddenColumns, column.name));
    }, [hiddenColumns]);
    if (!rows || rows.length === 0) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_2__["default"]['empty-state'], children: emptyMessage ?? 'No rows.' }));
    }
    const filteredSchema = filterSchema(getSchema(RowTypes.HEADER));
    if (filteredSchema.length > 0) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_7__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_2__["default"]['table-wrapper'], _style_css__WEBPACK_IMPORTED_MODULE_5__["default"]['horizontal-scroll-shadows']), children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("table", { className: _style_css__WEBPACK_IMPORTED_MODULE_2__["default"].table, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("thead", { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_table_header_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], { headerData: headerData, schema: filteredSchema, onChange: 
                                // @ts-expect-error This is dumb, but it needs to be like this. This will all go away when this stupid table is removed when APPA is made a real boy.
                                (0,lodash__WEBPACK_IMPORTED_MODULE_6__.partial)(onChange, RowTypes.HEADER, headerData) }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("tbody", { children: rows.map((row, index) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_table_row_tsx__WEBPACK_IMPORTED_MODULE_4__["default"], { rowData: row, schema: filterSchema(getSchema(RowTypes.ROW, row)), transformers: transformers, onChange: (0,lodash__WEBPACK_IMPORTED_MODULE_6__.partial)(onChange, RowTypes.ROW, index) }, index))) })] }) }) }));
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_7__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_2__["default"]['empty-state'], style: {
                height: ROW_HEIGHT * (rows.length + 1) + TABLE_PADDING_BOTTOM
            }, "data-testid": 'all-hidden-message', children: ["All columns have been hidden,", ' ', (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { href: '#', onClick: handleShowColumnsClick, children: "show columns" }), ' ', "to view data."] }) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_7__.memo)(Table));


/***/ }),

/***/ "./app/components/table/inner-table-row.tsx":
/*!**************************************************!*\
  !*** ./app/components/table/inner-table-row.tsx ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _utils_document_table_utils_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/utils/document/table-utils.tsx */ "./app/utils/document/table-utils.tsx");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./style.css */ "./app/components/table/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */




const InnerTableRow = ({ className, rowData, schema, getValue }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_4__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("tr", { className: classnames__WEBPACK_IMPORTED_MODULE_2___default()(_style_css__WEBPACK_IMPORTED_MODULE_3__["default"].row, className), children: schema.map((item) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("td", { "data-testid": 'table-cell', className: classnames__WEBPACK_IMPORTED_MODULE_2___default()(_style_css__WEBPACK_IMPORTED_MODULE_3__["default"].cell, (0,_utils_document_table_utils_tsx__WEBPACK_IMPORTED_MODULE_1__.classesForType)(item.type)), children: getValue(rowData, item) }, item.name))) }) }));
};
InnerTableRow.displayName = 'InnerTableRow';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_4__.memo)(InnerTableRow));


/***/ }),

/***/ "./app/components/table/style.css":
/*!****************************************!*\
  !*** ./app/components/table/style.css ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/table/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/table/table-header.tsx":
/*!***********************************************!*\
  !*** ./app/components/table/table-header.tsx ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_document_table_utils_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ~/utils/document/table-utils.tsx */ "./app/utils/document/table-utils.tsx");
/* harmony import */ var _inner_table_row_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./inner-table-row.tsx */ "./app/components/table/inner-table-row.tsx");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/table/style.css");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */





const TableHeader = ({ headerData, schema, onChange }) => {
    const getValue = (0,react__WEBPACK_IMPORTED_MODULE_5__.useCallback)((data, schema) => {
        if ((0,lodash__WEBPACK_IMPORTED_MODULE_1__.get)(schema, ['control', 'displayInHeader'])) {
            return (0,_utils_document_table_utils_tsx__WEBPACK_IMPORTED_MODULE_2__.getCellValue)(data, schema, false, null, undefined, onChange);
        }
        return (0,lodash__WEBPACK_IMPORTED_MODULE_1__.get)(schema, 'label');
    }, [onChange]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_5__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_inner_table_row_tsx__WEBPACK_IMPORTED_MODULE_3__["default"], { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['header-row'], schema: schema, rowData: headerData, 
            /* Need to cast as for some reason it's not picking up the generic. The internet has not been helpful on
             this. */
            getValue: getValue }) }));
};
TableHeader.displayName = 'TableHeader';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_5__.memo)(TableHeader));


/***/ }),

/***/ "./app/components/table/table-row.tsx":
/*!********************************************!*\
  !*** ./app/components/table/table-row.tsx ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _utils_document_table_utils_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ~/utils/document/table-utils.tsx */ "./app/utils/document/table-utils.tsx");
/* harmony import */ var _inner_table_row_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./inner-table-row.tsx */ "./app/components/table/inner-table-row.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



const TableRow = ({ rowData, schema, transformers, errors, onChange }) => {
    const getValue = (0,react__WEBPACK_IMPORTED_MODULE_3__.useCallback)((data, schema) => {
        return (0,_utils_document_table_utils_tsx__WEBPACK_IMPORTED_MODULE_1__.getCellValue)(data, schema, false, transformers, errors, onChange);
    }, [errors, onChange, transformers]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_3__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_inner_table_row_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { rowData: rowData, schema: schema, getValue: getValue }) }));
};
TableRow.displayName = 'TableRow';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_3__.memo)(TableRow));


/***/ }),

/***/ "./app/components/table/use-selectable-rows.ts":
/*!*****************************************************!*\
  !*** ./app/components/table/use-selectable-rows.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _index_tsx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./index.tsx */ "./app/components/table/index.tsx");
/* harmony import */ var use_immer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! use-immer */ "./node_modules/use-immer/dist/use-immer.module.mjs");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */




var ActionTypes;
(function (ActionTypes) {
    ActionTypes["HANDLE_ROW_CHANGE"] = "HANDLE_ROW_CHANGE";
    ActionTypes["INITIALIZE"] = "INITIALIZE";
})(ActionTypes || (ActionTypes = {}));
const getSelectedCount = (rows) => {
    return rows.reduce((rowCount, row) => {
        if (row.selected) {
            rowCount++;
        }
        return rowCount;
    }, 0);
};
const initializeSelectableCount = (rows, rowIsSelectable) => {
    let selectableRowCount = 0;
    for (const row of rows) {
        if (rowIsSelectable(row)) {
            row.selected = false;
            selectableRowCount++;
        }
    }
    return selectableRowCount;
};
const reducer = (draft, { type, payload }) => {
    let rowsToUpdate;
    let someRowsAreChecked;
    let allRowsAreChecked;
    switch (type) {
        case ActionTypes.INITIALIZE:
            draft.rows = (0,lodash__WEBPACK_IMPORTED_MODULE_2__.cloneDeep)((0,lodash__WEBPACK_IMPORTED_MODULE_2__.sortBy)(payload.initialRows, 'id'));
            draft.header = payload.initialHeader;
            draft.selectableRowCount = initializeSelectableCount(draft.rows, payload.rowIsSelectable);
            draft.selectedRowCount = getSelectedCount(draft.rows);
            break;
        case ActionTypes.HANDLE_ROW_CHANGE:
            if (payload.rowsToUpdate === 'ALL') {
                rowsToUpdate = draft.rows;
            }
            else {
                rowsToUpdate = [draft.rows[payload.rowsToUpdate]];
            }
            rowsToUpdate.forEach((row) => {
                if (payload.rowIsSelectable(row)) {
                    row.selected = payload.selected;
                }
            });
            draft.selectedRowCount = getSelectedCount(draft.rows);
            someRowsAreChecked = draft.selectedRowCount > 0;
            allRowsAreChecked = draft.selectedRowCount === draft.selectableRowCount;
            draft.header.selected = {
                checked: someRowsAreChecked,
                indeterminate: someRowsAreChecked && !allRowsAreChecked
            };
            break;
        default:
            break;
    }
};
/**
 * This hook isolates the logic of making a list of table rows selectable. The intent is to take a predefined set of rows
 * and add a property to denote its selected state typically used within the table component. The hook provides transformed
 * rows, the resulting header data that can help manage the collective selected state of all the rows (some, none, all), and
 * an handleRowOnChange function that can be passed into a Table component to keep the row data up to date as users interact
 * with a control that will manipulate a row's selected state
 *
 * @param {array} initialRows the rows to transformed and managed into "selectable" rows
 * @param {object} initialHeader the header data that will be managed as a side effect of the selected state of the rows
 * @param {function} rowIsSelectable a function that takes a row object as its parameter and determines if that row can be selected
 */
const useSelectableRows = (initialRows, initialHeader, rowIsSelectable) => {
    const [state, dispatch] = (0,use_immer__WEBPACK_IMPORTED_MODULE_1__.useImmerReducer)(reducer, {
        rows: [],
        header: undefined,
        selectedRowCount: 0,
        selectableRowCount: 0
    });
    const handleRowOnChange = (0,react__WEBPACK_IMPORTED_MODULE_3__.useCallback)((rowType, index, ...rest) => {
        let rowsToUpdate = 'ALL';
        if (rowType === _index_tsx__WEBPACK_IMPORTED_MODULE_0__.RowTypes.ROW) {
            rowsToUpdate = index;
        }
        const action = {
            type: ActionTypes.HANDLE_ROW_CHANGE,
            payload: {
                rowsToUpdate,
                rowIsSelectable,
                selected: !!(0,lodash__WEBPACK_IMPORTED_MODULE_2__.last)(rest)
            }
        };
        if (rowsToUpdate !== undefined) {
            dispatch(action);
        }
    }, [dispatch, rowIsSelectable]);
    // Initialize, and re-initialize when initialRows/initialHeader changes
    (0,react__WEBPACK_IMPORTED_MODULE_3__.useEffect)(() => {
        dispatch({
            type: ActionTypes.INITIALIZE,
            payload: {
                initialRows: initialRows,
                initialHeader,
                rowIsSelectable
            }
        });
    }, [dispatch, initialHeader, initialRows, rowIsSelectable]);
    return {
        rows: state.rows,
        header: state.header,
        selectedRowCount: state.selectedRowCount,
        handleRowOnChange
    };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useSelectableRows);


/***/ }),

/***/ "./app/components/tooltip/index.tsx":
/*!******************************************!*\
  !*** ./app/components/tooltip/index.tsx ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material/styles */ "./node_modules/@mui/material/esm/styles/styled.js");
/* harmony import */ var _mui_material_Tooltip__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/material/Tooltip */ "./node_modules/@mui/material/esm/Tooltip/Tooltip.js");
/* harmony import */ var _mui_material_Tooltip__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/material/Tooltip */ "./node_modules/@mui/material/esm/Tooltip/tooltipClasses.js");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



const StyledTooltip = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_2__["default"])(({ className, children, ...props }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_material_Tooltip__WEBPACK_IMPORTED_MODULE_3__["default"], { ...props, classes: { popper: className }, children: children })))(() => ({
    [`& .${_mui_material_Tooltip__WEBPACK_IMPORTED_MODULE_4__["default"].tooltip}`]: {
        backgroundColor: 'var(--kuali-dark-gray-200)',
        borderRadius: '4px',
        color: 'var(--kuali-white-default)',
        fontSize: '12px',
        padding: '4px 8px',
        pointerEvents: 'none'
    }
}));
const Tooltip = ({ disabled = false, children, ...rest }) => {
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(StyledTooltip, { disableFocusListener: disabled, disableHoverListener: disabled, disableTouchListener: disabled, ...rest, children: children }));
};
Tooltip.displayName = 'Tooltip';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_1__.memo)(Tooltip));


/***/ }),

/***/ "./app/components/tree/custom-tree-item.tsx":
/*!**************************************************!*\
  !*** ./app/components/tree/custom-tree-item.tsx ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _mui_x_tree_view_hooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/x-tree-view/hooks */ "./node_modules/@mui/x-tree-view/esm/hooks/useTreeItemUtils/useTreeItemUtils.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_x_tree_view_TreeItem__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/x-tree-view/TreeItem */ "./node_modules/@mui/x-tree-view/esm/TreeItem/TreeItem.js");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



const CustomTreeItem = ({ ref, ...props }) => {
    const { interactions } = (0,_mui_x_tree_view_hooks__WEBPACK_IMPORTED_MODULE_1__.useTreeItemUtils)({
        itemId: props.itemId,
        children: props.children
    });
    const handleContentClick = (event) => {
        event.defaultMuiPrevented = true;
        props.onItemClick(props.itemId);
    };
    const handleIconContainerClick = (event) => {
        event.defaultMuiPrevented = true;
        event.stopPropagation();
        interactions.handleExpansion(event);
    };
    const handleContentKeyDown = (event) => {
        if (event.code === 'Space') {
            event.defaultMuiPrevented = true;
            event.preventDefault();
            event.stopPropagation();
            props.onItemClick(props.itemId);
        }
    };
    const { onItemClick: _onItemClick, ...rest } = props;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_2__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_x_tree_view_TreeItem__WEBPACK_IMPORTED_MODULE_3__.TreeItem, { ...rest, onKeyDown: handleContentKeyDown, ref: ref, slotProps: {
                content: { onClick: handleContentClick },
                iconContainer: { onClick: handleIconContainerClick }
            } }) }));
};
CustomTreeItem.displayName = 'CustomTreeItem';
const MemoizedCustomTreeItem = (0,react__WEBPACK_IMPORTED_MODULE_2__.memo)(CustomTreeItem);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MemoizedCustomTreeItem);


/***/ }),

/***/ "./app/components/tree/style.css":
/*!***************************************!*\
  !*** ./app/components/tree/style.css ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!../../../node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./style.css */ "./node_modules/css-loader/dist/cjs.js??ruleSet[1].rules[1].use[1]!./node_modules/postcss-loader/dist/cjs.js??ruleSet[1].rules[1].use[2]!./app/components/tree/style.css");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());
options.insert = _node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
options.domAPI = (_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_css_loader_dist_cjs_js_ruleSet_1_rules_1_use_1_node_modules_postcss_loader_dist_cjs_js_ruleSet_1_rules_1_use_2_style_css__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./app/components/tree/tree.tsx":
/*!**************************************!*\
  !*** ./app/components/tree/tree.tsx ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var _custom_tree_item_tsx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./custom-tree-item.tsx */ "./app/components/tree/custom-tree-item.tsx");
/* harmony import */ var _icon_index_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../icon/index.tsx */ "./app/components/icon/index.tsx");
/* harmony import */ var _mui_x_tree_view__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/x-tree-view */ "./node_modules/@mui/x-tree-view/esm/SimpleTreeView/SimpleTreeView.js");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./style.css */ "./app/components/tree/style.css");
/* harmony import */ var react_hook_form__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react-hook-form */ "./node_modules/react-hook-form/dist/index.esm.mjs");
/* harmony import */ var lodash_without__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash/without */ "./node_modules/lodash/without.js");
/* harmony import */ var lodash_without__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash_without__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_8__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */








const Tree = ({ nodes = [], startCollapsed = false, name }) => {
    const { field } = (0,react_hook_form__WEBPACK_IMPORTED_MODULE_5__.useController)({ name, defaultValue: [] });
    const parentIcon = 'folder';
    const leafIcon = 'file-image';
    const expandedNodes = (0,react__WEBPACK_IMPORTED_MODULE_8__.useMemo)(() => [], []);
    const handleItemClick = (0,react__WEBPACK_IMPORTED_MODULE_8__.useCallback)((itemId) => {
        let value = (0,lodash__WEBPACK_IMPORTED_MODULE_7__.isArray)(field.value) ? [...field.value] : [field.value];
        if (value.includes(itemId)) {
            value = lodash_without__WEBPACK_IMPORTED_MODULE_6___default()(value, itemId);
        }
        else {
            value.push(itemId);
        }
        field.onChange(value);
    }, [field]);
    const processNode = (0,react__WEBPACK_IMPORTED_MODULE_8__.useCallback)((node) => {
        const { label, value, children } = node;
        const isSelected = field.value.includes(value);
        const isCollapsed = !expandedNodes.includes(value);
        const isEmptyFolder = !(0,lodash__WEBPACK_IMPORTED_MODULE_7__.isUndefined)(children) && (0,lodash__WEBPACK_IMPORTED_MODULE_7__.isEmpty)(children);
        const ariaLabel = `
          ${label}.
          ${isEmptyFolder ? 'Empty folder. ' : ''}
          ${isSelected ? 'selected' : 'unselected'}.
          ${isCollapsed ? 'collapsed' : 'expanded'}.
          Use up and down to navigate. Left and right to expand or collapse.
          Press space to ${isSelected ? 'unselect' : 'select'}.
        `;
        const labelElement = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: isSelected ? _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['node-selected'] : '', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_icon_index_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { name: children ? parentIcon : leafIcon, className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['node-icon'] }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"]['node-label'], children: label })] }));
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_custom_tree_item_tsx__WEBPACK_IMPORTED_MODULE_1__["default"], { itemId: value, label: labelElement, "aria-label": ariaLabel, onItemClick: handleItemClick, children: node.children
                ? node.children.map((child) => processNode(child))
                : '' }, value));
    }, [expandedNodes, field.value, handleItemClick]);
    const collectAllNodeIds = (nodes) => {
        nodes.forEach((node) => {
            expandedNodes.push(node.value);
            if (node.children) {
                collectAllNodeIds(node.children);
            }
        });
    };
    // expand all nodes by default
    if (!startCollapsed) {
        collectAllNodeIds(nodes);
    }
    const processedNodes = (0,react__WEBPACK_IMPORTED_MODULE_8__.useMemo)(() => {
        return nodes.map((node) => processNode(node));
    }, [nodes, processNode]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_8__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { tabIndex: 0, role: 'tree-container', className: _style_css__WEBPACK_IMPORTED_MODULE_4__["default"].tree, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_mui_x_tree_view__WEBPACK_IMPORTED_MODULE_3__.SimpleTreeView, { multiSelect: true, defaultExpandedItems: expandedNodes, selectedItems: field.value, ref: field.ref, "aria-label": 'File tree area. Use up and down arrow keys to navigate. Left and right to expand and collapse folders.', children: processedNodes }) }) }));
};
Tree.displayName = 'Tree';
const MemoizedTree = (0,react__WEBPACK_IMPORTED_MODULE_8__.memo)(Tree);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MemoizedTree);


/***/ }),

/***/ "./app/dashboard/dashboard-widgets.tsx":
/*!*********************************************!*\
  !*** ./app/dashboard/dashboard-widgets.tsx ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./style.css */ "./app/dashboard/style.css");
/* harmony import */ var _widget_template_builder_tsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./widget-template-builder.tsx */ "./app/dashboard/widget-template-builder.tsx");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _widgets_components_row_header_tsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./widgets/components/row-header.tsx */ "./app/dashboard/widgets/components/row-header.tsx");

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */





const DashboardWidgets = ({ dashboardId, backdoorId, userPreferences }) => {
    const renderWidget = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)((widget, hasRowHeader, widgetProps, index) => {
        const WidgetComponent = widget.widget;
        const renderedChildWidgets = widget.children
            ? widget.children.map((childWidget, childIndex) => renderWidget(childWidget, false, widgetProps, `${index}-${childIndex}`))
            : null;
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(WidgetComponent, { hasRowHeader: hasRowHeader, ...widget.config, ...widgetProps, children: renderedChildWidgets }, index));
    }, []);
    const widgetTemplate = (0,react__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => (0,_widget_template_builder_tsx__WEBPACK_IMPORTED_MODULE_3__.buildDashboardWidgetTemplate)(userPreferences, dashboardId), [dashboardId, userPreferences]);
    const templateMap = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)((row, i) => {
        const widgetProps = {
            backdoorId
        };
        const hasRowHeader = !!row.rowHeader;
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: _style_css__WEBPACK_IMPORTED_MODULE_2__["default"]['widget-row-wrapper'], children: [hasRowHeader && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_widgets_components_row_header_tsx__WEBPACK_IMPORTED_MODULE_5__["default"], { header: row.rowHeader?.header, actions: row.rowHeader?.actions, ...widgetProps })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_2__["default"]['widget-row'], row.rowClassName), children: row.widgets.map((widget, j) => renderWidget(widget, hasRowHeader, widgetProps, j)) })] }, i));
    }, [backdoorId, renderWidget]);
    const mappedTemplate = (0,react__WEBPACK_IMPORTED_MODULE_4__.useMemo)(() => widgetTemplate.map(templateMap), [templateMap, widgetTemplate]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_4__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { children: mappedTemplate }) }));
};
DashboardWidgets.displayName = 'DashboardWidgets';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_4__.memo)(DashboardWidgets));


/***/ }),

/***/ "./app/dashboard/dashboard.tsx":
/*!*************************************!*\
  !*** ./app/dashboard/dashboard.tsx ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "./node_modules/react/jsx-runtime.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _dashboard_widgets_tsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./dashboard-widgets.tsx */ "./app/dashboard/dashboard-widgets.tsx");
/* harmony import */ var _utils_constants_ts__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ~/utils/constants.ts */ "./app/utils/constants.ts");
/* harmony import */ var _utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ~/utils/dom_utils.tsx */ "./app/utils/dom_utils.tsx");
/* harmony import */ var _components_page_header_index_tsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ~/components/page-header/index.tsx */ "./app/components/page-header/index.tsx");
/* harmony import */ var _components_page_spinner_index_tsx__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ~/components/page-spinner/index.tsx */ "./app/components/page-spinner/index.tsx");
/* harmony import */ var _utils_use_previous_ts__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/use-previous.ts */ "./app/utils/use-previous.ts");
/* harmony import */ var _lookup_use_router_params_ts__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ~/lookup/use-router-params.ts */ "./app/lookup/use-router-params.ts");
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! react-redux */ "./node_modules/react-redux/dist/react-redux.mjs");
/* harmony import */ var _style_css__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ~/style.css */ "./app/style.css");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! lodash */ "./node_modules/lodash/lodash.js");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var _models_user_preferences_slice_ts__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ~/models/user-preferences-slice.ts */ "./app/models/user-preferences-slice.ts");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_13__);

/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */













const SPINNER_STATUSES = [
    _utils_constants_ts__WEBPACK_IMPORTED_MODULE_3__.FETCH_STATUSES.LOADING.toString(),
    _utils_constants_ts__WEBPACK_IMPORTED_MODULE_3__.FETCH_STATUSES.IDLE.toString()
];
const Dashboard = () => {
    const params = (0,_lookup_use_router_params_ts__WEBPACK_IMPORTED_MODULE_8__.useRouterParams)();
    const dashboardId = params.routeParams.dashboardId;
    const previousDashboardId = (0,_utils_use_previous_ts__WEBPACK_IMPORTED_MODULE_7__["default"])(dashboardId);
    const preferences = (0,react_redux__WEBPACK_IMPORTED_MODULE_9__.useSelector)(_models_user_preferences_slice_ts__WEBPACK_IMPORTED_MODULE_12__.getAllPreferences);
    const preferencesStatus = (0,react_redux__WEBPACK_IMPORTED_MODULE_9__.useSelector)(_models_user_preferences_slice_ts__WEBPACK_IMPORTED_MODULE_12__.getPreferencesStatus);
    const backdoorId = (0,react_redux__WEBPACK_IMPORTED_MODULE_9__.useSelector)(_models_user_preferences_slice_ts__WEBPACK_IMPORTED_MODULE_12__.getBackdoorId);
    const focusFirst = (0,react__WEBPACK_IMPORTED_MODULE_13__.useCallback)(() => {
        // focus on first focusable item
        const firstFocusableElement = (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_4__.getFirstElementBySelector)('[tabindex="0"]');
        if (firstFocusableElement) {
            firstFocusableElement.focus();
        }
    }, []);
    (0,react__WEBPACK_IMPORTED_MODULE_13__.useLayoutEffect)(() => {
        if (dashboardId !== previousDashboardId) {
            const container = (0,_utils_dom_utils_tsx__WEBPACK_IMPORTED_MODULE_4__.getFirstElementBySelector)('.content');
            if (container) {
                container.scrollTop = 0;
            }
            focusFirst();
        }
    }, [dashboardId, focusFirst, previousDashboardId]);
    let dashboardTitle;
    const dashboards = (0,lodash__WEBPACK_IMPORTED_MODULE_11__.get)(preferences, 'dashboards');
    if (!(0,lodash__WEBPACK_IMPORTED_MODULE_11__.isEmpty)(dashboards)) {
        if (dashboardId === 'home') {
            dashboardTitle = 'Home';
        }
        else {
            const dashboard = dashboards.find((dashboard) => dashboard.id === dashboardId);
            dashboardTitle = dashboard?.label;
        }
    }
    let component = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_dashboard_widgets_tsx__WEBPACK_IMPORTED_MODULE_2__["default"], { dashboardId: dashboardId, backdoorId: backdoorId, userPreferences: preferences }));
    if (SPINNER_STATUSES.includes(preferencesStatus)) {
        component = (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_page_spinner_index_tsx__WEBPACK_IMPORTED_MODULE_6__["default"], {});
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(react__WEBPACK_IMPORTED_MODULE_13__.StrictMode, { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_page_header_index_tsx__WEBPACK_IMPORTED_MODULE_5__["default"], { className: _style_css__WEBPACK_IMPORTED_MODULE_10__["default"].pagePadding, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h2", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_10__["default"]['webapp-header']), "data-testid": 'dashboardTitle', children: dashboardTitle }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(_style_css__WEBPACK_IMPORTED_MODULE_10__["default"]['webapp-container'], _style_css__WEBPACK_IMPORTED_MODULE_10__["default"]['webapp-page'], _style_css__WEBPACK_IMPORTED_MODULE_10__["default"].responsive, _style_css__WEBPACK_IMPORTED_MODULE_10__["default"].pagePadding), children: component })] }) }));
};
Dashboard.displayName = 'Dashboard';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,react__WEBPACK_IMPORTED_MODULE_13__.memo)(Dashboard));


/***/ }),

/***/ "./app/dashboard/style.css":
/*!*********************************!*\
  !*** ./app/dashboard/style.css ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_M