/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.pdf.mapper.FunctionProviderBase;
import org.kuali.research.pdf.mapper.MapperFunction;
import org.kuali.research.pdf.mapper.MiscFunctions;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/kuali/research/pdf/mapper/MiscFunctions;", "Lorg/kuali/research/pdf/mapper/FunctionProviderBase;", "<init>", "()V", "Companion", "pdf"})
public class MiscFunctions
extends FunctionProviderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public MiscFunctions() {
        super("Miscellaneous");
    }

    @JvmStatic
    @MapperFunction(registeredName="trunc", description="\n        ex: #trunc(\"truncate a string\", 10) = \"truncate a\"\n        Truncate a string to a max length.\n        ")
    @Nullable
    public static final String trunc(@Nullable String input, int length) {
        return Companion.trunc(input, length);
    }

    @JvmStatic
    @MapperFunction(registeredName="mapVals", description="\n        ex: #mapVals(#sponsor.name, \"NIH\", \"National Institutes of Health (NIH)\",\n        \"NSF\", \"National Science Foundation (NSF)\", \"Select from drop down options\")\n        Map a value to a set of possible values allowed in the pdf field.  The last mapping value\n        will be used as a default if supplied and no other value matches.\n        ")
    @Nullable
    public static final String mapVals(@Nullable String actualValue, String ... mappings) {
        return Companion.mapVals(actualValue, mappings);
    }

    @JvmStatic
    @MapperFunction(registeredName="mapPatternVals", description="\n        ex: #mapPatternVals(#sponsor.name, \".*NIH.*\", \"National Institutes of Health (NIH)\",\n        \".*NSF.*|.*National Science Foundation.*\", \"National Science Foundation (NSF)\",\n        \"Select from drop down options\")\n        Map a value to a set of possible values allowed in the pdf field.  The last mapping value\n        will be used as a default if supplied and no other value matches.\n        ")
    @Nullable
    public static final String mapPatternVals(@Nullable String actualValue, String ... mappings) {
        return Companion.mapPatternVals(actualValue, mappings);
    }

    @JvmStatic
    @MapperFunction(registeredName="inSet", description="\n        ex: #inSet(#field, \"value1\", \"value2\", ...)\n        Tell whether this value is in the given set of strings.\n        ")
    public static final boolean inSet(@Nullable String needle, String ... haystack) {
        return Companion.inSet(needle, haystack);
    }

    @JvmStatic
    @MapperFunction(registeredName="inPatternSet", description="\n        ex: #inPatternSet(#field, \".*value1\", \"val.?ue2\", ...)\n        Tell whether this value matches any in the given set of patterns.\n        ")
    public static final boolean inPatternSet(@Nullable String needle, String ... haystack) {
        return Companion.inPatternSet(needle, haystack);
    }

    @JvmStatic
    @MapperFunction(registeredName="fullName", description="\n        ex: #fullName(#path.to.person, true) = \"Smith, Bob Ing\"\n        Takes an object that has the fields firstName, middleName, lastName and outputs a full name.\n        The second argument is whether to list the last name first.\n        ")
    @NotNull
    public static final String fullName(@Nullable Map<String, ?> person, boolean lastNameFirst) {
        return Companion.fullName(person, lastNameFirst);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J-\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\f\"\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\f\"\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\rJa\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\f26\u0010\u0010\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u0011H\u0002\u00a2\u0006\u0002\u0010\u0016J+\u0010\u0017\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\f\"\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u001aJ+\u0010\u001b\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\f\"\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u001aJ$\u0010\u001c\u001a\u00020\u00052\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0007\u00a8\u0006 "}, d2={"Lorg/kuali/research/pdf/mapper/MiscFunctions$Companion;", "", "<init>", "()V", "trunc", "", "input", "length", "", "mapVals", "actualValue", "mappings", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "mapPatternVals", "mapV", "mappingFun", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "mapping", "", "(Ljava/lang/String;[Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Ljava/lang/String;", "inSet", "needle", "haystack", "(Ljava/lang/String;[Ljava/lang/String;)Z", "inPatternSet", "fullName", "person", "", "lastNameFirst", "pdf"})
    @SourceDebugExtension(value={"SMAP\nMiscFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MiscFunctions.kt\norg/kuali/research/pdf/mapper/MiscFunctions$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1#2:131\n1563#3:132\n1634#3,3:133\n1761#3,3:136\n*S KotlinDebug\n*F\n+ 1 MiscFunctions.kt\norg/kuali/research/pdf/mapper/MiscFunctions$Companion\n*L\n104#1:132\n104#1:133,3\n104#1:136,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @MapperFunction(registeredName="trunc", description="\n        ex: #trunc(\"truncate a string\", 10) = \"truncate a\"\n        Truncate a string to a max length.\n        ")
        @Nullable
        public final String trunc(@Nullable String input, int length) {
            String string = input;
            return string != null && (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) != null ? StringsKt.take((String)string, (int)length) : null;
        }

        @JvmStatic
        @MapperFunction(registeredName="mapVals", description="\n        ex: #mapVals(#sponsor.name, \"NIH\", \"National Institutes of Health (NIH)\",\n        \"NSF\", \"National Science Foundation (NSF)\", \"Select from drop down options\")\n        Map a value to a set of possible values allowed in the pdf field.  The last mapping value\n        will be used as a default if supplied and no other value matches.\n        ")
        @Nullable
        public final String mapVals(@Nullable String actualValue, String ... mappings) {
            Intrinsics.checkNotNullParameter((Object)mappings, (String)"mappings");
            return this.mapV(actualValue, mappings, (Function2<? super String, ? super String, Boolean>)((Function2)mapVals.1.INSTANCE));
        }

        @JvmStatic
        @MapperFunction(registeredName="mapPatternVals", description="\n        ex: #mapPatternVals(#sponsor.name, \".*NIH.*\", \"National Institutes of Health (NIH)\",\n        \".*NSF.*|.*National Science Foundation.*\", \"National Science Foundation (NSF)\",\n        \"Select from drop down options\")\n        Map a value to a set of possible values allowed in the pdf field.  The last mapping value\n        will be used as a default if supplied and no other value matches.\n        ")
        @Nullable
        public final String mapPatternVals(@Nullable String actualValue, String ... mappings) {
            Intrinsics.checkNotNullParameter((Object)mappings, (String)"mappings");
            return this.mapV(actualValue, mappings, (Function2<? super String, ? super String, Boolean>)((Function2)Companion::mapPatternVals$lambda$0));
        }

        private final String mapV(String actualValue, String[] mappings, Function2<? super String, ? super String, Boolean> mappingFun) {
            if (actualValue != null) {
                String it = actualValue;
                boolean bl = false;
                for (int i = 0; i < mappings.length - 1; i += 2) {
                    if (!((Boolean)mappingFun.invoke((Object)actualValue, (Object)mappings[i])).booleanValue()) continue;
                    return mappings[i + 1];
                }
            }
            return mappings.length % 2 == 1 ? (String)ArraysKt.last((Object[])mappings) : null;
        }

        @JvmStatic
        @MapperFunction(registeredName="inSet", description="\n        ex: #inSet(#field, \"value1\", \"value2\", ...)\n        Tell whether this value is in the given set of strings.\n        ")
        public final boolean inSet(@Nullable String needle, String ... haystack) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)haystack, (String)"haystack");
            String string = needle;
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                bl = ArraysKt.toSet((Object[])haystack).contains(it);
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @MapperFunction(registeredName="inPatternSet", description="\n        ex: #inPatternSet(#field, \".*value1\", \"val.?ue2\", ...)\n        Tell whether this value matches any in the given set of patterns.\n        ")
        public final boolean inPatternSet(@Nullable String needle, String ... haystack) {
            boolean bl;
            block6: {
                Intrinsics.checkNotNullParameter((Object)haystack, (String)"haystack");
                String string = needle;
                if (string != null) {
                    void $this$any$iv;
                    void $this$mapTo$iv$iv;
                    String it = string;
                    boolean bl2 = false;
                    Iterable $this$map$iv = ArraysKt.toSet((Object[])haystack);
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        String string2 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(new Regex((String)it2));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Regex it3 = (Regex)element$iv;
                            boolean bl4 = false;
                            if (!it3.matches((CharSequence)needle)) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @MapperFunction(registeredName="fullName", description="\n        ex: #fullName(#path.to.person, true) = \"Smith, Bob Ing\"\n        Takes an object that has the fields firstName, middleName, lastName and outputs a full name.\n        The second argument is whether to list the last name first.\n        ")
        @NotNull
        public final String fullName(@Nullable Map<String, ?> person, boolean lastNameFirst) {
            String string;
            String string2;
            if (person == null) return "";
            Map<String, ?> p = person;
            boolean bl = false;
            if (lastNameFirst) {
                Object object;
                Object object2;
                Object object3 = p.get("lastName");
                if (object3 == null) {
                    object3 = "";
                }
                if ((object2 = p.get("firstName")) == null) {
                    object2 = "";
                }
                if ((object = p.get("middleName")) == null) {
                    object = "";
                }
                string2 = object3 + ", " + object2 + " " + object;
            } else {
                Object object;
                Object object4;
                Object object5 = p.get("firstName");
                if (object5 == null) {
                    object5 = "";
                }
                if ((object4 = p.get("middleName")) == null) {
                    object4 = "";
                }
                if ((object = p.get("lastName")) == null) {
                    object = "";
                }
                string2 = object5 + " " + object4 + " " + object;
            }
            if ((string = string2) == null) return "";
            String string3 = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (string3 == null) return "";
            String string4 = StringsKt.replace$default((String)string3, (String)"  ", (String)" ", (boolean)false, (int)4, null);
            if (string4 == null) return "";
            String string5 = string4;
            return string5;
        }

        private static final boolean mapPatternVals$lambda$0(String actualVal, String mappingPattern) {
            Intrinsics.checkNotNullParameter((Object)actualVal, (String)"actualVal");
            Intrinsics.checkNotNullParameter((Object)mappingPattern, (String)"mappingPattern");
            CharSequence charSequence = actualVal;
            return new Regex(mappingPattern).matches(charSequence);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

