/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.health;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.health.HealthController;
import org.kuali.research.pdf.health.HealthService;
import org.kuali.research.pdf.health.Service;
import org.kuali.research.pdf.health.ServiceIntegrity;
import org.kuali.research.pdf.health.Status;
import org.kuali.research.pdf.sys.rest.PdfController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@PdfController
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/kuali/research/pdf/health/HealthController;", "", "healthServices", "", "Lorg/kuali/research/pdf/health/HealthService;", "<init>", "(Ljava/util/List;)V", "getHealthServices", "()Ljava/util/List;", "checkHealth", "", "checkIntegrity", "Lorg/kuali/research/pdf/health/ServiceIntegrity;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "Companion", "pdf"})
@SourceDebugExtension(value={"SMAP\nHealthController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HealthController.kt\norg/kuali/research/pdf/health/HealthController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1193#2,2:51\n1267#2,4:53\n1761#2,3:57\n*S KotlinDebug\n*F\n+ 1 HealthController.kt\norg/kuali/research/pdf/health/HealthController\n*L\n36#1:51,2\n36#1:53,4\n40#1:57,3\n*E\n"})
public class HealthController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<HealthService> healthServices;
    @NotNull
    private static final Map<String, Service> NO_DEPENDANT_SERVICES = MapsKt.mapOf((Pair)TuplesKt.to((Object)"NO_DEPENDANT_SERVICES", (Object)new Service(Status.OK, "Running with no dependant services")));

    public HealthController(@Autowired @NotNull List<? extends HealthService> healthServices) {
        Intrinsics.checkNotNullParameter(healthServices, (String)"healthServices");
        this.healthServices = healthServices;
    }

    @NotNull
    public List<HealthService> getHealthServices() {
        return this.healthServices;
    }

    @GetMapping(value={"/health"})
    @ResponseStatus(value=HttpStatus.OK)
    public void checkHealth() {
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/health/integrity"}, produces={"application/json"})
    @NotNull
    public ServiceIntegrity checkIntegrity(@NotNull HttpServletRequest request) {
        boolean bl;
        Map statuses;
        block6: {
            Map map;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            if (this.getHealthServices().isEmpty()) {
                map = NO_DEPENDANT_SERVICES;
            } else {
                void $this$associateTo$iv$iv;
                Iterable $this$associate$iv = this.getHealthServices();
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable2 = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map2 = destination$iv$iv;
                    HealthService it = (HealthService)element$iv$iv;
                    boolean bl2 = false;
                    Pair pair = it.getStatus(request);
                    map2.put(pair.getFirst(), pair.getSecond());
                }
                map = destination$iv$iv;
            }
            statuses = map;
            Iterable $this$any$iv = statuses.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Service it = (Service)element$iv;
                    boolean bl3 = false;
                    if (!(it.getStatus() != Status.OK)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        Status overallStatus = bl ? Status.ERROR : Status.OK;
        return new ServiceIntegrity(overallStatus, statuses);
    }

    public static final /* synthetic */ Map access$getNO_DEPENDANT_SERVICES$cp() {
        return NO_DEPENDANT_SERVICES;
    }
}

