/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.mapper;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.pdf.mapper.FunctionProviderBase;
import org.kuali.research.pdf.mapper.MapperFunction;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/kuali/research/pdf/mapper/NumberFunctions;", "Lorg/kuali/research/pdf/mapper/FunctionProviderBase;", "<init>", "()V", "Companion", "pdf"})
public class NumberFunctions
extends FunctionProviderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final DecimalFormat DECIMAL_DISPLAY_FORMAT = new DecimalFormat("#,##0.00");

    public NumberFunctions() {
        super("Numbers");
    }

    @JvmStatic
    @MapperFunction(registeredName="simpleCurrency", description="\n        ex: #simpleCurrency(50000) = 50,000.00\n        Format a number to a decimal value with precision of 2 using a round up algorithm.\n        ")
    @NotNull
    public static final String simpleCurrency(@NotNull Object amount) {
        return Companion.simpleCurrency(amount);
    }

    @JvmStatic
    @MapperFunction(registeredName="formatCurrency", description="\n        ex: #formatCurrency(50000, 'en-US') = $50,000.00\n        Format a number to a currency value based on the provided IETF BCP 47 language tag string.\n        ")
    @NotNull
    public static final String formatCurrency(@Nullable Object amount, @NotNull String languageTag) {
        return Companion.formatCurrency(amount, languageTag);
    }

    @JvmStatic
    @MapperFunction(registeredName="sum", description="\n        ex: #sum(#subAwardAmountInfoList.![obligatedChangeDirect]) = 150000\n        Sum a set of values.  This function expects a collection of numeric values to sum and returns a BigDecimal\n        ")
    @NotNull
    public static final BigDecimal sum(@NotNull Iterable<? extends Object> amounts) {
        return Companion.sum(amounts);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0007J\u001a\u0010\t\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u0007H\u0007J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0001H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/kuali/research/pdf/mapper/NumberFunctions$Companion;", "", "<init>", "()V", "DECIMAL_DISPLAY_FORMAT", "Ljava/text/DecimalFormat;", "simpleCurrency", "", "amount", "formatCurrency", "languageTag", "sum", "Ljava/math/BigDecimal;", "amounts", "", "parseNumber", "pdf"})
    @SourceDebugExtension(value={"SMAP\nNumberFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberFunctions.kt\norg/kuali/research/pdf/mapper/NumberFunctions$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1#2:80\n1803#3,3:81\n*S KotlinDebug\n*F\n+ 1 NumberFunctions.kt\norg/kuali/research/pdf/mapper/NumberFunctions$Companion\n*L\n66#1:81,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @MapperFunction(registeredName="simpleCurrency", description="\n        ex: #simpleCurrency(50000) = 50,000.00\n        Format a number to a decimal value with precision of 2 using a round up algorithm.\n        ")
        @NotNull
        public final String simpleCurrency(@NotNull Object amount) {
            Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
            BigDecimal it = this.parseNumber(amount);
            boolean bl = false;
            String string = DECIMAL_DISPLAY_FORMAT.format(it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"let(...)");
            return string;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @MapperFunction(registeredName="formatCurrency", description="\n        ex: #formatCurrency(50000, 'en-US') = $50,000.00\n        Format a number to a currency value based on the provided IETF BCP 47 language tag string.\n        ")
        @NotNull
        public final String formatCurrency(@Nullable Object amount, @NotNull String languageTag) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)languageTag, (String)"languageTag");
            if (amount == null) return "";
            Object it = amount;
            boolean bl = false;
            BigDecimal bigDecimal = Companion.parseNumber(it);
            if (bigDecimal == null) return "";
            BigDecimal it2 = bigDecimal;
            boolean bl2 = false;
            CharSequence charSequence2 = languageTag;
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl3 = false;
                charSequence = "en-US";
            } else {
                charSequence = charSequence2;
            }
            Locale locale = Locale.forLanguageTag((String)charSequence);
            if (locale == null) return "";
            Locale locale2 = locale;
            boolean bl4 = false;
            String string = NumberFormat.getCurrencyInstance(locale2).format(it2);
            String string2 = string;
            if (string2 == null) return "";
            String string3 = string2;
            return string3;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @MapperFunction(registeredName="sum", description="\n        ex: #sum(#subAwardAmountInfoList.![obligatedChangeDirect]) = 150000\n        Sum a set of values.  This function expects a collection of numeric values to sum and returns a BigDecimal\n        ")
        @NotNull
        public final BigDecimal sum(@NotNull Iterable<? extends Object> amounts) {
            void $this$fold$iv;
            Intrinsics.checkNotNullParameter(amounts, (String)"amounts");
            Iterable<? extends Object> iterable2 = amounts;
            BigDecimal initial$iv = new BigDecimal(0);
            boolean $i$f$fold = false;
            BigDecimal accumulator$iv = initial$iv;
            Iterator iterator2 = $this$fold$iv.iterator();
            while (iterator2.hasNext()) {
                void amount;
                Object element$iv;
                Object t = element$iv = iterator2.next();
                BigDecimal sum = accumulator$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)sum.add(Companion.parseNumber(amount)), (String)"add(...)");
            }
            return accumulator$iv;
        }

        private final BigDecimal parseNumber(Object amount) {
            BigDecimal bigDecimal;
            Object object = amount;
            if (object instanceof Integer) {
                BigDecimal bigDecimal2 = BigDecimal.valueOf(((Number)amount).intValue());
                bigDecimal = bigDecimal2;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(...)");
            } else if (object instanceof Long) {
                BigDecimal bigDecimal3 = BigDecimal.valueOf(((Number)amount).longValue());
                bigDecimal = bigDecimal3;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"valueOf(...)");
            } else if (object instanceof Double) {
                bigDecimal = new BigDecimal(String.valueOf(((Number)amount).doubleValue()));
            } else if (object instanceof Float) {
                bigDecimal = new BigDecimal(String.valueOf(((Number)amount).floatValue()));
            } else if (object instanceof BigDecimal) {
                bigDecimal = (BigDecimal)amount;
            } else {
                throw new IllegalArgumentException("Unable to parse " + amount + " as number");
            }
            return bigDecimal;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

