/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.health.auth;

import jakarta.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.health.HealthService;
import org.kuali.research.pdf.health.Service;
import org.kuali.research.pdf.health.Status;
import org.kuali.research.pdf.sys.extensions.ServletExtensionsKt;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.client.RestTemplate;

@org.springframework.stereotype.Service
@ConditionalOnProperty(name={"auth.enabled"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/kuali/research/pdf/health/auth/HealthServiceAuthImpl;", "Lorg/kuali/research/pdf/health/HealthService;", "Lorg/apache/logging/log4j/kotlin/Logging;", "baseUrl", "", "healthUrl", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/springframework/web/client/RestTemplate;)V", "getStatus", "Lkotlin/Pair;", "Lorg/kuali/research/pdf/health/Service;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "isConnected", "", "pdf"})
public class HealthServiceAuthImpl
implements HealthService,
Logging {
    @NotNull
    private final String baseUrl;
    @NotNull
    private final String healthUrl;
    @NotNull
    private final RestTemplate restTemplate;

    public HealthServiceAuthImpl(@Value(value="${auth.baseUrl:}") @NotNull String baseUrl, @Value(value="${auth.healthUrl}") @NotNull String healthUrl, @Autowired @NotNull RestTemplate restTemplate) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)healthUrl, (String)"healthUrl");
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        this.baseUrl = baseUrl;
        this.healthUrl = healthUrl;
        this.restTemplate = restTemplate;
    }

    @NotNull
    public Pair<String, Service> getStatus(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Service service = this.isConnected(ServletExtensionsKt.baseOrCurrentUrl((HttpServletRequest)request, (String)this.baseUrl) + this.healthUrl, this.restTemplate) ? new Service(Status.OK, "Core Auth is up") : new Service(Status.ERROR, "Core Auth is down");
        return new Pair((Object)"Core Auth", (Object)service);
    }

    private boolean isConnected(String healthUrl, RestTemplate restTemplate) {
        boolean bl;
        try {
            bl = restTemplate.getForEntity(healthUrl, Void.class, new Object[0]).getStatusCode().is2xxSuccessful();
        }
        catch (Throwable e) {
            KotlinLogger kotlinLogger = this.getLogger();
            String string = e.getMessage();
            if (string == null) {
                string = "unknown";
            }
            kotlinLogger.error((CharSequence)string, e);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }
}

