/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.concat;

import com.itextpdf.commons.exceptions.ITextException;
import com.itextpdf.forms.PdfPageFormCopier;
import com.itextpdf.io.exceptions.IOException;
import com.itextpdf.kernel.exceptions.BadPasswordException;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.IPdfPageExtraCopier;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfWriter;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.action.Action;
import org.kuali.research.pdf.action.ActionHelperService;
import org.kuali.research.pdf.action.ActionService;
import org.kuali.research.pdf.concat.ConcatAction;
import org.kuali.research.pdf.link.ActionLink;
import org.kuali.research.pdf.link.ActionLinkInitFinalizeService;
import org.kuali.research.pdf.link.Link;
import org.kuali.research.pdf.link.LinkService;
import org.kuali.research.pdf.sys.extensions.ItextExtensionsKt;
import org.kuali.research.pdf.sys.model.Message;
import org.kuali.research.pdf.sys.model.Props;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B%\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/kuali/research/pdf/concat/ConcatActionServiceImpl;", "Lorg/kuali/research/pdf/action/ActionService;", "Lorg/kuali/research/pdf/concat/ConcatAction;", "Lorg/apache/logging/log4j/kotlin/Logging;", "actionHelperService", "Lorg/kuali/research/pdf/action/ActionHelperService;", "linkService", "Lorg/kuali/research/pdf/link/LinkService;", "actionLinkInitFinalizeService", "Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;", "<init>", "(Lorg/kuali/research/pdf/action/ActionHelperService;Lorg/kuali/research/pdf/link/LinkService;Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;)V", "getActionHelperService", "()Lorg/kuali/research/pdf/action/ActionHelperService;", "getLinkService", "()Lorg/kuali/research/pdf/link/LinkService;", "getActionLinkInitFinalizeService", "()Lorg/kuali/research/pdf/link/ActionLinkInitFinalizeService;", "init", "action", "exec", "finalize", "pdf"})
@SourceDebugExtension(value={"SMAP\nConcatActionServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcatActionServiceImpl.kt\norg/kuali/research/pdf/concat/ConcatActionServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n1563#2:200\n1634#2,3:201\n1869#2:204\n774#2:205\n865#2,2:206\n1563#2:208\n1634#2,3:209\n1870#2:212\n1788#2,4:213\n1563#2:217\n1634#2,3:218\n*S KotlinDebug\n*F\n+ 1 ConcatActionServiceImpl.kt\norg/kuali/research/pdf/concat/ConcatActionServiceImpl\n*L\n44#1:200\n44#1:201,3\n96#1:204\n118#1:205\n118#1:206,2\n121#1:208\n121#1:209,3\n96#1:212\n166#1:213,4\n183#1:217\n183#1:218,3\n*E\n"})
public class ConcatActionServiceImpl
implements ActionService<ConcatAction>,
Logging {
    @NotNull
    private final ActionHelperService actionHelperService;
    @NotNull
    private final LinkService linkService;
    @NotNull
    private final ActionLinkInitFinalizeService actionLinkInitFinalizeService;

    public ConcatActionServiceImpl(@Autowired @NotNull ActionHelperService actionHelperService, @Autowired @NotNull LinkService linkService, @Autowired @NotNull ActionLinkInitFinalizeService actionLinkInitFinalizeService) {
        Intrinsics.checkNotNullParameter((Object)actionHelperService, (String)"actionHelperService");
        Intrinsics.checkNotNullParameter((Object)linkService, (String)"linkService");
        Intrinsics.checkNotNullParameter((Object)actionLinkInitFinalizeService, (String)"actionLinkInitFinalizeService");
        this.actionHelperService = actionHelperService;
        this.linkService = linkService;
        this.actionLinkInitFinalizeService = actionLinkInitFinalizeService;
    }

    @NotNull
    public ActionHelperService getActionHelperService() {
        return this.actionHelperService;
    }

    @NotNull
    public LinkService getLinkService() {
        return this.linkService;
    }

    @NotNull
    public ActionLinkInitFinalizeService getActionLinkInitFinalizeService() {
        return this.actionLinkInitFinalizeService;
    }

    @Override
    @NotNull
    public ConcatAction init(@NotNull ConcatAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (ConcatAction)this.getActionHelperService().initManual((Action)action, arg_0 -> ConcatActionServiceImpl.init$lambda$1(this, arg_0));
    }

    @Override
    @NotNull
    public ConcatAction exec(@NotNull ConcatAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (ConcatAction)this.getActionHelperService().execManual((Action)action, arg_0 -> ConcatActionServiceImpl.exec$lambda$10(this, action, arg_0));
    }

    @Override
    @NotNull
    public ConcatAction finalize(@NotNull ConcatAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return (ConcatAction)this.getActionHelperService().finalizeManual((Action)action, arg_0 -> ConcatActionServiceImpl.finalize$lambda$12(this, arg_0));
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }

    /*
     * WARNING - void declaration
     */
    private static final ConcatAction init$lambda$1(ConcatActionServiceImpl this$0, ConcatAction executingAction) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        Iterable $this$map$iv = executingAction.getSource();
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Link link = (Link)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().init((ActionLink)it, executingAction) : it);
        }
        List source = (List)destination$iv$iv;
        Link target = executingAction.getTarget() instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().init((ActionLink)executingAction.getTarget(), executingAction) : executingAction.getTarget();
        return ConcatAction.copy$default(executingAction, null, null, source, target, null, null, null, 115, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final ConcatAction exec$lambda$10(ConcatActionServiceImpl this$0, ConcatAction $action, ConcatAction executingAction) {
        ConcatAction concatAction;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        if (executingAction.getSource().isEmpty()) {
            concatAction = ConcatAction.copy$default(executingAction, null, null, null, null, null, null, CollectionsKt.plus((Collection)executingAction.getMessages(), (Object)Message.Companion.error("The " + executingAction.getName() + " action does not have a source.", "source.missing", MapsKt.mapOf(Props.ACTION_NAME.pair(executingAction.getName())))), 63, null);
        } else {
            int n;
            void $this$count$iv;
            Object writer;
            Object object;
            List executedMessages = CollectionsKt.toMutableList((Collection)executingAction.getMessages());
            if (executingAction.getSource().size() == 1) {
                ((Collection)executedMessages).add(Message.Companion.warn("The " + executingAction.getName() + " action only has a single source pdf.", "source.single.pdf", MapsKt.mapOf(Props.ACTION_NAME.pair(executingAction.getName()))));
            }
            LinkService linkService = this$0.getLinkService();
            Link link = executingAction.getTarget();
            String string = executingAction.getJobId();
            Intrinsics.checkNotNull((Object)string);
            String string2 = executingAction.getActionId();
            Intrinsics.checkNotNull((Object)string2);
            Link resolvedTarget = linkService.newIfNull(link, string, string2, "0");
            try {
                Closeable closeable = (Closeable)new PdfWriter(this$0.getLinkService().output(resolvedTarget));
                object = null;
                try {
                    writer = (PdfWriter)closeable;
                    boolean bl = false;
                    writer.setSmartMode(true);
                    Closeable closeable2 = (Closeable)new PdfDocument(writer, (DocumentProperties)this$0.getActionHelperService().getDocumentProperties($action));
                    Throwable throwable = null;
                    try {
                        PdfDocument document = (PdfDocument)closeable2;
                        boolean bl2 = false;
                        document.initializeOutlines();
                        Iterable $this$forEach$iv = executingAction.getSource();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Pair[] pairArray;
                            Object object2;
                            Link link2 = (Link)element$iv;
                            boolean bl3 = false;
                            try {
                                Closeable closeable3 = (Closeable)new PdfReader(this$0.getLinkService().input(link2));
                                object2 = null;
                                try {
                                    PdfReader reader = (PdfReader)closeable3;
                                    boolean bl4 = false;
                                    Closeable closeable4 = (Closeable)new PdfDocument(reader, (DocumentProperties)this$0.getActionHelperService().getDocumentProperties($action));
                                    Throwable throwable2 = null;
                                    try {
                                        PdfDocument sourceDoc = (PdfDocument)closeable4;
                                        boolean bl5 = false;
                                        if (reader.isEncrypted()) {
                                            ((Collection)executedMessages).add(Message.Companion.error("The source pdf is encrypted.", "source.encrypted", MapsKt.mapOf(Props.ACTION_NAME.pair(executingAction.getName()))));
                                        } else {
                                            void $this$mapTo$iv$iv;
                                            void $this$filterTo$iv$iv;
                                            sourceDoc.copyPagesTo(1, sourceDoc.getNumberOfPages(), document, (IPdfPageExtraCopier)new PdfPageFormCopier());
                                            Map sourceFiles = sourceDoc.getCatalog().getNameTree(PdfName.EmbeddedFiles).getNames();
                                            Map targetFiles = document.getCatalog().getNameTree(PdfName.EmbeddedFiles).getNames();
                                            Iterable $this$filter$iv = targetFiles.keySet();
                                            boolean $i$f$filter = false;
                                            Iterable iterable2 = $this$filter$iv;
                                            Iterable destination$iv$iv = new ArrayList();
                                            boolean $i$f$filterTo = false;
                                            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                                PdfString it = (PdfString)element$iv$iv;
                                                boolean bl6 = false;
                                                if (!sourceFiles.keySet().contains(it)) continue;
                                                destination$iv$iv.add(element$iv$iv);
                                            }
                                            List existing = (List)destination$iv$iv;
                                            Collection collection = executedMessages;
                                            Iterable $this$map$iv = existing;
                                            boolean $i$f$map = false;
                                            destination$iv$iv = $this$map$iv;
                                            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                            boolean $i$f$mapTo = false;
                                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                                void it;
                                                PdfString bl6 = (PdfString)item$iv$iv;
                                                Collection collection2 = destination$iv$iv2;
                                                boolean bl7 = false;
                                                String string3 = "The " + executingAction.getName() + " action contains multiple source pdf documents with a duplicate attachment key [" + (PdfString)it + "].";
                                                Pair[] pairArray2 = new Pair[2];
                                                pairArray2[0] = Props.ACTION_NAME.pair(executingAction.getName());
                                                Intrinsics.checkNotNull((Object)it);
                                                pairArray2[1] = Props.ATTACHMENT_KEY.pair(it);
                                                collection2.add(Message.Companion.warn(string3, "attachment.key.duplicate", MapsKt.mapOf((Pair[])pairArray2)));
                                            }
                                            Iterable iterable3 = (List)destination$iv$iv2;
                                            CollectionsKt.addAll((Collection)collection, (Iterable)iterable3);
                                            ItextExtensionsKt.copyAttachmentsTo(sourceDoc, document);
                                        }
                                        Unit unit = Unit.INSTANCE;
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2 = throwable3;
                                        throw throwable3;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)closeable4, (Throwable)throwable2);
                                    }
                                    pairArray = Unit.INSTANCE;
                                }
                                catch (Throwable throwable4) {
                                    object2 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)object2);
                                }
                            }
                            catch (BadPasswordException e) {
                                this$0.getLogger().debug((Object)e);
                                object2 = executedMessages;
                                pairArray = new Pair[]{Props.ACTION_NAME.pair(executingAction.getName()), Props.URL.pair(link2.getUrl())};
                                pairArray = Message.Companion.error("The source pdf is encrypted.", "source.encrypted", MapsKt.mapOf((Pair[])pairArray));
                                object2.add(pairArray);
                            }
                            catch (IOException e) {
                                this$0.getLogger().debug((Object)e);
                                object2 = executedMessages;
                                pairArray = new Pair[]{Props.ACTION_NAME.pair(executingAction.getName()), Props.URL.pair(link2.getUrl())};
                                pairArray = Message.Companion.warn("The source pdf is not a valid pdf.", "source.not.valid", MapsKt.mapOf((Pair[])pairArray));
                                object2.add(pairArray);
                            }
                        }
                        document = Unit.INSTANCE;
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                    }
                    writer = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
            }
            catch (ITextException e) {
                this$0.getLogger().error((CharSequence)("Action " + executingAction.getName() + " " + executingAction.getActionId() + " failed"), (Throwable)e);
                object = executedMessages;
                String string4 = e.getMessage();
                if (string4 == null) {
                    string4 = "unknown";
                }
                writer = Message.Companion.error(string4, "unknown.error", MapsKt.mapOf(Props.ACTION_NAME.pair(executingAction.getName())));
                object.add(writer);
            }
            Iterable e = executedMessages;
            int n2 = executingAction.getSource().size();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v7 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Message m = (Message)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)m.getKey(), (Object)"source.not.valid") || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v7 = n = count$iv;
            }
            if (n2 == n) {
                ((Collection)executedMessages).add(Message.Companion.error("All source pdfs are not valid pdfs.", "all.source.not.valid", MapsKt.mapOf(Props.ACTION_NAME.pair(executingAction.getName()))));
            }
            concatAction = ConcatAction.copy$default(executingAction, null, null, null, resolvedTarget, null, null, executedMessages, 55, null);
        }
        return concatAction;
    }

    /*
     * WARNING - void declaration
     */
    private static final ConcatAction finalize$lambda$12(ConcatActionServiceImpl this$0, ConcatAction executingAction) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)executingAction, (String)"executingAction");
        Iterable $this$map$iv = executingAction.getSource();
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Link link = (Link)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().finalize((ActionLink)it, executingAction) : it);
        }
        List source = (List)destination$iv$iv;
        Link target = executingAction.getTarget() instanceof ActionLink ? this$0.getActionLinkInitFinalizeService().finalize((ActionLink)executingAction.getTarget(), executingAction) : executingAction.getTarget();
        return ConcatAction.copy$default(executingAction, null, null, source, target, null, null, null, 115, null);
    }
}

