/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.health.mongo;

import com.mongodb.BasicDBObject;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.health.HealthService;
import org.kuali.research.pdf.health.Service;
import org.kuali.research.pdf.health.Status;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.mongodb.core.MongoTemplate;

@org.springframework.stereotype.Service
@ConditionalOnProperty(name={"mongo.enabled"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0012R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/kuali/research/pdf/health/mongo/HealthServiceMongoImpl;", "Lorg/kuali/research/pdf/health/HealthService;", "Lorg/apache/logging/log4j/kotlin/Logging;", "mongoTemplate", "Lorg/springframework/data/mongodb/core/MongoTemplate;", "<init>", "(Lorg/springframework/data/mongodb/core/MongoTemplate;)V", "getMongoTemplate", "()Lorg/springframework/data/mongodb/core/MongoTemplate;", "getStatus", "Lkotlin/Pair;", "", "Lorg/kuali/research/pdf/health/Service;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "isConnected", "", "pdf"})
public class HealthServiceMongoImpl
implements HealthService,
Logging {
    @NotNull
    private final MongoTemplate mongoTemplate;

    public HealthServiceMongoImpl(@Autowired @NotNull MongoTemplate mongoTemplate) {
        Intrinsics.checkNotNullParameter((Object)mongoTemplate, (String)"mongoTemplate");
        this.mongoTemplate = mongoTemplate;
    }

    @NotNull
    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    @Override
    @NotNull
    public Pair<String, Service> getStatus(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Service service = this.isConnected() ? new Service(Status.OK, "Mongo is up") : new Service(Status.ERROR, "Mongo is down");
        return new Pair((Object)"Mongo", (Object)service);
    }

    private boolean isConnected() {
        boolean bl;
        try {
            BasicDBObject ping = new BasicDBObject("ping", (Object)"1");
            Document document = this.getMongoTemplate().getDb().runCommand((Bson)ping);
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"runCommand(...)");
            Document answer = document;
            Collection collection = answer.values();
            bl = !(collection == null || collection.isEmpty());
        }
        catch (Throwable e) {
            KotlinLogger kotlinLogger = this.getLogger();
            String string = e.getMessage();
            if (string == null) {
                string = "unknown";
            }
            kotlinLogger.error((CharSequence)string, e);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }
}

