/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.health.s3;

import jakarta.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.health.HealthService;
import org.kuali.research.pdf.health.Service;
import org.kuali.research.pdf.health.Status;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;

@org.springframework.stereotype.Service
@ConditionalOnProperty(name={"aws.s3.enabled"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0012R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/kuali/research/pdf/health/s3/HealthServiceS3Impl;", "Lorg/kuali/research/pdf/health/HealthService;", "Lorg/apache/logging/log4j/kotlin/Logging;", "s3Client", "Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "<init>", "(Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;)V", "getS3Client", "()Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "getStatus", "Lkotlin/Pair;", "", "Lorg/kuali/research/pdf/health/Service;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "isConnected", "", "pdf"})
public class HealthServiceS3Impl
implements HealthService,
Logging {
    @NotNull
    private final S3AsyncClient s3Client;

    public HealthServiceS3Impl(@Autowired @NotNull S3AsyncClient s3Client) {
        Intrinsics.checkNotNullParameter((Object)s3Client, (String)"s3Client");
        this.s3Client = s3Client;
    }

    @NotNull
    public S3AsyncClient getS3Client() {
        return this.s3Client;
    }

    @Override
    @NotNull
    public Pair<String, Service> getStatus(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Service service = this.isConnected() ? new Service(Status.OK, "S3 is up") : new Service(Status.ERROR, "S3 is down");
        return new Pair((Object)"S3", (Object)service);
    }

    private boolean isConnected() {
        boolean bl;
        try {
            ((ListBucketsResponse)this.getS3Client().listBuckets().get()).sdkHttpResponse().isSuccessful();
            bl = true;
        }
        catch (Throwable e) {
            KotlinLogger kotlinLogger = this.getLogger();
            String string = e.getMessage();
            if (string == null) {
                string = "unknown";
            }
            kotlinLogger.error((CharSequence)string, e);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }
}

