/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.link.s3;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.link.s3.S3Service;
import org.owasp.fileio.SafeFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedGetObjectRequest;

@Service
@ConditionalOnProperty(name={"aws.s3.enabled"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B%\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0017J\b\u0010\u001a\u001a\u00020\u0015H\u0012J\b\u0010\u001b\u001a\u00020\u0015H\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lorg/kuali/research/pdf/link/s3/S3ServiceImpl;", "Lorg/kuali/research/pdf/link/s3/S3Service;", "s3Client", "Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "bucket", "", "expiration", "", "<init>", "(Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;Ljava/lang/String;J)V", "getS3Client", "()Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "getBucket", "()Ljava/lang/String;", "getExpiration", "()J", "createBucketAttempted", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getCreateBucketAttempted", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "put", "", "id", "file", "Lorg/owasp/fileio/SafeFile;", "presignedUrlForRead", "createBucket", "preconditions", "pdf"})
public class S3ServiceImpl
implements S3Service {
    @NotNull
    private final S3AsyncClient s3Client;
    @NotNull
    private final String bucket;
    private final long expiration;
    @NotNull
    private final AtomicBoolean createBucketAttempted;

    public S3ServiceImpl(@Autowired @NotNull S3AsyncClient s3Client, @Value(value="${aws.s3.bucket}") @NotNull String bucket, @Value(value="${aws.s3.file.url.expiration.ms}") long expiration) {
        Intrinsics.checkNotNullParameter((Object)s3Client, (String)"s3Client");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        this.s3Client = s3Client;
        this.bucket = bucket;
        this.expiration = expiration;
        this.createBucketAttempted = new AtomicBoolean(false);
    }

    @NotNull
    public S3AsyncClient getS3Client() {
        return this.s3Client;
    }

    @NotNull
    public String getBucket() {
        return this.bucket;
    }

    public long getExpiration() {
        return this.expiration;
    }

    @NotNull
    public AtomicBoolean getCreateBucketAttempted() {
        return this.createBucketAttempted;
    }

    @Override
    public void put(@NotNull String id, @NotNull SafeFile file) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.preconditions();
        this.getS3Client().putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.getBucket()).key(id).build(), file.toPath()).get();
    }

    @Override
    @Cacheable(value={"presignedUrlForRead"})
    @NotNull
    public String presignedUrlForRead(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        S3Presigner presigner = S3Presigner.create();
        GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.getBucket()).key(id).build();
        GetObjectPresignRequest getObjectPresignRequest = GetObjectPresignRequest.builder().signatureDuration(Duration.ofMillis(this.getExpiration())).getObjectRequest(getObjectRequest).build();
        PresignedGetObjectRequest presignedGetObjectRequest = presigner.presignGetObject(getObjectPresignRequest);
        String string = presignedGetObjectRequest.url().toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
        return string;
    }

    private void createBucket() {
        HeadBucketResponse headBucketResponse = (HeadBucketResponse)this.getS3Client().headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(this.getBucket()).build()).get();
        if (headBucketResponse.sdkHttpResponse().statusCode() == HttpStatus.NOT_FOUND.value()) {
            this.getS3Client().createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(this.getBucket()).build()).get();
        }
    }

    private void preconditions() {
        if (this.getCreateBucketAttempted().compareAndSet(false, true)) {
            this.createBucket();
        }
    }
}

