/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.mapper;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.pdf.mapper.AddressFunctions;
import org.kuali.research.pdf.mapper.FunctionProviderBase;
import org.kuali.research.pdf.mapper.MapperFunction;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/kuali/research/pdf/mapper/AddressFunctions;", "Lorg/kuali/research/pdf/mapper/FunctionProviderBase;", "<init>", "()V", "Companion", "pdf"})
public class AddressFunctions
extends FunctionProviderBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public AddressFunctions() {
        super("Addresses");
    }

    @JvmStatic
    @MapperFunction(registeredName="formatState", description="\n        ex: #formatState(\"#stateField\") = \"AZ: Arizona\"  \n        Format a state according to the StateCodeDataType format in the global library V2.  \n        The state value is expected to be a map with code and description as follows: \n        state[\\\"code\\\"] = 'AZ', state[\\\"description\\\"] = 'ARIZONA'.\n        ")
    @NotNull
    public static final String formatState(@NotNull Map<String, String> state) {
        return Companion.formatState(state);
    }

    @JvmStatic
    @MapperFunction(registeredName="formatCountry", description="\n        ex: #formatCountry(\"#countryField\") = \"USA: UNITED STATES\"  \n        Format a country according to the CountryCodeDataType format in the global library V2.  \n        The country value is expected to be a map with code and description as follows: \n        country[\\\"code\\\"] = 'USA', country[\\\"description\\\"] = 'UNITED STATES'.\n        ")
    @NotNull
    public static final String formatCountry(@NotNull Map<String, String> country) {
        return Companion.formatCountry(country);
    }

    @JvmStatic
    @MapperFunction(registeredName="formatAddress", description="\n        ex: #formatAddress(#addressable.object, false) = \"1234 Street, city state postalCode\"\n        Format an object that contains the following fields: addressLine1, addressLine2, addressLine3, city,\n        state, postalCode.  The second argument determines whether the address will span multiple lines.\n        ")
    @NotNull
    public static final String formatAddress(@Nullable Map<String, ?> addressObject, boolean multiline) {
        return Companion.formatAddress(addressObject, multiline);
    }
}

