/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.sys.auth;

import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.SignedJWT;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.sys.auth.AuthKt;
import org.kuali.research.pdf.sys.auth.AuthTokenResponse;
import org.kuali.research.pdf.sys.auth.AuthUser;
import org.kuali.research.pdf.sys.extensions.CoreExtensionsKt;
import org.kuali.research.pdf.sys.extensions.ServletExtensionsKt;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;

@Component
@ConditionalOnProperty(name={"auth.enabled"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\b\u0017\u0018\u00002\u00020\u0001Bc\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0004\u0012\b\b\u0001\u0010\b\u001a\u00020\u0004\u0012\b\b\u0001\u0010\t\u001a\u00020\u0004\u0012\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0001\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u001a\u0010\u0019\u001a\u00020\u00102\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0004H\u0012J\u0018\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J!\u0010\"\u001a\u0013\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b$\u0012\u0004\u0012\u00020%0#2\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\u0018\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0012J(\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.H\u0012R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/kuali/research/pdf/sys/auth/AuthFilter;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "service2serviceSecrets", "", "", "baseUrl", "currentUserUrl", "authorizeUrl", "tokenUrl", "appName", "excludedUrls", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "<init>", "(Ljava/util/Set;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Lorg/springframework/web/client/RestTemplate;)V", "shouldNotFilter", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "doFilterInternal", "", "response", "Ljakarta/servlet/http/HttpServletResponse;", "filterChain", "Ljakarta/servlet/FilterChain;", "validateToken", "authToken", "validateJwt", "tokenBody", "validateCoreToken", "validateOauthReturnAndFetchCode", "fetchTokenFromCode", "Lorg/kuali/research/pdf/sys/auth/AuthTokenResponse;", "code", "getOauthRedirectUrlAndCookie", "Lkotlin/Pair;", "Lkotlin/jvm/internal/EnhancedNullability;", "Ljakarta/servlet/http/Cookie;", "hashToken", "token", "context", "createCookie", "cookieName", "httpRequest", "cookieValue", "maxAge", "", "pdf"})
@SourceDebugExtension(value={"SMAP\nAuth.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Auth.kt\norg/kuali/research/pdf/sys/auth/AuthFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,295:1\n1761#2,3:296\n1563#2:300\n1634#2,3:301\n1761#2,3:304\n1#3:299\n*S KotlinDebug\n*F\n+ 1 Auth.kt\norg/kuali/research/pdf/sys/auth/AuthFilter\n*L\n107#1:296,3\n166#1:300\n166#1:301,3\n167#1:304,3\n*E\n"})
public class AuthFilter
extends OncePerRequestFilter {
    @NotNull
    private final Set<String> service2serviceSecrets;
    @NotNull
    private final String baseUrl;
    @NotNull
    private final String currentUserUrl;
    @NotNull
    private final String authorizeUrl;
    @NotNull
    private final String tokenUrl;
    @NotNull
    private final String appName;
    @NotNull
    private final Set<String> excludedUrls;
    @NotNull
    private final RestTemplate restTemplate;

    public AuthFilter(@Value(value="${auth.service2service.secrets}") @NotNull Set<String> service2serviceSecrets, @Value(value="${auth.baseUrl:}") @NotNull String baseUrl, @Value(value="${auth.currentUserUrl}") @NotNull String currentUserUrl, @Value(value="${auth.authorizeUrl}") @NotNull String authorizeUrl, @Value(value="${auth.tokenUrl}") @NotNull String tokenUrl, @Value(value="${spring.application.name}") @NotNull String appName, @Value(value="${auth.excludedUrls:/pdf/actuator/health.*,/pdf/swagger/.*,/pdf/webjars/.*}") @NotNull Set<String> excludedUrls, @Autowired @NotNull RestTemplate restTemplate) {
        Intrinsics.checkNotNullParameter(service2serviceSecrets, (String)"service2serviceSecrets");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)currentUserUrl, (String)"currentUserUrl");
        Intrinsics.checkNotNullParameter((Object)authorizeUrl, (String)"authorizeUrl");
        Intrinsics.checkNotNullParameter((Object)tokenUrl, (String)"tokenUrl");
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        Intrinsics.checkNotNullParameter(excludedUrls, (String)"excludedUrls");
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        this.service2serviceSecrets = service2serviceSecrets;
        this.baseUrl = baseUrl;
        this.currentUserUrl = currentUserUrl;
        this.authorizeUrl = authorizeUrl;
        this.tokenUrl = tokenUrl;
        this.appName = appName;
        this.excludedUrls = excludedUrls;
        this.restTemplate = restTemplate;
    }

    protected boolean shouldNotFilter(@NotNull HttpServletRequest request) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Iterable $this$any$iv = this.excludedUrls;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = request.getRequestURI();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestURI(...)");
                    CharSequence charSequence = string;
                    if (!new Regex(it).matches(charSequence)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)filterChain, (String)"filterChain");
        this.logger.trace((Object)"AuthFilter called");
        String authToken = AuthKt.access$authToken((HttpServletRequest)request);
        if (this.validateToken(authToken, request)) {
            this.logger.trace((Object)("Token validated: " + authToken));
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else if (AuthKt.access$isOauthReturn((HttpServletRequest)request)) {
            Pair pair;
            String string = this.validateOauthReturnAndFetchCode(request);
            if (string != null) {
                String code = string;
                boolean bl = false;
                AuthTokenResponse authTokenResponse = this.fetchTokenFromCode(code, request);
                if (authTokenResponse != null) {
                    AuthTokenResponse authToken2 = authTokenResponse;
                    boolean bl2 = false;
                    String string2 = authToken2.getAuthToken();
                    Intrinsics.checkNotNull((Object)string2);
                    response.addCookie(this.createCookie("authToken", request, string2, -1));
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
            }
            Pair it = pair = this.getOauthRedirectUrlAndCookie(request);
            boolean bl = false;
            response.addCookie((Cookie)it.getSecond());
            response.sendRedirect((String)it.getFirst());
        } else if (ServletExtensionsKt.isApi((HttpServletRequest)request)) {
            response.sendError(403);
        } else {
            Pair pair;
            Pair it = pair = this.getOauthRedirectUrlAndCookie(request);
            boolean bl = false;
            response.addCookie(this.createCookie("authToken", request, "", 0));
            response.addCookie((Cookie)it.getSecond());
            response.sendRedirect((String)it.getFirst());
        }
    }

    private boolean validateToken(String authToken, HttpServletRequest request) {
        boolean bl;
        try {
            boolean bl2;
            String string = authToken;
            if (string != null) {
                String it = string;
                boolean bl3 = false;
                bl2 = this.validateJwt(it) || this.validateCoreToken(it, request);
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        catch (KeyLengthException e) {
            this.logger.error((Object)"The service2service secret provided is too short", (Throwable)e);
            bl = false;
        }
        catch (Exception e) {
            this.logger.debug((Object)("Failed to validate token: " + authToken), (Throwable)e);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private boolean validateJwt(String tokenBody) {
        boolean bl;
        try {
            boolean bl2;
            block6: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.service2serviceSecrets;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(SignedJWT.parse((String)tokenBody).verify((JWSVerifier)new MACVerifier((String)it)));
                }
                Iterable $this$any$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean v = (Boolean)element$iv;
                        boolean bl4 = false;
                        if (!v) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        catch (ParseException e) {
            this.logger.debug((Object)("Failed to parse token as jwt: " + tokenBody), (Throwable)e);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Cacheable(value={"coreAuthUsers"}, key="tokenBody")
    public boolean validateCoreToken(@NotNull String tokenBody, @NotNull HttpServletRequest request) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)tokenBody, (String)"tokenBody");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            void $this$validateCoreToken_u24lambda_u248;
            HttpHeaders httpHeaders;
            HttpHeaders httpHeaders2 = httpHeaders = new HttpHeaders();
            HttpMethod httpMethod = HttpMethod.GET;
            String string = ServletExtensionsKt.baseOrCurrentUrl((HttpServletRequest)request, (String)this.baseUrl) + "/" + StringsKt.removePrefix((String)this.currentUserUrl, (CharSequence)"/");
            RestTemplate restTemplate = this.restTemplate;
            boolean bl2 = false;
            $this$validateCoreToken_u24lambda_u248.set("Authorization", CoreExtensionsKt.ensurePrefix((String)tokenBody, (String)"Bearer "));
            Unit unit = Unit.INSTANCE;
            MultiValueMap multiValueMap = (MultiValueMap)httpHeaders;
            ResponseEntity $this$validateCoreToken_u24lambda_u249 = restTemplate.exchange(string, httpMethod, new HttpEntity(multiValueMap), AuthUser.class, new Object[0]);
            boolean bl3 = false;
            this.logger.debug((Object)("User authenticated by core: " + $this$validateCoreToken_u24lambda_u249));
            bl = $this$validateCoreToken_u24lambda_u249.getBody() != null;
        }
        catch (Exception e) {
            this.logger.debug((Object)("Failed to validate core token: " + tokenBody), (Throwable)e);
            bl = false;
        }
        return bl;
    }

    private String validateOauthReturnAndFetchCode(HttpServletRequest request) {
        String string;
        Object object = ServletExtensionsKt.cookie((HttpServletRequest)request, (String)"pdfAuthToken");
        if (object != null && (object = object.getValue()) != null) {
            Object savedHash = object;
            boolean bl = false;
            this.logger.debug((Object)("pdf cookie value: " + (String)savedHash));
            String string2 = AuthKt.access$oauthState((HttpServletRequest)request);
            if (string2 != null) {
                String stateParam = string2;
                boolean bl2 = false;
                String string3 = AuthKt.access$oauthCode((HttpServletRequest)request);
                if (string3 != null) {
                    String string4;
                    String it = string4 = string3;
                    boolean bl3 = false;
                    String newHash = this.hashToken(stateParam, AuthKt.access$oauthRedirectUri((HttpServletRequest)request));
                    this.logger.debug((Object)("returned state: " + stateParam + ", new hash: " + newHash));
                    string = Intrinsics.areEqual((Object)newHash, (Object)savedHash) ? string4 : null;
                } else {
                    string = null;
                }
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private AuthTokenResponse fetchTokenFromCode(String code, HttpServletRequest request) {
        LinkedMultiValueMap linkedMultiValueMap;
        try {
            void $this$fetchTokenFromCode_u24lambda_u2414;
            LinkedMultiValueMap $this$fetchTokenFromCode_u24lambda_u2413;
            LinkedMultiValueMap linkedMultiValueMap2 = linkedMultiValueMap = new LinkedMultiValueMap();
            String string = ServletExtensionsKt.baseOrCurrentUrl((HttpServletRequest)request, (String)this.baseUrl) + "/" + StringsKt.removePrefix((String)this.tokenUrl, (CharSequence)"/");
            RestTemplate restTemplate = this.restTemplate;
            boolean bl = false;
            $this$fetchTokenFromCode_u24lambda_u2413.add((Object)"code", (Object)code);
            $this$fetchTokenFromCode_u24lambda_u2413.add((Object)"grant_type", (Object)"authorization_code");
            $this$fetchTokenFromCode_u24lambda_u2413.add((Object)"client_id", (Object)this.appName);
            $this$fetchTokenFromCode_u24lambda_u2413.add((Object)"redirect_uri", (Object)AuthKt.access$oauthRedirectUri((HttpServletRequest)request));
            Unit unit = Unit.INSTANCE;
            LinkedMultiValueMap linkedMultiValueMap3 = linkedMultiValueMap;
            $this$fetchTokenFromCode_u24lambda_u2413 = linkedMultiValueMap = new HttpHeaders();
            unit = linkedMultiValueMap3;
            boolean bl2 = false;
            $this$fetchTokenFromCode_u24lambda_u2414.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            Unit unit2 = Unit.INSTANCE;
            MultiValueMap multiValueMap = (MultiValueMap)linkedMultiValueMap;
            Unit unit3 = unit;
            linkedMultiValueMap = (AuthTokenResponse)restTemplate.postForObject(string, (Object)new HttpEntity((Object)unit3, multiValueMap), AuthTokenResponse.class, new Object[0]);
        }
        catch (RestClientException e) {
            this.logger.debug((Object)("Unable to fetch token using code: " + code), (Throwable)e);
            linkedMultiValueMap = null;
        }
        return linkedMultiValueMap;
    }

    private Pair<String, Cookie> getOauthRedirectUrlAndCookie(HttpServletRequest request) {
        UriComponentsBuilder $this$getOauthRedirectUrlAndCookie_u24lambda_u2415 = UriComponentsBuilder.fromUriString((String)(ServletExtensionsKt.baseOrCurrentUrl((HttpServletRequest)request, (String)this.baseUrl) + "/" + StringsKt.removePrefix((String)this.authorizeUrl, (CharSequence)"/")));
        boolean bl = false;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String stateToken = string;
        String redirectUri = AuthKt.access$oauthRedirectUri((HttpServletRequest)request);
        Object[] objectArray = new Object[]{stateToken};
        $this$getOauthRedirectUrlAndCookie_u24lambda_u2415.queryParam("state", objectArray);
        objectArray = new Object[]{this.appName};
        $this$getOauthRedirectUrlAndCookie_u24lambda_u2415.queryParam("client_id", objectArray);
        objectArray = new Object[]{"code"};
        $this$getOauthRedirectUrlAndCookie_u24lambda_u2415.queryParam("response_type", objectArray);
        objectArray = new Object[]{redirectUri};
        $this$getOauthRedirectUrlAndCookie_u24lambda_u2415.queryParam("redirect_uri", objectArray);
        return new Pair((Object)$this$getOauthRedirectUrlAndCookie_u24lambda_u2415.toUriString(), (Object)this.createCookie("pdfAuthToken", request, this.hashToken(stateToken, redirectUri), 600));
    }

    private String hashToken(String token, String context) {
        String string = Integer.toString((CollectionsKt.first((Iterable)this.service2serviceSecrets) + "|" + token + "|" + context).hashCode(), CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private Cookie createCookie(String cookieName, HttpServletRequest httpRequest, String cookieValue, int maxAge) {
        Cookie cookie;
        Cookie $this$createCookie_u24lambda_u2416 = cookie = new Cookie(cookieName, cookieValue);
        boolean bl = false;
        $this$createCookie_u24lambda_u2416.setDomain(httpRequest.getServerName());
        $this$createCookie_u24lambda_u2416.setPath("/");
        $this$createCookie_u24lambda_u2416.setSecure(httpRequest.isSecure());
        $this$createCookie_u24lambda_u2416.setMaxAge(maxAge);
        $this$createCookie_u24lambda_u2416.setHttpOnly(true);
        return cookie;
    }
}

