/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf.job;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.pdf.job.Job;
import org.kuali.research.pdf.job.JobService;
import org.kuali.research.pdf.sys.model.Status;
import org.kuali.research.pdf.sys.rest.V1ApiController;
import org.kuali.research.pdf.sys.rest.V1ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.server.ResponseStatusException;

@V1ApiController
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0017J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\nH\u0017J\u0012\u0010\u000e\u001a\u00020\n2\b\b\u0001\u0010\u000f\u001a\u00020\fH\u0017J\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120\u0011H\u0017J\u0012\u0010\u0013\u001a\u00020\f2\b\b\u0001\u0010\u000f\u001a\u00020\fH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/kuali/research/pdf/job/JobController;", "", "jobService", "Lorg/kuali/research/pdf/job/JobService;", "<init>", "(Lorg/kuali/research/pdf/job/JobService;)V", "getJobService", "()Lorg/kuali/research/pdf/job/JobService;", "getJobs", "", "Lorg/kuali/research/pdf/job/Job;", "submitJob", "", "job", "getJob", "jobId", "getJobStatuses", "", "Lorg/kuali/research/pdf/sys/model/Status;", "getJobStatus", "pdf"})
@SourceDebugExtension(value={"SMAP\nJobController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JobController.kt\norg/kuali/research/pdf/job/JobController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1193#2,2:65\n1267#2,4:67\n*S KotlinDebug\n*F\n+ 1 JobController.kt\norg/kuali/research/pdf/job/JobController\n*L\n54#1:65,2\n54#1:67,4\n*E\n"})
public class JobController {
    @NotNull
    private final JobService jobService;

    public JobController(@Autowired @NotNull JobService jobService) {
        Intrinsics.checkNotNullParameter((Object)jobService, (String)"jobService");
        this.jobService = jobService;
    }

    @NotNull
    public JobService getJobService() {
        return this.jobService;
    }

    @V1ApiOperation
    @GetMapping(value={"/jobs"}, produces={"application/json"})
    @NotNull
    public List<Job> getJobs() {
        return this.getJobService().fetchAll();
    }

    @V1ApiOperation
    @PostMapping(value={"/jobs"}, consumes={"application/json"}, produces={"text/plain"})
    @NotNull
    public String submitJob(@RequestBody @NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        return this.getJobService().submit(job);
    }

    @V1ApiOperation
    @GetMapping(value={"/jobs/{jobId}"}, produces={"application/json"})
    @NotNull
    public Job getJob(@PathVariable(name="jobId") @NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        Job job = this.getJobService().fetch(jobId);
        if (job == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return job;
    }

    /*
     * WARNING - void declaration
     */
    @V1ApiOperation
    @GetMapping(value={"/jobs/status"}, produces={"application/json"})
    @NotNull
    public Map<String, Status> getJobStatuses() {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = this.getJobService().fetchAll();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable2 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Job it = (Job)element$iv$iv;
            boolean bl = false;
            String string = it.getJobId();
            Intrinsics.checkNotNull((Object)string);
            Pair pair = new Pair((Object)string, (Object)it.getStatus());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @V1ApiOperation
    @GetMapping(value={"/jobs/{jobId}/status"}, produces={"text/plain"})
    @NotNull
    public String getJobStatus(@PathVariable(name="jobId") @NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        Object object = this.getJobService().fetch(jobId);
        if (object == null || (object = object.getStatus()) == null || (object = object.name()) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return object;
    }
}

