/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.pdf;

import com.itextpdf.licensing.base.LicenseKey;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"xfa.flattening.supported"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0017J\b\u0010\f\u001a\u00020\u000bH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\r"}, d2={"Lorg/kuali/research/pdf/ItextLicenseInitializer;", "", "itextXfaLicense", "Lorg/springframework/core/io/Resource;", "itextLicense", "<init>", "(Lorg/springframework/core/io/Resource;Lorg/springframework/core/io/Resource;)V", "getItextXfaLicense", "()Lorg/springframework/core/io/Resource;", "getItextLicense", "loadLicense", "", "unloadLicense", "pdf"})
@SourceDebugExtension(value={"SMAP\nItextLicenseInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItextLicenseInitializer.kt\norg/kuali/research/pdf/ItextLicenseInitializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,30:1\n1#2:31\n*E\n"})
public class ItextLicenseInitializer {
    @NotNull
    private final Resource itextXfaLicense;
    @NotNull
    private final Resource itextLicense;

    public ItextLicenseInitializer(@Value(value="${itext.xfa.license.key.json.path}") @NotNull Resource itextXfaLicense, @Value(value="${itext.license.key.json.path}") @NotNull Resource itextLicense) {
        Intrinsics.checkNotNullParameter((Object)itextXfaLicense, (String)"itextXfaLicense");
        Intrinsics.checkNotNullParameter((Object)itextLicense, (String)"itextLicense");
        this.itextXfaLicense = itextXfaLicense;
        this.itextLicense = itextLicense;
    }

    @NotNull
    public Resource getItextXfaLicense() {
        return this.itextXfaLicense;
    }

    @NotNull
    public Resource getItextLicense() {
        return this.itextLicense;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void loadLicense() {
        InputStream it;
        Closeable closeable = this.getItextLicense().getInputStream();
        Throwable throwable = null;
        try {
            it = (InputStream)closeable;
            boolean bl = false;
            LicenseKey.loadLicenseFile((InputStream)it);
            it = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        closeable = this.getItextXfaLicense().getInputStream();
        throwable = null;
        try {
            it = (InputStream)closeable;
            boolean bl = false;
            LicenseKey.loadLicenseFile((InputStream)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @PreDestroy
    public void unloadLicense() {
        LicenseKey.unloadLicenses();
    }
}

