/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.proposal.internal.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.proposal.internal.assembler.PropOppPkgFormOverrideAssembler;
import org.kuali.research.grants.proposal.internal.controller.PropOppPackageController;
import org.kuali.research.grants.proposal.internal.dto.PropOppPkgFormOverrideInsertDto;
import org.kuali.research.grants.proposal.internal.entity.File;
import org.kuali.research.grants.proposal.internal.entity.PropOppPkgFormOverride;
import org.kuali.research.grants.proposal.internal.model.PropOppPkgFormOverrideModel;
import org.kuali.research.grants.proposal.internal.repository.PropOppPkgFormOverrideRepository;
import org.kuali.research.grants.proposal.internal.service.PropOppPkgFormOverrideService;
import org.kuali.research.grants.proposal.internal.util.Error;
import org.kuali.research.grants.proposal.internal.util.PackageId;
import org.kuali.research.grants.proposal.internal.util.PropOpportunityId;
import org.kuali.research.grants.proposal.internal.util.ProposalId;
import org.kuali.research.grants.sys.hateoas.ProblemModel;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.problem.Problem;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/proposals"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ,\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u000eH\u0017J6\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u000e2\b\b\u0001\u0010\u0013\u001a\u00020\u000eH\u0017J@\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u000e2\b\b\u0001\u0010\u0016\u001a\u00020\u000e2\b\b\u0001\u0010\u0013\u001a\u00020\u000eH\u0017J@\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u000e2\b\b\u0001\u0010\u0016\u001a\u00020\u000e2\b\b\u0001\u0010\u0013\u001a\u00020\u000eH\u0017JJ\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u000e2\b\b\u0001\u0010\u0016\u001a\u00020\u000e2\b\b\u0001\u0010\u0019\u001a\u00020\u000e2\b\b\u0001\u0010\u0013\u001a\u00020\u000eH\u0017J<\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001b0\u00122\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u000e2\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0017J6\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00122\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u000e2\b\b\u0001\u0010\u0013\u001a\u00020\u000eH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/kuali/research/grants/proposal/internal/controller/PropOppPkgFormOverrideController;", "", "service", "Lorg/kuali/research/grants/proposal/internal/service/PropOppPkgFormOverrideService;", "repository", "Lorg/kuali/research/grants/proposal/internal/repository/PropOppPkgFormOverrideRepository;", "assembler", "Lorg/kuali/research/grants/proposal/internal/assembler/PropOppPkgFormOverrideAssembler;", "<init>", "(Lorg/kuali/research/grants/proposal/internal/service/PropOppPkgFormOverrideService;Lorg/kuali/research/grants/proposal/internal/repository/PropOppPkgFormOverrideRepository;Lorg/kuali/research/grants/proposal/internal/assembler/PropOppPkgFormOverrideAssembler;)V", "getAllPropOppPkgFormOverrides", "Lorg/springframework/hateoas/CollectionModel;", "Lorg/kuali/research/grants/proposal/internal/model/PropOppPkgFormOverrideModel;", "proposalId", "", "propOpportunityId", "packageId", "getPropOppPkgFormOverrideById", "Lorg/springframework/http/ResponseEntity;", "id", "getPropOppPkgFormOverridePdfFileById", "", "formOverrideId", "getPropOppPkgFormOverrideXmlFileById", "getPropOppPkgFormOverrideAttachmentFileById", "attachmentFileId", "createPropOppPkgFormOverride", "Lorg/kuali/research/grants/sys/hateoas/ProblemModel;", "propOppPkgFormOverrideInsertDto", "Lorg/kuali/research/grants/proposal/internal/dto/PropOppPkgFormOverrideInsertDto;", "deletePropOppPkgFormOverride", "Ljava/lang/Void;", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nPropOppPkgFormOverrideController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropOppPkgFormOverrideController.kt\norg/kuali/research/grants/proposal/internal/controller/PropOppPkgFormOverrideController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n1563#2:202\n1634#2,3:203\n1563#2:206\n1634#2,3:207\n*S KotlinDebug\n*F\n+ 1 PropOppPkgFormOverrideController.kt\norg/kuali/research/grants/proposal/internal/controller/PropOppPkgFormOverrideController\n*L\n47#1:202\n47#1:203,3\n172#1:206\n172#1:207,3\n*E\n"})
public class PropOppPkgFormOverrideController {
    @NotNull
    private final PropOppPkgFormOverrideService service;
    @NotNull
    private final PropOppPkgFormOverrideRepository repository;
    @NotNull
    private final PropOppPkgFormOverrideAssembler assembler;

    public PropOppPkgFormOverrideController(@NotNull PropOppPkgFormOverrideService service, @NotNull PropOppPkgFormOverrideRepository repository, @NotNull PropOppPkgFormOverrideAssembler assembler) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)assembler, (String)"assembler");
        this.service = service;
        this.repository = repository;
        this.assembler = assembler;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages/{packageId}/form-overrides"})
    @NotNull
    public CollectionModel<PropOppPkgFormOverrideModel> getAllPropOppPkgFormOverrides(@PathVariable long proposalId, @PathVariable long propOpportunityId, @PathVariable long packageId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.repository.findByProposalIdAndPropOpportunityIdAndPropOppPackageId(proposalId, propOpportunityId, packageId);
        PropOppPkgFormOverrideAssembler propOppPkgFormOverrideAssembler = this.assembler;
        boolean $i$f$map = false;
        void var9_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PropOppPkgFormOverride propOppPkgFormOverride = (PropOppPkgFormOverride)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)proposalId, (Object)it));
        }
        RepresentationModel representationModel = propOppPkgFormOverrideAssembler.toCollectionModel((Iterable)((List)destination$iv$iv)).add(WebMvcLinkBuilder.linkTo((Object)((PropOppPackageController)WebMvcLinkBuilder.methodOn(PropOppPackageController.class, (Object[])new Object[0])).getAllPropOppPackages(proposalId, propOpportunityId)).withSelfRel());
        Intrinsics.checkNotNullExpressionValue((Object)representationModel, (String)"add(...)");
        return (CollectionModel)representationModel;
    }

    @GetMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages/{packageId}/form-overrides/{id}"})
    @NotNull
    public ResponseEntity<PropOppPkgFormOverrideModel> getPropOppPkgFormOverrideById(@PathVariable long proposalId, @PathVariable long propOpportunityId, @PathVariable long packageId, @PathVariable long id) {
        ResponseEntity responseEntity = this.repository.findByProposalIdAndPropOpportunityIdAndPropOppPackageIdAndId(proposalId, propOpportunityId, packageId, id).map(arg_0 -> PropOppPkgFormOverrideController.getPropOppPkgFormOverrideById$lambda$2(arg_0 -> PropOppPkgFormOverrideController.getPropOppPkgFormOverrideById$lambda$1(this, proposalId, arg_0), arg_0)).orElse(ResponseEntity.notFound().build());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"orElse(...)");
        return responseEntity;
    }

    @GetMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages/{packageId}/form-overrides/{formOverrideId}/pdf-files/{id}/download"}, produces={"application/pdf"})
    @NotNull
    public ResponseEntity<byte[]> getPropOppPkgFormOverridePdfFileById(@PathVariable long proposalId, @PathVariable long propOpportunityId, @PathVariable long packageId, @PathVariable long formOverrideId, @PathVariable long id) {
        ResponseEntity responseEntity = this.repository.findPdfFileByProposalIdAndPropOpportunityIdAndPropOppPackageIdAndAndFormOverrideIdAndId(proposalId, propOpportunityId, packageId, formOverrideId, id).map(arg_0 -> PropOppPkgFormOverrideController.getPropOppPkgFormOverridePdfFileById$lambda$4(PropOppPkgFormOverrideController::getPropOppPkgFormOverridePdfFileById$lambda$3, arg_0)).orElse(ResponseEntity.notFound().build());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"orElse(...)");
        return responseEntity;
    }

    @GetMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages/{packageId}/form-overrides/{formOverrideId}/xml-files/{id}/download"}, produces={"application/xml"})
    @NotNull
    public ResponseEntity<byte[]> getPropOppPkgFormOverrideXmlFileById(@PathVariable long proposalId, @PathVariable long propOpportunityId, @PathVariable long packageId, @PathVariable long formOverrideId, @PathVariable long id) {
        ResponseEntity responseEntity = this.repository.findXmlFileByProposalIdAndPropOpportunityIdAndPropOppPackageIdAndAndFormOverrideIdAndId(proposalId, propOpportunityId, packageId, formOverrideId, id).map(arg_0 -> PropOppPkgFormOverrideController.getPropOppPkgFormOverrideXmlFileById$lambda$6(PropOppPkgFormOverrideController::getPropOppPkgFormOverrideXmlFileById$lambda$5, arg_0)).orElse(ResponseEntity.notFound().build());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"orElse(...)");
        return responseEntity;
    }

    @GetMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages/{packageId}/form-overrides/{formOverrideId}/attachment-files/{attachmentFileId}/files/{id}/download"}, produces={"application/octet-stream"})
    @NotNull
    public ResponseEntity<byte[]> getPropOppPkgFormOverrideAttachmentFileById(@PathVariable long proposalId, @PathVariable long propOpportunityId, @PathVariable long packageId, @PathVariable long formOverrideId, @PathVariable long attachmentFileId, @PathVariable long id) {
        ResponseEntity responseEntity = this.repository.findAttachmentFileByProposalIdAndPropOpportunityIdAndPropOppPackageIdAndAndFormOverrideIdAndId(proposalId, propOpportunityId, packageId, formOverrideId, attachmentFileId, id).map(arg_0 -> PropOppPkgFormOverrideController.getPropOppPkgFormOverrideAttachmentFileById$lambda$8(PropOppPkgFormOverrideController::getPropOppPkgFormOverrideAttachmentFileById$lambda$7, arg_0)).orElse(ResponseEntity.notFound().build());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"orElse(...)");
        return responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages/{packageId}/form-overrides"})
    @NotNull
    public ResponseEntity<ProblemModel<PropOppPkgFormOverrideModel>> createPropOppPkgFormOverride(@PathVariable long proposalId, @PathVariable long propOpportunityId, @PathVariable long packageId, @RequestBody @NotNull PropOppPkgFormOverrideInsertDto propOppPkgFormOverrideInsertDto) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)propOppPkgFormOverrideInsertDto, (String)"propOppPkgFormOverrideInsertDto");
        Pair pair = this.service.createPropOppPkgFormOverride-p2gsc9Y(ProposalId.constructor-impl((long)proposalId), PropOpportunityId.constructor-impl((long)propOpportunityId), PackageId.constructor-impl((long)packageId), propOppPkgFormOverrideInsertDto);
        PropOppPkgFormOverride formOverride = (PropOppPkgFormOverride)pair.component1();
        List errors = (List)pair.component2();
        if (formOverride != null) {
            ResponseEntity responseEntity2 = ResponseEntity.ok((Object)ProblemModel.Companion.of$default((ProblemModel.Companion)ProblemModel.Companion, (RepresentationModel)((RepresentationModel)this.assembler.toModel(TuplesKt.to((Object)proposalId, (Object)formOverride))), null, (int)2, null));
            Intrinsics.checkNotNull((Object)responseEntity2);
            responseEntity = responseEntity2;
        } else {
            Collection<Problem> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = errors;
            RepresentationModel representationModel = null;
            ProblemModel.Companion companion = ProblemModel.Companion;
            ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.unprocessableEntity();
            boolean $i$f$map = false;
            void var14_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Error error = (Error)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Problem.create().withDetail(it.getMessage()));
            }
            collection = (List)destination$iv$iv;
            ResponseEntity responseEntity3 = bodyBuilder.body((Object)companion.of(representationModel, CollectionsKt.toMutableList((Collection)collection)));
            Intrinsics.checkNotNull((Object)responseEntity3);
            responseEntity = responseEntity3;
        }
        return responseEntity;
    }

    @DeleteMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages/{packageId}/form-overrides/{id}"})
    @NotNull
    public ResponseEntity<Void> deletePropOppPkgFormOverride(@PathVariable long proposalId, @PathVariable long propOpportunityId, @PathVariable long packageId, @PathVariable long id) {
        ResponseEntity responseEntity = this.repository.findByProposalIdAndPropOpportunityIdAndPropOppPackageIdAndId(proposalId, propOpportunityId, packageId, id).map(arg_0 -> PropOppPkgFormOverrideController.deletePropOppPkgFormOverride$lambda$11(arg_0 -> PropOppPkgFormOverrideController.deletePropOppPkgFormOverride$lambda$10(this, arg_0), arg_0)).orElse(ResponseEntity.notFound().build());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"orElse(...)");
        return responseEntity;
    }

    private static final ResponseEntity getPropOppPkgFormOverrideById$lambda$1(PropOppPkgFormOverrideController this$0, long $proposalId, PropOppPkgFormOverride propOppPackage) {
        return ResponseEntity.ok((Object)this$0.assembler.toModel(TuplesKt.to((Object)$proposalId, (Object)propOppPackage)));
    }

    private static final ResponseEntity getPropOppPkgFormOverrideById$lambda$2(Function1 $tmp0, Object p0) {
        return (ResponseEntity)$tmp0.invoke(p0);
    }

    private static final ResponseEntity getPropOppPkgFormOverridePdfFileById$lambda$3(File file) {
        return ResponseEntity.ok((Object)file.getData());
    }

    private static final ResponseEntity getPropOppPkgFormOverridePdfFileById$lambda$4(Function1 $tmp0, Object p0) {
        return (ResponseEntity)$tmp0.invoke(p0);
    }

    private static final ResponseEntity getPropOppPkgFormOverrideXmlFileById$lambda$5(File file) {
        return ResponseEntity.ok((Object)file.getData());
    }

    private static final ResponseEntity getPropOppPkgFormOverrideXmlFileById$lambda$6(Function1 $tmp0, Object p0) {
        return (ResponseEntity)$tmp0.invoke(p0);
    }

    private static final ResponseEntity getPropOppPkgFormOverrideAttachmentFileById$lambda$7(File file) {
        return ResponseEntity.ok((Object)file.getData());
    }

    private static final ResponseEntity getPropOppPkgFormOverrideAttachmentFileById$lambda$8(Function1 $tmp0, Object p0) {
        return (ResponseEntity)$tmp0.invoke(p0);
    }

    private static final ResponseEntity deletePropOppPkgFormOverride$lambda$10(PropOppPkgFormOverrideController this$0, PropOppPkgFormOverride propOppPackage) {
        this$0.repository.delete((Object)propOppPackage);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    private static final ResponseEntity deletePropOppPkgFormOverride$lambda$11(Function1 $tmp0, Object p0) {
        return (ResponseEntity)$tmp0.invoke(p0);
    }
}

