/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.proposal.internal.controller;

import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.grants.proposal.internal.controller.PropOpportunityController;
import org.kuali.research.grants.proposal.internal.dto.PropOpportunityUpsertDto;
import org.kuali.research.grants.proposal.internal.entity.PropOpportunity;
import org.kuali.research.grants.proposal.internal.model.PropOpportunityModel;
import org.kuali.research.grants.proposal.internal.repository.PropOpportunityRepository;
import org.kuali.research.grants.proposal.internal.service.PropOpportunityService;
import org.kuali.research.grants.proposal.internal.util.ProposalId;
import org.kuali.research.grants.sys.hateoas.ProblemModel;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/proposals"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0017J\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u000fH\u0017J(\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00140\u00112\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J.\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00140\u00112\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0097@\u00a2\u0006\u0002\u0010\u0018J\"\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00112\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/kuali/research/grants/proposal/internal/controller/PropOpportunityController;", "", "repository", "Lorg/kuali/research/grants/proposal/internal/repository/PropOpportunityRepository;", "propOpportunityService", "Lorg/kuali/research/grants/proposal/internal/service/PropOpportunityService;", "assembler", "Lorg/springframework/hateoas/server/RepresentationModelAssembler;", "Lorg/kuali/research/grants/proposal/internal/entity/PropOpportunity;", "Lorg/kuali/research/grants/proposal/internal/model/PropOpportunityModel;", "<init>", "(Lorg/kuali/research/grants/proposal/internal/repository/PropOpportunityRepository;Lorg/kuali/research/grants/proposal/internal/service/PropOpportunityService;Lorg/springframework/hateoas/server/RepresentationModelAssembler;)V", "getAllOpportunitiesForProposal", "Lorg/springframework/hateoas/CollectionModel;", "proposalId", "", "getPropOpportunityById", "Lorg/springframework/http/ResponseEntity;", "id", "createOrUpdatePropOpportunity", "Lorg/kuali/research/grants/sys/hateoas/ProblemModel;", "propOpportunity", "Lorg/kuali/research/grants/proposal/internal/dto/PropOpportunityUpsertDto;", "createOrUpdatePropOpportunityWithPackages", "(JLorg/kuali/research/grants/proposal/internal/dto/PropOpportunityUpsertDto;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deletePropOpportunity", "Ljava/lang/Void;", "research-grants-backend"})
public class PropOpportunityController {
    @NotNull
    private final PropOpportunityRepository repository;
    @NotNull
    private final PropOpportunityService propOpportunityService;
    @NotNull
    private final RepresentationModelAssembler<PropOpportunity, PropOpportunityModel> assembler;

    public PropOpportunityController(@NotNull PropOpportunityRepository repository, @NotNull PropOpportunityService propOpportunityService, @NotNull RepresentationModelAssembler<PropOpportunity, PropOpportunityModel> assembler) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)propOpportunityService, (String)"propOpportunityService");
        Intrinsics.checkNotNullParameter(assembler, (String)"assembler");
        this.repository = repository;
        this.propOpportunityService = propOpportunityService;
        this.assembler = assembler;
    }

    @GetMapping(value={"/{proposalId}/opportunities"})
    @NotNull
    public CollectionModel<PropOpportunityModel> getAllOpportunitiesForProposal(@PathVariable long proposalId) {
        RepresentationModel representationModel = this.assembler.toCollectionModel((Iterable)this.repository.findByProposalId(proposalId)).add(WebMvcLinkBuilder.linkTo((Object)((PropOpportunityController)WebMvcLinkBuilder.methodOn(PropOpportunityController.class, (Object[])new Object[0])).getAllOpportunitiesForProposal(proposalId)).withSelfRel());
        Intrinsics.checkNotNullExpressionValue((Object)representationModel, (String)"add(...)");
        return (CollectionModel)representationModel;
    }

    @GetMapping(value={"/{proposalId}/opportunities/{id}"})
    @NotNull
    public ResponseEntity<PropOpportunityModel> getPropOpportunityById(@PathVariable long proposalId, @PathVariable long id) {
        ResponseEntity responseEntity = this.repository.findByProposalIdAndId(proposalId, id).map(arg_0 -> PropOpportunityController.getPropOpportunityById$lambda$1(arg_0 -> PropOpportunityController.getPropOpportunityById$lambda$0(this, arg_0), arg_0)).orElse(ResponseEntity.notFound().build());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"orElse(...)");
        return responseEntity;
    }

    @PostMapping(value={"/{proposalId}/opportunities"})
    @NotNull
    public ResponseEntity<ProblemModel<PropOpportunityModel>> createOrUpdatePropOpportunity(@PathVariable long proposalId, @RequestBody @NotNull PropOpportunityUpsertDto propOpportunity) {
        Intrinsics.checkNotNullParameter((Object)propOpportunity, (String)"propOpportunity");
        PropOpportunity savedPropOpportunity = this.propOpportunityService.createPropOpportunity-Vf9ko8g(ProposalId.constructor-impl((long)proposalId), propOpportunity);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)ProblemModel.Companion.of$default((ProblemModel.Companion)ProblemModel.Companion, (RepresentationModel)this.assembler.toModel((Object)savedPropOpportunity), null, (int)2, null));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @PostMapping(value={"/{proposalId}/opportunities"}, params={"with-packages"})
    @Nullable
    public Object createOrUpdatePropOpportunityWithPackages(@PathVariable long proposalId, @RequestBody @NotNull PropOpportunityUpsertDto propOpportunity, @NotNull Continuation<? super ResponseEntity<ProblemModel<PropOpportunityModel>>> $completion) {
        return PropOpportunityController.createOrUpdatePropOpportunityWithPackages$suspendImpl((PropOpportunityController)this, (long)proposalId, (PropOpportunityUpsertDto)propOpportunity, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @PostMapping(value={"/{proposalId}/opportunities"}, params={"with-packages"})
    static /* synthetic */ Object createOrUpdatePropOpportunityWithPackages$suspendImpl(PropOpportunityController $this, @PathVariable long proposalId, @RequestBody PropOpportunityUpsertDto propOpportunity, Continuation<? super ResponseEntity<ProblemModel<PropOpportunityModel>>> $completion) {
        if (!($completion instanceof createOrUpdatePropOpportunityWithPackages.1)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new /* Unavailable Anonymous Inner Class!! */;
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $this;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)propOpportunity);
                $continuation.J$0 = proposalId;
                $continuation.label = 1;
                v0 = $this.propOpportunityService.createPropOpportunityWithPackages-tZlqGmA(ProposalId.constructor-impl((long)proposalId), propOpportunity, (Continuation)$continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl26
            }
            case 1: {
                proposalId = $continuation.J$0;
                propOpportunity = (PropOpportunityUpsertDto)$continuation.L$1;
                $this = (PropOpportunityController)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                savedPropOpportunity = (PropOpportunity)v0;
                v1 = ResponseEntity.ok((Object)ProblemModel.Companion.of$default((ProblemModel.Companion)ProblemModel.Companion, (RepresentationModel)$this.assembler.toModel((Object)savedPropOpportunity), null, (int)2, null));
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"ok(...)");
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @DeleteMapping(value={"/{proposalId}/opportunities/{id}"})
    @NotNull
    public ResponseEntity<Void> deletePropOpportunity(@PathVariable long proposalId, @PathVariable long id) {
        ResponseEntity responseEntity = this.repository.findByProposalIdAndId(proposalId, id).map(arg_0 -> PropOpportunityController.deletePropOpportunity$lambda$3(arg_0 -> PropOpportunityController.deletePropOpportunity$lambda$2(this, arg_0), arg_0)).orElse(ResponseEntity.notFound().build());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"orElse(...)");
        return responseEntity;
    }

    private static final ResponseEntity getPropOpportunityById$lambda$0(PropOpportunityController this$0, PropOpportunity propOpportunity) {
        return ResponseEntity.ok((Object)this$0.assembler.toModel((Object)propOpportunity));
    }

    private static final ResponseEntity getPropOpportunityById$lambda$1(Function1 $tmp0, Object p0) {
        return (ResponseEntity)$tmp0.invoke(p0);
    }

    private static final ResponseEntity deletePropOpportunity$lambda$2(PropOpportunityController this$0, PropOpportunity propOpportunity) {
        this$0.repository.delete((Object)propOpportunity);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    private static final ResponseEntity deletePropOpportunity$lambda$3(Function1 $tmp0, Object p0) {
        return (ResponseEntity)$tmp0.invoke(p0);
    }
}

