/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.db.internal.tenant;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.sys.environment.EnvService;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0002H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/kuali/research/grants/sys/db/internal/tenant/TenantIdentifierResolver;", "Lorg/hibernate/context/spi/CurrentTenantIdentifierResolver;", "", "Lorg/springframework/boot/autoconfigure/orm/jpa/HibernatePropertiesCustomizer;", "envService", "Lorg/kuali/research/grants/sys/environment/EnvService;", "<init>", "(Lorg/kuali/research/grants/sys/environment/EnvService;)V", "resolveCurrentTenantIdentifier", "validateExistingCurrentSessions", "", "customize", "", "hibernateProperties", "", "", "research-grants-backend"})
public final class TenantIdentifierResolver
implements CurrentTenantIdentifierResolver<String>,
HibernatePropertiesCustomizer {
    @NotNull
    private final EnvService envService;

    public TenantIdentifierResolver(@NotNull EnvService envService) {
        Intrinsics.checkNotNullParameter((Object)envService, (String)"envService");
        this.envService = envService;
    }

    @NotNull
    public String resolveCurrentTenantIdentifier() {
        Object object;
        if (this.envService.isSet()) {
            String tenant = this.envService.tenant();
            String lane = this.envService.lane();
            object = tenant + "-" + lane;
        } else {
            object = (String)this.envService.doInInternal(() -> TenantIdentifierResolver.resolveCurrentTenantIdentifier$lambda$0(this));
        }
        return object;
    }

    public boolean validateExistingCurrentSessions() {
        return true;
    }

    public void customize(@NotNull Map<String, Object> hibernateProperties) {
        Intrinsics.checkNotNullParameter(hibernateProperties, (String)"hibernateProperties");
        hibernateProperties.put("hibernate.tenant_identifier_resolver", this);
    }

    private static final String resolveCurrentTenantIdentifier$lambda$0(TenantIdentifierResolver this$0) {
        String tenant = this$0.envService.tenant();
        String lane = this$0.envService.lane();
        return tenant + "-" + lane;
    }
}

