/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.ggintegration.internal.client;

import java.net.URI;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.grants.ggintegration.FormSearchRestClient;
import org.kuali.research.grants.ggintegration.GgFormSearchParams;
import org.kuali.research.grants.ggintegration.GgFormSearchResults;
import org.kuali.research.grants.ggintegration.internal.client.FormSearchRestClientImpl;
import org.kuali.research.grants.sys.service.ServiceCategory;
import org.kuali.research.grants.sys.service.ServiceInfo;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J \u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/kuali/research/grants/ggintegration/internal/client/FormSearchRestClientImpl;", "Lorg/kuali/research/grants/ggintegration/FormSearchRestClient;", "Lorg/apache/logging/log4j/kotlin/Logging;", "formsSearchUri", "", "formsUriBase", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/springframework/web/client/RestClient$Builder;)V", "search", "Lorg/kuali/research/grants/ggintegration/GgFormSearchResults;", "searchParams", "Lorg/kuali/research/grants/ggintegration/GgFormSearchParams;", "pdfUrl", "Ljava/net/URL;", "id", "", "name", "version", "readOnlyPdfUrl", "schemaUrl", "datUrl", "instructionsUrl", "serviceUri", "isConnectedThrowing", "", "serviceInfo", "Lorg/kuali/research/grants/sys/service/ServiceInfo;", "serviceId", "ApplicationWebServicesClient", "research-grants-backend"})
public final class FormSearchRestClientImpl
implements FormSearchRestClient,
Logging {
    @NotNull
    public static final ApplicationWebServicesClient ApplicationWebServicesClient = new ApplicationWebServicesClient(null);
    @NotNull
    private final String formsSearchUri;
    @NotNull
    private final String formsUriBase;
    @NotNull
    private final RestClient.Builder restClientBuilder;
    @NotNull
    private static final GgFormSearchParams DUMMY_REQUEST = new GgFormSearchParams(null, "all", null, 5, null);

    public FormSearchRestClientImpl(@NotNull String formsSearchUri, @NotNull String formsUriBase, @NotNull RestClient.Builder restClientBuilder) {
        Intrinsics.checkNotNullParameter((Object)formsSearchUri, (String)"formsSearchUri");
        Intrinsics.checkNotNullParameter((Object)formsUriBase, (String)"formsUriBase");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        this.formsSearchUri = formsSearchUri;
        this.formsUriBase = formsUriBase;
        this.restClientBuilder = restClientBuilder;
    }

    @Nullable
    public GgFormSearchResults search(@NotNull GgFormSearchParams searchParams) {
        Intrinsics.checkNotNullParameter((Object)searchParams, (String)"searchParams");
        Object[] objectArray = new MediaType[]{MediaType.APPLICATION_JSON};
        RestClient.RequestBodySpec requestBodySpec = (RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClientBuilder.build().post().uri(this.formsSearchUri, new Object[0])).contentType(MediaType.APPLICATION_JSON).body((Object)searchParams).accept(objectArray);
        objectArray = new String[]{"gzip, deflate, br"};
        return (GgFormSearchResults)((RestClient.RequestBodySpec)requestBodySpec.header("Accept-Encoding", (String[])objectArray)).retrieve().body(GgFormSearchResults.class);
    }

    @NotNull
    public URL pdfUrl(int id, @NotNull String name, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        URL uRL = URI.create(this.formsUriBase + "/sample/" + name + "-V" + version + ".pdf").toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return uRL;
    }

    @NotNull
    public URL readOnlyPdfUrl(int id, @NotNull String name, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        URL uRL = URI.create(this.formsUriBase + "/readonly/" + name + "-V" + version + ".pdf").toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return uRL;
    }

    @NotNull
    public URL schemaUrl(int id, @NotNull String name, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        URL uRL = URI.create(this.formsUriBase + "/schemas/" + name + "-V" + version + ".xsd").toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return uRL;
    }

    @NotNull
    public URL datUrl(int id, @NotNull String name, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        URL uRL = URI.create(this.formsUriBase + "/sample/" + name + "-V" + version + "_F" + id + ".xls").toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return uRL;
    }

    @NotNull
    public URL instructionsUrl(int id, @NotNull String name, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        URL uRL = URI.create(this.formsUriBase + "/instructions/" + name + "-V" + version + "-Instructions.pdf").toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return uRL;
    }

    @NotNull
    public String serviceUri() {
        return this.formsSearchUri;
    }

    public boolean isConnectedThrowing() {
        this.search(DUMMY_REQUEST);
        return true;
    }

    @NotNull
    public ServiceInfo serviceInfo() {
        return new ServiceInfo(this.serviceId(), "Form Search", this.isConnected(), "This service provides form search.", this.serviceUri(), ServiceCategory.GRANTS_GOV);
    }

    @NotNull
    public String serviceId() {
        return "GGRFS";
    }

    @NotNull
    public KotlinLogger getLogger() {
        return FormSearchRestClient.DefaultImpls.getLogger((FormSearchRestClient)this);
    }
}

