/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.proposal.internal.controller;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.proposal.internal.controller.ProposalController;
import org.kuali.research.grants.proposal.internal.entity.Proposal;
import org.kuali.research.grants.proposal.internal.model.ProposalModel;
import org.kuali.research.grants.proposal.internal.repository.ProposalRepository;
import org.kuali.research.grants.sys.hateoas.ProblemModel;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.data.web.SortDefault;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/proposals"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u001aB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0017J\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\u001e\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00150\u00112\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0017J\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/kuali/research/grants/proposal/internal/controller/ProposalController;", "", "repository", "Lorg/kuali/research/grants/proposal/internal/repository/ProposalRepository;", "assembler", "Lorg/springframework/hateoas/server/RepresentationModelAssembler;", "Lorg/kuali/research/grants/proposal/internal/entity/Proposal;", "Lorg/kuali/research/grants/proposal/internal/model/ProposalModel;", "pagedResourcesAssembler", "Lorg/springframework/data/web/PagedResourcesAssembler;", "<init>", "(Lorg/kuali/research/grants/proposal/internal/repository/ProposalRepository;Lorg/springframework/hateoas/server/RepresentationModelAssembler;Lorg/springframework/data/web/PagedResourcesAssembler;)V", "getAllProposals", "Lorg/springframework/hateoas/PagedModel;", "pageable", "Lorg/springframework/data/domain/Pageable;", "getProposalById", "Lorg/springframework/http/ResponseEntity;", "id", "", "createOrUpdateProposal", "Lorg/kuali/research/grants/sys/hateoas/ProblemModel;", "proposal", "Lorg/kuali/research/grants/proposal/internal/controller/ProposalController$ProposalUpsertDto;", "deleteProposal", "Ljava/lang/Void;", "ProposalUpsertDto", "research-grants-backend"})
public class ProposalController {
    @NotNull
    private final ProposalRepository repository;
    @NotNull
    private final RepresentationModelAssembler<Proposal, ProposalModel> assembler;
    @NotNull
    private final PagedResourcesAssembler<Proposal> pagedResourcesAssembler;

    public ProposalController(@NotNull ProposalRepository repository, @NotNull RepresentationModelAssembler<Proposal, ProposalModel> assembler, @NotNull PagedResourcesAssembler<Proposal> pagedResourcesAssembler) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter(assembler, (String)"assembler");
        Intrinsics.checkNotNullParameter(pagedResourcesAssembler, (String)"pagedResourcesAssembler");
        this.repository = repository;
        this.assembler = assembler;
        this.pagedResourcesAssembler = pagedResourcesAssembler;
    }

    @GetMapping
    @NotNull
    public PagedModel<ProposalModel> getAllProposals(@PageableDefault(size=20) @SortDefault.SortDefaults(value={@SortDefault(sort={"id"}, direction=Sort.Direction.ASC)}) @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.repository.findAll(pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findAll(...)");
        Page page2 = page;
        PagedModel pagedModel = this.pagedResourcesAssembler.toModel(page2, this.assembler);
        Intrinsics.checkNotNullExpressionValue((Object)pagedModel, (String)"toModel(...)");
        return pagedModel;
    }

    @GetMapping(value={"/{id}"})
    @NotNull
    public ResponseEntity<ProposalModel> getProposalById(@PathVariable long id) {
        ResponseEntity responseEntity = this.repository.findById((Object)id).map(arg_0 -> ProposalController.getProposalById$lambda$1(arg_0 -> ProposalController.getProposalById$lambda$0(this, arg_0), arg_0)).orElse(ResponseEntity.notFound().build());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"orElse(...)");
        return responseEntity;
    }

    @PostMapping
    @NotNull
    public ResponseEntity<ProblemModel<ProposalModel>> createOrUpdateProposal(@RequestBody @NotNull ProposalUpsertDto proposal) {
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        Proposal proposal2 = new Proposal(proposal.getId(), proposal.getPrincipalInvestigator(), proposal.getProposalNumber(), proposal.getSponsorName(), proposal.getTitle(), null, null, null, 224, null);
        Object object = this.repository.save((Object)proposal2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        Proposal savedProposal = (Proposal)object;
        RepresentationModel representationModel = this.assembler.toModel((Object)savedProposal);
        Intrinsics.checkNotNullExpressionValue((Object)representationModel, (String)"toModel(...)");
        ResponseEntity responseEntity = ResponseEntity.ok((Object)ProblemModel.Companion.victory$default((ProblemModel.Companion)ProblemModel.Companion, (RepresentationModel)representationModel, null, (int)2, null));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @DeleteMapping(value={"/{id}"})
    @NotNull
    public ResponseEntity<Void> deleteProposal(@PathVariable long id) {
        ResponseEntity responseEntity = this.repository.findById((Object)id).map(arg_0 -> ProposalController.deleteProposal$lambda$3(arg_0 -> ProposalController.deleteProposal$lambda$2(this, arg_0), arg_0)).orElse(ResponseEntity.notFound().build());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"orElse(...)");
        return responseEntity;
    }

    private static final ResponseEntity getProposalById$lambda$0(ProposalController this$0, Proposal proposal) {
        return ResponseEntity.ok((Object)this$0.assembler.toModel((Object)proposal));
    }

    private static final ResponseEntity getProposalById$lambda$1(Function1 $tmp0, Object p0) {
        return (ResponseEntity)$tmp0.invoke(p0);
    }

    private static final ResponseEntity deleteProposal$lambda$2(ProposalController this$0, Proposal proposal) {
        this$0.repository.delete((Object)proposal);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    private static final ResponseEntity deleteProposal$lambda$3(Function1 $tmp0, Object p0) {
        return (ResponseEntity)$tmp0.invoke(p0);
    }
}

