/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.config.internal.controller;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.grants.config.Certificate;
import org.kuali.research.grants.config.Config;
import org.kuali.research.grants.config.internal.controller.ConfigController;
import org.kuali.research.grants.sys.environment.EnvService;
import org.kuali.research.grants.sys.property.Property;
import org.kuali.research.grants.sys.property.PropertyService;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/configurations"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001:\u0001%B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0014\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fH\u0017J\u001e\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\b\b\u0001\u0010\u0010\u001a\u00020\u000eH\u0017J\b\u0010\u0011\u001a\u00020\u0012H\u0017J(\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0012J,\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0012J \u0010\u001f\u001a\u0004\u0018\u00010 2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019H\u0012J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001c2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0012J*\u0010\"\u001a\u0004\u0018\u00010 2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001c2\b\u0010#\u001a\u0004\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0012J\u001c\u0010$\u001a\u0004\u0018\u00010 2\b\u0010#\u001a\u0004\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/kuali/research/grants/config/internal/controller/ConfigController;", "Lorg/apache/logging/log4j/kotlin/Logging;", "propertyService", "Lorg/kuali/research/grants/sys/property/PropertyService;", "envService", "Lorg/kuali/research/grants/sys/environment/EnvService;", "truststoreLocation", "", "truststorePassword", "<init>", "(Lorg/kuali/research/grants/sys/property/PropertyService;Lorg/kuali/research/grants/sys/environment/EnvService;Ljava/lang/String;Ljava/lang/String;)V", "getConfiguration", "Lorg/springframework/http/ResponseEntity;", "Lorg/springframework/hateoas/EntityModel;", "Lorg/kuali/research/grants/config/Config;", "persistConfiguration", "config", "deleteConfiguration", "", "buildPropertyName", "property", "tenant", "lane", "name", "getCertificateProperties", "Lkotlin/Pair;", "Lorg/kuali/research/grants/sys/property/Property;", "properties", "", "certOrg", "Lorg/kuali/research/grants/config/internal/controller/ConfigController$KnownProperties$CertOrg;", "toCertificate", "Lorg/kuali/research/grants/config/Certificate;", "getRelatedProperties", "persistCertificate", "certificate", "createCertificate", "KnownProperties", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nConfigController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigController.kt\norg/kuali/research/grants/config/internal/controller/ConfigController\n+ 2 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,331:1\n30#2:332\n295#3,2:333\n295#3,2:335\n774#3:337\n865#3,2:338\n*S KotlinDebug\n*F\n+ 1 ConfigController.kt\norg/kuali/research/grants/config/internal/controller/ConfigController\n*L\n47#1:332\n106#1:333,2\n116#1:335,2\n147#1:337\n147#1:338,2\n*E\n"})
public class ConfigController
implements Logging {
    @NotNull
    private final PropertyService propertyService;
    @NotNull
    private final EnvService envService;
    @NotNull
    private final String truststoreLocation;
    @NotNull
    private final String truststorePassword;

    public ConfigController(@NotNull PropertyService propertyService, @NotNull EnvService envService, @NotNull String truststoreLocation, @NotNull String truststorePassword) {
        Intrinsics.checkNotNullParameter((Object)propertyService, (String)"propertyService");
        Intrinsics.checkNotNullParameter((Object)envService, (String)"envService");
        Intrinsics.checkNotNullParameter((Object)truststoreLocation, (String)"truststoreLocation");
        Intrinsics.checkNotNullParameter((Object)truststorePassword, (String)"truststorePassword");
        this.propertyService = propertyService;
        this.envService = envService;
        this.truststoreLocation = truststoreLocation;
        this.truststorePassword = truststorePassword;
    }

    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @NotNull
    public ResponseEntity<EntityModel<Config>> getConfiguration() {
        EntityModel entityModel;
        List properties = this.propertyService.findAll();
        if (properties.isEmpty()) {
            ResponseEntity responseEntity = ResponseEntity.notFound().build();
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"build(...)");
            return responseEntity;
        }
        Pair ggCertificateExisting = this.getCertificateProperties(properties, KnownProperties.CertOrg.GG);
        Pair nihCertificateExisting = this.getCertificateProperties(properties, KnownProperties.CertOrg.NIH);
        if (ggCertificateExisting == null && nihCertificateExisting == null) {
            ConfigController $this$logger$iv = this;
            boolean $i$f$logger = false;
            LoggingFactoryKt.loggerOf(ConfigController.class).warn(ConfigController::getConfiguration$lambda$0);
            ResponseEntity responseEntity = ResponseEntity.notFound().build();
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"build(...)");
            return responseEntity;
        }
        EntityModel $this$getConfiguration_u24lambda_u241 = entityModel = EntityModel.of((Object)new Config(this.toCertificate(ggCertificateExisting), this.toCertificate(nihCertificateExisting)));
        boolean bl = false;
        $this$getConfiguration_u24lambda_u241.add(WebMvcLinkBuilder.linkTo((Object)((ConfigController)WebMvcLinkBuilder.methodOn(ConfigController.class, (Object[])new Object[0])).getConfiguration()).withSelfRel());
        ResponseEntity responseEntity = ResponseEntity.ok((Object)entityModel);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.OK)
    @NotNull
    public ResponseEntity<EntityModel<Config>> persistConfiguration(@RequestBody @NotNull Config config) {
        EntityModel entityModel;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List properties = this.propertyService.findAll();
        EntityModel $this$persistConfiguration_u24lambda_u242 = entityModel = EntityModel.of((Object)new Config(this.persistCertificate(properties, config.getGgCertificate(), KnownProperties.CertOrg.GG), this.persistCertificate(properties, config.getNihCertificate(), KnownProperties.CertOrg.NIH)));
        boolean bl = false;
        $this$persistConfiguration_u24lambda_u242.add(WebMvcLinkBuilder.linkTo((Object)((ConfigController)WebMvcLinkBuilder.methodOn(ConfigController.class, (Object[])new Object[0])).getConfiguration()).withSelfRel());
        ResponseEntity responseEntity = ResponseEntity.ok((Object)entityModel);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @DeleteMapping
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteConfiguration() {
        List properties = this.propertyService.findAll();
        this.propertyService.deleteAll(CollectionsKt.plus((Collection)this.getRelatedProperties(properties, KnownProperties.CertOrg.GG), (Iterable)this.getRelatedProperties(properties, KnownProperties.CertOrg.NIH)));
    }

    private String buildPropertyName(String property, String tenant, String lane, String name) {
        String string = property;
        Object[] objectArray = new Object[]{tenant + "-" + lane, name};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private Pair<Property, Property> getCertificateProperties(List<Property> properties, KnownProperties.CertOrg certOrg) {
        Object v1;
        Property location;
        block3: {
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = properties;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Property it = (Property)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getKey(), (Object)this.buildPropertyName("spring.ssl.bundle.jks.%s-%s.keystore.location", this.envService.tenant(), this.envService.lane(), certOrg.getOrg()))) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            location = v0;
            Iterable $this$firstOrNull$iv = properties;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Property it = (Property)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKey(), (Object)this.buildPropertyName("spring.ssl.bundle.jks.%s-%s.keystore.password", this.envService.tenant(), this.envService.lane(), certOrg.getOrg()))) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        Property password = v1;
        return location != null && password != null ? new Pair((Object)location, (Object)password) : null;
    }

    private Certificate toCertificate(Pair<Property, Property> properties) {
        Certificate certificate;
        if (properties != null) {
            Property location = (Property)properties.component1();
            Property password = (Property)properties.component2();
            certificate = new Certificate(location.getValue(), StringsKt.decodeToString((byte[])password.getValue()));
        } else {
            certificate = null;
        }
        return certificate;
    }

    /*
     * WARNING - void declaration
     */
    private List<Property> getRelatedProperties(List<Property> properties, KnownProperties.CertOrg certOrg) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = properties;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Property it = (Property)element$iv$iv;
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual((Object)it.getKey(), (Object)this.buildPropertyName("spring.ssl.bundle.jks.%s-%s.keystore.location", this.envService.tenant(), this.envService.lane(), certOrg.getOrg())) || Intrinsics.areEqual((Object)it.getKey(), (Object)this.buildPropertyName("spring.ssl.bundle.jks.%s-%s.keystore.password", this.envService.tenant(), this.envService.lane(), certOrg.getOrg())) || Intrinsics.areEqual((Object)it.getKey(), (Object)this.buildPropertyName("spring.ssl.bundle.jks.%s-%s.keystore.type", this.envService.tenant(), this.envService.lane(), certOrg.getOrg())) || Intrinsics.areEqual((Object)it.getKey(), (Object)this.buildPropertyName("spring.ssl.bundle.jks.%s-%s.truststore.location", this.envService.tenant(), this.envService.lane(), certOrg.getOrg())) || Intrinsics.areEqual((Object)it.getKey(), (Object)this.buildPropertyName("spring.ssl.bundle.jks.%s-%s.truststore.password", this.envService.tenant(), this.envService.lane(), certOrg.getOrg())) || Intrinsics.areEqual((Object)it.getKey(), (Object)this.buildPropertyName("spring.ssl.bundle.jks.%s-%s.truststore.type", this.envService.tenant(), this.envService.lane(), certOrg.getOrg()));
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private Certificate persistCertificate(List<Property> properties, Certificate certificate, KnownProperties.CertOrg certOrg) {
        Certificate certificate2;
        Pair existing = this.getCertificateProperties(properties, certOrg);
        if (existing != null) {
            if (certificate == null) {
                this.propertyService.deleteAll(this.getRelatedProperties(properties, certOrg));
                certificate2 = null;
            } else {
                Property existingLocation = (Property)existing.component1();
                Property existingPassword = (Property)existing.component2();
                Object[] objectArray = new Property[2];
                objectArray[0] = Property.copy$default((Property)existingLocation, null, null, (byte[])certificate.getCertificate(), (boolean)false, (int)11, null);
                String string = certificate.getPassword();
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                objectArray[1] = Property.copy$default((Property)existingPassword, null, null, (byte[])byArray, (boolean)false, (int)11, null);
                this.propertyService.saveAll(CollectionsKt.listOf((Object[])objectArray));
                certificate2 = certificate;
            }
        } else {
            certificate2 = this.createCertificate(certificate, certOrg);
        }
        return certificate2;
    }

    @Nullable
    public Certificate createCertificate(@Nullable Certificate certificate, @NotNull KnownProperties.CertOrg certOrg) {
        Intrinsics.checkNotNullParameter((Object)certOrg, (String)"certOrg");
        if (certificate == null) {
            return null;
        }
        Property keystoreLocation = new Property(null, this.buildPropertyName("spring.ssl.bundle.jks.%s-%s.keystore.location", this.envService.tenant(), this.envService.lane(), certOrg.getOrg()), certificate.getCertificate(), true);
        String string = this.buildPropertyName("spring.ssl.bundle.jks.%s-%s.keystore.password", this.envService.tenant(), this.envService.lane(), certOrg.getOrg());
        String string2 = certificate.getPassword();
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Property keystorePassword = new Property(null, string, byArray, false, 8, null);
        String string3 = this.buildPropertyName("spring.ssl.bundle.jks.%s-%s.keystore.type", this.envService.tenant(), this.envService.lane(), certOrg.getOrg());
        String string4 = KnownProperties.CertType.JKS.getType();
        byte[] byArray2 = string4.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        Property keystoreType = new Property(null, string3, byArray2, false, 8, null);
        Property truststoreLocation = new Property(null, this.buildPropertyName("spring.ssl.bundle.jks.%s-%s.truststore.location", this.envService.tenant(), this.envService.lane(), certOrg.getOrg()), FilesKt.readBytes((File)new File(this.truststoreLocation)), true);
        String string5 = this.buildPropertyName("spring.ssl.bundle.jks.%s-%s.truststore.password", this.envService.tenant(), this.envService.lane(), certOrg.getOrg());
        String string6 = this.truststorePassword;
        byte[] byArray3 = string6.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
        Property truststorePassword = new Property(null, string5, byArray3, false, 8, null);
        String string7 = this.buildPropertyName("spring.ssl.bundle.jks.%s-%s.truststore.type", this.envService.tenant(), this.envService.lane(), certOrg.getOrg());
        Object[] objectArray = KnownProperties.CertType.JKS.getType();
        byte[] byArray4 = objectArray.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"getBytes(...)");
        Property truststoreType = new Property(null, string7, byArray4, false, 8, null);
        objectArray = new Property[]{keystoreLocation, keystorePassword, keystoreType, truststoreLocation, truststorePassword, truststoreType};
        this.propertyService.saveAll(CollectionsKt.listOf((Object[])objectArray));
        return certificate;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }

    private static final Object getConfiguration$lambda$0() {
        return "properties exist but complete certificate not found";
    }
}

