/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.nihintegration.internal.config;

import gov.nih.era.svs.types.ObjectFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.nihintegration.SubmissionAgencyDataServiceClient;
import org.kuali.research.grants.nihintegration.SubmissionImageServiceClient;
import org.kuali.research.grants.nihintegration.SubmissionValidationServiceClient;
import org.kuali.research.grants.nihintegration.internal.client.SubmissionAgencyDataServiceClientImpl;
import org.kuali.research.grants.nihintegration.internal.client.SubmissionImageServiceClientImpl;
import org.kuali.research.grants.nihintegration.internal.client.SubmissionValidationServiceClientImpl;
import org.kuali.research.grants.nihintegration.internal.health.SubmissionAgencyDataServiceHealthCheck;
import org.kuali.research.grants.nihintegration.internal.health.SubmissionImageServiceHealthCheck;
import org.kuali.research.grants.nihintegration.internal.health.SubmissionValidationServiceHealthCheck;
import org.kuali.research.grants.nihintegration.internal.wsdl.SubmissionAgencyDataServiceWsdlFetcher;
import org.kuali.research.grants.nihintegration.internal.wsdl.SubmissionImageServiceWsdlFetcher;
import org.kuali.research.grants.nihintegration.internal.wsdl.SubmissionValidationServiceWsdlFetcher;
import org.kuali.research.grants.sys.environment.EnvService;
import org.kuali.research.grants.sys.reflect.ReflectUtils;
import org.kuali.research.grants.sys.ssl.EnvAwareSslBundleLookupService;
import org.kuali.research.grants.sys.web.client.DelayedConfigClientHttpRequestFactories;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.web.client.RestTemplate;
import org.springframework.ws.transport.WebServiceMessageSender;
import org.springframework.ws.transport.http.ClientHttpRequestMessageSender;

@Configuration
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\"\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\b\u0010\u0016\u001a\u00020\tH\u0017J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\"\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\b\u0010\u001d\u001a\u00020\tH\u0017J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\"\u0010 \u001a\u00020!2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0017\u00a8\u0006$"}, d2={"Lorg/kuali/research/grants/nihintegration/internal/config/NihConfiguration;", "", "<init>", "()V", "nihRestTemplate", "Lorg/springframework/web/client/RestTemplate;", "envAwareSslBundleLookupService", "Lorg/kuali/research/grants/sys/ssl/EnvAwareSslBundleLookupService;", "submissionAgencyDataServiceMarshaller", "Lorg/springframework/oxm/jaxb/Jaxb2Marshaller;", "submissionAgencyDataServiceHealthCheck", "Lorg/kuali/research/grants/nihintegration/internal/health/SubmissionAgencyDataServiceHealthCheck;", "submissionAgencyDataServiceClient", "Lorg/kuali/research/grants/nihintegration/SubmissionAgencyDataServiceClient;", "envService", "Lorg/kuali/research/grants/sys/environment/EnvService;", "uri", "", "nihMessageSender", "Lorg/springframework/ws/transport/WebServiceMessageSender;", "submissionAgencyDataServiceWsdlFetcher", "Lorg/kuali/research/grants/nihintegration/internal/wsdl/SubmissionAgencyDataServiceWsdlFetcher;", "submissionImageServiceMarshaller", "submissionImageServiceHealthCheck", "Lorg/kuali/research/grants/nihintegration/internal/health/SubmissionImageServiceHealthCheck;", "submissionImageServiceClient", "Lorg/kuali/research/grants/nihintegration/SubmissionImageServiceClient;", "submissionImageServiceWsdlFetcher", "Lorg/kuali/research/grants/nihintegration/internal/wsdl/SubmissionImageServiceWsdlFetcher;", "submissionValidationServiceMarshaller", "submissionValidationServiceHealthCheck", "Lorg/kuali/research/grants/nihintegration/internal/health/SubmissionValidationServiceHealthCheck;", "submissionValidationServiceClient", "Lorg/kuali/research/grants/nihintegration/SubmissionValidationServiceClient;", "submissionValidationServiceWsdlFetcher", "Lorg/kuali/research/grants/nihintegration/internal/wsdl/SubmissionValidationServiceWsdlFetcher;", "research-grants-backend"})
public class NihConfiguration {
    @Bean
    @NotNull
    public RestTemplate nihRestTemplate(@NotNull EnvAwareSslBundleLookupService envAwareSslBundleLookupService) {
        Intrinsics.checkNotNullParameter((Object)envAwareSslBundleLookupService, (String)"envAwareSslBundleLookupService");
        RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).requestFactory(() -> NihConfiguration.nihRestTemplate$lambda$1(envAwareSslBundleLookupService)).detectRequestFactory(false).build();
        Intrinsics.checkNotNullExpressionValue((Object)restTemplate, (String)"build(...)");
        return restTemplate;
    }

    @Bean
    @NotNull
    public Jaxb2Marshaller submissionAgencyDataServiceMarshaller() {
        Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
        marshaller.setContextPath(ReflectUtils.INSTANCE.getPackageName(Reflection.getOrCreateKotlinClass(gov.nih.era.sads.types.ObjectFactory.class)));
        return marshaller;
    }

    @Bean
    @NotNull
    public SubmissionAgencyDataServiceHealthCheck submissionAgencyDataServiceHealthCheck(@NotNull SubmissionAgencyDataServiceClient submissionAgencyDataServiceClient, @NotNull EnvService envService) {
        Intrinsics.checkNotNullParameter((Object)submissionAgencyDataServiceClient, (String)"submissionAgencyDataServiceClient");
        Intrinsics.checkNotNullParameter((Object)envService, (String)"envService");
        return new SubmissionAgencyDataServiceHealthCheck(submissionAgencyDataServiceClient, envService);
    }

    @Bean
    @NotNull
    public SubmissionAgencyDataServiceClient submissionAgencyDataServiceClient(@Value(value="${kuali.nih.sads.uri}") @NotNull String uri, @NotNull Jaxb2Marshaller submissionAgencyDataServiceMarshaller, @NotNull WebServiceMessageSender nihMessageSender) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)submissionAgencyDataServiceMarshaller, (String)"submissionAgencyDataServiceMarshaller");
        Intrinsics.checkNotNullParameter((Object)nihMessageSender, (String)"nihMessageSender");
        SubmissionAgencyDataServiceClientImpl client = new SubmissionAgencyDataServiceClientImpl(uri);
        client.setMarshaller((Marshaller)submissionAgencyDataServiceMarshaller);
        client.setUnmarshaller((Unmarshaller)submissionAgencyDataServiceMarshaller);
        client.getWebServiceTemplate().setMessageSender(nihMessageSender);
        return (SubmissionAgencyDataServiceClient)client;
    }

    @Bean
    @NotNull
    public SubmissionAgencyDataServiceWsdlFetcher submissionAgencyDataServiceWsdlFetcher(@NotNull RestTemplate nihRestTemplate, @NotNull EnvService envService) {
        Intrinsics.checkNotNullParameter((Object)nihRestTemplate, (String)"nihRestTemplate");
        Intrinsics.checkNotNullParameter((Object)envService, (String)"envService");
        return new SubmissionAgencyDataServiceWsdlFetcher(nihRestTemplate, envService);
    }

    @Bean
    @NotNull
    public Jaxb2Marshaller submissionImageServiceMarshaller() {
        Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
        marshaller.setContextPath(ReflectUtils.INSTANCE.getPackageName(Reflection.getOrCreateKotlinClass(gov.nih.era.submissionimageservice.ObjectFactory.class)));
        return marshaller;
    }

    @Bean
    @NotNull
    public SubmissionImageServiceHealthCheck submissionImageServiceHealthCheck(@NotNull SubmissionImageServiceClient submissionImageServiceClient, @NotNull EnvService envService) {
        Intrinsics.checkNotNullParameter((Object)submissionImageServiceClient, (String)"submissionImageServiceClient");
        Intrinsics.checkNotNullParameter((Object)envService, (String)"envService");
        return new SubmissionImageServiceHealthCheck(submissionImageServiceClient, envService);
    }

    @Bean
    @NotNull
    public SubmissionImageServiceClient submissionImageServiceClient(@Value(value="${kuali.nih.sil.uri}") @NotNull String uri, @NotNull Jaxb2Marshaller submissionImageServiceMarshaller, @NotNull WebServiceMessageSender nihMessageSender) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)submissionImageServiceMarshaller, (String)"submissionImageServiceMarshaller");
        Intrinsics.checkNotNullParameter((Object)nihMessageSender, (String)"nihMessageSender");
        SubmissionImageServiceClientImpl client = new SubmissionImageServiceClientImpl(uri);
        client.setMarshaller((Marshaller)submissionImageServiceMarshaller);
        client.setUnmarshaller((Unmarshaller)submissionImageServiceMarshaller);
        client.getWebServiceTemplate().setMessageSender(nihMessageSender);
        return (SubmissionImageServiceClient)client;
    }

    @Bean
    @NotNull
    public SubmissionImageServiceWsdlFetcher submissionImageServiceWsdlFetcher(@NotNull RestTemplate nihRestTemplate, @NotNull EnvService envService) {
        Intrinsics.checkNotNullParameter((Object)nihRestTemplate, (String)"nihRestTemplate");
        Intrinsics.checkNotNullParameter((Object)envService, (String)"envService");
        return new SubmissionImageServiceWsdlFetcher(nihRestTemplate, envService);
    }

    @Bean
    @NotNull
    public Jaxb2Marshaller submissionValidationServiceMarshaller() {
        Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
        marshaller.setContextPath(ReflectUtils.INSTANCE.getPackageName(Reflection.getOrCreateKotlinClass(ObjectFactory.class)));
        return marshaller;
    }

    @Bean
    @NotNull
    public SubmissionValidationServiceHealthCheck submissionValidationServiceHealthCheck(@NotNull SubmissionValidationServiceClient submissionValidationServiceClient, @NotNull EnvService envService) {
        Intrinsics.checkNotNullParameter((Object)submissionValidationServiceClient, (String)"submissionValidationServiceClient");
        Intrinsics.checkNotNullParameter((Object)envService, (String)"envService");
        return new SubmissionValidationServiceHealthCheck(submissionValidationServiceClient, envService);
    }

    @Bean
    @NotNull
    public SubmissionValidationServiceClient submissionValidationServiceClient(@Value(value="${kuali.nih.svs.uri}") @NotNull String uri, @NotNull Jaxb2Marshaller submissionValidationServiceMarshaller, @NotNull WebServiceMessageSender nihMessageSender) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)submissionValidationServiceMarshaller, (String)"submissionValidationServiceMarshaller");
        Intrinsics.checkNotNullParameter((Object)nihMessageSender, (String)"nihMessageSender");
        SubmissionValidationServiceClientImpl client = new SubmissionValidationServiceClientImpl(uri);
        client.setMarshaller((Marshaller)submissionValidationServiceMarshaller);
        client.setUnmarshaller((Unmarshaller)submissionValidationServiceMarshaller);
        client.getWebServiceTemplate().setMessageSender(nihMessageSender);
        return (SubmissionValidationServiceClient)client;
    }

    @Bean
    @NotNull
    public SubmissionValidationServiceWsdlFetcher submissionValidationServiceWsdlFetcher(@NotNull RestTemplate nihRestTemplate, @NotNull EnvService envService) {
        Intrinsics.checkNotNullParameter((Object)nihRestTemplate, (String)"nihRestTemplate");
        Intrinsics.checkNotNullParameter((Object)envService, (String)"envService");
        return new SubmissionValidationServiceWsdlFetcher(nihRestTemplate, envService);
    }

    @Bean
    @NotNull
    public WebServiceMessageSender nihMessageSender(@NotNull EnvAwareSslBundleLookupService envAwareSslBundleLookupService) {
        Intrinsics.checkNotNullParameter((Object)envAwareSslBundleLookupService, (String)"envAwareSslBundleLookupService");
        return (WebServiceMessageSender)new ClientHttpRequestMessageSender(DelayedConfigClientHttpRequestFactories.Simple.INSTANCE.get(() -> NihConfiguration.nihMessageSender$lambda$2(envAwareSslBundleLookupService)));
    }

    private static final ClientHttpRequestFactorySettings nihRestTemplate$lambda$1$lambda$0(EnvAwareSslBundleLookupService $envAwareSslBundleLookupService) {
        return ClientHttpRequestFactorySettings.defaults().withSslBundle($envAwareSslBundleLookupService.getBundle("nih"));
    }

    private static final ClientHttpRequestFactory nihRestTemplate$lambda$1(EnvAwareSslBundleLookupService $envAwareSslBundleLookupService) {
        return DelayedConfigClientHttpRequestFactories.Simple.INSTANCE.get(() -> NihConfiguration.nihRestTemplate$lambda$1$lambda$0($envAwareSslBundleLookupService));
    }

    private static final ClientHttpRequestFactorySettings nihMessageSender$lambda$2(EnvAwareSslBundleLookupService $envAwareSslBundleLookupService) {
        return ClientHttpRequestFactorySettings.defaults().withSslBundle($envAwareSslBundleLookupService.getBundle("nih"));
    }
}

