/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.conversion.internal.converter;

import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.grants.sys.conversion.internal.converter.StringToBooleanConverter;
import org.springframework.core.convert.converter.Converter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \t2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0017\u00a2\u0006\u0002\u0010\b\u00a8\u0006\n"}, d2={"Lorg/kuali/research/grants/sys/conversion/internal/converter/StringToBooleanConverter;", "Lorg/springframework/core/convert/converter/Converter;", "", "", "<init>", "()V", "convert", "source", "(Ljava/lang/String;)Ljava/lang/Boolean;", "Companion", "research-grants-backend"})
public final class StringToBooleanConverter
implements Converter<String, Boolean> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> TRUE_VALUES;
    @NotNull
    private static final Set<String> FALSE_VALUES;

    @org.springframework.lang.Nullable
    @Nullable
    public Boolean convert(@NotNull String source) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String value = ((Object)StringsKt.trim((CharSequence)source)).toString();
        if (((CharSequence)value).length() == 0) {
            return null;
        }
        String string = value.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        value = string;
        if (TRUE_VALUES.contains(value)) {
            bl = true;
        } else if (FALSE_VALUES.contains(value)) {
            bl = false;
        } else {
            throw new IllegalArgumentException("Invalid boolean value '" + source + "'");
        }
        return bl;
    }

    static {
        Object[] objectArray = new String[]{"true", "on", "yes", "1", "y"};
        TRUE_VALUES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"false", "off", "no", "0", "n"};
        FALSE_VALUES = SetsKt.setOf((Object[])objectArray);
    }
}

