/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.authintegration.internal.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.sys.authintegration.AuthRestClient;
import org.kuali.research.grants.sys.authintegration.AuthUser;
import org.kuali.research.grants.sys.authintegration.internal.filter.AuthFilter;
import org.kuali.research.grants.sys.authintegration.internal.service.MutableAuthService;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 '2\u00020\u0001:\u0001'B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014Jn\u0010\u0015\u001a\u00020\u00102\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00172#\u0010\u0018\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\f0\u00192!\u0010\u001d\u001a\u001d\u0012\u0013\u0012\u00110\u001e\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00100\u00192\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100\u0017H\u0002J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/kuali/research/grants/sys/authintegration/internal/filter/AuthFilter;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "excludedUrls", "", "", "authRestClient", "Lorg/kuali/research/grants/sys/authintegration/AuthRestClient;", "mutableAuthService", "Lorg/kuali/research/grants/sys/authintegration/internal/service/MutableAuthService;", "<init>", "(Ljava/util/Set;Lorg/kuali/research/grants/sys/authintegration/AuthRestClient;Lorg/kuali/research/grants/sys/authintegration/internal/service/MutableAuthService;)V", "shouldNotFilter", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "doFilterInternal", "", "response", "Ljakarta/servlet/http/HttpServletResponse;", "filterChain", "Ljakarta/servlet/FilterChain;", "doAuthorize", "tokenFetch", "Lkotlin/Function0;", "verificaton", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "token", "successResponse", "Lorg/kuali/research/grants/sys/authintegration/AuthUser;", "authUser", "failureResponse", "isApiCall", "getBearerToken", "getCookieToken", "redirectToLoginUrl", "returnUrl", "verificationToken", "Companion", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nAuthFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthFilter.kt\norg/kuali/research/grants/sys/authintegration/internal/filter/AuthFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,143:1\n1761#2,3:144\n1310#3,2:147\n*S KotlinDebug\n*F\n+ 1 AuthFilter.kt\norg/kuali/research/grants/sys/authintegration/internal/filter/AuthFilter\n*L\n35#1:144,3\n120#1:147,2\n*E\n"})
public final class AuthFilter
extends OncePerRequestFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> excludedUrls;
    @NotNull
    private final AuthRestClient authRestClient;
    @NotNull
    private final MutableAuthService mutableAuthService;
    @NotNull
    public static final String CLIENT_ID = "client_id";
    @NotNull
    public static final String CLIENT_ID_PARAM = "grants";
    @NotNull
    public static final String AUTH_CODE_PARAM = "code";
    @NotNull
    public static final String REDIRECT_URI = "redirect_uri";
    @NotNull
    public static final String AUTH_STATE = "state";
    @NotNull
    public static final String RESPONSE_TYPE = "response_type";
    @NotNull
    public static final String VERIFICATION_TOKEN = "verificationToken";

    public AuthFilter(@NotNull Set<String> excludedUrls, @NotNull AuthRestClient authRestClient, @NotNull MutableAuthService mutableAuthService) {
        Intrinsics.checkNotNullParameter(excludedUrls, (String)"excludedUrls");
        Intrinsics.checkNotNullParameter((Object)authRestClient, (String)"authRestClient");
        Intrinsics.checkNotNullParameter((Object)mutableAuthService, (String)"mutableAuthService");
        this.excludedUrls = excludedUrls;
        this.authRestClient = authRestClient;
        this.mutableAuthService = mutableAuthService;
    }

    protected boolean shouldNotFilter(@NotNull HttpServletRequest request) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Iterable $this$any$iv = this.excludedUrls;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = request.getRequestURI();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestURI(...)");
                    CharSequence charSequence = string;
                    if (!new Regex(it).matches(charSequence)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response2, @NotNull FilterChain filterChain) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Intrinsics.checkNotNullParameter((Object)filterChain, (String)"filterChain");
        Function1 verification = AuthFilter::doFilterInternal$lambda$1;
        Function1 successResponse = arg_0 -> AuthFilter.doFilterInternal$lambda$2(this, filterChain, request, response2, arg_0);
        Function0 failureResponse = () -> AuthFilter.doFilterInternal$lambda$3(this, response2);
        if (this.isApiCall(request)) {
            this.doAuthorize(() -> AuthFilter.doFilterInternal$lambda$4(this, request), verification, successResponse, failureResponse);
        } else {
            this.doAuthorize(() -> AuthFilter.doFilterInternal$lambda$5(this, request), arg_0 -> AuthFilter.doFilterInternal$lambda$6(request, verification, arg_0), successResponse, () -> AuthFilter.doFilterInternal$lambda$7(this, request, failureResponse, response2));
        }
    }

    private final void doAuthorize(Function0<String> tokenFetch, Function1<? super String, Boolean> verificaton, Function1<? super AuthUser, Unit> successResponse, Function0<Unit> failureResponse) {
        String token = (String)tokenFetch.invoke();
        if (!((Boolean)verificaton.invoke((Object)token)).booleanValue()) {
            failureResponse.invoke();
        } else {
            String string = token;
            Intrinsics.checkNotNull((Object)string);
            AuthUser authUser = this.authRestClient.current(string);
            if (authUser == null) {
                failureResponse.invoke();
            } else {
                successResponse.invoke((Object)authUser);
            }
        }
    }

    private final boolean isApiCall(HttpServletRequest request) {
        String string = request.getRequestURI();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestURI(...)");
        return StringsKt.startsWith$default((String)string, (String)"/api/", (boolean)false, (int)2, null);
    }

    private final String getBearerToken(HttpServletRequest request) {
        String string = request.getHeader("Authorization");
        return string != null ? StringsKt.substringAfter$default((String)string, (String)"Bearer ", null, (int)2, null) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getCookieToken(HttpServletRequest request) {
        Cookie element$iv;
        Cookie[] cookieArray;
        block2: {
            Cookie[] cookieArray2 = request.getCookies();
            cookieArray = cookieArray2;
            if (cookieArray2 == null) return null;
            Cookie[] $this$firstOrNull$iv = cookieArray;
            boolean $i$f$firstOrNull = false;
            int n = 0;
            int n2 = $this$firstOrNull$iv.length;
            while (n < n2) {
                Cookie it = element$iv = $this$firstOrNull$iv[n];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"authToken")) {
                    ++n;
                    continue;
                }
                break block2;
            }
            return null;
        }
        Cookie cookie = element$iv;
        cookieArray = cookie;
        if (cookie == null) return null;
        String string = cookieArray.getValue();
        return string;
    }

    @NotNull
    public final String redirectToLoginUrl(@NotNull String returnUrl, @NotNull String verificationToken) {
        Intrinsics.checkNotNullParameter((Object)returnUrl, (String)"returnUrl");
        Intrinsics.checkNotNullParameter((Object)verificationToken, (String)VERIFICATION_TOKEN);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)this.authRestClient.serviceUri()).path("/auth/authorize");
        Intrinsics.checkNotNullExpressionValue((Object)uriComponentsBuilder, (String)"path(...)");
        UriComponentsBuilder loginUrlBuilder = uriComponentsBuilder;
        Object[] objectArray = new Object[]{CLIENT_ID_PARAM};
        loginUrlBuilder.queryParam(CLIENT_ID, objectArray);
        objectArray = new Object[]{verificationToken};
        loginUrlBuilder.queryParam(AUTH_STATE, objectArray);
        objectArray = new Object[]{AUTH_CODE_PARAM};
        loginUrlBuilder.queryParam(RESPONSE_TYPE, objectArray);
        objectArray = new Object[]{returnUrl};
        loginUrlBuilder.queryParam(REDIRECT_URI, objectArray);
        String string = loginUrlBuilder.toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        return string;
    }

    private static final boolean doFilterInternal$lambda$1(String token) {
        CharSequence charSequence = token;
        return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    private static final Unit doFilterInternal$lambda$2(AuthFilter this$0, FilterChain $filterChain, HttpServletRequest $request, HttpServletResponse $response, AuthUser authUser) {
        Intrinsics.checkNotNullParameter((Object)authUser, (String)"authUser");
        this$0.mutableAuthService.setAuthUser(authUser);
        $filterChain.doFilter((ServletRequest)$request, (ServletResponse)$response);
        return Unit.INSTANCE;
    }

    private static final Unit doFilterInternal$lambda$3(AuthFilter this$0, HttpServletResponse $response) {
        this$0.mutableAuthService.removeAuthUser();
        $response.sendError(401);
        return Unit.INSTANCE;
    }

    private static final String doFilterInternal$lambda$4(AuthFilter this$0, HttpServletRequest $request) {
        return this$0.getBearerToken($request);
    }

    private static final String doFilterInternal$lambda$5(AuthFilter this$0, HttpServletRequest $request) {
        return this$0.getCookieToken($request);
    }

    private static final boolean doFilterInternal$lambda$6(HttpServletRequest $request, Function1 $verification, String token) {
        String verificationToken = $request.getParameter(VERIFICATION_TOKEN);
        return (Boolean)$verification.invoke((Object)token) != false && (verificationToken == null || Intrinsics.areEqual((Object)verificationToken, (Object)$request.getSession().getAttribute(VERIFICATION_TOKEN)));
    }

    private static final Unit doFilterInternal$lambda$7(AuthFilter this$0, HttpServletRequest $request, Function0 $failureResponse, HttpServletResponse $response) {
        this$0.mutableAuthService.removeAuthUser();
        if ($request.getParameter(VERIFICATION_TOKEN) != null) {
            $failureResponse.invoke();
        } else {
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String verificationToken = string;
            $request.getSession().setAttribute(VERIFICATION_TOKEN, (Object)verificationToken);
            Object[] objectArray = new Object[]{verificationToken};
            String string2 = UriComponentsBuilder.fromUriString((String)$request.getRequestURL().toString()).query($request.getQueryString()).queryParam(VERIFICATION_TOKEN, objectArray).build().toUriString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUriString(...)");
            String returnUrl = string2;
            $response.sendRedirect(this$0.redirectToLoginUrl(returnUrl, verificationToken));
        }
        return Unit.INSTANCE;
    }
}

