/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.tenancy.internal.service;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.sys.tenancy.TenancyService;
import org.kuali.research.grants.sys.tenancy.internal.service.MutableTenancyService;
import org.kuali.research.grants.sys.tenancy.internal.service.TenancyServiceImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0015B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016J!\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/kuali/research/grants/sys/tenancy/internal/service/TenancyServiceImpl;", "Lorg/kuali/research/grants/sys/tenancy/internal/service/MutableTenancyService;", "kualiEnvironments", "", "", "kualiEnvironmentSystem", "<init>", "(Ljava/util/Set;Ljava/lang/String;)V", "isValidTenantHost", "", "host", "isSet", "setTenantHost", "", "removeTenantHost", "getTenantHost", "doInInternal", "R", "task", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "TenancyHostState", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nTenancyServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TenancyServiceImpl.kt\norg/kuali/research/grants/sys/tenancy/internal/service/TenancyServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1761#2,3:52\n*S KotlinDebug\n*F\n+ 1 TenancyServiceImpl.kt\norg/kuali/research/grants/sys/tenancy/internal/service/TenancyServiceImpl\n*L\n11#1:52,3\n*E\n"})
public final class TenancyServiceImpl
implements MutableTenancyService {
    @NotNull
    private final Set<String> kualiEnvironments;
    @NotNull
    private final String kualiEnvironmentSystem;

    public TenancyServiceImpl(@NotNull Set<String> kualiEnvironments, @NotNull String kualiEnvironmentSystem) {
        Intrinsics.checkNotNullParameter(kualiEnvironments, (String)"kualiEnvironments");
        Intrinsics.checkNotNullParameter((Object)kualiEnvironmentSystem, (String)"kualiEnvironmentSystem");
        this.kualiEnvironments = kualiEnvironments;
        this.kualiEnvironmentSystem = kualiEnvironmentSystem;
    }

    public boolean isValidTenantHost(@NotNull String host) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Iterable $this$any$iv = TenancyService.Companion.getDOMAIN_TO_SYSTEM().keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)host, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl && this.kualiEnvironments.contains(host);
    }

    public boolean isSet() {
        return TenancyHostState.INSTANCE.getHosts().get() != null;
    }

    public void setTenantHost(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (!this.isValidTenantHost(host)) {
            throw new IllegalArgumentException("Invalid tenant host: " + host);
        }
        TenancyHostState.INSTANCE.getHosts().set(host);
    }

    public void removeTenantHost() {
        TenancyHostState.INSTANCE.getHosts().remove();
    }

    @NotNull
    public String getTenantHost() {
        String string = (String)TenancyHostState.INSTANCE.getHosts().get();
        if (string == null) {
            throw new IllegalStateException("tenant host not set");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R doInInternal(@NotNull Function0<? extends R> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        if (this.isSet()) {
            String previousHost = this.getTenantHost();
            try {
                this.setTenantHost(this.kualiEnvironmentSystem);
                Object object = task.invoke();
                return (R)object;
            }
            finally {
                this.setTenantHost(previousHost);
            }
        }
        try {
            this.setTenantHost(this.kualiEnvironmentSystem);
            Object object = task.invoke();
            return (R)object;
        }
        finally {
            this.removeTenantHost();
        }
    }
}

