/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.internal.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.sys.db.internal.tenant.SchemaMultiTenantConnectionProvider;
import org.kuali.research.grants.sys.db.internal.tenant.TenantIdentifierResolver;
import org.kuali.research.grants.sys.logging.LoggingRequestInterceptor;
import org.kuali.research.grants.sys.tenancy.TenancyService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.client.RestClient;

@Configuration
@EnableCaching
@EnableAsync
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\b\u0010\r\u001a\u00020\u000eH\u0017J\u0018\u0010\u000f\u001a\u00020\u00102\u000e\b\u0001\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0017J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017\u00a8\u0006\u0016"}, d2={"Lorg/kuali/research/grants/sys/internal/config/SysConfiguration;", "", "<init>", "()V", "tenantIdentifierResolver", "Lorg/springframework/boot/autoconfigure/orm/jpa/HibernatePropertiesCustomizer;", "tenancyService", "Lorg/kuali/research/grants/sys/tenancy/TenancyService;", "schemaMultiTenantConnectionProvider", "datasource", "Ljavax/sql/DataSource;", "dataSourceProperties", "Lorg/springframework/boot/autoconfigure/jdbc/DataSourceProperties;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "loggingRequestInterceptor", "Lorg/springframework/http/client/ClientHttpRequestInterceptor;", "ignoredContentTypes", "", "Lorg/springframework/http/MediaType;", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nSysConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SysConfiguration.kt\norg/kuali/research/grants/sys/internal/config/SysConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1869#2,2:85\n*S KotlinDebug\n*F\n+ 1 SysConfiguration.kt\norg/kuali/research/grants/sys/internal/config/SysConfiguration\n*L\n74#1:85,2\n*E\n"})
public class SysConfiguration {
    @Bean
    @NotNull
    public HibernatePropertiesCustomizer tenantIdentifierResolver(@NotNull TenancyService tenancyService) {
        Intrinsics.checkNotNullParameter((Object)tenancyService, (String)"tenancyService");
        return (HibernatePropertiesCustomizer)new TenantIdentifierResolver(tenancyService);
    }

    @Bean
    @NotNull
    public HibernatePropertiesCustomizer schemaMultiTenantConnectionProvider(@NotNull DataSource datasource, @NotNull DataSourceProperties dataSourceProperties) {
        Intrinsics.checkNotNullParameter((Object)datasource, (String)"datasource");
        Intrinsics.checkNotNullParameter((Object)dataSourceProperties, (String)"dataSourceProperties");
        return (HibernatePropertiesCustomizer)new SchemaMultiTenantConnectionProvider(datasource, dataSourceProperties);
    }

    @Bean
    @NotNull
    public ObjectMapper objectMapper() {
        Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder();
        builder.failOnUnknownProperties(true);
        Object[] objectArray = new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS};
        builder.featuresToDisable(objectArray);
        ObjectMapper objectMapper = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"build(...)");
        return objectMapper;
    }

    @Bean
    @NotNull
    public ClientHttpRequestInterceptor loggingRequestInterceptor(@Value(value="${logging.request.interceptor.ignore.content-types}") @NotNull Set<? extends MediaType> ignoredContentTypes) {
        Intrinsics.checkNotNullParameter(ignoredContentTypes, (String)"ignoredContentTypes");
        return (ClientHttpRequestInterceptor)new LoggingRequestInterceptor(ignoredContentTypes);
    }

    @Bean
    @NotNull
    public RestClient.Builder restClientBuilder(@NotNull ObjectMapper objectMapper, @NotNull ClientHttpRequestInterceptor loggingRequestInterceptor) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)loggingRequestInterceptor, (String)"loggingRequestInterceptor");
        RestClient.Builder builder = RestClient.builder().requestInterceptors(arg_0 -> SysConfiguration.restClientBuilder$lambda$0(loggingRequestInterceptor, arg_0)).messageConverters(arg_0 -> SysConfiguration.restClientBuilder$lambda$2(objectMapper, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"messageConverters(...)");
        return builder;
    }

    private static final void restClientBuilder$lambda$0(ClientHttpRequestInterceptor $loggingRequestInterceptor, List interceptors) {
        interceptors.add($loggingRequestInterceptor);
    }

    private static final void restClientBuilder$lambda$2(ObjectMapper $objectMapper, List converters) {
        Intrinsics.checkNotNull((Object)converters);
        Iterable $this$forEach$iv = converters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpMessageConverter converter = (HttpMessageConverter)element$iv;
            boolean bl = false;
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            ((MappingJackson2HttpMessageConverter)converter).setObjectMapper($objectMapper);
        }
    }
}

