/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.proposal.internal.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.proposal.internal.assembler.PropOppPackageModelAssembler;
import org.kuali.research.grants.proposal.internal.dto.PropOppPackageUpsertDto;
import org.kuali.research.grants.proposal.internal.entity.File;
import org.kuali.research.grants.proposal.internal.entity.PropOppPackage;
import org.kuali.research.grants.proposal.internal.model.PropOppPackageModel;
import org.kuali.research.grants.proposal.internal.repository.PropOppPackageRepository;
import org.kuali.research.grants.proposal.internal.service.PropOppPackageService;
import org.kuali.research.grants.proposal.internal.util.PropOpportunityId;
import org.kuali.research.grants.proposal.internal.util.ProposalId;
import org.kuali.research.grants.sys.hateoas.ProblemModel;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/proposals"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000eH\u0017J,\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0012\u001a\u00020\u000eH\u0017J@\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00112\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0015\u001a\u00020\u000e2\b\b\u0001\u0010\u0016\u001a\u00020\u000e2\b\b\u0001\u0010\u0012\u001a\u00020\u000eH\u0017J2\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00180\u00112\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00112\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0012\u001a\u00020\u000eH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/kuali/research/grants/proposal/internal/controller/PropOppPackageController;", "", "repository", "Lorg/kuali/research/grants/proposal/internal/repository/PropOppPackageRepository;", "assembler", "Lorg/kuali/research/grants/proposal/internal/assembler/PropOppPackageModelAssembler;", "propOppPackageService", "Lorg/kuali/research/grants/proposal/internal/service/PropOppPackageService;", "<init>", "(Lorg/kuali/research/grants/proposal/internal/repository/PropOppPackageRepository;Lorg/kuali/research/grants/proposal/internal/assembler/PropOppPackageModelAssembler;Lorg/kuali/research/grants/proposal/internal/service/PropOppPackageService;)V", "getAllPropOppPackages", "Lorg/springframework/hateoas/CollectionModel;", "Lorg/kuali/research/grants/proposal/internal/model/PropOppPackageModel;", "proposalId", "", "propOpportunityId", "getPropOppPackageById", "Lorg/springframework/http/ResponseEntity;", "id", "getPropOppPkgSchemaById", "", "packageId", "schemaId", "createOrUpdatePropOppPackage", "Lorg/kuali/research/grants/sys/hateoas/ProblemModel;", "propOppPackageUpsertDto", "Lorg/kuali/research/grants/proposal/internal/dto/PropOppPackageUpsertDto;", "deletePropOppPackage", "Ljava/lang/Void;", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nPropOppPackageController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropOppPackageController.kt\norg/kuali/research/grants/proposal/internal/controller/PropOppPackageController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1563#2:113\n1634#2,3:114\n*S KotlinDebug\n*F\n+ 1 PropOppPackageController.kt\norg/kuali/research/grants/proposal/internal/controller/PropOppPackageController\n*L\n33#1:113\n33#1:114,3\n*E\n"})
public class PropOppPackageController {
    @NotNull
    private final PropOppPackageRepository repository;
    @NotNull
    private final PropOppPackageModelAssembler assembler;
    @NotNull
    private final PropOppPackageService propOppPackageService;

    public PropOppPackageController(@NotNull PropOppPackageRepository repository, @NotNull PropOppPackageModelAssembler assembler, @NotNull PropOppPackageService propOppPackageService) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)assembler, (String)"assembler");
        Intrinsics.checkNotNullParameter((Object)propOppPackageService, (String)"propOppPackageService");
        this.repository = repository;
        this.assembler = assembler;
        this.propOppPackageService = propOppPackageService;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages"})
    @NotNull
    public CollectionModel<PropOppPackageModel> getAllPropOppPackages(@PathVariable long proposalId, @PathVariable long propOpportunityId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.repository.findByProposalIdAndPropOpportunityId(proposalId, propOpportunityId);
        PropOppPackageModelAssembler propOppPackageModelAssembler = this.assembler;
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PropOppPackage propOppPackage = (PropOppPackage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)proposalId, (Object)it));
        }
        RepresentationModel representationModel = propOppPackageModelAssembler.toCollectionModel((Iterable)((List)destination$iv$iv)).add(WebMvcLinkBuilder.linkTo((Object)((PropOppPackageController)WebMvcLinkBuilder.methodOn(PropOppPackageController.class, (Object[])new Object[0])).getAllPropOppPackages(proposalId, propOpportunityId)).withSelfRel());
        Intrinsics.checkNotNullExpressionValue((Object)representationModel, (String)"add(...)");
        return (CollectionModel)representationModel;
    }

    @GetMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages/{id}"})
    @NotNull
    public ResponseEntity<PropOppPackageModel> getPropOppPackageById(@PathVariable long proposalId, @PathVariable long propOpportunityId, @PathVariable long id) {
        ResponseEntity responseEntity = this.repository.findByProposalIdAndPropOpportunityIdAndId(proposalId, propOpportunityId, id).map(arg_0 -> PropOppPackageController.getPropOppPackageById$lambda$2(arg_0 -> PropOppPackageController.getPropOppPackageById$lambda$1(this, proposalId, arg_0), arg_0)).orElse(ResponseEntity.notFound().build());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"orElse(...)");
        return responseEntity;
    }

    @GetMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages/{packageId}/schemas/{schemaId}/schema-files/{id}/download"}, produces={"application/xml"})
    @NotNull
    public ResponseEntity<byte[]> getPropOppPkgSchemaById(@PathVariable long proposalId, @PathVariable long propOpportunityId, @PathVariable long packageId, @PathVariable long schemaId, @PathVariable long id) {
        ResponseEntity responseEntity = this.repository.findSchemaFileByProposalIdAndPropOpportunityIdAndPropOppPackageIdAndAndSchemaIdAndId(proposalId, propOpportunityId, packageId, schemaId, id).map(arg_0 -> PropOppPackageController.getPropOppPkgSchemaById$lambda$4(PropOppPackageController::getPropOppPkgSchemaById$lambda$3, arg_0)).orElse(ResponseEntity.notFound().build());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"orElse(...)");
        return responseEntity;
    }

    @PostMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages"})
    @NotNull
    public ResponseEntity<ProblemModel<PropOppPackageModel>> createOrUpdatePropOppPackage(@PathVariable long proposalId, @PathVariable long propOpportunityId, @RequestBody @NotNull PropOppPackageUpsertDto propOppPackageUpsertDto) {
        Intrinsics.checkNotNullParameter((Object)propOppPackageUpsertDto, (String)"propOppPackageUpsertDto");
        PropOppPackage savedPropOppPackage = this.propOppPackageService.createOrUpdatePropOppPackage-Zfh2DEQ(ProposalId.constructor-impl((long)proposalId), PropOpportunityId.constructor-impl((long)propOpportunityId), propOppPackageUpsertDto);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)ProblemModel.Companion.victory$default((ProblemModel.Companion)ProblemModel.Companion, (RepresentationModel)((RepresentationModel)this.assembler.toModel(TuplesKt.to((Object)proposalId, (Object)savedPropOppPackage))), null, (int)2, null));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @DeleteMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages/{id}"})
    @NotNull
    public ResponseEntity<Void> deletePropOppPackage(@PathVariable long proposalId, @PathVariable long propOpportunityId, @PathVariable long id) {
        ResponseEntity responseEntity = this.repository.findByProposalIdAndPropOpportunityIdAndId(proposalId, propOpportunityId, id).map(arg_0 -> PropOppPackageController.deletePropOppPackage$lambda$6(arg_0 -> PropOppPackageController.deletePropOppPackage$lambda$5(this, arg_0), arg_0)).orElse(ResponseEntity.notFound().build());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"orElse(...)");
        return responseEntity;
    }

    private static final ResponseEntity getPropOppPackageById$lambda$1(PropOppPackageController this$0, long $proposalId, PropOppPackage propOppPackage) {
        return ResponseEntity.ok((Object)this$0.assembler.toModel(TuplesKt.to((Object)$proposalId, (Object)propOppPackage)));
    }

    private static final ResponseEntity getPropOppPackageById$lambda$2(Function1 $tmp0, Object p0) {
        return (ResponseEntity)$tmp0.invoke(p0);
    }

    private static final ResponseEntity getPropOppPkgSchemaById$lambda$3(File file) {
        return ResponseEntity.ok((Object)file.getData());
    }

    private static final ResponseEntity getPropOppPkgSchemaById$lambda$4(Function1 $tmp0, Object p0) {
        return (ResponseEntity)$tmp0.invoke(p0);
    }

    private static final ResponseEntity deletePropOppPackage$lambda$5(PropOppPackageController this$0, PropOppPackage propOppPackage) {
        this$0.repository.delete((Object)propOppPackage);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    private static final ResponseEntity deletePropOppPackage$lambda$6(Function1 $tmp0, Object p0) {
        return (ResponseEntity)$tmp0.invoke(p0);
    }
}

