/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.proposal.internal.controller;

import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.grants.proposal.internal.entity.RevisionType;
import org.kuali.research.grants.proposal.internal.model.RevisionTypeModel;
import org.kuali.research.grants.proposal.internal.repository.RevisionTypeRepository;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/revision-types"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0017\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\rH\u0017\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/kuali/research/grants/proposal/internal/controller/RevisionTypeController;", "", "repository", "Lorg/kuali/research/grants/proposal/internal/repository/RevisionTypeRepository;", "assembler", "Lorg/springframework/hateoas/server/RepresentationModelAssembler;", "Lorg/kuali/research/grants/proposal/internal/entity/RevisionType;", "Lorg/kuali/research/grants/proposal/internal/model/RevisionTypeModel;", "<init>", "(Lorg/kuali/research/grants/proposal/internal/repository/RevisionTypeRepository;Lorg/springframework/hateoas/server/RepresentationModelAssembler;)V", "all", "Lorg/springframework/hateoas/CollectionModel;", "active", "", "(Ljava/lang/Boolean;)Lorg/springframework/hateoas/CollectionModel;", "one", "Lorg/springframework/http/ResponseEntity;", "id", "", "research-grants-backend"})
public class RevisionTypeController {
    @NotNull
    private final RevisionTypeRepository repository;
    @NotNull
    private final RepresentationModelAssembler<RevisionType, RevisionTypeModel> assembler;

    public RevisionTypeController(@NotNull RevisionTypeRepository repository, @NotNull RepresentationModelAssembler<RevisionType, RevisionTypeModel> assembler) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter(assembler, (String)"assembler");
        this.repository = repository;
        this.assembler = assembler;
    }

    @GetMapping
    @NotNull
    public CollectionModel<RevisionTypeModel> all(@RequestParam(required=false) @Nullable Boolean active) {
        List list;
        if (active != null) {
            list = this.repository.findByActive(active.booleanValue());
        } else {
            List list2 = this.repository.findAll();
            Intrinsics.checkNotNull((Object)list2);
            list = list2;
        }
        List revisionTypes = list;
        RepresentationModel representationModel = this.assembler.toCollectionModel((Iterable)revisionTypes).add(WebMvcLinkBuilder.linkTo((Object)((RevisionTypeController)WebMvcLinkBuilder.methodOn(RevisionTypeController.class, (Object[])new Object[0])).all(active)).withSelfRel());
        Intrinsics.checkNotNullExpressionValue((Object)representationModel, (String)"add(...)");
        return (CollectionModel)representationModel;
    }

    @GetMapping(value={"/{id}"})
    @NotNull
    public ResponseEntity<RevisionTypeModel> one(@PathVariable long id) {
        ResponseEntity responseEntity;
        Optional optional = this.repository.findById((Object)id);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findById(...)");
        Optional revisionType = optional;
        if (revisionType.isPresent()) {
            ResponseEntity responseEntity2 = ResponseEntity.ok((Object)this.assembler.toModel(revisionType.get()));
            Intrinsics.checkNotNull((Object)responseEntity2);
            responseEntity = responseEntity2;
        } else {
            ResponseEntity responseEntity3 = ResponseEntity.notFound().build();
            Intrinsics.checkNotNull((Object)responseEntity3);
            responseEntity = responseEntity3;
        }
        return responseEntity;
    }
}

