/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.redirect.internal.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;

@Controller
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017\u00a8\u0006\n"}, d2={"Lorg/kuali/research/grants/sys/redirect/internal/controller/RedirectController;", "", "<init>", "()V", "index", "", "redirect", "Ljava/net/URI;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "research-grants-backend"})
public class RedirectController {
    @GetMapping(value={"/"})
    @NotNull
    public String index(@RequestParam @NotNull URI redirect, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)redirect, (String)"redirect");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (redirect.isAbsolute()) {
            String requestHost = request.getServerName();
            String requestScheme = request.getScheme();
            if (!Intrinsics.areEqual((Object)redirect.getHost(), (Object)requestHost) || !Intrinsics.areEqual((Object)redirect.getScheme(), (Object)requestScheme)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Redirect to external domain is not allowed");
            }
        }
        return "redirect:" + redirect.toASCIIString();
    }
}

