/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.opportunity.internal.controller;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.ggintegration.OpportunityFilesRestClient;
import org.kuali.research.grants.ggintegration.OpportunityFoldersRestClient;
import org.kuali.research.grants.opportunity.internal.model.FileFolderModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/opportunities/"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/kuali/research/grants/opportunity/internal/controller/FileController;", "Lorg/apache/logging/log4j/kotlin/Logging;", "opportunityFilesRestClient", "Lorg/kuali/research/grants/ggintegration/OpportunityFilesRestClient;", "opportunityFoldersRestClient", "Lorg/kuali/research/grants/ggintegration/OpportunityFoldersRestClient;", "<init>", "(Lorg/kuali/research/grants/ggintegration/OpportunityFilesRestClient;Lorg/kuali/research/grants/ggintegration/OpportunityFoldersRestClient;)V", "file", "Lorg/springframework/http/ResponseEntity;", "Lorg/kuali/research/grants/opportunity/internal/model/FileFolderModel;", "id", "", "downloadFile", "", "folder", "downloadFolder", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nFileController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileController.kt\norg/kuali/research/grants/opportunity/internal/controller/FileController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public class FileController
implements Logging {
    @NotNull
    private final OpportunityFilesRestClient opportunityFilesRestClient;
    @NotNull
    private final OpportunityFoldersRestClient opportunityFoldersRestClient;

    public FileController(@NotNull OpportunityFilesRestClient opportunityFilesRestClient, @NotNull OpportunityFoldersRestClient opportunityFoldersRestClient) {
        Intrinsics.checkNotNullParameter((Object)opportunityFilesRestClient, (String)"opportunityFilesRestClient");
        Intrinsics.checkNotNullParameter((Object)opportunityFoldersRestClient, (String)"opportunityFoldersRestClient");
        this.opportunityFilesRestClient = opportunityFilesRestClient;
        this.opportunityFoldersRestClient = opportunityFoldersRestClient;
    }

    @GetMapping(value={"/files/{id:\\d+}"})
    @NotNull
    public ResponseEntity<FileFolderModel> file(@PathVariable(name="id", required=true) int id) {
        Link link = WebMvcLinkBuilder.linkTo((Object)((FileController)WebMvcLinkBuilder.methodOn(FileController.class, (Object[])new Object[0])).file(id)).withSelfRel();
        Intrinsics.checkNotNullExpressionValue((Object)link, (String)"withSelfRel(...)");
        Link selfLink = link;
        Link link2 = WebMvcLinkBuilder.linkTo((Object)((FileController)WebMvcLinkBuilder.methodOn(FileController.class, (Object[])new Object[0])).downloadFile(id)).withRel("download");
        Intrinsics.checkNotNullExpressionValue((Object)link2, (String)"withRel(...)");
        Link downloadLink = link2;
        Link[] linkArray = new Link[]{selfLink, downloadLink};
        ResponseEntity responseEntity = ResponseEntity.ok((Object)new FileFolderModel(id, id + ".pdf", "application/pdf").add(linkArray));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @GetMapping(value={"/files/{id:\\d+}/download"}, produces={"application/pdf"})
    @NotNull
    public ResponseEntity<byte[]> downloadFile(@PathVariable(name="id", required=true) int id) {
        Object object;
        block3: {
            block2: {
                object = this.opportunityFilesRestClient.file(id);
                if (object == null) break block2;
                byte[] it = object;
                boolean bl = false;
                ResponseEntity responseEntity = ResponseEntity.ok((Object)it);
                object = responseEntity;
                if (responseEntity != null) break block3;
            }
            ResponseEntity responseEntity = ResponseEntity.notFound().build();
            object = responseEntity;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"build(...)");
        }
        return object;
    }

    @GetMapping(value={"/folders/{id:\\d+}"})
    @NotNull
    public ResponseEntity<FileFolderModel> folder(@PathVariable(name="id", required=true) int id) {
        Link link = WebMvcLinkBuilder.linkTo((Object)((FileController)WebMvcLinkBuilder.methodOn(FileController.class, (Object[])new Object[0])).folder(id)).withSelfRel();
        Intrinsics.checkNotNullExpressionValue((Object)link, (String)"withSelfRel(...)");
        Link selfLink = link;
        Link link2 = WebMvcLinkBuilder.linkTo((Object)((FileController)WebMvcLinkBuilder.methodOn(FileController.class, (Object[])new Object[0])).downloadFolder(id)).withRel("download");
        Intrinsics.checkNotNullExpressionValue((Object)link2, (String)"withRel(...)");
        Link downloadLink = link2;
        Link[] linkArray = new Link[]{selfLink, downloadLink};
        ResponseEntity responseEntity = ResponseEntity.ok((Object)new FileFolderModel(id, id + ".zip", "application/zip").add(linkArray));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @GetMapping(value={"/folders/{id:\\d+}/download"}, produces={"application/zip"})
    @NotNull
    public ResponseEntity<byte[]> downloadFolder(@PathVariable(name="id", required=true) int id) {
        Object object;
        block3: {
            block2: {
                object = this.opportunityFoldersRestClient.folder(id);
                if (object == null) break block2;
                byte[] it = object;
                boolean bl = false;
                ResponseEntity responseEntity = ResponseEntity.ok((Object)it);
                object = responseEntity;
                if (responseEntity != null) break block3;
            }
            ResponseEntity responseEntity = ResponseEntity.notFound().build();
            object = responseEntity;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"build(...)");
        }
        return object;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }
}

