/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.sys.cache;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.sys.cache.CacheWarmer;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.cache.CacheType;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH$J\b\u0010\u000b\u001a\u00020\nH\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/kuali/research/grants/sys/cache/AbstractCacheWarmer;", "Lorg/kuali/research/grants/sys/cache/CacheWarmer;", "Lorg/apache/logging/log4j/kotlin/Logging;", "cacheProperties", "Lorg/springframework/boot/autoconfigure/cache/CacheProperties;", "<init>", "(Lorg/springframework/boot/autoconfigure/cache/CacheProperties;)V", "getCacheProperties", "()Lorg/springframework/boot/autoconfigure/cache/CacheProperties;", "doWarming", "", "warm", "cacheEnabled", "", "getCacheEnabled", "()Z", "name", "", "getName", "()Ljava/lang/String;", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nAbstractCacheWarmer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCacheWarmer.kt\norg/kuali/research/grants/sys/cache/AbstractCacheWarmer\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,37:1\n95#2:38\n135#2,3:39\n*S KotlinDebug\n*F\n+ 1 AbstractCacheWarmer.kt\norg/kuali/research/grants/sys/cache/AbstractCacheWarmer\n*L\n21#1:38\n21#1:39,3\n*E\n"})
public abstract class AbstractCacheWarmer
implements CacheWarmer,
Logging {
    @NotNull
    private final CacheProperties cacheProperties;

    public AbstractCacheWarmer(@NotNull CacheProperties cacheProperties) {
        Intrinsics.checkNotNullParameter((Object)cacheProperties, (String)"cacheProperties");
        this.cacheProperties = cacheProperties;
    }

    @NotNull
    public final CacheProperties getCacheProperties() {
        return this.cacheProperties;
    }

    protected abstract void doWarming();

    @Async
    @EventListener(value={ApplicationReadyEvent.class})
    public void warm() {
        if (this.getCacheEnabled()) {
            this.getLogger().info((CharSequence)("Starting cache warming for " + this.getName()));
            boolean $i$f$measureTimedValue = false;
            TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            this.doWarming();
            Unit result$iv$iv = Unit.INSTANCE;
            TimedValue result = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
            boolean bl2 = false;
            this.getLogger().info((CharSequence)("Completed cache warming for " + this.getName() + " in " + Duration.toString-impl((long)result.getDuration-UwyO8pc())));
            result.getValue();
        } else {
            this.getLogger().info((CharSequence)("Skipping caching warming for " + this.getName() + ", cache is disabled"));
        }
    }

    public final boolean getCacheEnabled() {
        return this.cacheProperties.getType() != CacheType.NONE;
    }

    @NotNull
    public final String getName() {
        String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }
}

