/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.proposal.internal.controller;

import gov.grants.apply.services.applicantwebservices_v2.GetApplicationInfoResponse;
import gov.grants.apply.services.applicantwebservices_v2.GetApplicationZipResponse;
import gov.grants.apply.services.applicantwebservices_v2.SubmitApplicationRequest;
import gov.grants.apply.services.applicantwebservices_v2.SubmitApplicationResponse;
import gov.grants.apply.system.applicantcommonelements_v1.SubmissionDetails;
import gov.nih.era.sads.types.ContactType;
import gov.nih.era.sads.types.GrantNumber;
import gov.nih.era.sads.types.GrantStatusResponseType;
import jakarta.activation.DataHandler;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.ggintegration.ApplicationWebServicesClient;
import org.kuali.research.grants.nihintegration.SubmissionAgencyDataServiceClient;
import org.kuali.research.grants.proposal.internal.assembler.PropOppPkgSubmissionAssembler;
import org.kuali.research.grants.proposal.internal.controller.PropOppPkgSubmissionController;
import org.kuali.research.grants.proposal.internal.entity.ContactInfo;
import org.kuali.research.grants.proposal.internal.entity.File;
import org.kuali.research.grants.proposal.internal.entity.IntegrationError;
import org.kuali.research.grants.proposal.internal.entity.MeetingInfo;
import org.kuali.research.grants.proposal.internal.entity.PropOppPackage;
import org.kuali.research.grants.proposal.internal.entity.PropOppPkgForm;
import org.kuali.research.grants.proposal.internal.entity.PropOppPkgFormOverride;
import org.kuali.research.grants.proposal.internal.entity.PropOppPkgFormOvrdAttachment;
import org.kuali.research.grants.proposal.internal.entity.PropOppPkgSchema;
import org.kuali.research.grants.proposal.internal.entity.PropOppPkgSubmForm;
import org.kuali.research.grants.proposal.internal.entity.PropOppPkgSubmFormAttachment;
import org.kuali.research.grants.proposal.internal.entity.PropOppPkgSubmGgSubmit;
import org.kuali.research.grants.proposal.internal.entity.PropOppPkgSubmGgSubmitDetails;
import org.kuali.research.grants.proposal.internal.entity.PropOppPkgSubmNihSubmitDetails;
import org.kuali.research.grants.proposal.internal.entity.PropOppPkgSubmPackage;
import org.kuali.research.grants.proposal.internal.entity.PropOppPkgSubmPkgAttachment;
import org.kuali.research.grants.proposal.internal.entity.PropOppPkgSubmPkgSchema;
import org.kuali.research.grants.proposal.internal.entity.PropOppPkgSubmission;
import org.kuali.research.grants.proposal.internal.entity.Proposal;
import org.kuali.research.grants.proposal.internal.model.PropOppPkgSubmissionModel;
import org.kuali.research.grants.proposal.internal.repository.PropOppPackageRepository;
import org.kuali.research.grants.proposal.internal.repository.PropOppPkgSubmGgSubmitDetailsRepository;
import org.kuali.research.grants.proposal.internal.repository.PropOppPkgSubmNihSubmitDetailsRepository;
import org.kuali.research.grants.proposal.internal.repository.PropOppPkgSubmissionRepository;
import org.kuali.research.grants.proposal.internal.repository.ProposalRepository;
import org.kuali.research.grants.resintegration.ResAuthService;
import org.kuali.research.grants.resintegration.ResAuthUser;
import org.kuali.research.grants.sys.hateoas.ProblemModel;
import org.kuali.research.grants.sys.xml.XmlUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.ws.soap.client.SoapFaultClientException;

@RestController
@RequestMapping(value={"/api/v1/proposals"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 F2\u00020\u0001:\u0001FBY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0001\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J<\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00192\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001d2\b\b\u0001\u0010\u001f\u001a\u00020\u001d2\b\b\u0001\u0010 \u001a\u00020\u001dH\u0017J\u001a\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\"H\u0012J\u001a\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020'2\b\u0010%\u001a\u0004\u0018\u00010\"H\u0012J\u0012\u0010(\u001a\u0004\u0018\u00010\"2\u0006\u0010)\u001a\u00020*H\u0012J\u001a\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\u0010%\u001a\u0004\u0018\u00010,H\u0012J\u001a\u0010/\u001a\u00020,2\u0006\u00100\u001a\u0002012\b\u0010%\u001a\u0004\u0018\u00010,H\u0012J\u001a\u00102\u001a\u00020,2\u0006\u00103\u001a\u0002042\b\u0010%\u001a\u0004\u0018\u00010,H\u0012J\u001a\u00105\u001a\u00020,2\u0006\u0010&\u001a\u00020'2\b\u0010%\u001a\u0004\u0018\u00010,H\u0012J\u0012\u00106\u001a\u0004\u0018\u00010,2\u0006\u0010)\u001a\u00020*H\u0012J\u0012\u00107\u001a\u0004\u0018\u00010,2\u0006\u0010)\u001a\u00020*H\u0012J\u0012\u00108\u001a\u0004\u0018\u00010,2\u0006\u0010)\u001a\u00020*H\u0012J2\u00109\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00192\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001d2\b\b\u0001\u0010\u001f\u001a\u00020\u001dH\u0017J&\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?2\u0006\u0010A\u001a\u00020BH\u0012J\u0018\u0010C\u001a\u00020;2\u0006\u0010D\u001a\u00020E2\u0006\u0010<\u001a\u00020=H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/kuali/research/grants/proposal/internal/controller/PropOppPkgSubmissionController;", "", "resAuthService", "Lorg/kuali/research/grants/resintegration/ResAuthService;", "proposalRepository", "Lorg/kuali/research/grants/proposal/internal/repository/ProposalRepository;", "propOppPkgSubmissionRepository", "Lorg/kuali/research/grants/proposal/internal/repository/PropOppPkgSubmissionRepository;", "propOppPackageRepository", "Lorg/kuali/research/grants/proposal/internal/repository/PropOppPackageRepository;", "propOppPkgSubmissionAssembler", "Lorg/kuali/research/grants/proposal/internal/assembler/PropOppPkgSubmissionAssembler;", "applicationWebServicesClient", "Lorg/kuali/research/grants/ggintegration/ApplicationWebServicesClient;", "submissionAgencyDataServiceClient", "Lorg/kuali/research/grants/nihintegration/SubmissionAgencyDataServiceClient;", "propOppPkgSubmNihSubmitDetailsRepository", "Lorg/kuali/research/grants/proposal/internal/repository/PropOppPkgSubmNihSubmitDetailsRepository;", "propOppPkgSubmGgSubmitDetailsRepository", "Lorg/kuali/research/grants/proposal/internal/repository/PropOppPkgSubmGgSubmitDetailsRepository;", "grantApplicationTemplate", "Lorg/springframework/core/io/Resource;", "<init>", "(Lorg/kuali/research/grants/resintegration/ResAuthService;Lorg/kuali/research/grants/proposal/internal/repository/ProposalRepository;Lorg/kuali/research/grants/proposal/internal/repository/PropOppPkgSubmissionRepository;Lorg/kuali/research/grants/proposal/internal/repository/PropOppPackageRepository;Lorg/kuali/research/grants/proposal/internal/assembler/PropOppPkgSubmissionAssembler;Lorg/kuali/research/grants/ggintegration/ApplicationWebServicesClient;Lorg/kuali/research/grants/nihintegration/SubmissionAgencyDataServiceClient;Lorg/kuali/research/grants/proposal/internal/repository/PropOppPkgSubmNihSubmitDetailsRepository;Lorg/kuali/research/grants/proposal/internal/repository/PropOppPkgSubmGgSubmitDetailsRepository;Lorg/springframework/core/io/Resource;)V", "refresh", "Lorg/springframework/http/ResponseEntity;", "Lorg/kuali/research/grants/sys/hateoas/ProblemModel;", "Lorg/kuali/research/grants/proposal/internal/model/PropOppPkgSubmissionModel;", "proposalId", "", "propOpportunityId", "packageId", "id", "buildNihDetails", "Lorg/kuali/research/grants/proposal/internal/entity/PropOppPkgSubmNihSubmitDetails;", "grantStatus", "Lgov/nih/era/sads/types/GrantStatusResponseType;", "existingDetails", "exception", "Lorg/springframework/ws/soap/client/SoapFaultClientException;", "refreshAndSaveNihDetails", "propOppPkgSubmGgSubmit", "Lorg/kuali/research/grants/proposal/internal/entity/PropOppPkgSubmGgSubmit;", "buildGgDetailsAppInfo", "Lorg/kuali/research/grants/proposal/internal/entity/PropOppPkgSubmGgSubmitDetails;", "applicationInfo", "Lgov/grants/apply/services/applicantwebservices_v2/GetApplicationInfoResponse;", "buildGgDetailsSubmissionDetails", "submissionDetails", "Lgov/grants/apply/system/applicantcommonelements_v1/SubmissionDetails;", "buildGgDetailsApplicationZip", "applicationZip", "Lgov/grants/apply/services/applicantwebservices_v2/GetApplicationZipResponse;", "buildGgDetails", "refreshAndSaveGgDetailsAppInfo", "refreshAndSaveGgDetailsSubmissionDetails", "refreshAndSaveGgDetailsApplicationZip", "submit", "buildSubmissionFromPackage", "Lorg/kuali/research/grants/proposal/internal/entity/PropOppPkgSubmission;", "propOppPackage", "Lorg/kuali/research/grants/proposal/internal/entity/PropOppPackage;", "forms", "", "Lorg/kuali/research/grants/proposal/internal/entity/PropOppPkgSubmForm;", "proposalTitle", "", "createSubmission", "proposal", "Lorg/kuali/research/grants/proposal/internal/entity/Proposal;", "Companion", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nPropOppPkgSubmissionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropOppPkgSubmissionController.kt\norg/kuali/research/grants/proposal/internal/controller/PropOppPkgSubmissionController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,537:1\n1#2:538\n1563#3:539\n1634#3,3:540\n1563#3:543\n1634#3,3:544\n1374#3:547\n1460#3,5:548\n1563#3:553\n1634#3,3:554\n1563#3:557\n1634#3,3:558\n774#3:561\n865#3,2:562\n774#3:564\n865#3:565\n1761#3,3:566\n866#3:569\n774#3:570\n865#3,2:571\n1563#3:573\n1634#3,2:574\n1563#3:576\n1634#3,3:577\n1636#3:580\n*S KotlinDebug\n*F\n+ 1 PropOppPkgSubmissionController.kt\norg/kuali/research/grants/proposal/internal/controller/PropOppPkgSubmissionController\n*L\n373#1:539\n373#1:540,3\n374#1:543\n374#1:544,3\n392#1:547\n392#1:548,5\n393#1:553\n393#1:554,3\n396#1:557\n396#1:558,3\n446#1:561\n446#1:562,2\n450#1:564\n450#1:565\n451#1:566,3\n450#1:569\n455#1:570\n455#1:571,2\n456#1:573\n456#1:574,2\n481#1:576\n481#1:577,3\n456#1:580\n*E\n"})
public class PropOppPkgSubmissionController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResAuthService resAuthService;
    @NotNull
    private final ProposalRepository proposalRepository;
    @NotNull
    private final PropOppPkgSubmissionRepository propOppPkgSubmissionRepository;
    @NotNull
    private final PropOppPackageRepository propOppPackageRepository;
    @NotNull
    private final PropOppPkgSubmissionAssembler propOppPkgSubmissionAssembler;
    @NotNull
    private final ApplicationWebServicesClient applicationWebServicesClient;
    @NotNull
    private final SubmissionAgencyDataServiceClient submissionAgencyDataServiceClient;
    @NotNull
    private final PropOppPkgSubmNihSubmitDetailsRepository propOppPkgSubmNihSubmitDetailsRepository;
    @NotNull
    private final PropOppPkgSubmGgSubmitDetailsRepository propOppPkgSubmGgSubmitDetailsRepository;
    @NotNull
    private final Resource grantApplicationTemplate;
    private static final int APPLICATION_FILING_NAME_MAX_LENGTH = 240;

    public PropOppPkgSubmissionController(@NotNull ResAuthService resAuthService, @NotNull ProposalRepository proposalRepository, @NotNull PropOppPkgSubmissionRepository propOppPkgSubmissionRepository, @NotNull PropOppPackageRepository propOppPackageRepository, @NotNull PropOppPkgSubmissionAssembler propOppPkgSubmissionAssembler, @NotNull ApplicationWebServicesClient applicationWebServicesClient, @NotNull SubmissionAgencyDataServiceClient submissionAgencyDataServiceClient, @NotNull PropOppPkgSubmNihSubmitDetailsRepository propOppPkgSubmNihSubmitDetailsRepository, @NotNull PropOppPkgSubmGgSubmitDetailsRepository propOppPkgSubmGgSubmitDetailsRepository, @Value(value="classpath:org/kuali/research/grants/proposal/internal/controller/grant-application-template.xml") @NotNull Resource grantApplicationTemplate) {
        Intrinsics.checkNotNullParameter((Object)resAuthService, (String)"resAuthService");
        Intrinsics.checkNotNullParameter((Object)proposalRepository, (String)"proposalRepository");
        Intrinsics.checkNotNullParameter((Object)propOppPkgSubmissionRepository, (String)"propOppPkgSubmissionRepository");
        Intrinsics.checkNotNullParameter((Object)propOppPackageRepository, (String)"propOppPackageRepository");
        Intrinsics.checkNotNullParameter((Object)propOppPkgSubmissionAssembler, (String)"propOppPkgSubmissionAssembler");
        Intrinsics.checkNotNullParameter((Object)applicationWebServicesClient, (String)"applicationWebServicesClient");
        Intrinsics.checkNotNullParameter((Object)submissionAgencyDataServiceClient, (String)"submissionAgencyDataServiceClient");
        Intrinsics.checkNotNullParameter((Object)propOppPkgSubmNihSubmitDetailsRepository, (String)"propOppPkgSubmNihSubmitDetailsRepository");
        Intrinsics.checkNotNullParameter((Object)propOppPkgSubmGgSubmitDetailsRepository, (String)"propOppPkgSubmGgSubmitDetailsRepository");
        Intrinsics.checkNotNullParameter((Object)grantApplicationTemplate, (String)"grantApplicationTemplate");
        this.resAuthService = resAuthService;
        this.proposalRepository = proposalRepository;
        this.propOppPkgSubmissionRepository = propOppPkgSubmissionRepository;
        this.propOppPackageRepository = propOppPackageRepository;
        this.propOppPkgSubmissionAssembler = propOppPkgSubmissionAssembler;
        this.applicationWebServicesClient = applicationWebServicesClient;
        this.submissionAgencyDataServiceClient = submissionAgencyDataServiceClient;
        this.propOppPkgSubmNihSubmitDetailsRepository = propOppPkgSubmNihSubmitDetailsRepository;
        this.propOppPkgSubmGgSubmitDetailsRepository = propOppPkgSubmGgSubmitDetailsRepository;
        this.grantApplicationTemplate = grantApplicationTemplate;
    }

    @PostMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages/{packageId}/submission/{id}/refresh"})
    @NotNull
    public ResponseEntity<ProblemModel<PropOppPkgSubmissionModel>> refresh(@PathVariable long proposalId, @PathVariable long propOpportunityId, @PathVariable long packageId, @PathVariable long id) {
        ResponseEntity responseEntity = this.propOppPkgSubmissionRepository.findByProposalIdAndPropOpportunityIdAndPropOppPackageIdAndId(proposalId, propOpportunityId, packageId, id).map(arg_0 -> PropOppPkgSubmissionController.refresh$lambda$1(arg_0 -> PropOppPkgSubmissionController.refresh$lambda$0(this, arg_0), arg_0)).map(arg_0 -> PropOppPkgSubmissionController.refresh$lambda$3(arg_0 -> PropOppPkgSubmissionController.refresh$lambda$2(this, proposalId, arg_0), arg_0)).orElse(ResponseEntity.notFound().build());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"orElse(...)");
        return responseEntity;
    }

    private PropOppPkgSubmNihSubmitDetails buildNihDetails(GrantStatusResponseType grantStatus2, PropOppPkgSubmNihSubmitDetails existingDetails) {
        Object object;
        Object object2;
        ZonedDateTime zonedDateTime;
        GregorianCalendar gregorianCalendar;
        ContactType contactType = grantStatus2.getSRAContact();
        ContactType contactType2 = grantStatus2.getSRAContact();
        ContactType contactType3 = grantStatus2.getSRAContact();
        ContactType contactType4 = grantStatus2.getPOContact();
        ContactType contactType5 = grantStatus2.getPOContact();
        ContactType contactType6 = grantStatus2.getPOContact();
        XMLGregorianCalendar xMLGregorianCalendar = grantStatus2.getAdvisoryCouncilMeeting().getMeetingDate();
        MeetingInfo meetingInfo = new MeetingInfo(xMLGregorianCalendar != null && (gregorianCalendar = xMLGregorianCalendar.toGregorianCalendar()) != null && (zonedDateTime = gregorianCalendar.toZonedDateTime()) != null ? zonedDateTime.toInstant() : null, grantStatus2.getAdvisoryCouncilMeeting().getMeetingLocation());
        xMLGregorianCalendar = grantStatus2.getStudySectionMeeting().getMeetingDate();
        MeetingInfo meetingInfo2 = new MeetingInfo(xMLGregorianCalendar != null && (gregorianCalendar = xMLGregorianCalendar.toGregorianCalendar()) != null && (zonedDateTime = gregorianCalendar.toZonedDateTime()) != null ? zonedDateTime.toInstant() : null, grantStatus2.getStudySectionMeeting().getMeetingLocation());
        GrantNumber grantNumber = grantStatus2.getGrantNumber();
        GrantNumber grantNumber2 = grantStatus2.getGrantNumber();
        GrantNumber grantNumber3 = grantStatus2.getGrantNumber();
        GrantNumber grantNumber4 = grantStatus2.getGrantNumber();
        GrantNumber grantNumber5 = grantStatus2.getGrantNumber();
        GrantNumber grantNumber6 = grantStatus2.getGrantNumber();
        GrantNumber grantNumber7 = grantStatus2.getGrantNumber();
        ContactType contactType7 = grantStatus2.getGMSContact();
        ContactType contactType8 = grantStatus2.getGMSContact();
        ContactType contactType9 = grantStatus2.getGMSContact();
        Object object3 = grantStatus2.getESubmissionStatusDate();
        PropOppPkgSubmNihSubmitDetails details2 = new PropOppPkgSubmNihSubmitDetails(null, object3 != null && (object3 = ((XMLGregorianCalendar)object3).toGregorianCalendar()) != null && (object3 = ((GregorianCalendar)object3).toZonedDateTime()) != null ? object3.toInstant() : null, new ContactInfo(contactType != null ? contactType.getName() : null, contactType2 != null ? contactType2.getEmail() : null, contactType3 != null ? contactType3.getPhone() : null), grantStatus2.getGrantStatus(), grantStatus2.getTrackingNumber(), new ContactInfo(contactType4 != null ? contactType4.getName() : null, contactType5 != null ? contactType5.getEmail() : null, contactType6 != null ? contactType6.getPhone() : null), (object2 = grantStatus2.getGrantStatusDate()) != null && (object2 = ((XMLGregorianCalendar)object2).toGregorianCalendar()) != null && (object2 = ((GregorianCalendar)object2).toZonedDateTime()) != null ? object2.toInstant() : null, grantStatus2.getIRGAssignment(), grantStatus2.getProjectTitle(), meetingInfo, meetingInfo2, (object = grantStatus2.getProposalReceiptDate()) != null && (object = ((XMLGregorianCalendar)object).toGregorianCalendar()) != null && (object = ((GregorianCalendar)object).toZonedDateTime()) != null ? object.toInstant() : null, grantStatus2.getESubmissionStatus(), grantStatus2.getAccessionNumber(), grantNumber != null ? grantNumber.getActivityCode() : null, grantNumber2 != null ? grantNumber2.getPHSOrgCode() : null, grantNumber3 != null ? grantNumber3.getSuffixCode() : null, grantNumber4 != null ? grantNumber4.getSupportYear() : null, grantNumber5 != null ? grantNumber5.getApplicationTypeCode() : null, grantNumber6 != null ? grantNumber6.getSerialNumber() : null, grantNumber7 != null ? grantNumber7.getPHSOrgId() : null, grantStatus2.getApplId(), new ContactInfo(contactType7 != null ? contactType7.getName() : null, contactType8 != null ? contactType8.getEmail() : null, contactType9 != null ? contactType9.getPhone() : null), null, null, null, 58720257, null);
        PropOppPkgSubmNihSubmitDetails propOppPkgSubmNihSubmitDetails = existingDetails;
        if (propOppPkgSubmNihSubmitDetails == null || (propOppPkgSubmNihSubmitDetails = PropOppPkgSubmNihSubmitDetails.copy$default((PropOppPkgSubmNihSubmitDetails)propOppPkgSubmNihSubmitDetails, null, (Instant)details2.getESubmissionStatusDate(), (ContactInfo)details2.getSraContact(), (String)details2.getGrantStatus(), (String)details2.getTrackingNumber(), (ContactInfo)details2.getPoContact(), (Instant)details2.getGrantStatusDate(), (String)details2.getIrgAssignment(), (String)details2.getProjectTitle(), (MeetingInfo)details2.getAdvisoryCouncilMeeting(), (MeetingInfo)details2.getStudySectionMeeting(), (Instant)details2.getProposalReceiptDate(), (String)details2.getESubmissionStatus(), (String)details2.getAccessionNumber(), (String)details2.getGrantNumberActivityCode(), (String)details2.getGrantNumberPhsOrgCode(), (String)details2.getGrantNumberSuffixCode(), (Integer)details2.getGrantNumberSupportYear(), (String)details2.getGrantNumberApplicationTypeCode(), (Integer)details2.getGrantNumberSerialNumber(), (Long)details2.getGrantNumberPhsOrgId(), (Integer)details2.getApplId(), (ContactInfo)details2.getGmsContact(), null, null, null, (int)58720257, null)) == null) {
            propOppPkgSubmNihSubmitDetails = details2;
        }
        return propOppPkgSubmNihSubmitDetails;
    }

    private PropOppPkgSubmNihSubmitDetails buildNihDetails(SoapFaultClientException exception, PropOppPkgSubmNihSubmitDetails existingDetails) {
        PropOppPkgSubmNihSubmitDetails propOppPkgSubmNihSubmitDetails;
        PropOppPkgSubmNihSubmitDetails propOppPkgSubmNihSubmitDetails2 = existingDetails;
        if (propOppPkgSubmNihSubmitDetails2 != null) {
            PropOppPkgSubmNihSubmitDetails propOppPkgSubmNihSubmitDetails3;
            PropOppPkgSubmNihSubmitDetails $this$buildNihDetails_u24lambda_u244 = propOppPkgSubmNihSubmitDetails3 = propOppPkgSubmNihSubmitDetails2;
            boolean bl = false;
            $this$buildNihDetails_u24lambda_u244.add(IntegrationError.Companion.fromSoapFault(exception));
            propOppPkgSubmNihSubmitDetails = propOppPkgSubmNihSubmitDetails3;
        } else {
            PropOppPkgSubmNihSubmitDetails propOppPkgSubmNihSubmitDetails4;
            PropOppPkgSubmNihSubmitDetails $this$buildNihDetails_u24lambda_u245 = propOppPkgSubmNihSubmitDetails4 = new PropOppPkgSubmNihSubmitDetails(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0x3FFFFFF, null);
            boolean bl = false;
            $this$buildNihDetails_u24lambda_u245.add(IntegrationError.Companion.fromSoapFault(exception));
            propOppPkgSubmNihSubmitDetails = propOppPkgSubmNihSubmitDetails4;
        }
        return propOppPkgSubmNihSubmitDetails;
    }

    private PropOppPkgSubmNihSubmitDetails refreshAndSaveNihDetails(PropOppPkgSubmGgSubmit propOppPkgSubmGgSubmit) {
        try {
            String string = propOppPkgSubmGgSubmit.getGrantsGovTrackingNumber();
            Intrinsics.checkNotNull((Object)string);
            GrantStatusResponseType grantStatus2 = this.submissionAgencyDataServiceClient.grantStatus(string);
            if (grantStatus2 != null) {
                return (PropOppPkgSubmNihSubmitDetails)this.propOppPkgSubmNihSubmitDetailsRepository.save((Object)this.buildNihDetails(grantStatus2, propOppPkgSubmGgSubmit.getPropOppPkgSubmNihSubmitDetails()));
            }
        }
        catch (SoapFaultClientException errorMessage) {
            return (PropOppPkgSubmNihSubmitDetails)this.propOppPkgSubmNihSubmitDetailsRepository.save((Object)this.buildNihDetails(errorMessage, propOppPkgSubmGgSubmit.getPropOppPkgSubmNihSubmitDetails()));
        }
        return null;
    }

    private PropOppPkgSubmGgSubmitDetails buildGgDetailsAppInfo(GetApplicationInfoResponse applicationInfo2, PropOppPkgSubmGgSubmitDetails existingDetails) {
        PropOppPkgSubmGgSubmitDetails details2 = new PropOppPkgSubmGgSubmitDetails(null, applicationInfo2.getStatusDetail(), applicationInfo2.getAgencyNotes(), null, null, null, null, null, null, null, null, null, 4089, null);
        PropOppPkgSubmGgSubmitDetails propOppPkgSubmGgSubmitDetails = existingDetails;
        if (propOppPkgSubmGgSubmitDetails == null || (propOppPkgSubmGgSubmitDetails = PropOppPkgSubmGgSubmitDetails.copy$default((PropOppPkgSubmGgSubmitDetails)propOppPkgSubmGgSubmitDetails, null, (String)details2.getStatusDetails(), (String)details2.getAgencyNotes(), null, null, null, null, null, null, null, null, null, (int)4089, null)) == null) {
            propOppPkgSubmGgSubmitDetails = details2;
        }
        return propOppPkgSubmGgSubmitDetails;
    }

    private PropOppPkgSubmGgSubmitDetails buildGgDetailsSubmissionDetails(SubmissionDetails submissionDetails2, PropOppPkgSubmGgSubmitDetails existingDetails) {
        Object object;
        Object object2;
        PropOppPkgSubmGgSubmitDetails details2 = new PropOppPkgSubmGgSubmitDetails(null, null, null, submissionDetails2.getAgencyTrackingNumber(), submissionDetails2.getGrantsGovApplicationStatus().name(), (object2 = submissionDetails2.getReceivedDateTime()) != null && (object2 = ((XMLGregorianCalendar)object2).toGregorianCalendar()) != null && (object2 = ((GregorianCalendar)object2).toZonedDateTime()) != null ? object2.toInstant() : null, (object = submissionDetails2.getStatusDateTime()) != null && (object = ((XMLGregorianCalendar)object).toGregorianCalendar()) != null && (object = ((GregorianCalendar)object).toZonedDateTime()) != null ? object.toInstant() : null, submissionDetails2.getSubmissionTitle(), null, null, null, null, 3847, null);
        PropOppPkgSubmGgSubmitDetails propOppPkgSubmGgSubmitDetails = existingDetails;
        if (propOppPkgSubmGgSubmitDetails == null || (propOppPkgSubmGgSubmitDetails = PropOppPkgSubmGgSubmitDetails.copy$default((PropOppPkgSubmGgSubmitDetails)propOppPkgSubmGgSubmitDetails, null, null, null, (String)details2.getAgencyTrackingNumber(), (String)details2.getGrantsGovApplicationStatus(), (Instant)details2.getReceivedDateTime(), (Instant)details2.getStatusDateTime(), (String)details2.getSubmissionTitle(), null, null, null, null, (int)3847, null)) == null) {
            propOppPkgSubmGgSubmitDetails = details2;
        }
        return propOppPkgSubmGgSubmitDetails;
    }

    private PropOppPkgSubmGgSubmitDetails buildGgDetailsApplicationZip(GetApplicationZipResponse applicationZip2, PropOppPkgSubmGgSubmitDetails existingDetails) {
        byte[] byArray = applicationZip2.getFileDataHandler().getInputStream().readAllBytes();
        Intrinsics.checkNotNull((Object)byArray);
        byte[] bytes = byArray;
        String string = applicationZip2.getFileDataHandler().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = applicationZip2.getFileDataHandler().getContentType();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getContentType(...)");
        PropOppPkgSubmGgSubmitDetails details2 = new PropOppPkgSubmGgSubmitDetails(null, null, null, null, null, null, null, null, new File(null, string, string2, (long)bytes.length, bytes, null, null, 96, null), null, null, null, 3839, null);
        PropOppPkgSubmGgSubmitDetails propOppPkgSubmGgSubmitDetails = existingDetails;
        if (propOppPkgSubmGgSubmitDetails == null || (propOppPkgSubmGgSubmitDetails = PropOppPkgSubmGgSubmitDetails.copy$default((PropOppPkgSubmGgSubmitDetails)propOppPkgSubmGgSubmitDetails, null, null, null, null, null, null, null, null, (File)details2.getGgApplicationZip(), null, null, null, (int)3839, null)) == null) {
            propOppPkgSubmGgSubmitDetails = details2;
        }
        return propOppPkgSubmGgSubmitDetails;
    }

    private PropOppPkgSubmGgSubmitDetails buildGgDetails(SoapFaultClientException exception, PropOppPkgSubmGgSubmitDetails existingDetails) {
        PropOppPkgSubmGgSubmitDetails propOppPkgSubmGgSubmitDetails;
        PropOppPkgSubmGgSubmitDetails propOppPkgSubmGgSubmitDetails2 = existingDetails;
        if (propOppPkgSubmGgSubmitDetails2 != null) {
            PropOppPkgSubmGgSubmitDetails propOppPkgSubmGgSubmitDetails3;
            PropOppPkgSubmGgSubmitDetails $this$buildGgDetails_u24lambda_u246 = propOppPkgSubmGgSubmitDetails3 = propOppPkgSubmGgSubmitDetails2;
            boolean bl = false;
            $this$buildGgDetails_u24lambda_u246.add(IntegrationError.Companion.fromSoapFault(exception));
            propOppPkgSubmGgSubmitDetails = propOppPkgSubmGgSubmitDetails3;
        } else {
            PropOppPkgSubmGgSubmitDetails propOppPkgSubmGgSubmitDetails4;
            PropOppPkgSubmGgSubmitDetails $this$buildGgDetails_u24lambda_u247 = propOppPkgSubmGgSubmitDetails4 = new PropOppPkgSubmGgSubmitDetails(null, null, null, null, null, null, null, null, null, null, null, null, 4095, null);
            boolean bl = false;
            $this$buildGgDetails_u24lambda_u247.add(IntegrationError.Companion.fromSoapFault(exception));
            propOppPkgSubmGgSubmitDetails = propOppPkgSubmGgSubmitDetails4;
        }
        return propOppPkgSubmGgSubmitDetails;
    }

    private PropOppPkgSubmGgSubmitDetails refreshAndSaveGgDetailsAppInfo(PropOppPkgSubmGgSubmit propOppPkgSubmGgSubmit) {
        try {
            String string = propOppPkgSubmGgSubmit.getGrantsGovTrackingNumber();
            Intrinsics.checkNotNull((Object)string);
            GetApplicationInfoResponse applicationInfo2 = this.applicationWebServicesClient.applicationInfo(string);
            if (applicationInfo2 != null) {
                return (PropOppPkgSubmGgSubmitDetails)this.propOppPkgSubmGgSubmitDetailsRepository.save((Object)this.buildGgDetailsAppInfo(applicationInfo2, propOppPkgSubmGgSubmit.getPropOppPkgSubmGgSubmitDetails()));
            }
        }
        catch (SoapFaultClientException errorMessage) {
            return (PropOppPkgSubmGgSubmitDetails)this.propOppPkgSubmGgSubmitDetailsRepository.save((Object)this.buildGgDetails(errorMessage, propOppPkgSubmGgSubmit.getPropOppPkgSubmGgSubmitDetails()));
        }
        return null;
    }

    private PropOppPkgSubmGgSubmitDetails refreshAndSaveGgDetailsSubmissionDetails(PropOppPkgSubmGgSubmit propOppPkgSubmGgSubmit) {
        try {
            String string = propOppPkgSubmGgSubmit.getGrantsGovTrackingNumber();
            Intrinsics.checkNotNull((Object)string);
            SubmissionDetails submissionDetails2 = this.applicationWebServicesClient.submissionDetails(string);
            if (submissionDetails2 != null) {
                return (PropOppPkgSubmGgSubmitDetails)this.propOppPkgSubmGgSubmitDetailsRepository.save((Object)this.buildGgDetailsSubmissionDetails(submissionDetails2, propOppPkgSubmGgSubmit.getPropOppPkgSubmGgSubmitDetails()));
            }
        }
        catch (SoapFaultClientException errorMessage) {
            return (PropOppPkgSubmGgSubmitDetails)this.propOppPkgSubmGgSubmitDetailsRepository.save((Object)this.buildGgDetails(errorMessage, propOppPkgSubmGgSubmit.getPropOppPkgSubmGgSubmitDetails()));
        }
        return null;
    }

    private PropOppPkgSubmGgSubmitDetails refreshAndSaveGgDetailsApplicationZip(PropOppPkgSubmGgSubmit propOppPkgSubmGgSubmit) {
        PropOppPkgSubmGgSubmitDetails propOppPkgSubmGgSubmitDetails = propOppPkgSubmGgSubmit.getPropOppPkgSubmGgSubmitDetails();
        if ((propOppPkgSubmGgSubmitDetails != null ? propOppPkgSubmGgSubmitDetails.getGgApplicationZip() : null) == null) {
            try {
                String string = propOppPkgSubmGgSubmit.getGrantsGovTrackingNumber();
                Intrinsics.checkNotNull((Object)string);
                GetApplicationZipResponse applicationZip2 = this.applicationWebServicesClient.applicationZip(string);
                if (applicationZip2 != null) {
                    DataHandler dataHandler = applicationZip2.getFileDataHandler();
                    if ((dataHandler != null ? dataHandler.getInputStream() : null) != null) {
                        return (PropOppPkgSubmGgSubmitDetails)this.propOppPkgSubmGgSubmitDetailsRepository.save((Object)this.buildGgDetailsApplicationZip(applicationZip2, propOppPkgSubmGgSubmit.getPropOppPkgSubmGgSubmitDetails()));
                    }
                }
            }
            catch (SoapFaultClientException errorMessage) {
                return (PropOppPkgSubmGgSubmitDetails)this.propOppPkgSubmGgSubmitDetailsRepository.save((Object)this.buildGgDetails(errorMessage, propOppPkgSubmGgSubmit.getPropOppPkgSubmGgSubmitDetails()));
            }
        }
        return null;
    }

    @PostMapping(value={"/{proposalId}/opportunities/{propOpportunityId}/packages/{packageId}/submission"})
    @NotNull
    public ResponseEntity<ProblemModel<PropOppPkgSubmissionModel>> submit(@PathVariable long proposalId, @PathVariable long propOpportunityId, @PathVariable long packageId) {
        ResponseEntity responseEntity = this.propOppPackageRepository.findByProposalIdAndPropOpportunityIdAndId(proposalId, propOpportunityId, packageId).map(arg_0 -> PropOppPkgSubmissionController.submit$lambda$9(arg_0 -> PropOppPkgSubmissionController.submit$lambda$8(this, proposalId, arg_0), arg_0)).map(arg_0 -> PropOppPkgSubmissionController.submit$lambda$11(arg_0 -> PropOppPkgSubmissionController.submit$lambda$10(this, proposalId, arg_0), arg_0)).orElse(ResponseEntity.notFound().build());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"orElse(...)");
        return responseEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private PropOppPkgSubmission buildSubmissionFromPackage(PropOppPackage propOppPackage, List<PropOppPkgSubmForm> forms, String proposalTitle) {
        void $this$buildSubmissionFromPackage_u24lambda_u2419;
        PropOppPkgSubmPackage propOppPkgSubmPackage;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Iterable list$iv$iv;
        PropOppPkgSubmForm it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Object it2;
        Iterator it3;
        Collection collection;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv3;
        Iterable $this$map$iv2;
        Iterable iterable = forms;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv2;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        int $i$f$mapTo = 0;
        Iterator iterator = $this$mapTo$iv$iv3.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            PropOppPkgSubmForm propOppPkgSubmForm = (PropOppPkgSubmForm)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new String(it3.getXmlFile().getData(), Charsets.UTF_8));
        }
        $this$map$iv2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv3 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = 0;
        iterator = $this$mapTo$iv$iv3.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            it3 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(XmlUtils.INSTANCE.removeXmlDeclaration((String)((Object)it3)));
        }
        String formsStr = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, PropOppPkgSubmissionController::buildSubmissionFromPackage$lambda$14, (int)30, null);
        InputStream inputStream = this.grantApplicationTemplate.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        Closeable $i$f$map2 = inputStream;
        $this$mapTo$iv$iv3 = Charsets.UTF_8;
        destination$iv$iv = new InputStreamReader((InputStream)$i$f$map2, (Charset)$this$mapTo$iv$iv3);
        $i$f$mapTo = 8192;
        $i$f$map2 = destination$iv$iv instanceof BufferedReader ? (BufferedReader)destination$iv$iv : new BufferedReader((Reader)destination$iv$iv, $i$f$mapTo);
        $this$mapTo$iv$iv3 = null;
        try {
            it2 = (BufferedReader)$i$f$map2;
            boolean bl = false;
            it2 = TextStreamsKt.readText((Reader)((Reader)it2));
        }
        catch (Throwable bl) {
            $this$mapTo$iv$iv3 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)$i$f$map2, (Throwable)$this$mapTo$iv$iv3);
        }
        String string = propOppPackage.getSchemaUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String packageXml = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)it2, (String)"{schemaUrl}", (String)((Object)StringsKt.trim((CharSequence)string)).toString(), (boolean)false, (int)4, null), (String)"{applicationFilingName}", (String)StringsKt.take((String)((Object)StringsKt.trim((CharSequence)proposalTitle)).toString(), (int)240), (boolean)false, (int)4, null), (String)"{packageId}", (String)((Object)StringsKt.trim((CharSequence)propOppPackage.getPackageId())).toString(), (boolean)false, (int)4, null), (String)"{forms}", (String)formsStr, (boolean)false, (int)4, null))).toString();
        $this$mapTo$iv$iv3 = forms;
        boolean $i$f$flatMap = false;
        void bl = $this$flatMap$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (PropOppPkgSubmForm)element$iv$iv;
            boolean bl2 = false;
            list$iv$iv = it.getAttachments();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$map3 = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            list$iv$iv = (PropOppPkgSubmFormAttachment)item$iv$iv2;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(new PropOppPkgSubmPkgAttachment(null, it.getFileContentId(), it.getAttachmentFile(), null, null, null, 56, null));
        }
        List attachments = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = propOppPackage.getSchemas();
        boolean $i$f$map4 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo222 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it4;
            PropOppPkgSchema bl3 = (PropOppPkgSchema)item$iv$iv3;
            collection = destination$iv$iv3;
            boolean bl4 = false;
            collection.add(new PropOppPkgSubmPkgSchema(null, it4.getNamespace(), new File(null, it4.getSchemaFile().getName(), it4.getSchemaFile().getContentType(), (long)it4.getSchemaFile().getData().length, it4.getSchemaFile().getData(), null, null, 96, null), null, null, null, 56, null));
        }
        List schemas = (List)destination$iv$iv3;
        String string2 = packageXml;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] packageXmlData = byArray;
        ResAuthUser authUser = (ResAuthUser)this.resAuthService.authUser().component2();
        String string3 = authUser.getUsername();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        PropOppPkgSubmPackage $i$f$mapTo222 = propOppPkgSubmPackage = new PropOppPkgSubmPackage(null, propOppPackage.getProvider(), propOppPackage.getSchemaUrl(), new File(null, propOppPackage.getPackageId() + ".xml", "application/xml", (long)packageXmlData.length, packageXmlData, null, null, 96, null), null, null, null, null, 240, null);
        Instant instant2 = instant;
        String string4 = string3;
        String string5 = "submitted";
        boolean bl5 = false;
        PropOppPackage propOppPackage2 = propOppPackage;
        Long l = null;
        boolean bl6 = false;
        $this$buildSubmissionFromPackage_u24lambda_u2419.addAllAttachments(attachments);
        $this$buildSubmissionFromPackage_u24lambda_u2419.addAllSchemas(schemas);
        Unit unit = Unit.INSTANCE;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 897;
        List list = null;
        Instant instant3 = null;
        Instant instant4 = null;
        PropOppPkgSubmPackage propOppPkgSubmPackage2 = propOppPkgSubmPackage;
        Instant instant5 = instant2;
        String string6 = string4;
        String string7 = string5;
        boolean bl7 = bl5;
        PropOppPackage propOppPackage3 = propOppPackage2;
        Long l2 = l;
        PropOppPkgSubmPackage $this$buildSubmissionFromPackage_u24lambda_u2420 = propOppPkgSubmPackage = new PropOppPkgSubmission(l2, propOppPackage3, bl7, string7, string6, instant5, propOppPkgSubmPackage2, instant4, instant3, list, n, defaultConstructorMarker);
        boolean bl8 = false;
        $this$buildSubmissionFromPackage_u24lambda_u2420.addAll(forms);
        return propOppPkgSubmPackage;
    }

    /*
     * WARNING - void declaration
     */
    private PropOppPkgSubmission createSubmission(Proposal proposal, PropOppPackage propOppPackage) {
        PropOppPkgSubmGgSubmit propOppPkgSubmGgSubmit;
        Collection collection;
        Collection collection2;
        SubmitApplicationRequest $this$mapTo$iv$iv3;
        void $this$map$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2 = propOppPackage.getForms();
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            PropOppPkgForm it = (PropOppPkgForm)element$iv$iv;
            boolean bl = false;
            if (!it.getInclude()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List formsToInclude = (List)destination$iv$iv;
        Iterable $i$f$filter22 = propOppPackage.getFormOverrides();
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block10: {
                PropOppPkgFormOverride it = (PropOppPkgFormOverride)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = formsToInclude;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PropOppPkgForm include = (PropOppPkgForm)element$iv;
                        boolean bl3 = false;
                        if (!(Intrinsics.areEqual((Object)it.getName(), (Object)include.getName()) && Intrinsics.areEqual((Object)it.getFormVersion(), (Object)include.getFormVersion()))) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PropOppPkgFormOverride it = (PropOppPkgFormOverride)element$iv$iv;
            boolean bl = false;
            if (!it.getActive()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            PropOppPkgSubmForm propOppPkgSubmForm;
            Object element$iv;
            PropOppPkgFormOverride it = (PropOppPkgFormOverride)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl = false;
            PropOppPkgSubmForm $this$createSubmission_u24lambda_u2427_u24lambda_u2426 = propOppPkgSubmForm = new PropOppPkgSubmForm(null, it.getName(), it.getFormVersion(), it.getSchemaUrl(), null, new File(null, it.getPdfFile().getName(), it.getPdfFile().getContentType(), (long)it.getPdfFile().getData().length, it.getPdfFile().getData(), null, null, 96, null), null, new File(null, it.getXmlFile().getName(), it.getXmlFile().getContentType(), (long)it.getXmlFile().getData().length, it.getXmlFile().getData(), null, null, 96, null), null, null, null, 1792, null);
            boolean bl4 = false;
            element$iv = it.getFormOvrdAttachments();
            PropOppPkgSubmForm propOppPkgSubmForm2 = $this$createSubmission_u24lambda_u2427_u24lambda_u2426;
            boolean $i$f$map2 = false;
            void var20_31 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void att;
                PropOppPkgFormOvrdAttachment propOppPkgFormOvrdAttachment = (PropOppPkgFormOvrdAttachment)item$iv$iv2;
                Collection collection3 = destination$iv$iv3;
                boolean bl5 = false;
                collection3.add(new PropOppPkgSubmFormAttachment(null, att.getFileKey(), new File($this$createSubmission_u24lambda_u2427_u24lambda_u2426.getId(), att.getAttachmentFile().getName(), att.getAttachmentFile().getContentType(), att.getAttachmentFile().getSize(), att.getAttachmentFile().getData(), null, null, 96, null), null, null, null, 56, null));
            }
            propOppPkgSubmForm2.addAll((List)destination$iv$iv3);
            collection2.add(propOppPkgSubmForm);
        }
        List forms = (List)destination$iv$iv2;
        PropOppPkgSubmission submission = this.buildSubmissionFromPackage(propOppPackage, forms, proposal.getTitle());
        collection2 = submission;
        try {
            void $this$createSubmission_u24lambda_u2428;
            $this$mapTo$iv$iv3 = new SubmitApplicationRequest();
            destination$iv$iv2 = $this$mapTo$iv$iv3;
            ApplicationWebServicesClient applicationWebServicesClient = this.applicationWebServicesClient;
            Collection collection4 = collection2;
            boolean bl = false;
            $this$createSubmission_u24lambda_u2428.setGrantApplicationXML(new String(submission.getPropOppPkgSubmPackage().getXmlFile().getData(), Charsets.UTF_8));
            Unit unit = Unit.INSTANCE;
            collection = collection4;
            SubmitApplicationResponse response2 = applicationWebServicesClient.submit($this$mapTo$iv$iv3);
            propOppPkgSubmGgSubmit = new PropOppPkgSubmGgSubmit(null, response2.getGrantsGovTrackingNumber(), response2.getReceivedDateTime().toGregorianCalendar().toZonedDateTime().toInstant(), null, submission, null, null, null, null, 384, null);
        }
        catch (SoapFaultClientException $this$mapTo$iv$iv3) {
            void errorMessage;
            collection = collection2;
            propOppPkgSubmGgSubmit = new PropOppPkgSubmGgSubmit(null, null, null, IntegrationError.Companion.fromSoapFault((SoapFaultClientException)errorMessage), submission, null, null, null, null, 384, null);
        }
        collection.setPropOppPkgSubmGgSubmit(propOppPkgSubmGgSubmit);
        Object object = this.propOppPkgSubmissionRepository.save((Object)submission);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        return (PropOppPkgSubmission)object;
    }

    private static final PropOppPkgSubmission refresh$lambda$0(PropOppPkgSubmissionController this$0, PropOppPkgSubmission propOppPkgSubmission) {
        PropOppPkgSubmGgSubmit propOppPkgSubmGgSubmit = propOppPkgSubmission.getPropOppPkgSubmGgSubmit();
        CharSequence charSequence = propOppPkgSubmGgSubmit != null ? propOppPkgSubmGgSubmit.getGrantsGovTrackingNumber() : null;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            PropOppPkgSubmGgSubmit propOppPkgSubmGgSubmit2 = propOppPkgSubmission.getPropOppPkgSubmGgSubmit();
            Intrinsics.checkNotNull((Object)propOppPkgSubmGgSubmit2);
            PropOppPkgSubmGgSubmit propOppPkgSubmGgSubmit3 = propOppPkgSubmGgSubmit2;
            if (propOppPkgSubmission.isNih()) {
                PropOppPkgSubmNihSubmitDetails propOppPkgSubmNihSubmitDetails = propOppPkgSubmGgSubmit3.getPropOppPkgSubmNihSubmitDetails();
                if (propOppPkgSubmNihSubmitDetails != null) {
                    propOppPkgSubmNihSubmitDetails.clearIntegrationErrors();
                }
                propOppPkgSubmGgSubmit3.setPropOppPkgSubmNihSubmitDetails(this$0.refreshAndSaveNihDetails(propOppPkgSubmGgSubmit3));
            }
            PropOppPkgSubmGgSubmitDetails propOppPkgSubmGgSubmitDetails = propOppPkgSubmGgSubmit3.getPropOppPkgSubmGgSubmitDetails();
            if (propOppPkgSubmGgSubmitDetails != null) {
                propOppPkgSubmGgSubmitDetails.clearIntegrationErrors();
            }
            propOppPkgSubmGgSubmit3.setPropOppPkgSubmGgSubmitDetails(this$0.refreshAndSaveGgDetailsAppInfo(propOppPkgSubmGgSubmit3));
            propOppPkgSubmGgSubmit3.setPropOppPkgSubmGgSubmitDetails(this$0.refreshAndSaveGgDetailsSubmissionDetails(propOppPkgSubmGgSubmit3));
            propOppPkgSubmGgSubmit3.setPropOppPkgSubmGgSubmitDetails(this$0.refreshAndSaveGgDetailsApplicationZip(propOppPkgSubmGgSubmit3));
        }
        return propOppPkgSubmission;
    }

    private static final PropOppPkgSubmission refresh$lambda$1(Function1 $tmp0, Object p0) {
        return (PropOppPkgSubmission)$tmp0.invoke(p0);
    }

    private static final ResponseEntity refresh$lambda$2(PropOppPkgSubmissionController this$0, long $proposalId, PropOppPkgSubmission it) {
        return ResponseEntity.ok((Object)ProblemModel.Companion.victory$default((ProblemModel.Companion)ProblemModel.Companion, (RepresentationModel)((RepresentationModel)this$0.propOppPkgSubmissionAssembler.toModel(TuplesKt.to((Object)$proposalId, (Object)it))), null, (int)2, null));
    }

    private static final ResponseEntity refresh$lambda$3(Function1 $tmp0, Object p0) {
        return (ResponseEntity)$tmp0.invoke(p0);
    }

    private static final PropOppPkgSubmission submit$lambda$8(PropOppPkgSubmissionController this$0, long $proposalId, PropOppPackage it) {
        PropOppPkgSubmission propOppPkgSubmission = it.getSubmission();
        if (propOppPkgSubmission == null) {
            Object t = this$0.proposalRepository.findById((Object)$proposalId).get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            Proposal proposal = (Proposal)t;
            Intrinsics.checkNotNull((Object)it);
            propOppPkgSubmission = this$0.createSubmission(proposal, it);
        }
        return propOppPkgSubmission;
    }

    private static final PropOppPkgSubmission submit$lambda$9(Function1 $tmp0, Object p0) {
        return (PropOppPkgSubmission)$tmp0.invoke(p0);
    }

    private static final ResponseEntity submit$lambda$10(PropOppPkgSubmissionController this$0, long $proposalId, PropOppPkgSubmission it) {
        return ResponseEntity.ok((Object)ProblemModel.Companion.victory$default((ProblemModel.Companion)ProblemModel.Companion, (RepresentationModel)((RepresentationModel)this$0.propOppPkgSubmissionAssembler.toModel(TuplesKt.to((Object)$proposalId, (Object)it))), null, (int)2, null));
    }

    private static final ResponseEntity submit$lambda$11(Function1 $tmp0, Object p0) {
        return (ResponseEntity)$tmp0.invoke(p0);
    }

    private static final CharSequence buildSubmissionFromPackage$lambda$14(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }
}

