/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.resintegration.sp.proposal.internal.client;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.grants.resintegration.sp.auth.ResSpAuthService;
import org.kuali.research.grants.resintegration.sp.auth.SpAuthBearerToken;
import org.kuali.research.grants.resintegration.sp.proposal.ResSpProposal;
import org.kuali.research.grants.resintegration.sp.proposal.ResSpProposalClient;
import org.kuali.research.grants.sys.service.ServiceCategory;
import org.kuali.research.grants.sys.service.ServiceInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/kuali/research/grants/resintegration/sp/proposal/internal/client/ResSpProposalClientImpl;", "Lorg/kuali/research/grants/resintegration/sp/proposal/ResSpProposalClient;", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "resSpAuthService", "Lorg/kuali/research/grants/resintegration/sp/auth/ResSpAuthService;", "<init>", "(Lorg/springframework/web/client/RestClient$Builder;Lorg/kuali/research/grants/resintegration/sp/auth/ResSpAuthService;)V", "getProposal", "Lorg/kuali/research/grants/resintegration/sp/proposal/ResSpProposal;", "proposalNumber", "Lorg/kuali/research/grants/resintegration/sp/proposal/SpProposalNumber;", "getProposal-il8oOJ0", "(Ljava/lang/String;)Lorg/kuali/research/grants/resintegration/sp/proposal/ResSpProposal;", "serviceUri", "", "isConnectedThrowing", "", "serviceInfo", "Lorg/kuali/research/grants/sys/service/ServiceInfo;", "serviceId", "research-grants-backend"})
public class ResSpProposalClientImpl
implements ResSpProposalClient {
    @NotNull
    private final RestClient.Builder restClientBuilder;
    @NotNull
    private final ResSpAuthService resSpAuthService;

    public ResSpProposalClientImpl(@Autowired @NotNull RestClient.Builder restClientBuilder, @Autowired @NotNull ResSpAuthService resSpAuthService) {
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        Intrinsics.checkNotNullParameter((Object)resSpAuthService, (String)"resSpAuthService");
        this.restClientBuilder = restClientBuilder;
        this.resSpAuthService = resSpAuthService;
    }

    @Nullable
    public ResSpProposal getProposal-il8oOJ0(@NotNull String proposalNumber) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)proposalNumber, (String)"proposalNumber");
        String string = UriComponentsBuilder.fromUriString((String)this.serviceUri()).path("/propdev/api/v2/development-proposals/" + proposalNumber).build().toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        String currentUrl = string;
        String token = ((SpAuthBearerToken)this.resSpAuthService.authUser().component1()).unbox-impl();
        try {
            stringArray = new String[]{"Bearer " + SpAuthBearerToken.toString-impl((String)token)};
            RestClient.RequestHeadersSpec requestHeadersSpec = this.restClientBuilder.build().get().uri(currentUrl, new Object[0]).header("Authorization", stringArray);
            stringArray = new String[]{"application/json"};
            stringArray = (String[])requestHeadersSpec.header("Content-Type", stringArray).retrieve().body(ResSpProposal.class);
        }
        catch (HttpClientErrorException.Unauthorized ex) {
            this.getLogger().debug((CharSequence)"Unauthorized request to Core Auth", (Throwable)ex);
            stringArray = null;
        }
        return stringArray;
    }

    @NotNull
    public String serviceUri() {
        return "https://greendale-tst.kuali.co/res";
    }

    public boolean isConnectedThrowing() {
        String string = UriComponentsBuilder.fromUriString((String)this.serviceUri()).path("/research-sys/").build().toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        String healthUrl = string;
        return this.restClientBuilder.build().get().uri(healthUrl, new Object[0]).retrieve().toBodilessEntity().getStatusCode().is2xxSuccessful();
    }

    @NotNull
    public ServiceInfo serviceInfo() {
        return new ServiceInfo(this.serviceId(), "SP Proposal", this.isConnected(), "This is the Kuali SP Proposal Service.", this.serviceUri(), ServiceCategory.KUALI);
    }

    @NotNull
    public String serviceId() {
        return "SPPROPOSAL";
    }

    @NotNull
    public KotlinLogger getLogger() {
        return ResSpProposalClient.DefaultImpls.getLogger((ResSpProposalClient)this);
    }
}

