/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.proposal.internal.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kuali.research.grants.proposal.internal.entity.Proposal;
import org.kuali.research.grants.proposal.internal.model.ProposalModel;
import org.kuali.research.grants.proposal.internal.model.ProposalUpsertDto;
import org.kuali.research.grants.proposal.internal.service.ProposalService;
import org.kuali.research.grants.proposal.internal.util.Error;
import org.kuali.research.grants.proposal.internal.util.ProposalId;
import org.kuali.research.grants.resintegration.SourceSystemId;
import org.kuali.research.grants.sys.hateoas.ProblemBuilder;
import org.kuali.research.grants.sys.hateoas.ProblemModel;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.data.web.SortDefault;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/proposals"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000f0\u000e0\r2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u001e\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000e0\r2\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017J\u001e\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000e0\r2\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0017J\u001e\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000e0\r2\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J\u001e\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000e0\r2\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/kuali/research/grants/proposal/internal/controller/ProposalController;", "", "service", "Lorg/kuali/research/grants/proposal/internal/service/ProposalService;", "assembler", "Lorg/springframework/hateoas/server/RepresentationModelAssembler;", "Lorg/kuali/research/grants/proposal/internal/entity/Proposal;", "Lorg/kuali/research/grants/proposal/internal/model/ProposalModel;", "pagedResourcesAssembler", "Lorg/springframework/data/web/PagedResourcesAssembler;", "<init>", "(Lorg/kuali/research/grants/proposal/internal/service/ProposalService;Lorg/springframework/hateoas/server/RepresentationModelAssembler;Lorg/springframework/data/web/PagedResourcesAssembler;)V", "getAllProposals", "Lorg/springframework/http/ResponseEntity;", "Lorg/kuali/research/grants/sys/hateoas/ProblemModel;", "Lorg/springframework/hateoas/PagedModel;", "pageable", "Lorg/springframework/data/domain/Pageable;", "getProposalById", "id", "", "getProposalBySourceSystemId", "sourceSystemId", "", "createOrUpdateProposal", "proposal", "Lorg/kuali/research/grants/proposal/internal/model/ProposalUpsertDto;", "deleteProposal", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nProposalController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProposalController.kt\norg/kuali/research/grants/proposal/internal/controller/ProposalController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1#2:84\n1563#3:85\n1634#3,3:86\n1563#3:89\n1634#3,3:90\n1563#3:93\n1634#3,3:94\n*S KotlinDebug\n*F\n+ 1 ProposalController.kt\norg/kuali/research/grants/proposal/internal/controller/ProposalController\n*L\n55#1:85\n55#1:86,3\n66#1:89\n66#1:90,3\n77#1:93\n77#1:94,3\n*E\n"})
public class ProposalController {
    @NotNull
    private final ProposalService service;
    @NotNull
    private final RepresentationModelAssembler<Proposal, ProposalModel> assembler;
    @NotNull
    private final PagedResourcesAssembler<Proposal> pagedResourcesAssembler;

    public ProposalController(@NotNull ProposalService service, @NotNull RepresentationModelAssembler<Proposal, ProposalModel> assembler, @NotNull PagedResourcesAssembler<Proposal> pagedResourcesAssembler) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter(assembler, (String)"assembler");
        Intrinsics.checkNotNullParameter(pagedResourcesAssembler, (String)"pagedResourcesAssembler");
        this.service = service;
        this.assembler = assembler;
        this.pagedResourcesAssembler = pagedResourcesAssembler;
    }

    @GetMapping
    @NotNull
    public ResponseEntity<ProblemModel<PagedModel<ProposalModel>>> getAllProposals(@PageableDefault(size=20) @SortDefault.SortDefaults(value={@SortDefault(sort={"id"}, direction=Sort.Direction.ASC)}) @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.service.getAllProposals(pageable);
        PagedModel pagedModel = this.pagedResourcesAssembler.toModel(page, this.assembler);
        Intrinsics.checkNotNullExpressionValue((Object)pagedModel, (String)"toModel(...)");
        ResponseEntity responseEntity = ResponseEntity.ok((Object)ProblemModel.Companion.victory$default((ProblemModel.Companion)ProblemModel.Companion, (RepresentationModel)((RepresentationModel)pagedModel), null, (int)2, null));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @GetMapping(value={"/{id}"})
    @NotNull
    public ResponseEntity<ProblemModel<ProposalModel>> getProposalById(@PathVariable long id) {
        Proposal proposal;
        block3: {
            block2: {
                Proposal proposal2 = this.service.getProposalById-8G5Oh5Q(ProposalId.constructor-impl((long)id));
                proposal = proposal2;
                if (proposal == null) break block2;
                Proposal it = proposal;
                boolean bl = false;
                RepresentationModel representationModel = this.assembler.toModel((Object)it);
                Intrinsics.checkNotNullExpressionValue((Object)representationModel, (String)"toModel(...)");
                ResponseEntity responseEntity = ResponseEntity.ok((Object)ProblemModel.Companion.victory$default((ProblemModel.Companion)ProblemModel.Companion, (RepresentationModel)representationModel, null, (int)2, null));
                proposal = responseEntity;
                if (responseEntity != null) break block3;
            }
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND)).body((Object)ProblemModel.Companion.empty());
            proposal = responseEntity;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        }
        return proposal;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/source-system/{sourceSystemId}"})
    @NotNull
    public ResponseEntity<ProblemModel<ProposalModel>> getProposalBySourceSystemId(@PathVariable @NotNull String sourceSystemId) {
        Proposal proposal;
        block4: {
            List problems;
            block3: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)sourceSystemId, (String)"sourceSystemId");
                Pair pair = this.service.synchronizeProposalWithSourceSystem-9woYloA(SourceSystemId.constructor-impl((String)sourceSystemId));
                Proposal proposal2 = (Proposal)pair.component1();
                List errors = (List)pair.component2();
                Iterable $this$map$iv = errors;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Error error = (Error)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(ProblemBuilder.Companion.build(it.getMessage(), it.getLevel()));
                }
                problems = (List)destination$iv$iv;
                proposal = proposal2;
                if (proposal == null) break block3;
                Proposal it = proposal;
                boolean bl = false;
                RepresentationModel representationModel = this.assembler.toModel((Object)it);
                Intrinsics.checkNotNullExpressionValue((Object)representationModel, (String)"toModel(...)");
                ResponseEntity responseEntity = ResponseEntity.ok((Object)ProblemModel.Companion.victory$default((ProblemModel.Companion)ProblemModel.Companion, (RepresentationModel)representationModel, null, (int)2, null));
                proposal = responseEntity;
                if (responseEntity != null) break block4;
            }
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.NOT_FOUND)).body((Object)ProblemModel.Companion.defeat(problems));
            proposal = responseEntity;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        }
        return proposal;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping
    @NotNull
    public ResponseEntity<ProblemModel<ProposalModel>> createOrUpdateProposal(@RequestBody @NotNull ProposalUpsertDto proposal) {
        Proposal proposal2;
        block4: {
            List problems;
            block3: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
                Pair pair = this.service.createOrUpdateProposal(proposal);
                Proposal savedProposal = (Proposal)pair.component1();
                List errors = (List)pair.component2();
                Iterable $this$map$iv = errors;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Error error = (Error)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(ProblemBuilder.Companion.build(it.getMessage(), it.getLevel()));
                }
                problems = (List)destination$iv$iv;
                proposal2 = savedProposal;
                if (proposal2 == null) break block3;
                Proposal it = proposal2;
                boolean bl = false;
                RepresentationModel representationModel = this.assembler.toModel((Object)it);
                Intrinsics.checkNotNullExpressionValue((Object)representationModel, (String)"toModel(...)");
                ResponseEntity responseEntity = ResponseEntity.ok((Object)ProblemModel.Companion.victory(representationModel, problems));
                proposal2 = responseEntity;
                if (responseEntity != null) break block4;
            }
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY)).body((Object)ProblemModel.Companion.defeat(problems));
            proposal2 = responseEntity;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        }
        return proposal2;
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"/{id}"})
    @NotNull
    public ResponseEntity<ProblemModel<ProposalModel>> deleteProposal(@PathVariable long id) {
        Proposal proposal;
        block4: {
            List problems;
            block3: {
                void $this$mapTo$iv$iv;
                Pair pair = this.service.deleteProposal-8G5Oh5Q(ProposalId.constructor-impl((long)id));
                Proposal deletedProposal = (Proposal)pair.component1();
                List errors = (List)pair.component2();
                Iterable $this$map$iv = errors;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Error error = (Error)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(ProblemBuilder.Companion.build(it.getMessage(), it.getLevel()));
                }
                problems = (List)destination$iv$iv;
                proposal = deletedProposal;
                if (proposal == null) break block3;
                Proposal it = proposal;
                boolean bl = false;
                ResponseEntity responseEntity = ResponseEntity.ok((Object)ProblemModel.Companion.emptyVictory(problems));
                proposal = responseEntity;
                if (responseEntity != null) break block4;
            }
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY)).body((Object)ProblemModel.Companion.defeat(problems));
            proposal = responseEntity;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        }
        return proposal;
    }
}

