/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.research.grants.proposal.internal.service;

import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.apache.logging.log4j.kotlin.LoggingFactoryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kuali.research.grants.proposal.internal.entity.Proposal;
import org.kuali.research.grants.proposal.internal.model.ProposalUpsertDto;
import org.kuali.research.grants.proposal.internal.repository.ProposalRepository;
import org.kuali.research.grants.proposal.internal.service.ProposalService;
import org.kuali.research.grants.proposal.internal.util.Error;
import org.kuali.research.grants.resintegration.ResProposal;
import org.kuali.research.grants.resintegration.ResProposalService;
import org.kuali.research.grants.sys.util.Level;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J+\u0010\u0014\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\n0\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0014\u0010 \u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\f\u0010!\u001a\u00020\u000b*\u00020\u001fH\u0016J$\u0010\"\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\n0\u00152\u0006\u0010#\u001a\u00020$H\u0016J+\u0010%\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\n0\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b&\u0010'R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/kuali/research/grants/proposal/internal/service/ProposalServiceImpl;", "Lorg/kuali/research/grants/proposal/internal/service/ProposalService;", "Lorg/apache/logging/log4j/kotlin/Logging;", "repository", "Lorg/kuali/research/grants/proposal/internal/repository/ProposalRepository;", "resProposalService", "Lorg/kuali/research/grants/resintegration/ResProposalService;", "<init>", "(Lorg/kuali/research/grants/proposal/internal/repository/ProposalRepository;Lorg/kuali/research/grants/resintegration/ResProposalService;)V", "getAllProposals", "", "Lorg/kuali/research/grants/proposal/internal/entity/Proposal;", "Lorg/springframework/data/domain/Page;", "pageable", "Lorg/springframework/data/domain/Pageable;", "getProposalById", "id", "Lorg/kuali/research/grants/proposal/internal/util/ProposalId;", "getProposalById-8G5Oh5Q", "(J)Lorg/kuali/research/grants/proposal/internal/entity/Proposal;", "synchronizeProposalWithSourceSystem", "Lkotlin/Pair;", "Lorg/kuali/research/grants/proposal/internal/util/Error;", "sourceSystemId", "Lorg/kuali/research/grants/resintegration/SourceSystemId;", "synchronizeProposalWithSourceSystem-9woYloA", "(Ljava/lang/String;)Lkotlin/Pair;", "hasUpdates", "", "proposal", "resProposal", "Lorg/kuali/research/grants/resintegration/ResProposal;", "updateFromSource", "toProposal", "createOrUpdateProposal", "proposalUpsertDto", "Lorg/kuali/research/grants/proposal/internal/model/ProposalUpsertDto;", "deleteProposal", "deleteProposal-8G5Oh5Q", "(J)Lkotlin/Pair;", "research-grants-backend"})
@SourceDebugExtension(value={"SMAP\nProposalServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProposalServiceImpl.kt\norg/kuali/research/grants/proposal/internal/service/ProposalServiceImpl\n+ 2 LoggingFactory.kt\norg/apache/logging/log4j/kotlin/LoggingFactoryKt\n*L\n1#1,132:1\n30#2:133\n30#2:134\n30#2:135\n30#2:136\n30#2:137\n30#2:138\n*S KotlinDebug\n*F\n+ 1 ProposalServiceImpl.kt\norg/kuali/research/grants/proposal/internal/service/ProposalServiceImpl\n*L\n41#1:133\n51#1:134\n63#1:135\n108#1:136\n118#1:137\n127#1:138\n*E\n"})
public class ProposalServiceImpl
implements ProposalService,
Logging {
    @NotNull
    private final ProposalRepository repository;
    @NotNull
    private final ResProposalService resProposalService;

    public ProposalServiceImpl(@NotNull ProposalRepository repository, @NotNull ResProposalService resProposalService) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)resProposalService, (String)"resProposalService");
        this.repository = repository;
        this.resProposalService = resProposalService;
    }

    @NotNull
    public List<Proposal> getAllProposals() {
        List list = this.repository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAll(...)");
        return list;
    }

    @NotNull
    public Page<Proposal> getAllProposals(@NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.repository.findAll(pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findAll(...)");
        return page;
    }

    @Nullable
    public Proposal getProposalById-8G5Oh5Q(long id) {
        Optional optional = this.repository.findById((Object)id);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findById(...)");
        return (Proposal)OptionalsKt.getOrNull((Optional)optional);
    }

    @NotNull
    public Pair<Proposal, List<Error>> synchronizeProposalWithSourceSystem-9woYloA(@NotNull String sourceSystemId) {
        Proposal proposal;
        Proposal grantsProposal;
        Intrinsics.checkNotNullParameter((Object)sourceSystemId, (String)"sourceSystemId");
        if (StringsKt.isBlank((CharSequence)sourceSystemId)) {
            ProposalServiceImpl $this$logger$iv = this;
            boolean $i$f$logger = false;
            LoggingFactoryKt.loggerOf(ProposalServiceImpl.class).error((CharSequence)"Proposal source system ID is blank, returning null.");
            return TuplesKt.to(null, (Object)CollectionsKt.listOf((Object)new Error("Proposal source system ID cannot be blank.", Level.SEVERE)));
        }
        ResProposal sourceProposal = this.resProposalService.getProposal-9woYloA(sourceSystemId);
        if (sourceProposal == null) {
            String message = "No proposal found in source system for source system ID: " + sourceSystemId;
            ProposalServiceImpl $this$logger$iv = this;
            boolean $i$f$logger = false;
            LoggingFactoryKt.loggerOf(ProposalServiceImpl.class).error((CharSequence)message);
            return TuplesKt.to(null, (Object)CollectionsKt.listOf((Object)new Error(message, Level.SEVERE)));
        }
        Proposal proposal2 = grantsProposal = (Proposal)OptionalsKt.getOrNull((Optional)this.repository.findBySourceSystemId(sourceSystemId));
        if (proposal2 != null) {
            Proposal $this$synchronizeProposalWithSourceSystem_9woYloA_u24lambda_u240 = var6_10 = proposal2;
            boolean bl = false;
            if (!this.hasUpdates($this$synchronizeProposalWithSourceSystem_9woYloA_u24lambda_u240, sourceProposal)) {
                return TuplesKt.to((Object)$this$synchronizeProposalWithSourceSystem_9woYloA_u24lambda_u240, (Object)CollectionsKt.emptyList());
            }
            this.updateFromSource($this$synchronizeProposalWithSourceSystem_9woYloA_u24lambda_u240, sourceProposal);
            proposal = var6_10;
        } else {
            Proposal it = var6_10 = this.toProposal(sourceProposal);
            boolean bl = false;
            ProposalServiceImpl $this$logger$iv = this;
            boolean $i$f$logger = false;
            LoggingFactoryKt.loggerOf(ProposalServiceImpl.class).info((CharSequence)("No local proposal found for source system ID: " + sourceSystemId + ". Generating new proposal entity."));
            proposal = var6_10;
        }
        Proposal updatedProposal = proposal;
        return TuplesKt.to((Object)this.repository.save((Object)updatedProposal), (Object)CollectionsKt.emptyList());
    }

    public boolean hasUpdates(@NotNull Proposal proposal, @NotNull ResProposal resProposal) {
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        Intrinsics.checkNotNullParameter((Object)resProposal, (String)"resProposal");
        return !Intrinsics.areEqual((Object)proposal.getPrincipalInvestigator(), (Object)resProposal.getPrincipalInvestigator()) || !Intrinsics.areEqual((Object)proposal.getSponsorName(), (Object)resProposal.getSponsorName()) || !Intrinsics.areEqual((Object)proposal.getTitle(), (Object)resProposal.getTitle());
    }

    @NotNull
    public Proposal updateFromSource(@NotNull Proposal $this$updateFromSource, @NotNull ResProposal resProposal) {
        Proposal proposal;
        Intrinsics.checkNotNullParameter((Object)$this$updateFromSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resProposal, (String)"resProposal");
        Proposal $this$updateFromSource_u24lambda_u242 = proposal = $this$updateFromSource;
        boolean bl = false;
        $this$updateFromSource_u24lambda_u242.setPrincipalInvestigator(resProposal.getPrincipalInvestigator());
        $this$updateFromSource_u24lambda_u242.setSponsorName(resProposal.getSponsorName());
        $this$updateFromSource_u24lambda_u242.setTitle(resProposal.getTitle());
        return proposal;
    }

    @NotNull
    public Proposal toProposal(@NotNull ResProposal $this$toProposal) {
        Intrinsics.checkNotNullParameter((Object)$this$toProposal, (String)"<this>");
        String string = $this$toProposal.getSourceSystemId-zvgqOkY();
        String string2 = $this$toProposal.getPrincipalInvestigator();
        String string3 = $this$toProposal.getSponsorName();
        String string4 = $this$toProposal.getTitle();
        return new Proposal(null, string2, string, string3, string4, null, null, null, 225, null);
    }

    @NotNull
    public Pair<Proposal, List<Error>> createOrUpdateProposal(@NotNull ProposalUpsertDto proposalUpsertDto) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)proposalUpsertDto, (String)"proposalUpsertDto");
        Proposal proposal = new Proposal(proposalUpsertDto.getId(), proposalUpsertDto.getPrincipalInvestigator(), proposalUpsertDto.getSourceSystemId(), proposalUpsertDto.getSponsorName(), proposalUpsertDto.getTitle(), null, null, null, 224, null);
        try {
            pair = TuplesKt.to((Object)this.repository.save((Object)proposal), (Object)CollectionsKt.emptyList());
        }
        catch (Exception e) {
            String message = "Failed to save proposal " + proposal + ".";
            ProposalServiceImpl $this$logger$iv = this;
            boolean $i$f$logger = false;
            LoggingFactoryKt.loggerOf(ProposalServiceImpl.class).error((CharSequence)(message + " " + e.getMessage()), (Throwable)e);
            pair = TuplesKt.to(null, (Object)CollectionsKt.listOf((Object)new Error(message, Level.SEVERE)));
        }
        return pair;
    }

    @NotNull
    public Pair<Proposal, List<Error>> deleteProposal-8G5Oh5Q(long id) {
        Pair pair;
        Optional optional = this.repository.findById((Object)id);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findById(...)");
        Proposal proposal = (Proposal)OptionalsKt.getOrNull((Optional)optional);
        if (proposal == null) {
            String message = "Failed to delete proposal with id " + id + ".";
            ProposalServiceImpl $this$logger$iv = this;
            boolean $i$f$logger = false;
            LoggingFactoryKt.loggerOf(ProposalServiceImpl.class).error((CharSequence)message);
            return TuplesKt.to(null, (Object)CollectionsKt.listOf((Object)new Error(message, Level.SEVERE)));
        }
        try {
            this.repository.delete((Object)proposal);
            pair = TuplesKt.to((Object)proposal, (Object)CollectionsKt.emptyList());
        }
        catch (Exception e) {
            String message = "Failed to delete proposal with id " + id + ".";
            ProposalServiceImpl $this$logger$iv = this;
            boolean $i$f$logger = false;
            LoggingFactoryKt.loggerOf(ProposalServiceImpl.class).error((CharSequence)(message + " " + e.getMessage()), (Throwable)e);
            pair = TuplesKt.to(null, (Object)CollectionsKt.listOf((Object)new Error(message, Level.SEVERE)));
        }
        return pair;
    }

    @NotNull
    public KotlinLogger getLogger() {
        return Logging.DefaultImpls.getLogger((Logging)this);
    }
}

