/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.exception;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * This class is a valud added datastructure that is used to house a list of Exceptions and is 
 * recognized as an Exception so that it can be thrown from methods and handled like an Exception.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ErrorList extends Exception {
    private static final long serialVersionUID = -8045847343472018601L;
    
    private List errorList;
    
    /**
     * Constructs a ErrorList instance.
     */
    public ErrorList() {
    	errorList = new ArrayList();
    }
    
    /**
     * This method checks to see if the list is empty or not.
     * @return boolean
     */
    public boolean isEmpty() {
    	return errorList.isEmpty();
    }
    
    /**
     * This method adds errors to the error list.
     * @param error
     */
    public void addError(String error) {
    	this.errorList.add(error);
    }
    
    /**
     * This method retreives all of the errors in the list.
     * @return List
     */
    public List getErrors() {
    	return this.errorList;
    }
    
    /**
     * This method adds a list of errors to the error list.
     * @param errors
     */
    public void addErrors(ErrorList errors) {
    	this.errorList.addAll(errors.errorList);
    }
    
    /**
     * This method returns a string representation of all of the errors in the error list.
     * @see java.lang.Throwable#getMessage()
     */
    @Override
    public String getMessage() {
    	return toString();
    }
    
    /**
     * This method is responsible for concatenating all of the errors in the error list together.
     * @see java.lang.Throwable#toString()
     */
    @Override
    public String toString() {
    	StringBuffer buf = new StringBuffer("errors=(");
    
    	for (Iterator i = errorList.iterator(); i.hasNext();) {
    		buf.append(i.next());
    		if (i.hasNext()) {
    			buf.append(";");
    		}
    	}
    	buf.append(")");
    
    	return buf.toString();
    }
}
