/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.dao.impl;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.OrderByField;
import org.kuali.rice.core.api.criteria.OrderDirection;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.kew.rule.bo.RuleTemplateBo;
import org.kuali.rice.kew.rule.dao.RuleTemplateDAO;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class RuleTemplateDAOJpa
implements RuleTemplateDAO {
    private static final String SEQUENCE_NAME = "KREW_RTE_TMPL_S";
    private EntityManager entityManager;
    private DataObjectService dataObjectService;
    private DataSource dataSource;

    @Override
    public List<RuleTemplateBo> findAll() {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        return this.getDataObjectService().findMatching(RuleTemplateBo.class, builder.build()).getResults();
    }

    @Override
    public RuleTemplateBo findByRuleTemplateName(String ruleTemplateName) {
        if (StringUtils.isBlank((String)ruleTemplateName)) {
            return null;
        }
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"name", (Object)ruleTemplateName)});
        builder.setOrderByFields(new OrderByField[]{OrderByField.Builder.create((String)"name", (OrderDirection)OrderDirection.DESCENDING).build()});
        QueryResults ruleTemplates = this.getDataObjectService().findMatching(RuleTemplateBo.class, builder.build());
        if (ruleTemplates == null || ruleTemplates.getResults() == null || ruleTemplates.getResults().isEmpty()) {
            return null;
        }
        return (RuleTemplateBo)((Object)ruleTemplates.getResults().get(0));
    }

    @Override
    public List<RuleTemplateBo> findByRuleTemplate(RuleTemplateBo ruleTemplate) {
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (ruleTemplate.getName() != null) {
            predicates.add(PredicateFactory.likeIgnoreCase((String)"name", (CharSequence)ruleTemplate.getName()));
        }
        if (ruleTemplate.getDescription() != null) {
            predicates.add(PredicateFactory.likeIgnoreCase((String)"description", (CharSequence)ruleTemplate.getDescription()));
        }
        Predicate[] preds = predicates.toArray(new Predicate[predicates.size()]);
        builder.setPredicates(preds);
        QueryResults results = this.getDataObjectService().findMatching(RuleTemplateBo.class, builder.build());
        return results.getResults();
    }

    @Override
    public void delete(String ruleTemplateId) {
        this.getDataObjectService().delete((Object)this.findByRuleTemplateId(ruleTemplateId));
    }

    @Override
    public RuleTemplateBo findByRuleTemplateId(String ruleTemplateId) {
        return (RuleTemplateBo)((Object)this.getDataObjectService().find(RuleTemplateBo.class, (Object)ruleTemplateId));
    }

    @Override
    public RuleTemplateBo save(RuleTemplateBo ruleTemplate) {
        return (RuleTemplateBo)((Object)this.getDataObjectService().save((Object)ruleTemplate, new PersistenceOption[]{PersistenceOption.FLUSH}));
    }

    @Override
    public String getNextRuleTemplateId() {
        DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)this.getDataSource(), (String)SEQUENCE_NAME);
        return incrementer.nextStringValue();
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Required
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

