/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.util;

import java.io.IOException;
import java.io.StringReader;

import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.service.NotificationContentTypeService;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * Entity resolver that resolves content type XSD resources to XSDs define in
 * the respective content type's NotificationContentType record
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ContentTypeEntityResolver extends ContentTypeResourceResolver implements EntityResolver {

    public ContentTypeEntityResolver(NotificationContentTypeService notificationContentTypeService) {
        super(notificationContentTypeService);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        LOG.debug("Resolving '" + publicId + "' / '" + systemId + "'");
        if (!systemId.startsWith(CONTENT_TYPE_PREFIX)) {
            LOG.warn("Cannot resolve non-ContentType resources");
            return null;
        }
        NotificationContentTypeBo notificationContentType = resolveContentType(systemId);
        if (notificationContentType == null) {
            LOG.error("Unable to resolve system id '" + systemId + "' locally...delegating to default resolution strategy.");
            return null;
        }
        LOG.debug("Resolved '" + systemId + "' to " + notificationContentType.getXsd());
        return new InputSource(new StringReader(notificationContentType.getXsd()));
    }

    @Override
    public String toString() {
        return "[ContentTypeEntityResolver]";
    }
}
