/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.exception;

import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.engine.RouteContext;


/**
 * Thrown from the engine when a problem is encountered.  Wraps a {@link RouteContext}
 * which contains information about the state of the engine at the time the
 * problem was encountered.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class RouteManagerException extends WorkflowRuntimeException {

    private static final long serialVersionUID = -7957245610622538745L;

    private RouteContext routeContext;
    
    public RouteManagerException(String message) {
        super(message);
    }
    
    public RouteManagerException(String message, RouteContext routeContext) {
        super(message);
        this.routeContext = routeContext;
    }
    
    public RouteManagerException(String message, Throwable throwable) {
        super(message, throwable);
    }
    
    public RouteManagerException(String message, Throwable throwable, RouteContext routeContext) {
        super(message, throwable);
        this.routeContext = routeContext;
    }
    
    public RouteManagerException(Throwable throwable, RouteContext routeContext) {
        super(throwable);
        this.routeContext = routeContext;
    }
        
    public RouteContext getRouteContext() {
        return routeContext;
    }

    public void setRouteContext(RouteContext routeContext) {
        this.routeContext = routeContext;
    }
    
}
