/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.impl.Responsibility;

import org.kuali.rice.kew.api.responsibility.ResponsibilityChangeQueue;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.CallMetadata;

import javax.xml.namespace.QName;
import java.util.HashSet;
import java.util.Set;

final class ResponsibilityChangeQueueAsyncCapableImpl implements ResponsibilityChangeQueue {

    private final AsyncCapableService asyncCapableService;
    private final ResponsibilityChangeQueue responsibilityChangeQueue;
    private final QName qname;
    private final String applicationId;

    ResponsibilityChangeQueueAsyncCapableImpl(AsyncCapableService asyncCapableService, ResponsibilityChangeQueue responsibilityChangeQueue, QName qname, String applicationId) {
        if (asyncCapableService == null) {
            throw new IllegalArgumentException("asyncCapableService is null");
        }

        if (responsibilityChangeQueue == null) {
            throw new IllegalArgumentException("responsibilityChangeQueue is null");
        }

        if (qname == null) {
            throw new IllegalArgumentException("qname is null");
        }

        this.asyncCapableService = asyncCapableService;
        this.responsibilityChangeQueue = responsibilityChangeQueue;
        this.qname = qname;
        this.applicationId = applicationId;
    }

    @Override
    public void responsibilitiesChanged(Set<String> responsibilityIds) {
        asyncCapableService.executeCall(qname, applicationId, responsibilityIds != null ? responsibilityIds.toString() : null, null,
                new CallMetadata("responsibilitiesChanged", new Class[]{Set.class}, new Object[]{responsibilityIds != null ? new HashSet<>(responsibilityIds) : null}),
                () -> responsibilityChangeQueue.responsibilitiesChanged(responsibilityIds));
    }
}
