/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.rule;

import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;

/**
 * A {@link WorkflowAttributeDefinition} for the {@link RuleRoutingAttribute}.
 * 
 * @see RuleRoutingAttribute
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public final class RuleRoutingDefinition {
        
	private static final long serialVersionUID = -5633697385117416044L;
	private static final String RULE_ROUTING_ATTRIBUTE_CLASS = "org.kuali.rice.kew.rule.RuleRoutingAttribute";
        
	public static WorkflowAttributeDefinition createAttributeDefinition(String docTypeName) {
	    WorkflowAttributeDefinition.Builder builder = WorkflowAttributeDefinition.Builder.create(RULE_ROUTING_ATTRIBUTE_CLASS);
	    builder.addParameter(docTypeName);
	    return builder.build();
	}
	
	private RuleRoutingDefinition() {}

}
