/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.service.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kcb.bo.RecipientDelivererConfig;
import org.kuali.rice.kcb.bo.RecipientPreference;
import org.kuali.rice.kcb.deliverer.MessageDeliverer;
import org.kuali.rice.kcb.exception.ErrorList;
import org.kuali.rice.kcb.service.RecipientPreferenceService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;

public class RecipientPreferenceServiceImpl
implements RecipientPreferenceService {
    private DataObjectService dataObjectService;

    @Override
    public RecipientPreference getRecipientPreference(String recipientId, String key) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"recipientId", (Object)recipientId), PredicateFactory.equal((String)"property", (Object)key)});
        List prefs = this.dataObjectService.findMatching(RecipientPreference.class, criteria.build()).getResults();
        assert (prefs.size() <= 1);
        if (prefs.isEmpty()) {
            return null;
        }
        return (RecipientPreference)prefs.get(0);
    }

    @Override
    public void deleteRecipientPreference(RecipientPreference pref) {
        this.dataObjectService.delete((Object)pref);
    }

    @Override
    public HashMap<String, String> getRecipientPreferences(String recipientId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"recipientId", (Object)recipientId)});
        List userPrefs = this.dataObjectService.findMatching(RecipientPreference.class, criteria.build()).getResults();
        HashMap<String, String> prefs = new HashMap<String, String>();
        for (RecipientPreference p : userPrefs) {
            prefs.put(p.getProperty(), p.getValue());
        }
        return prefs;
    }

    @Override
    public RecipientPreference saveRecipientPreference(RecipientPreference pref) {
        return (RecipientPreference)this.dataObjectService.save((Object)pref, new PersistenceOption[0]);
    }

    @Override
    public void saveRecipientPreferences(String recipientId, HashMap<String, String> prefs, MessageDeliverer deliverer) throws ErrorList {
        deliverer.validatePreferenceValues(prefs);
        for (Map.Entry<String, String> entry : prefs.entrySet()) {
            String prop = entry.getKey();
            String value = entry.getValue();
            RecipientPreference currentPreference = this.getRecipientPreference(recipientId, prop);
            if (currentPreference != null) {
                currentPreference.setRecipientId(recipientId);
                currentPreference.setProperty(prop);
                currentPreference.setValue(value);
                this.dataObjectService.save((Object)currentPreference, new PersistenceOption[0]);
                continue;
            }
            RecipientPreference recipientPreference = new RecipientPreference();
            recipientPreference.setRecipientId(recipientId);
            recipientPreference.setProperty(prop);
            recipientPreference.setValue(value);
            this.dataObjectService.save((Object)recipientPreference, new PersistenceOption[0]);
        }
    }

    @Override
    public void removeRecipientDelivererConfigs(String recipientId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"recipientId", (Object)recipientId)});
        this.dataObjectService.deleteMatching(RecipientDelivererConfig.class, criteria.build());
    }

    @Override
    public void saveRecipientDelivererConfig(String recipientId, String delivererName, String[] channels) {
        if (channels == null || channels.length == 0) {
            return;
        }
        for (String channel : channels) {
            RecipientDelivererConfig config = new RecipientDelivererConfig();
            config.setRecipientId(recipientId);
            config.setDelivererName(delivererName);
            config.setChannel(channel);
            Collection<RecipientDelivererConfig> deliverers = this.getDeliverersForRecipientAndChannel(recipientId, channel);
            if (deliverers != null) {
                for (RecipientDelivererConfig deliverer : deliverers) {
                    if (!deliverer.getDelivererName().equals(delivererName)) continue;
                    throw new RiceRuntimeException("Attempting to save a duplicate Recipient Deliverer Config.");
                }
            }
            this.dataObjectService.save((Object)config, new PersistenceOption[0]);
        }
    }

    @Override
    public Collection<RecipientDelivererConfig> getDeliverersForRecipient(String recipientId) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"recipientId", (Object)recipientId)});
        return this.dataObjectService.findMatching(RecipientDelivererConfig.class, criteria.build()).getResults();
    }

    @Override
    public Collection<RecipientDelivererConfig> getDeliverersForRecipientAndChannel(String recipientId, String channel) {
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setPredicates(new Predicate[]{PredicateFactory.equal((String)"recipientId", (Object)recipientId), PredicateFactory.equal((String)"channel", (Object)channel)});
        return this.dataObjectService.findMatching(RecipientDelivererConfig.class, criteria.build()).getResults();
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

