/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kcb.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

import org.springframework.beans.factory.BeanFactory;

/**
 * Maps accessor invocations to beans in a BeanFactory. 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class BeanFactoryInvocationHandler implements InvocationHandler {
     private static final String PREFIX = "get";

     private BeanFactory beanFactory;
     
     public BeanFactoryInvocationHandler(BeanFactory beanFactory) {
         this.beanFactory = beanFactory;
     }

     @Override
     public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
         if (args != null && args.length > 0) {
             throw new RuntimeException("BeanFactoryInvocationHandler only serves getters");
         }
         String methodName = method.getName();
         if (!methodName.startsWith(PREFIX)) {
             throw new RuntimeException("BeanFactoryInvocationHandler only serves getters");
         }
         String beanName = methodName.substring(PREFIX.length());
         if (beanName.length() == 0) {
             throw new RuntimeException("Illegal accessor, no bean name specified: " + methodName);
         }
         char firstChar = beanName.charAt(0);
         if (!Character.isLowerCase(firstChar)) {
             beanName = Character.toLowerCase(firstChar) + beanName.substring(1);
         }
         return beanFactory.getBean(beanName);
     }
}
