/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.service;

import java.util.Collection;

import org.kuali.rice.ken.bo.UserChannelSubscriptionBo;

/**
 * Service for accessing user preferences in the KEN system.{@link UserPreference}
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface UserPreferenceService {
    /**
     * This method retrieves all of the current channel subscriptions for a user.
     * @param userid
     * @return Collection
     */
    public Collection<UserChannelSubscriptionBo> getCurrentSubscriptions(String userid);
    
    /**
     * This method retrieves the UserChannelSubscription instance given the two unique keys that are 
     * passed in.
     * @param channelid
     * @param userid
     * @return UserChannelSubscription
     */
    public UserChannelSubscriptionBo getSubscription(String channelid, String userid);

    /**
     * This method will add a channel subscription into the system.
     * @param userChannelSubscription
     */
    public void subscribeToChannel(UserChannelSubscriptionBo userChannelSubscription);

    /**
     * This method will remove a channel subscription from the system.
     * @param userChannelSubscription
     */
    public void unsubscribeFromChannel(UserChannelSubscriptionBo userChannelSubscription);
}
