/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.responsibility.dao.impl;

import org.kuali.rice.kew.responsibility.dao.ResponsibilityIdDAO;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;

import javax.sql.DataSource;

public class ResponsibilityIdDAOJpaImpl implements ResponsibilityIdDAO {

    private static final String SEQUENCE_NAME = "KREW_RSP_S";

    private DataSource dataSource;

    @Override
	public String getNewResponsibilityId() {
        return MaxValueIncrementerFactory.getIncrementer(dataSource, SEQUENCE_NAME).nextStringValue();
    }

    public DataSource getDataSource() {
        return dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}
