/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ken.exception;

/**
 * This class represents an auto-remove exception - when notifications are not properly removed 
 * from their target audiences.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class NotificationAutoRemoveException extends Exception {
    /**
     * Constructs a NotificationAutoRemoveException instance.
     */
    public NotificationAutoRemoveException() {
        super();
    }

    /**
     * Constructs a NotificationAutoRemoveException instance.
     * @param message
     * @param cause
     */
    public NotificationAutoRemoveException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a NotificationAutoRemoveException instance.
     * @param message
     */
    public NotificationAutoRemoveException(String message) {
        super(message);
    }

    /**
     * Constructs a NotificationAutoRemoveException instance.
     * @param cause
     */
    public NotificationAutoRemoveException(Throwable cause) {
        super(cause);
    }
}
