/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.lifecycle;

import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.core.api.lifecycle.BaseCompositeLifecycle;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.kuali.rice.kew.mail.EmailReminderLifecycle;

import java.util.LinkedList;
import java.util.List;


/**
 * A temporary lifecycle that lives in embedded space.  Will be removed when the embedded plugin is factored out.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class StandaloneLifeCycle extends BaseCompositeLifecycle {

    @Override
    protected List<Lifecycle> loadLifecycles() throws Exception {
    	List<Lifecycle> lifecycles = new LinkedList<Lifecycle>();
    	if (ConfigContext.getCurrentContextConfig().getXmlPipelineLifeCycleEnabled()) {
            lifecycles.add(new XmlPipelineLifeCycle());
    	}
    	if (ConfigContext.getCurrentContextConfig().getEmailReminderLifecycleEnabled()) {
            lifecycles.add(new EmailReminderLifecycle());
    	}
    	return lifecycles;
	}

}
