/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kcb.service;

import org.kuali.rice.kcb.bo.MessageDelivery;

/**
 * The EmailService class is responsible for actually sending email messages to recipients.
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface EmailService {
    /**
     * This service method is responsible for sending a Email notification for the given user.
     * @param messageDelivery
     * @param recipientEmailAddress
     * @param emailFormat
     * @return Long - the id of the email message
     */
    public Long sendEmail(MessageDelivery messageDelivery, String recipientEmailAddress, String emailFormat) throws Exception;
}
