/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.routemodule.service;

import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.api.exception.ResourceUnavailableException;
import org.kuali.rice.kew.routemodule.RouteModule;



/**
 * A service for locating Route Modules.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface RouteModuleService {
    
    public RouteModule findRouteModule(RouteNode node) throws ResourceUnavailableException;
    
    public RouteModule findRouteModule(ActionRequestValue actionRequest) throws ResourceUnavailableException;
    
}
