/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.actiontaken.dao.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.actiontaken.dao.ActionTakenDao;
import org.kuali.rice.kew.api.action.ActionType;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import java.sql.Timestamp;


/**
 * JPA implementation of the {@link org.kuali.rice.kew.actiontaken.dao.ActionTakenDao}.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ActionTakenDaoJpa implements ActionTakenDao {

	private EntityManager entityManager;

    public static final String GET_LAST_ACTION_TAKEN_DATE_NAME = "ActionTakenValue.getLastActionTakenDate";
    public static final String GET_LAST_ACTION_TAKEN_DATE_QUERY =
            "SELECT max(a.actionDate) from ActionTakenValue a where a.documentId = :documentId and a.actionTaken=:actionTaken";

    @Override
    public Timestamp getLastActionTakenDate(String documentId, ActionType actionType) {
        if (StringUtils.isBlank(documentId) || actionType == null) {
            throw new IllegalArgumentException("Both documentId and actionType must be non-null");
        }
        TypedQuery<Timestamp> query =
                entityManager.createNamedQuery(GET_LAST_ACTION_TAKEN_DATE_NAME, Timestamp.class);
        query.setParameter("documentId", documentId);
        query.setParameter("actionTaken", actionType.getCode());
        try {
            return query.getSingleResult();
        } catch (NoResultException e) {
            return null;
        }
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

}
